/*
 * Decompiled with CFR 0.152.
 */
package zombie.core;

import zombie.core.Color;
import zombie.core.Rand;
import zombie.core.math.PZMath;

public final class ImmutableColor {
    public static final ImmutableColor transparent = new ImmutableColor(0.0f, 0.0f, 0.0f, 0.0f);
    public static final ImmutableColor white = new ImmutableColor(1.0f, 1.0f, 1.0f, 1.0f);
    public static final ImmutableColor yellow = new ImmutableColor(1.0f, 1.0f, 0.0f, 1.0f);
    public static final ImmutableColor red = new ImmutableColor(1.0f, 0.0f, 0.0f, 1.0f);
    public static final ImmutableColor purple = new ImmutableColor(196.0f, 0.0f, 171.0f);
    public static final ImmutableColor blue = new ImmutableColor(0.0f, 0.0f, 1.0f, 1.0f);
    public static final ImmutableColor green = new ImmutableColor(0.0f, 1.0f, 0.0f, 1.0f);
    public static final ImmutableColor black = new ImmutableColor(0.0f, 0.0f, 0.0f, 1.0f);
    public static final ImmutableColor gray = new ImmutableColor(0.5f, 0.5f, 0.5f, 1.0f);
    public static final ImmutableColor cyan = new ImmutableColor(0.0f, 1.0f, 1.0f, 1.0f);
    public static final ImmutableColor darkGray = new ImmutableColor(0.3f, 0.3f, 0.3f, 1.0f);
    public static final ImmutableColor lightGray = new ImmutableColor(0.7f, 0.7f, 0.7f, 1.0f);
    public static final ImmutableColor pink = new ImmutableColor(255, 175, 175, 255);
    public static final ImmutableColor orange = new ImmutableColor(255, 200, 0, 255);
    public static final ImmutableColor magenta = new ImmutableColor(255, 0, 255, 255);
    public static final ImmutableColor darkGreen = new ImmutableColor(22, 113, 20, 255);
    public static final ImmutableColor lightGreen = new ImmutableColor(55, 148, 53, 255);
    public final float a;
    public final float b;
    public final float g;
    public final float r;

    public ImmutableColor(ImmutableColor immutableColor) {
        if (immutableColor == null) {
            this.r = 0.0f;
            this.g = 0.0f;
            this.b = 0.0f;
            this.a = 1.0f;
            return;
        }
        this.r = immutableColor.r;
        this.g = immutableColor.g;
        this.b = immutableColor.b;
        this.a = immutableColor.a;
    }

    public ImmutableColor(Color color) {
        if (color == null) {
            this.r = 0.0f;
            this.g = 0.0f;
            this.b = 0.0f;
            this.a = 1.0f;
            return;
        }
        this.r = color.r;
        this.g = color.g;
        this.b = color.b;
        this.a = color.a;
    }

    public Color toMutableColor() {
        return new Color(this.r, this.g, this.b, this.a);
    }

    public ImmutableColor(float f, float f2, float f3) {
        this.r = PZMath.clamp(f, 0.0f, 1.0f);
        this.g = PZMath.clamp(f2, 0.0f, 1.0f);
        this.b = PZMath.clamp(f3, 0.0f, 1.0f);
        this.a = 1.0f;
    }

    public ImmutableColor(float f, float f2, float f3, float f4) {
        this.r = Math.min(f, 1.0f);
        this.g = Math.min(f2, 1.0f);
        this.b = Math.min(f3, 1.0f);
        this.a = Math.min(f4, 1.0f);
    }

    public ImmutableColor(Color color, Color color2, float f) {
        float f2 = (color2.r - color.r) * f;
        float f3 = (color2.g - color.g) * f;
        float f4 = (color2.b - color.b) * f;
        float f5 = (color2.a - color.a) * f;
        this.r = color.r + f2;
        this.g = color.g + f3;
        this.b = color.b + f4;
        this.a = color.a + f5;
    }

    public ImmutableColor(int n, int n2, int n3) {
        this.r = (float)n / 255.0f;
        this.g = (float)n2 / 255.0f;
        this.b = (float)n3 / 255.0f;
        this.a = 1.0f;
    }

    public ImmutableColor(int n, int n2, int n3, int n4) {
        this.r = (float)n / 255.0f;
        this.g = (float)n2 / 255.0f;
        this.b = (float)n3 / 255.0f;
        this.a = (float)n4 / 255.0f;
    }

    public ImmutableColor(int n) {
        int n2 = (n & 0xFF0000) >> 16;
        int n3 = (n & 0xFF00) >> 8;
        int n4 = n & 0xFF;
        int n5 = (n & 0xFF000000) >> 24;
        if (n5 < 0) {
            n5 += 256;
        }
        if (n5 == 0) {
            n5 = 255;
        }
        this.r = (float)n4 / 255.0f;
        this.g = (float)n3 / 255.0f;
        this.b = (float)n2 / 255.0f;
        this.a = (float)n5 / 255.0f;
    }

    public static ImmutableColor random() {
        float f = Rand.Next(0.0f, 1.0f);
        float f2 = Rand.Next(0.0f, 0.6f);
        float f3 = Rand.Next(0.0f, 0.9f);
        Color color = Color.HSBtoRGB(f, f2, f3);
        return new ImmutableColor(color);
    }

    public static ImmutableColor decode(String string) {
        return new ImmutableColor(Integer.decode(string));
    }

    public ImmutableColor add(ImmutableColor immutableColor) {
        return new ImmutableColor(this.r + immutableColor.r, this.g + immutableColor.g, this.b + immutableColor.b, this.a + immutableColor.a);
    }

    public ImmutableColor brighter() {
        return this.brighter(0.2f);
    }

    public ImmutableColor brighter(float f) {
        return new ImmutableColor(this.r + f, this.g + f, this.b + f);
    }

    public ImmutableColor darker() {
        return this.darker(0.5f);
    }

    public ImmutableColor darker(float f) {
        return new ImmutableColor(this.r - f, this.g - f, this.b - f);
    }

    public boolean equals(Object object) {
        if (object instanceof ImmutableColor) {
            ImmutableColor immutableColor = (ImmutableColor)object;
            return immutableColor.r == this.r && immutableColor.g == this.g && immutableColor.b == this.b && immutableColor.a == this.a;
        }
        return false;
    }

    public int getAlphaInt() {
        return (int)(this.a * 255.0f);
    }

    public float getAlphaFloat() {
        return this.a;
    }

    public float getRedFloat() {
        return this.r;
    }

    public float getGreenFloat() {
        return this.g;
    }

    public float getBlueFloat() {
        return this.b;
    }

    public byte getAlphaByte() {
        return (byte)((int)(this.a * 255.0f) & 0xFF);
    }

    public int getBlueInt() {
        return (int)(this.b * 255.0f);
    }

    public byte getBlueByte() {
        return (byte)((int)(this.b * 255.0f) & 0xFF);
    }

    public int getGreenInt() {
        return (int)(this.g * 255.0f);
    }

    public byte getGreenByte() {
        return (byte)((int)(this.g * 255.0f) & 0xFF);
    }

    public int getRedInt() {
        return (int)(this.r * 255.0f);
    }

    public byte getRedByte() {
        return (byte)((int)(this.r * 255.0f) & 0xFF);
    }

    public int hashCode() {
        return (int)(this.r + this.g + this.b + this.a) * 255;
    }

    public ImmutableColor multiply(Color color) {
        return new ImmutableColor(this.r * color.r, this.g * color.g, this.b * color.b, this.a * color.a);
    }

    public ImmutableColor scale(float f) {
        return new ImmutableColor(this.r * f, this.g * f, this.b * f, this.a * f);
    }

    public String toString() {
        return "ImmutableColor (" + this.r + "," + this.g + "," + this.b + "," + this.a + ")";
    }

    public ImmutableColor interp(ImmutableColor immutableColor, float f) {
        float f2 = immutableColor.r - this.r;
        float f3 = immutableColor.g - this.g;
        float f4 = immutableColor.b - this.b;
        float f5 = immutableColor.a - this.a;
        return new ImmutableColor(this.r + (f2 *= f), this.g + (f3 *= f), this.b + (f4 *= f), this.a + (f5 *= f));
    }

    public static Integer[] HSBtoRGB(float f, float f2, float f3) {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        if (f2 == 0.0f) {
            n2 = n3 = (int)(f3 * 255.0f + 0.5f);
            n = n3;
        } else {
            float f4 = (f - (float)Math.floor(f)) * 6.0f;
            float f5 = f4 - (float)Math.floor(f4);
            float f6 = f3 * (1.0f - f2);
            float f7 = f3 * (1.0f - f2 * f5);
            float f8 = f3 * (1.0f - f2 * (1.0f - f5));
            switch ((int)f4) {
                case 0: {
                    n = (int)(f3 * 255.0f + 0.5f);
                    n2 = (int)(f8 * 255.0f + 0.5f);
                    n3 = (int)(f6 * 255.0f + 0.5f);
                    break;
                }
                case 1: {
                    n = (int)(f7 * 255.0f + 0.5f);
                    n2 = (int)(f3 * 255.0f + 0.5f);
                    n3 = (int)(f6 * 255.0f + 0.5f);
                    break;
                }
                case 2: {
                    n = (int)(f6 * 255.0f + 0.5f);
                    n2 = (int)(f3 * 255.0f + 0.5f);
                    n3 = (int)(f8 * 255.0f + 0.5f);
                    break;
                }
                case 3: {
                    n = (int)(f6 * 255.0f + 0.5f);
                    n2 = (int)(f7 * 255.0f + 0.5f);
                    n3 = (int)(f3 * 255.0f + 0.5f);
                    break;
                }
                case 4: {
                    n = (int)(f8 * 255.0f + 0.5f);
                    n2 = (int)(f6 * 255.0f + 0.5f);
                    n3 = (int)(f3 * 255.0f + 0.5f);
                    break;
                }
                case 5: {
                    n = (int)(f3 * 255.0f + 0.5f);
                    n2 = (int)(f6 * 255.0f + 0.5f);
                    n3 = (int)(f7 * 255.0f + 0.5f);
                }
            }
        }
        Integer[] integerArray = new Integer[]{n, n2, n3};
        return integerArray;
    }
}

