/*
 * Decompiled with CFR 0.152.
 */
package zombie.core.Collections;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.AbstractSet;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.concurrent.atomic.AtomicInteger;
import sun.misc.Unsafe;
import zombie.core.Collections.Counter;
import zombie.core.Collections.IntIterator;
import zombie.core.Collections.UtilUnsafe;

public class NonBlockingSetInt
extends AbstractSet<Integer>
implements Serializable {
    private static final long serialVersionUID = 1234123412341234123L;
    private static final Unsafe _unsafe = UtilUnsafe.getUnsafe();
    private static final long _nbsi_offset;
    private transient NBSI _nbsi;

    private final boolean CAS_nbsi(NBSI nBSI, NBSI nBSI2) {
        return _unsafe.compareAndSwapObject(this, _nbsi_offset, nBSI, nBSI2);
    }

    public NonBlockingSetInt() {
        this._nbsi = new NBSI(63, new Counter(), this);
    }

    private NonBlockingSetInt(NonBlockingSetInt nonBlockingSetInt, NonBlockingSetInt nonBlockingSetInt2) {
        this._nbsi = new NBSI(nonBlockingSetInt._nbsi, nonBlockingSetInt2._nbsi, new Counter(), this);
    }

    @Override
    public boolean add(Integer n) {
        return this.add((int)n);
    }

    @Override
    public boolean contains(Object object) {
        return object instanceof Integer ? this.contains((Integer)object) : false;
    }

    @Override
    public boolean remove(Object object) {
        return object instanceof Integer ? this.remove((Integer)object) : false;
    }

    @Override
    public boolean add(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("" + n);
        }
        return this._nbsi.add(n);
    }

    public boolean contains(int n) {
        return n < 0 ? false : this._nbsi.contains(n);
    }

    public boolean remove(int n) {
        return n < 0 ? false : this._nbsi.remove(n);
    }

    @Override
    public int size() {
        return this._nbsi.size();
    }

    @Override
    public void clear() {
        NBSI nBSI = new NBSI(63, new Counter(), this);
        while (!this.CAS_nbsi(this._nbsi, nBSI)) {
        }
    }

    public int sizeInBytes() {
        return this._nbsi.sizeInBytes();
    }

    public NonBlockingSetInt intersect(NonBlockingSetInt nonBlockingSetInt) {
        NonBlockingSetInt nonBlockingSetInt2 = new NonBlockingSetInt(this, nonBlockingSetInt);
        nonBlockingSetInt2._nbsi.intersect(nonBlockingSetInt2._nbsi, this._nbsi, nonBlockingSetInt._nbsi);
        return nonBlockingSetInt2;
    }

    public NonBlockingSetInt union(NonBlockingSetInt nonBlockingSetInt) {
        NonBlockingSetInt nonBlockingSetInt2 = new NonBlockingSetInt(this, nonBlockingSetInt);
        nonBlockingSetInt2._nbsi.union(nonBlockingSetInt2._nbsi, this._nbsi, nonBlockingSetInt._nbsi);
        return nonBlockingSetInt2;
    }

    public void print() {
        this._nbsi.print(0);
    }

    @Override
    public Iterator<Integer> iterator() {
        return new iter();
    }

    public IntIterator intIterator() {
        return new NBSIIntIterator();
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        NBSI nBSI = this._nbsi;
        int n = this._nbsi._bits.length << 6;
        objectOutputStream.writeInt(n);
        for (int i = 0; i < n; ++i) {
            objectOutputStream.writeBoolean(this._nbsi.contains(i));
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        int n = objectInputStream.readInt();
        this._nbsi = new NBSI(n, new Counter(), this);
        for (int i = 0; i < n; ++i) {
            if (!objectInputStream.readBoolean()) continue;
            this._nbsi.add(i);
        }
    }

    static {
        Field field = null;
        try {
            field = NonBlockingSetInt.class.getDeclaredField("_nbsi");
        }
        catch (NoSuchFieldException noSuchFieldException) {
            // empty catch block
        }
        _nbsi_offset = _unsafe.objectFieldOffset(field);
    }

    private static final class NBSI {
        private final transient NonBlockingSetInt _non_blocking_set_int;
        private final transient Counter _size;
        private final long[] _bits;
        private static final int _Lbase = _unsafe.arrayBaseOffset(long[].class);
        private static final int _Lscale = _unsafe.arrayIndexScale(long[].class);
        private NBSI _new;
        private static final long _new_offset;
        private final transient AtomicInteger _copyIdx;
        private final transient AtomicInteger _copyDone;
        private final transient int _sum_bits_length;
        private final NBSI _nbsi64;

        private static long rawIndex(long[] lArray, int n) {
            assert (n >= 0 && n < lArray.length);
            return _Lbase + n * _Lscale;
        }

        private final boolean CAS(int n, long l, long l2) {
            return _unsafe.compareAndSwapLong(this._bits, NBSI.rawIndex(this._bits, n), l, l2);
        }

        private final boolean CAS_new(NBSI nBSI) {
            return _unsafe.compareAndSwapObject(this, _new_offset, null, nBSI);
        }

        private static final long mask(int n) {
            return 1L << (n & 0x3F);
        }

        private NBSI(int n, Counter counter, NonBlockingSetInt nonBlockingSetInt) {
            this._non_blocking_set_int = nonBlockingSetInt;
            this._size = counter;
            this._copyIdx = counter == null ? null : new AtomicInteger();
            this._copyDone = counter == null ? null : new AtomicInteger();
            this._bits = new long[(int)((long)n + 63L >>> 6)];
            this._nbsi64 = n + 1 >>> 6 == 0 ? null : new NBSI(n + 1 >>> 6, null, null);
            this._sum_bits_length = this._bits.length + (this._nbsi64 == null ? 0 : this._nbsi64._sum_bits_length);
        }

        private NBSI(NBSI nBSI, NBSI nBSI2, Counter counter, NonBlockingSetInt nonBlockingSetInt) {
            this._non_blocking_set_int = nonBlockingSetInt;
            this._size = counter;
            this._copyIdx = counter == null ? null : new AtomicInteger();
            AtomicInteger atomicInteger = this._copyDone = counter == null ? null : new AtomicInteger();
            if (!NBSI.has_bits(nBSI) && !NBSI.has_bits(nBSI2)) {
                this._bits = null;
                this._nbsi64 = null;
                this._sum_bits_length = 0;
                return;
            }
            if (!NBSI.has_bits(nBSI)) {
                this._bits = new long[nBSI2._bits.length];
                this._nbsi64 = new NBSI(null, nBSI2._nbsi64, null, null);
            } else if (!NBSI.has_bits(nBSI2)) {
                this._bits = new long[nBSI._bits.length];
                this._nbsi64 = new NBSI(null, nBSI._nbsi64, null, null);
            } else {
                int n = nBSI._bits.length > nBSI2._bits.length ? nBSI._bits.length : nBSI2._bits.length;
                this._bits = new long[n];
                this._nbsi64 = new NBSI(nBSI._nbsi64, nBSI2._nbsi64, null, null);
            }
            this._sum_bits_length = this._bits.length + this._nbsi64._sum_bits_length;
        }

        private static boolean has_bits(NBSI nBSI) {
            return nBSI != null && nBSI._bits != null;
        }

        public boolean add(int n) {
            long l;
            if (n >> 6 >= this._bits.length) {
                return this.install_larger_new_bits(n).help_copy().add(n);
            }
            NBSI nBSI = this;
            int n2 = n;
            while ((n2 & 0x3F) == 63) {
                nBSI = nBSI._nbsi64;
                n2 >>= 6;
            }
            long l2 = NBSI.mask(n2);
            do {
                if ((l = nBSI._bits[n2 >> 6]) < 0L) {
                    return this.help_copy_impl(n).help_copy().add(n);
                }
                if ((l & l2) == 0L) continue;
                return false;
            } while (!nBSI.CAS(n2 >> 6, l, l | l2));
            this._size.add(1L);
            return true;
        }

        public boolean remove(int n) {
            long l;
            if (n >> 6 >= this._bits.length) {
                return this._new == null ? false : this.help_copy().remove(n);
            }
            NBSI nBSI = this;
            int n2 = n;
            while ((n2 & 0x3F) == 63) {
                nBSI = nBSI._nbsi64;
                n2 >>= 6;
            }
            long l2 = NBSI.mask(n2);
            do {
                if ((l = nBSI._bits[n2 >> 6]) < 0L) {
                    return this.help_copy_impl(n).help_copy().remove(n);
                }
                if ((l & l2) != 0L) continue;
                return false;
            } while (!nBSI.CAS(n2 >> 6, l, l & (l2 ^ 0xFFFFFFFFFFFFFFFFL)));
            this._size.add(-1L);
            return true;
        }

        public boolean contains(int n) {
            if (n >> 6 >= this._bits.length) {
                return this._new == null ? false : this.help_copy().contains(n);
            }
            NBSI nBSI = this;
            int n2 = n;
            while ((n2 & 0x3F) == 63) {
                nBSI = nBSI._nbsi64;
                n2 >>= 6;
            }
            long l = NBSI.mask(n2);
            long l2 = nBSI._bits[n2 >> 6];
            if (l2 < 0L) {
                return this.help_copy_impl(n).help_copy().contains(n);
            }
            return (l2 & l) != 0L;
        }

        public boolean intersect(NBSI nBSI, NBSI nBSI2, NBSI nBSI3) {
            if (!NBSI.has_bits(nBSI2) || !NBSI.has_bits(nBSI3)) {
                return true;
            }
            for (int i = 0; i < nBSI._bits.length; ++i) {
                long l = nBSI2.safe_read_word(i, 0L);
                long l2 = nBSI3.safe_read_word(i, 0L);
                nBSI._bits[i] = l & l2 & Long.MAX_VALUE;
            }
            return this.intersect(nBSI._nbsi64, nBSI2._nbsi64, nBSI3._nbsi64);
        }

        public boolean union(NBSI nBSI, NBSI nBSI2, NBSI nBSI3) {
            if (!NBSI.has_bits(nBSI2) && !NBSI.has_bits(nBSI3)) {
                return true;
            }
            if (NBSI.has_bits(nBSI2) || NBSI.has_bits(nBSI3)) {
                for (int i = 0; i < nBSI._bits.length; ++i) {
                    long l = nBSI2.safe_read_word(i, 0L);
                    long l2 = nBSI3.safe_read_word(i, 0L);
                    nBSI._bits[i] = (l | l2) & Long.MAX_VALUE;
                }
            }
            return this.union(nBSI._nbsi64, nBSI2._nbsi64, nBSI3._nbsi64);
        }

        private long safe_read_word(int n, long l) {
            if (n >= this._bits.length) {
                return l;
            }
            long l2 = this._bits[n];
            if (l2 < 0L) {
                l2 = this.help_copy_impl((int)n).help_copy()._bits[n];
            }
            return l2;
        }

        public int sizeInBytes() {
            return this._bits.length;
        }

        public int size() {
            return (int)this._size.get();
        }

        private NBSI install_larger_new_bits(int n) {
            if (this._new == null) {
                int n2 = this._bits.length << 6 << 1;
                this.CAS_new(new NBSI(n2, this._size, this._non_blocking_set_int));
            }
            return this;
        }

        private NBSI help_copy() {
            NBSI nBSI = this._non_blocking_set_int._nbsi;
            int n = nBSI._copyIdx.getAndAdd(512);
            for (int i = 0; i < 8; ++i) {
                int n2 = n + i * 64;
                nBSI.help_copy_impl(n2 %= nBSI._bits.length << 6);
                nBSI.help_copy_impl(n2 + 63);
            }
            if (nBSI._copyDone.get() != nBSI._sum_bits_length || this._non_blocking_set_int.CAS_nbsi(nBSI, nBSI._new)) {
                // empty if block
            }
            return this._new;
        }

        private NBSI help_copy_impl(int n) {
            long l;
            NBSI nBSI = this;
            NBSI nBSI2 = this._new;
            if (nBSI2 == null) {
                return this;
            }
            int n2 = n;
            while ((n2 & 0x3F) == 63) {
                nBSI = nBSI._nbsi64;
                nBSI2 = nBSI2._nbsi64;
                n2 >>= 6;
            }
            long l2 = nBSI._bits[n2 >> 6];
            while (l2 >= 0L) {
                l = l2;
                if (nBSI.CAS(n2 >> 6, l, l2 |= NBSI.mask(63))) {
                    if (l != 0L) break;
                    this._copyDone.addAndGet(1);
                    break;
                }
                l2 = nBSI._bits[n2 >> 6];
            }
            if (l2 != NBSI.mask(63)) {
                l = nBSI2._bits[n2 >> 6];
                if (l == 0L) {
                    l = l2 & (NBSI.mask(63) ^ 0xFFFFFFFFFFFFFFFFL);
                    if (!nBSI2.CAS(n2 >> 6, 0L, l)) {
                        l = nBSI2._bits[n2 >> 6];
                    }
                    assert (l != 0L);
                }
                if (nBSI.CAS(n2 >> 6, l2, NBSI.mask(63))) {
                    this._copyDone.addAndGet(1);
                }
            }
            return this;
        }

        private void print(int n, String string) {
            for (int i = 0; i < n; ++i) {
                System.out.print("  ");
            }
            System.out.println(string);
        }

        private void print(int n) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("NBSI - _bits.len=");
            NBSI nBSI = this;
            while (nBSI != null) {
                stringBuffer.append(" " + nBSI._bits.length);
                nBSI = nBSI._nbsi64;
            }
            this.print(n, stringBuffer.toString());
            nBSI = this;
            while (nBSI != null) {
                for (int i = 0; i < nBSI._bits.length; ++i) {
                    System.out.print(Long.toHexString(nBSI._bits[i]) + " ");
                }
                nBSI = nBSI._nbsi64;
                System.out.println();
            }
            if (this._copyIdx.get() != 0 || this._copyDone.get() != 0) {
                this.print(n, "_copyIdx=" + this._copyIdx.get() + " _copyDone=" + this._copyDone.get() + " _words_to_cpy=" + this._sum_bits_length);
            }
            if (this._new != null) {
                this.print(n, "__has_new - ");
                this._new.print(n + 1);
            }
        }

        static {
            Field field = null;
            try {
                field = NBSI.class.getDeclaredField("_new");
            }
            catch (NoSuchFieldException noSuchFieldException) {
                // empty catch block
            }
            _new_offset = _unsafe.objectFieldOffset(field);
        }
    }

    private class iter
    implements Iterator<Integer> {
        NBSIIntIterator intIterator;

        iter() {
            this.intIterator = new NBSIIntIterator();
        }

        @Override
        public boolean hasNext() {
            return this.intIterator.hasNext();
        }

        @Override
        public Integer next() {
            return this.intIterator.next();
        }

        @Override
        public void remove() {
            this.intIterator.remove();
        }
    }

    private class NBSIIntIterator
    implements IntIterator {
        NBSI nbsi;
        int index = -1;
        int prev = -1;

        NBSIIntIterator() {
            this.nbsi = NonBlockingSetInt.this._nbsi;
            this.advance();
        }

        private void advance() {
            do {
                ++this.index;
                while (this.index >> 6 >= this.nbsi._bits.length) {
                    if (this.nbsi._new == null) {
                        this.index = -2;
                        return;
                    }
                    this.nbsi = this.nbsi._new;
                }
            } while (!this.nbsi.contains(this.index));
        }

        @Override
        public int next() {
            if (this.index == -1) {
                throw new NoSuchElementException();
            }
            this.prev = this.index;
            this.advance();
            return this.prev;
        }

        @Override
        public boolean hasNext() {
            return this.index != -2;
        }

        public void remove() {
            if (this.prev == -1) {
                throw new IllegalStateException();
            }
            this.nbsi.remove(this.prev);
            this.prev = -1;
        }
    }
}

