/*
 * Decompiled with CFR 0.152.
 */
package zombie.core.Collections;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import sun.misc.Unsafe;
import zombie.core.Collections.AbstractEntry;
import zombie.core.Collections.Counter;
import zombie.core.Collections.UtilUnsafe;

public class NonBlockingHashMap<TypeK, TypeV>
extends AbstractMap<TypeK, TypeV>
implements ConcurrentMap<TypeK, TypeV>,
Cloneable,
Serializable {
    private static final long serialVersionUID = 1234123412341234123L;
    private static final int REPROBE_LIMIT = 10;
    private static final Unsafe _unsafe = UtilUnsafe.getUnsafe();
    private static final int _Obase = _unsafe.arrayBaseOffset(Object[].class);
    private static final int _Oscale = _unsafe.arrayIndexScale(Object[].class);
    private static final long _kvs_offset;
    private transient Object[] _kvs;
    private transient long _last_resize_milli;
    private static final int MIN_SIZE_LOG = 3;
    private static final int MIN_SIZE = 8;
    private static final Object NO_MATCH_OLD;
    private static final Object MATCH_ANY;
    private static final Object TOMBSTONE;
    private static final Prime TOMBPRIME;
    private transient Counter _reprobes = new Counter();

    private static long rawIndex(Object[] objectArray, int n) {
        assert (n >= 0 && n < objectArray.length);
        return _Obase + n * _Oscale;
    }

    private final boolean CAS_kvs(Object[] objectArray, Object[] objectArray2) {
        return _unsafe.compareAndSwapObject(this, _kvs_offset, objectArray, objectArray2);
    }

    private static final int hash(Object object) {
        int n = object.hashCode();
        n += n << 15 ^ 0xFFFFCD7D;
        n ^= n >>> 10;
        n += n << 3;
        n ^= n >>> 6;
        n += (n << 2) + (n << 14);
        return n ^ n >>> 16;
    }

    private static final CHM chm(Object[] objectArray) {
        return (CHM)objectArray[0];
    }

    private static final int[] hashes(Object[] objectArray) {
        return (int[])objectArray[1];
    }

    private static final int len(Object[] objectArray) {
        return objectArray.length - 2 >> 1;
    }

    private static final Object key(Object[] objectArray, int n) {
        return objectArray[(n << 1) + 2];
    }

    private static final Object val(Object[] objectArray, int n) {
        return objectArray[(n << 1) + 3];
    }

    private static final boolean CAS_key(Object[] objectArray, int n, Object object, Object object2) {
        return _unsafe.compareAndSwapObject(objectArray, NonBlockingHashMap.rawIndex(objectArray, (n << 1) + 2), object, object2);
    }

    private static final boolean CAS_val(Object[] objectArray, int n, Object object, Object object2) {
        return _unsafe.compareAndSwapObject(objectArray, NonBlockingHashMap.rawIndex(objectArray, (n << 1) + 3), object, object2);
    }

    public final void print() {
        System.out.println("=========");
        this.print2(this._kvs);
        System.out.println("=========");
    }

    private final void print(Object[] objectArray) {
        for (int i = 0; i < NonBlockingHashMap.len(objectArray); ++i) {
            Object object = NonBlockingHashMap.key(objectArray, i);
            if (object == null) continue;
            String string = object == TOMBSTONE ? "XXX" : object.toString();
            Object object2 = NonBlockingHashMap.val(objectArray, i);
            Object object3 = Prime.unbox(object2);
            String string2 = object2 == object3 ? "" : "prime_";
            String string3 = object3 == TOMBSTONE ? "tombstone" : object3.toString();
            System.out.println(i + " (" + string + "," + string2 + string3 + ")");
        }
        Object[] objectArray2 = NonBlockingHashMap.chm((Object[])objectArray)._newkvs;
        if (objectArray2 != null) {
            System.out.println("----");
            this.print(objectArray2);
        }
    }

    private final void print2(Object[] objectArray) {
        for (int i = 0; i < NonBlockingHashMap.len(objectArray); ++i) {
            Object object = NonBlockingHashMap.key(objectArray, i);
            Object object2 = NonBlockingHashMap.val(objectArray, i);
            Object object3 = Prime.unbox(object2);
            if (object == null || object == TOMBSTONE || object2 == null || object3 == TOMBSTONE) continue;
            String string = object2 == object3 ? "" : "prime_";
            System.out.println(i + " (" + object + "," + string + object2 + ")");
        }
        Object[] objectArray2 = NonBlockingHashMap.chm((Object[])objectArray)._newkvs;
        if (objectArray2 != null) {
            System.out.println("----");
            this.print2(objectArray2);
        }
    }

    public long reprobes() {
        long l = this._reprobes.get();
        this._reprobes = new Counter();
        return l;
    }

    private static final int reprobe_limit(int n) {
        return 10 + (n >> 2);
    }

    public NonBlockingHashMap() {
        this(8);
    }

    public NonBlockingHashMap(int n) {
        this.initialize(n);
    }

    private final void initialize(int n) {
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        if (n > 0x100000) {
            n = 0x100000;
        }
        int n2 = 3;
        while (1 << n2 < n << 2) {
            ++n2;
        }
        this._kvs = new Object[(1 << n2 << 1) + 2];
        this._kvs[0] = new CHM(new Counter());
        this._kvs[1] = new int[1 << n2];
        this._last_resize_milli = System.currentTimeMillis();
    }

    protected final void initialize() {
        this.initialize(8);
    }

    @Override
    public int size() {
        return NonBlockingHashMap.chm(this._kvs).size();
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public boolean containsKey(Object object) {
        return this.get(object) != null;
    }

    public boolean contains(Object object) {
        return this.containsValue(object);
    }

    @Override
    public TypeV put(TypeK TypeK, TypeV TypeV) {
        return this.putIfMatch(TypeK, TypeV, NO_MATCH_OLD);
    }

    @Override
    public TypeV putIfAbsent(TypeK TypeK, TypeV TypeV) {
        return this.putIfMatch(TypeK, TypeV, TOMBSTONE);
    }

    @Override
    public TypeV remove(Object object) {
        return this.putIfMatch(object, TOMBSTONE, NO_MATCH_OLD);
    }

    @Override
    public boolean remove(Object object, Object object2) {
        TypeV TypeV = this.putIfMatch(object, TOMBSTONE, object2);
        return object2 == null ? TypeV == object2 : object2.equals(TypeV);
    }

    @Override
    public TypeV replace(TypeK TypeK, TypeV TypeV) {
        return this.putIfMatch(TypeK, TypeV, MATCH_ANY);
    }

    @Override
    public boolean replace(TypeK TypeK, TypeV TypeV, TypeV TypeV2) {
        TypeV TypeV3 = this.putIfMatch(TypeK, TypeV2, TypeV);
        return TypeV == null ? TypeV3 == TypeV : TypeV.equals(TypeV3);
    }

    private final TypeV putIfMatch(Object object, Object object2, Object object3) {
        if (object3 == null || object2 == null) {
            throw new NullPointerException();
        }
        Object object4 = NonBlockingHashMap.putIfMatch(this, this._kvs, object, object2, object3);
        assert (!(object4 instanceof Prime));
        assert (object4 != null);
        return (TypeV)(object4 == TOMBSTONE ? null : object4);
    }

    @Override
    public void putAll(Map<? extends TypeK, ? extends TypeV> map) {
        for (Map.Entry<TypeK, TypeV> entry : map.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public void clear() {
        Object[] objectArray = new NonBlockingHashMap<TypeK, TypeV>((int)8)._kvs;
        while (!this.CAS_kvs(this._kvs, objectArray)) {
        }
    }

    @Override
    public boolean containsValue(Object object) {
        if (object == null) {
            throw new NullPointerException();
        }
        for (TypeV TypeV : this.values()) {
            if (TypeV != object && !TypeV.equals(object)) continue;
            return true;
        }
        return false;
    }

    protected void rehash() {
    }

    @Override
    public Object clone() {
        try {
            NonBlockingHashMap nonBlockingHashMap = (NonBlockingHashMap)super.clone();
            nonBlockingHashMap.clear();
            for (TypeK TypeK : this.keySet()) {
                TypeV TypeV = this.get(TypeK);
                nonBlockingHashMap.put(TypeK, TypeV);
            }
            return nonBlockingHashMap;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    @Override
    public String toString() {
        Iterator<Map.Entry<TypeK, TypeV>> iterator = this.entrySet().iterator();
        if (!iterator.hasNext()) {
            return "{}";
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('{');
        while (true) {
            Map.Entry<TypeK, TypeV> entry = iterator.next();
            TypeK TypeK = entry.getKey();
            TypeV TypeV = entry.getValue();
            stringBuilder.append((Object)(TypeK == this ? "(this Map)" : TypeK));
            stringBuilder.append('=');
            stringBuilder.append((Object)(TypeV == this ? "(this Map)" : TypeV));
            if (!iterator.hasNext()) {
                return stringBuilder.append('}').toString();
            }
            stringBuilder.append(", ");
        }
    }

    private static boolean keyeq(Object object, Object object2, int[] nArray, int n, int n2) {
        return object == object2 || (nArray[n] == 0 || nArray[n] == n2) && object != TOMBSTONE && object2.equals(object);
    }

    @Override
    public TypeV get(Object object) {
        int n = NonBlockingHashMap.hash(object);
        Object object2 = NonBlockingHashMap.get_impl(this, this._kvs, object, n);
        assert (!(object2 instanceof Prime));
        return (TypeV)object2;
    }

    private static final Object get_impl(NonBlockingHashMap nonBlockingHashMap, Object[] objectArray, Object object, int n) {
        int n2 = NonBlockingHashMap.len(objectArray);
        CHM cHM = NonBlockingHashMap.chm(objectArray);
        int[] nArray = NonBlockingHashMap.hashes(objectArray);
        int n3 = n & n2 - 1;
        int n4 = 0;
        while (true) {
            Object object2 = NonBlockingHashMap.key(objectArray, n3);
            Object object3 = NonBlockingHashMap.val(objectArray, n3);
            if (object2 == null) {
                return null;
            }
            Object[] objectArray2 = cHM._newkvs;
            if (NonBlockingHashMap.keyeq(object2, object, nArray, n3, n)) {
                if (!(object3 instanceof Prime)) {
                    return object3 == TOMBSTONE ? null : object3;
                }
                return NonBlockingHashMap.get_impl(nonBlockingHashMap, cHM.copy_slot_and_check(nonBlockingHashMap, objectArray, n3, object), object, n);
            }
            if (++n4 >= NonBlockingHashMap.reprobe_limit(n2) || object == TOMBSTONE) {
                return objectArray2 == null ? null : NonBlockingHashMap.get_impl(nonBlockingHashMap, nonBlockingHashMap.help_copy(objectArray2), object, n);
            }
            n3 = n3 + 1 & n2 - 1;
        }
    }

    private static final Object putIfMatch(NonBlockingHashMap nonBlockingHashMap, Object[] objectArray, Object object, Object object2, Object object3) {
        assert (object2 != null);
        assert (!(object2 instanceof Prime));
        assert (!(object3 instanceof Prime));
        int n = NonBlockingHashMap.hash(object);
        int n2 = NonBlockingHashMap.len(objectArray);
        CHM cHM = NonBlockingHashMap.chm(objectArray);
        int[] nArray = NonBlockingHashMap.hashes(objectArray);
        int n3 = n & n2 - 1;
        int n4 = 0;
        Object object4 = null;
        Object object5 = null;
        Object[] objectArray2 = null;
        while (true) {
            object5 = NonBlockingHashMap.val(objectArray, n3);
            object4 = NonBlockingHashMap.key(objectArray, n3);
            if (object4 == null) {
                if (object2 == TOMBSTONE) {
                    return object2;
                }
                if (NonBlockingHashMap.CAS_key(objectArray, n3, null, object)) {
                    cHM._slots.add(1L);
                    nArray[n3] = n;
                    break;
                }
                object4 = NonBlockingHashMap.key(objectArray, n3);
                assert (object4 != null);
            }
            objectArray2 = cHM._newkvs;
            if (NonBlockingHashMap.keyeq(object4, object, nArray, n3, n)) break;
            if (++n4 >= NonBlockingHashMap.reprobe_limit(n2) || object == TOMBSTONE) {
                objectArray2 = cHM.resize(nonBlockingHashMap, objectArray);
                if (object3 != null) {
                    nonBlockingHashMap.help_copy(objectArray2);
                }
                return NonBlockingHashMap.putIfMatch(nonBlockingHashMap, objectArray2, object, object2, object3);
            }
            n3 = n3 + 1 & n2 - 1;
        }
        if (object2 == object5) {
            return object5;
        }
        if (objectArray2 == null && (object5 == null && cHM.tableFull(n4, n2) || object5 instanceof Prime)) {
            objectArray2 = cHM.resize(nonBlockingHashMap, objectArray);
        }
        if (objectArray2 != null) {
            return NonBlockingHashMap.putIfMatch(nonBlockingHashMap, cHM.copy_slot_and_check(nonBlockingHashMap, objectArray, n3, object3), object, object2, object3);
        }
        do {
            assert (!(object5 instanceof Prime));
            if (!(object3 == NO_MATCH_OLD || object5 == object3 || object3 == MATCH_ANY && object5 != TOMBSTONE && object5 != null || object5 == null && object3 == TOMBSTONE || object3 != null && object3.equals(object5))) {
                return object5;
            }
            if (!NonBlockingHashMap.CAS_val(objectArray, n3, object5, object2)) continue;
            if (object3 != null) {
                if ((object5 == null || object5 == TOMBSTONE) && object2 != TOMBSTONE) {
                    cHM._size.add(1L);
                }
                if (object5 != null && object5 != TOMBSTONE && object2 == TOMBSTONE) {
                    cHM._size.add(-1L);
                }
            }
            return object5 == null && object3 != null ? TOMBSTONE : object5;
        } while (!((object5 = NonBlockingHashMap.val(objectArray, n3)) instanceof Prime));
        return NonBlockingHashMap.putIfMatch(nonBlockingHashMap, cHM.copy_slot_and_check(nonBlockingHashMap, objectArray, n3, object3), object, object2, object3);
    }

    private final Object[] help_copy(Object[] objectArray) {
        Object[] objectArray2 = this._kvs;
        CHM cHM = NonBlockingHashMap.chm(objectArray2);
        if (cHM._newkvs == null) {
            return objectArray;
        }
        cHM.help_copy_impl(this, objectArray2, false);
        return objectArray;
    }

    public Enumeration<TypeV> elements() {
        return new SnapshotV();
    }

    @Override
    public Collection<TypeV> values() {
        return new AbstractCollection<TypeV>(){

            @Override
            public void clear() {
                NonBlockingHashMap.this.clear();
            }

            @Override
            public int size() {
                return NonBlockingHashMap.this.size();
            }

            @Override
            public boolean contains(Object object) {
                return NonBlockingHashMap.this.containsValue(object);
            }

            @Override
            public Iterator<TypeV> iterator() {
                return new SnapshotV();
            }
        };
    }

    public Enumeration<TypeK> keys() {
        return new SnapshotK();
    }

    @Override
    public Set<TypeK> keySet() {
        return new AbstractSet<TypeK>(){

            @Override
            public void clear() {
                NonBlockingHashMap.this.clear();
            }

            @Override
            public int size() {
                return NonBlockingHashMap.this.size();
            }

            @Override
            public boolean contains(Object object) {
                return NonBlockingHashMap.this.containsKey(object);
            }

            @Override
            public boolean remove(Object object) {
                return NonBlockingHashMap.this.remove(object) != null;
            }

            @Override
            public Iterator<TypeK> iterator() {
                return new SnapshotK();
            }
        };
    }

    @Override
    public Set<Map.Entry<TypeK, TypeV>> entrySet() {
        return new AbstractSet<Map.Entry<TypeK, TypeV>>(){

            @Override
            public void clear() {
                NonBlockingHashMap.this.clear();
            }

            @Override
            public int size() {
                return NonBlockingHashMap.this.size();
            }

            @Override
            public boolean remove(Object object) {
                if (!(object instanceof Map.Entry)) {
                    return false;
                }
                Map.Entry entry = (Map.Entry)object;
                return NonBlockingHashMap.this.remove(entry.getKey(), entry.getValue());
            }

            @Override
            public boolean contains(Object object) {
                if (!(object instanceof Map.Entry)) {
                    return false;
                }
                Map.Entry entry = (Map.Entry)object;
                Object TypeV = NonBlockingHashMap.this.get(entry.getKey());
                return TypeV.equals(entry.getValue());
            }

            @Override
            public Iterator<Map.Entry<TypeK, TypeV>> iterator() {
                return new SnapshotE();
            }
        };
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        for (TypeK TypeK : this.keySet()) {
            TypeV TypeV = this.get(TypeK);
            objectOutputStream.writeObject(TypeK);
            objectOutputStream.writeObject(TypeV);
        }
        objectOutputStream.writeObject(null);
        objectOutputStream.writeObject(null);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.initialize(8);
        while (true) {
            Object object = objectInputStream.readObject();
            Object object2 = objectInputStream.readObject();
            if (object == null) break;
            this.put((TypeK)object, (TypeV)object2);
        }
    }

    static {
        Field field = null;
        try {
            field = NonBlockingHashMap.class.getDeclaredField("_kvs");
        }
        catch (NoSuchFieldException noSuchFieldException) {
            throw new RuntimeException(noSuchFieldException);
        }
        _kvs_offset = _unsafe.objectFieldOffset(field);
        NO_MATCH_OLD = new Object();
        MATCH_ANY = new Object();
        TOMBSTONE = new Object();
        TOMBPRIME = new Prime(TOMBSTONE);
    }

    private static final class CHM<TypeK, TypeV> {
        private final Counter _size;
        private final Counter _slots;
        volatile Object[] _newkvs;
        private final AtomicReferenceFieldUpdater<CHM, Object[]> _newkvsUpdater = AtomicReferenceFieldUpdater.newUpdater(CHM.class, Object[].class, "_newkvs");
        volatile long _resizers;
        private static final AtomicLongFieldUpdater<CHM> _resizerUpdater = AtomicLongFieldUpdater.newUpdater(CHM.class, "_resizers");
        volatile long _copyIdx = 0L;
        private static final AtomicLongFieldUpdater<CHM> _copyIdxUpdater = AtomicLongFieldUpdater.newUpdater(CHM.class, "_copyIdx");
        volatile long _copyDone = 0L;
        private static final AtomicLongFieldUpdater<CHM> _copyDoneUpdater = AtomicLongFieldUpdater.newUpdater(CHM.class, "_copyDone");

        public int size() {
            return (int)this._size.get();
        }

        public int slots() {
            return (int)this._slots.get();
        }

        boolean CAS_newkvs(Object[] objectArray) {
            while (this._newkvs == null) {
                if (!this._newkvsUpdater.compareAndSet(this, null, objectArray)) continue;
                return true;
            }
            return false;
        }

        CHM(Counter counter) {
            this._size = counter;
            this._slots = new Counter();
        }

        private final boolean tableFull(int n, int n2) {
            return n >= 10 && this._slots.estimate_get() >= (long)NonBlockingHashMap.reprobe_limit(n2);
        }

        private final Object[] resize(NonBlockingHashMap nonBlockingHashMap, Object[] objectArray) {
            int n;
            assert (NonBlockingHashMap.chm(objectArray) == this);
            Object[] objectArray2 = this._newkvs;
            if (objectArray2 != null) {
                return objectArray2;
            }
            int n2 = NonBlockingHashMap.len(objectArray);
            int n3 = n = this.size();
            if (n >= n2 >> 2) {
                n3 = n2 << 1;
                if (n >= n2 >> 1) {
                    n3 = n2 << 2;
                }
            }
            long l = System.currentTimeMillis();
            long l2 = 0L;
            if (n3 <= n2 && l <= nonBlockingHashMap._last_resize_milli + 10000L && (l2 = this._slots.estimate_get()) >= (long)(n << 1)) {
                n3 = n2 << 1;
            }
            if (n3 < n2) {
                n3 = n2;
            }
            int n4 = 3;
            while (1 << n4 < n3) {
                ++n4;
            }
            long l3 = this._resizers;
            while (!_resizerUpdater.compareAndSet(this, l3, l3 + 1L)) {
                l3 = this._resizers;
            }
            int n5 = (1 << n4 << 1) + 4 << 3 >> 20;
            if (l3 >= 2L && n5 > 0) {
                objectArray2 = this._newkvs;
                if (objectArray2 != null) {
                    return objectArray2;
                }
                try {
                    Thread.sleep(8 * n5);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if ((objectArray2 = this._newkvs) != null) {
                return objectArray2;
            }
            objectArray2 = new Object[(1 << n4 << 1) + 2];
            objectArray2[0] = new CHM<TypeK, TypeV>(this._size);
            objectArray2[1] = new int[1 << n4];
            if (this._newkvs != null) {
                return this._newkvs;
            }
            if (this.CAS_newkvs(objectArray2)) {
                nonBlockingHashMap.rehash();
            } else {
                objectArray2 = this._newkvs;
            }
            return objectArray2;
        }

        private final void help_copy_impl(NonBlockingHashMap nonBlockingHashMap, Object[] objectArray, boolean bl) {
            assert (NonBlockingHashMap.chm(objectArray) == this);
            Object[] objectArray2 = this._newkvs;
            assert (objectArray2 != null);
            int n = NonBlockingHashMap.len(objectArray);
            int n2 = Math.min(n, 1024);
            int n3 = -1;
            int n4 = -9999;
            while (this._copyDone < (long)n) {
                if (n3 == -1) {
                    n4 = (int)this._copyIdx;
                    while (n4 < n << 1 && !_copyIdxUpdater.compareAndSet(this, n4, n4 + n2)) {
                        n4 = (int)this._copyIdx;
                    }
                    if (n4 >= n << 1) {
                        n3 = n4;
                    }
                }
                int n5 = 0;
                for (int i = 0; i < n2; ++i) {
                    if (!this.copy_slot(nonBlockingHashMap, n4 + i & n - 1, objectArray, objectArray2)) continue;
                    ++n5;
                }
                if (n5 > 0) {
                    this.copy_check_and_promote(nonBlockingHashMap, objectArray, n5);
                }
                n4 += n2;
                if (bl || n3 != -1) continue;
                return;
            }
            this.copy_check_and_promote(nonBlockingHashMap, objectArray, 0);
        }

        private final Object[] copy_slot_and_check(NonBlockingHashMap nonBlockingHashMap, Object[] objectArray, int n, Object object) {
            assert (NonBlockingHashMap.chm(objectArray) == this);
            Object[] objectArray2 = this._newkvs;
            assert (objectArray2 != null);
            if (this.copy_slot(nonBlockingHashMap, n, objectArray, this._newkvs)) {
                this.copy_check_and_promote(nonBlockingHashMap, objectArray, 1);
            }
            return object == null ? objectArray2 : nonBlockingHashMap.help_copy(objectArray2);
        }

        private final void copy_check_and_promote(NonBlockingHashMap nonBlockingHashMap, Object[] objectArray, int n) {
            assert (NonBlockingHashMap.chm(objectArray) == this);
            int n2 = NonBlockingHashMap.len(objectArray);
            long l = this._copyDone;
            assert (l + (long)n <= (long)n2);
            if (n > 0) {
                while (!_copyDoneUpdater.compareAndSet(this, l, l + (long)n)) {
                    l = this._copyDone;
                    assert (l + (long)n <= (long)n2);
                }
            }
            if (l + (long)n == (long)n2 && nonBlockingHashMap._kvs == objectArray && nonBlockingHashMap.CAS_kvs(objectArray, this._newkvs)) {
                nonBlockingHashMap._last_resize_milli = System.currentTimeMillis();
            }
        }

        private boolean copy_slot(NonBlockingHashMap nonBlockingHashMap, int n, Object[] objectArray, Object[] objectArray2) {
            boolean bl;
            Object object;
            Object object2;
            while ((object2 = NonBlockingHashMap.key(objectArray, n)) == null) {
                NonBlockingHashMap.CAS_key(objectArray, n, null, TOMBSTONE);
            }
            Object object3 = NonBlockingHashMap.val(objectArray, n);
            while (!(object3 instanceof Prime)) {
                Object object4 = object = object3 == null || object3 == TOMBSTONE ? TOMBPRIME : new Prime(object3);
                if (NonBlockingHashMap.CAS_val(objectArray, n, object3, object)) {
                    if (object == TOMBPRIME) {
                        return true;
                    }
                    object3 = object;
                    break;
                }
                object3 = NonBlockingHashMap.val(objectArray, n);
            }
            if (object3 == TOMBPRIME) {
                return false;
            }
            object = ((Prime)object3)._V;
            assert (object != TOMBSTONE);
            boolean bl2 = bl = NonBlockingHashMap.putIfMatch(nonBlockingHashMap, objectArray2, object2, object, null) == null;
            while (!NonBlockingHashMap.CAS_val(objectArray, n, object3, TOMBPRIME)) {
                object3 = NonBlockingHashMap.val(objectArray, n);
            }
            return bl;
        }
    }

    private static final class Prime {
        final Object _V;

        Prime(Object object) {
            this._V = object;
        }

        static Object unbox(Object object) {
            return object instanceof Prime ? ((Prime)object)._V : object;
        }
    }

    private class SnapshotV
    implements Iterator<TypeV>,
    Enumeration<TypeV> {
        final Object[] _sskvs;
        private int _idx;
        private Object _nextK;
        private Object _prevK;
        private TypeV _nextV;
        private TypeV _prevV;

        public SnapshotV() {
            Object[] objectArray;
            while (true) {
                objectArray = NonBlockingHashMap.this._kvs;
                CHM cHM = NonBlockingHashMap.chm(objectArray);
                if (cHM._newkvs == null) break;
                cHM.help_copy_impl(NonBlockingHashMap.this, objectArray, true);
            }
            this._sskvs = objectArray;
            this.next();
        }

        int length() {
            return NonBlockingHashMap.len(this._sskvs);
        }

        Object key(int n) {
            return NonBlockingHashMap.key(this._sskvs, n);
        }

        @Override
        public boolean hasNext() {
            return this._nextV != null;
        }

        @Override
        public TypeV next() {
            if (this._idx != 0 && this._nextV == null) {
                throw new NoSuchElementException();
            }
            this._prevK = this._nextK;
            this._prevV = this._nextV;
            this._nextV = null;
            while (this._idx < this.length()) {
                this._nextK = this.key(this._idx++);
                if (this._nextK == null || this._nextK == TOMBSTONE || (this._nextV = NonBlockingHashMap.this.get(this._nextK)) == null) continue;
                break;
            }
            return this._prevV;
        }

        @Override
        public void remove() {
            if (this._prevV == null) {
                throw new IllegalStateException();
            }
            NonBlockingHashMap.putIfMatch(NonBlockingHashMap.this, this._sskvs, this._prevK, TOMBSTONE, this._prevV);
            this._prevV = null;
        }

        @Override
        public TypeV nextElement() {
            return this.next();
        }

        @Override
        public boolean hasMoreElements() {
            return this.hasNext();
        }
    }

    private class SnapshotK
    implements Iterator<TypeK>,
    Enumeration<TypeK> {
        final SnapshotV _ss;

        public SnapshotK() {
            this._ss = new SnapshotV();
        }

        @Override
        public void remove() {
            this._ss.remove();
        }

        @Override
        public TypeK next() {
            this._ss.next();
            return this._ss._prevK;
        }

        @Override
        public boolean hasNext() {
            return this._ss.hasNext();
        }

        @Override
        public TypeK nextElement() {
            return this.next();
        }

        @Override
        public boolean hasMoreElements() {
            return this.hasNext();
        }
    }

    private class SnapshotE
    implements Iterator<Map.Entry<TypeK, TypeV>> {
        final SnapshotV _ss;

        public SnapshotE() {
            this._ss = new SnapshotV();
        }

        @Override
        public void remove() {
            this._ss.remove();
        }

        @Override
        public Map.Entry<TypeK, TypeV> next() {
            this._ss.next();
            return new NBHMEntry(this._ss._prevK, this._ss._prevV);
        }

        @Override
        public boolean hasNext() {
            return this._ss.hasNext();
        }
    }

    private class NBHMEntry
    extends AbstractEntry<TypeK, TypeV> {
        NBHMEntry(TypeK TypeK, TypeV TypeV) {
            super(TypeK, TypeV);
        }

        @Override
        public TypeV setValue(TypeV TypeV) {
            if (TypeV == null) {
                throw new NullPointerException();
            }
            this._val = TypeV;
            return NonBlockingHashMap.this.put(this._key, TypeV);
        }
    }
}

