/*
 * Decompiled with CFR 0.152.
 */
package zombie.core.Collections;

import java.io.Serializable;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import sun.misc.Unsafe;
import zombie.core.Collections.UtilUnsafe;

public class ConcurrentAutoTable
implements Serializable {
    private volatile CAT _cat = new CAT(null, 4, 0L);
    private static final AtomicReferenceFieldUpdater<ConcurrentAutoTable, CAT> _catUpdater = AtomicReferenceFieldUpdater.newUpdater(ConcurrentAutoTable.class, CAT.class, "_cat");

    public void add(long l) {
        this.add_if_mask(l, 0L);
    }

    public void decrement() {
        this.add_if_mask(-1L, 0L);
    }

    public void increment() {
        this.add_if_mask(1L, 0L);
    }

    public void set(long l) {
        CAT cAT = new CAT(null, 4, l);
        while (!this.CAS_cat(this._cat, cAT)) {
        }
    }

    public long get() {
        return this._cat.sum(0L);
    }

    public int intValue() {
        return (int)this._cat.sum(0L);
    }

    public long longValue() {
        return this._cat.sum(0L);
    }

    public long estimate_get() {
        return this._cat.estimate_sum(0L);
    }

    public String toString() {
        return this._cat.toString(0L);
    }

    public void print() {
        this._cat.print();
    }

    public int internal_size() {
        return this._cat._t.length;
    }

    private long add_if_mask(long l, long l2) {
        return this._cat.add_if_mask(l, l2, ConcurrentAutoTable.hash(), this);
    }

    private boolean CAS_cat(CAT cAT, CAT cAT2) {
        return _catUpdater.compareAndSet(this, cAT, cAT2);
    }

    private static final int hash() {
        int n = System.identityHashCode(Thread.currentThread());
        n ^= n >>> 20 ^ n >>> 12;
        n ^= n >>> 7 ^ n >>> 4;
        return n << 2;
    }

    private static class CAT
    implements Serializable {
        private static final Unsafe _unsafe = UtilUnsafe.getUnsafe();
        private static final int _Lbase = _unsafe.arrayBaseOffset(long[].class);
        private static final int _Lscale = _unsafe.arrayIndexScale(long[].class);
        volatile long _resizers;
        private static final AtomicLongFieldUpdater<CAT> _resizerUpdater = AtomicLongFieldUpdater.newUpdater(CAT.class, "_resizers");
        private final CAT _next;
        private volatile long _sum_cache;
        private volatile long _fuzzy_sum_cache;
        private volatile long _fuzzy_time;
        private static final int MAX_SPIN = 2;
        private long[] _t;

        private static long rawIndex(long[] lArray, int n) {
            assert (n >= 0 && n < lArray.length);
            return _Lbase + n * _Lscale;
        }

        private static final boolean CAS(long[] lArray, int n, long l, long l2) {
            return _unsafe.compareAndSwapLong(lArray, CAT.rawIndex(lArray, n), l, l2);
        }

        CAT(CAT cAT, int n, long l) {
            this._next = cAT;
            this._sum_cache = Long.MIN_VALUE;
            this._t = new long[n];
            this._t[0] = l;
        }

        public long add_if_mask(long l, long l2, int n, ConcurrentAutoTable concurrentAutoTable) {
            long[] lArray = this._t;
            int n2 = n & lArray.length - 1;
            long l3 = lArray[n2];
            boolean bl = CAT.CAS(lArray, n2, l3 & (l2 ^ 0xFFFFFFFFFFFFFFFFL), l3 + l);
            if (this._sum_cache != Long.MIN_VALUE) {
                this._sum_cache = Long.MIN_VALUE;
            }
            if (bl) {
                return l3;
            }
            if ((l3 & l2) != 0L) {
                return l3;
            }
            int n3 = 0;
            while (true) {
                if (((l3 = lArray[n2]) & l2) != 0L) {
                    return l3;
                }
                if (CAT.CAS(lArray, n2, l3, l3 + l)) break;
                ++n3;
            }
            if (n3 < 2) {
                return l3;
            }
            if (lArray.length >= 0x100000) {
                return l3;
            }
            long l4 = this._resizers;
            int n4 = lArray.length << 1 << 3;
            while (!_resizerUpdater.compareAndSet(this, l4, l4 + (long)n4)) {
                l4 = this._resizers;
            }
            l4 += (long)n4;
            if (concurrentAutoTable._cat != this) {
                return l3;
            }
            if (l4 >> 17 != 0L) {
                try {
                    Thread.sleep(l4 >> 17);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (concurrentAutoTable._cat != this) {
                    return l3;
                }
            }
            CAT cAT = new CAT(this, lArray.length * 2, 0L);
            concurrentAutoTable.CAS_cat(this, cAT);
            return l3;
        }

        public long sum(long l) {
            long l2 = this._sum_cache;
            if (l2 != Long.MIN_VALUE) {
                return l2;
            }
            l2 = this._next == null ? 0L : this._next.sum(l);
            long[] lArray = this._t;
            for (int i = 0; i < lArray.length; ++i) {
                l2 += lArray[i] & (l ^ 0xFFFFFFFFFFFFFFFFL);
            }
            this._sum_cache = l2;
            return l2;
        }

        public long estimate_sum(long l) {
            if (this._t.length <= 64) {
                return this.sum(l);
            }
            long l2 = System.currentTimeMillis();
            if (this._fuzzy_time != l2) {
                this._fuzzy_sum_cache = this.sum(l);
                this._fuzzy_time = l2;
            }
            return this._fuzzy_sum_cache;
        }

        public void all_or(long l) {
            long[] lArray = this._t;
            for (int i = 0; i < lArray.length; ++i) {
                boolean bl = false;
                while (!bl) {
                    long l2 = lArray[i];
                    bl = CAT.CAS(lArray, i, l2, l2 | l);
                }
            }
            if (this._next != null) {
                this._next.all_or(l);
            }
            if (this._sum_cache != Long.MIN_VALUE) {
                this._sum_cache = Long.MIN_VALUE;
            }
        }

        public void all_and(long l) {
            long[] lArray = this._t;
            for (int i = 0; i < lArray.length; ++i) {
                boolean bl = false;
                while (!bl) {
                    long l2 = lArray[i];
                    bl = CAT.CAS(lArray, i, l2, l2 & l);
                }
            }
            if (this._next != null) {
                this._next.all_and(l);
            }
            if (this._sum_cache != Long.MIN_VALUE) {
                this._sum_cache = Long.MIN_VALUE;
            }
        }

        public void all_set(long l) {
            long[] lArray = this._t;
            for (int i = 0; i < lArray.length; ++i) {
                lArray[i] = l;
            }
            if (this._next != null) {
                this._next.all_set(l);
            }
            if (this._sum_cache != Long.MIN_VALUE) {
                this._sum_cache = Long.MIN_VALUE;
            }
        }

        String toString(long l) {
            return Long.toString(this.sum(l));
        }

        public void print() {
            long[] lArray = this._t;
            System.out.print("[sum=" + this._sum_cache + "," + lArray[0]);
            for (int i = 1; i < lArray.length; ++i) {
                System.out.print("," + lArray[i]);
            }
            System.out.print("]");
            if (this._next != null) {
                this._next.print();
            }
        }
    }
}

