/*
 * Decompiled with CFR 0.152.
 */
package zombie.config;

import zombie.config.ConfigOption;

public class StringConfigOption
extends ConfigOption {
    protected String value;
    protected String defaultValue;
    protected int maxLength;

    public StringConfigOption(String string, String string2, int n) {
        super(string);
        if (string2 == null) {
            string2 = "";
        }
        this.value = string2;
        this.defaultValue = string2;
        this.maxLength = n;
    }

    @Override
    public String getType() {
        return "string";
    }

    @Override
    public void resetToDefault() {
        this.value = this.defaultValue;
    }

    @Override
    public void setDefaultToCurrentValue() {
        this.defaultValue = this.value;
    }

    @Override
    public void parse(String string) {
        this.setValueFromObject(string);
    }

    @Override
    public String getValueAsString() {
        return this.value;
    }

    @Override
    public String getValueAsLuaString() {
        return String.format("\"%s\"", this.value.replace("\\", "\\\\").replace("\"", "\\\""));
    }

    @Override
    public void setValueFromObject(Object object) {
        this.value = object == null ? "" : (object instanceof String ? (String)object : object.toString());
    }

    @Override
    public Object getValueAsObject() {
        return this.value;
    }

    @Override
    public boolean isValidString(String string) {
        return true;
    }

    public void setValue(String string) {
        if (string == null) {
            string = "";
        }
        if (this.maxLength > 0 && string.length() > this.maxLength) {
            string = string.substring(0, this.maxLength);
        }
        this.value = string;
    }

    public String getValue() {
        return this.value;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    @Override
    public String getTooltip() {
        return this.value;
    }
}

