/*
 * Decompiled with CFR 0.152.
 */
package zombie.config;

import zombie.config.ConfigOption;
import zombie.debug.DebugLog;

public class IntegerConfigOption
extends ConfigOption {
    protected int value;
    protected int defaultValue;
    protected int min;
    protected int max;

    public IntegerConfigOption(String string, int n, int n2, int n3) {
        super(string);
        if (n3 < n || n3 > n2) {
            throw new IllegalArgumentException();
        }
        this.value = n3;
        this.defaultValue = n3;
        this.min = n;
        this.max = n2;
    }

    @Override
    public String getType() {
        return "integer";
    }

    @Override
    public void resetToDefault() {
        this.setValue(this.defaultValue);
    }

    public double getMin() {
        return this.min;
    }

    public double getMax() {
        return this.max;
    }

    @Override
    public void setDefaultToCurrentValue() {
        this.defaultValue = this.value;
    }

    @Override
    public void parse(String string) {
        try {
            double d = Double.parseDouble(string);
            this.setValue((int)d);
        }
        catch (NumberFormatException numberFormatException) {
            DebugLog.log("ERROR IntegerConfigOption.parse() \"" + this.name + "\" string=\"" + string + "\"");
        }
    }

    @Override
    public String getValueAsString() {
        return String.valueOf(this.value);
    }

    @Override
    public void setValueFromObject(Object object) {
        if (object instanceof Double) {
            this.setValue(((Double)object).intValue());
        } else if (object instanceof String) {
            this.parse((String)object);
        }
    }

    @Override
    public Object getValueAsObject() {
        return (double)this.value;
    }

    @Override
    public boolean isValidString(String string) {
        try {
            int n = Integer.parseInt(string);
            return n >= this.min && n <= this.max;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    public void setValue(int n) {
        if (n < this.min) {
            DebugLog.log("ERROR: IntegerConfigOption.setValue() \"" + this.name + "\" " + n + " is less than min=" + this.min);
            return;
        }
        if (n > this.max) {
            DebugLog.log("ERROR: IntegerConfigOption.setValue() \"" + this.name + "\" " + n + " is greater than max=" + this.max);
            return;
        }
        this.value = n;
    }

    public int getValue() {
        return this.value;
    }

    public int getDefaultValue() {
        return this.defaultValue;
    }

    @Override
    public String getTooltip() {
        return String.valueOf(this.value);
    }
}

