/*
 * Decompiled with CFR 0.152.
 */
package zombie.config;

import zombie.config.ConfigOption;
import zombie.debug.DebugLog;

public class DoubleConfigOption
extends ConfigOption {
    protected double value;
    protected double defaultValue;
    protected double min;
    protected double max;

    public DoubleConfigOption(String string, double d, double d2, double d3) {
        super(string);
        if (d3 < d || d3 > d2) {
            throw new IllegalArgumentException();
        }
        this.value = d3;
        this.defaultValue = d3;
        this.min = d;
        this.max = d2;
    }

    @Override
    public String getType() {
        return "double";
    }

    public double getMin() {
        return this.min;
    }

    public double getMax() {
        return this.max;
    }

    @Override
    public void resetToDefault() {
        this.setValue(this.defaultValue);
    }

    @Override
    public void setDefaultToCurrentValue() {
        this.defaultValue = this.value;
    }

    @Override
    public void parse(String string) {
        try {
            double d = Double.parseDouble(string);
            this.setValue(d);
        }
        catch (NumberFormatException numberFormatException) {
            DebugLog.log("ERROR DoubleConfigOption.parse() \"" + this.name + "\" string=" + string + "\"");
        }
    }

    @Override
    public String getValueAsString() {
        return String.valueOf(this.value);
    }

    @Override
    public void setValueFromObject(Object object) {
        if (object instanceof Double) {
            this.setValue((Double)object);
        } else if (object instanceof String) {
            this.parse((String)object);
        }
    }

    @Override
    public Object getValueAsObject() {
        return this.value;
    }

    @Override
    public boolean isValidString(String string) {
        try {
            double d = Double.parseDouble(string);
            return d >= this.min && d <= this.max;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    public void setValue(double d) {
        if (d < this.min) {
            DebugLog.log("ERROR: DoubleConfigOption.setValue() \"" + this.name + "\" " + d + " is less than min=" + this.min);
            return;
        }
        if (d > this.max) {
            DebugLog.log("ERROR: DoubleConfigOption.setValue() \"" + this.name + "\" " + d + " is greater than max=" + this.max);
            return;
        }
        this.value = d;
    }

    public double getValue() {
        return this.value;
    }

    public double getDefaultValue() {
        return this.defaultValue;
    }

    @Override
    public String getTooltip() {
        return String.valueOf(this.value);
    }
}

