/*
 * Decompiled with CFR 0.152.
 */
package zombie.commands.serverCommands;

import java.sql.SQLException;
import zombie.characters.IsoPlayer;
import zombie.commands.CommandArgs;
import zombie.commands.CommandBase;
import zombie.commands.CommandHelp;
import zombie.commands.CommandName;
import zombie.commands.PlayerType;
import zombie.commands.RequiredRight;
import zombie.core.logger.LoggerManager;
import zombie.core.raknet.UdpConnection;
import zombie.network.GameServer;
import zombie.network.ServerWorldDatabase;
import zombie.network.chat.ChatServer;

@CommandName(name="setaccesslevel")
@CommandArgs(required={"(.+)", "(\\w+)"})
@CommandHelp(helpText="UI_ServerOptionDesc_SetAccessLevel")
@RequiredRight(requiredRights=48)
public class SetAccessLevelCommand
extends CommandBase {
    public SetAccessLevelCommand(String string, String string2, String string3, UdpConnection udpConnection) {
        super(string, string2, string3, udpConnection);
    }

    @Override
    protected String Command() throws SQLException {
        String string = this.getCommandArg(0);
        String string2 = "none".equals(this.getCommandArg(1)) ? "" : this.getCommandArg(1);
        return SetAccessLevelCommand.update(this.getExecutorUsername(), this.connection, string, string2);
    }

    static String update(String string, UdpConnection udpConnection, String string2, String string3) throws SQLException {
        if (udpConnection != null && udpConnection.isCoopHost || ServerWorldDatabase.instance.containsUser(string2) || udpConnection == null) {
            IsoPlayer isoPlayer = GameServer.getPlayerByUserName(string2);
            byte by = PlayerType.fromString(string3.trim().toLowerCase());
            if (udpConnection != null && udpConnection.accessLevel == 16 && by == 32) {
                return "Moderators can't set Admin access level";
            }
            if (by == 0) {
                return "Access Level '" + by + "' unknown, list of access level: player, admin, moderator, overseer, gm, observer";
            }
            if (isoPlayer != null) {
                UdpConnection udpConnection2;
                byte by2;
                if (isoPlayer.networkAI != null) {
                    isoPlayer.networkAI.setCheckAccessLevelDelay(5000L);
                }
                if ((by2 = (udpConnection2 = GameServer.getConnectionFromPlayer(isoPlayer)) != null ? udpConnection2.accessLevel : PlayerType.fromString(isoPlayer.accessLevel.toLowerCase())) != by) {
                    if (by == 32) {
                        ChatServer.getInstance().joinAdminChat(isoPlayer.OnlineID);
                    } else if (by2 == 32 && by != 32) {
                        ChatServer.getInstance().leaveAdminChat(isoPlayer.OnlineID);
                    }
                }
                if (by2 != 1 && by == 1) {
                    isoPlayer.setGhostMode(false);
                    isoPlayer.setNoClip(false);
                }
                isoPlayer.accessLevel = PlayerType.toString(by);
                if (udpConnection2 != null) {
                    udpConnection2.accessLevel = by;
                }
                if ((by & 0x3E) != 0) {
                    isoPlayer.setGodMod(true);
                    isoPlayer.setGhostMode(true);
                    isoPlayer.setInvisible(true);
                } else {
                    isoPlayer.setGodMod(false);
                    isoPlayer.setGhostMode(false);
                    isoPlayer.setInvisible(false);
                }
                GameServer.sendPlayerExtraInfo(isoPlayer, null);
            }
            LoggerManager.getLogger("admin").write(string + " granted " + by + " access level on " + string2);
            if (udpConnection == null || !udpConnection.isCoopHost) {
                return ServerWorldDatabase.instance.setAccessLevel(string2, PlayerType.toString(by));
            }
            return "Your access level is now: " + by;
        }
        return "User \"" + string2 + "\" is not in the whitelist, use /adduser first";
    }
}

