/*
 * Decompiled with CFR 0.152.
 */
package zombie.commands.serverCommands;

import zombie.characters.IsoPlayer;
import zombie.commands.AltCommandArgs;
import zombie.commands.CommandArgs;
import zombie.commands.CommandBase;
import zombie.commands.CommandHelp;
import zombie.commands.CommandName;
import zombie.commands.RequiredRight;
import zombie.core.logger.LoggerManager;
import zombie.core.raknet.UdpConnection;
import zombie.network.GameServer;
import zombie.network.ReplayManager;

@CommandName(name="replay")
@AltCommandArgs(value={@CommandArgs(required={"(.+)", "(-record|-play|-stop)", "(.+)"}), @CommandArgs(required={"(.+)", "(-stop)"})})
@CommandHelp(helpText="UI_ServerOptionDesc_Replay")
@RequiredRight(requiredRights=32)
public class ReplayCommands
extends CommandBase {
    public static final String RecordPlay = "(-record|-play|-stop)";
    public static final String Stop = "(-stop)";

    public ReplayCommands(String string, String string2, String string3, UdpConnection udpConnection) {
        super(string, string2, string3, udpConnection);
    }

    @Override
    protected String Command() {
        String string = this.getCommandArg(0);
        String string2 = this.getCommandArg(1);
        String string3 = this.getCommandArg(2);
        boolean bl = false;
        boolean bl2 = false;
        if ("-play".equals(string2)) {
            bl2 = true;
        } else if ("-stop".equals(string2)) {
            bl = true;
        }
        IsoPlayer isoPlayer = GameServer.getPlayerByUserNameForCommand(string);
        if (isoPlayer != null) {
            if (isoPlayer.replay == null) {
                isoPlayer.replay = new ReplayManager(isoPlayer);
            }
            if (bl) {
                ReplayManager.State state = isoPlayer.replay.getState();
                if (state == ReplayManager.State.Stop) {
                    return "Nothing to stop.";
                }
                if (state == ReplayManager.State.Recording) {
                    isoPlayer.replay.stopRecordReplay();
                    LoggerManager.getLogger("admin").write(this.getExecutorUsername() + " end record replay for " + string);
                    return "Recording replay is stopped  for " + string + ".";
                }
                isoPlayer.replay.stopPlayReplay();
                LoggerManager.getLogger("admin").write(this.getExecutorUsername() + " end play replay for " + string);
                return "Playing replay is stopped  for " + string + ".";
            }
            if (bl2) {
                if (!isoPlayer.replay.startPlayReplay(isoPlayer, string3, this.connection)) {
                    return "Can't play replay";
                }
                LoggerManager.getLogger("admin").write(this.getExecutorUsername() + " enabled play replay for " + string);
                return "Replay is playing for " + string + " to file \"" + string3 + "\" now.";
            }
            if (!isoPlayer.replay.startRecordReplay(isoPlayer, string3)) {
                return "Can't record replay";
            }
            LoggerManager.getLogger("admin").write(this.getExecutorUsername() + " enabled record replay for " + string);
            return "Replay is recording for " + string + " to file \"" + string3 + "\" now.";
        }
        return "User " + string + " not found.";
    }
}

