/*
 * Decompiled with CFR 0.152.
 */
package zombie.commands.serverCommands;

import java.util.ArrayList;
import zombie.commands.CommandArgs;
import zombie.commands.CommandBase;
import zombie.commands.CommandHelp;
import zombie.commands.CommandName;
import zombie.commands.RequiredRight;
import zombie.core.Translator;
import zombie.core.raknet.UdpConnection;
import zombie.core.znet.ZNet;
import zombie.debug.DebugLog;
import zombie.debug.DebugType;
import zombie.debug.LogSeverity;

@CommandName(name="log")
@CommandArgs(required={"(.+)", "(.+)"})
@CommandHelp(helpText="UI_ServerOptionDesc_SetLogLevel")
@RequiredRight(requiredRights=32)
public class LogCommand
extends CommandBase {
    public LogCommand(String string, String string2, String string3, UdpConnection udpConnection) {
        super(string, string2, string3, udpConnection);
    }

    public static DebugType getDebugType(String string) {
        ArrayList<DebugType> arrayList = new ArrayList<DebugType>();
        for (DebugType debugType : DebugType.values()) {
            if (!debugType.name().toLowerCase().startsWith(string.toLowerCase())) continue;
            arrayList.add(debugType);
        }
        return arrayList.size() == 1 ? (DebugType)((Object)arrayList.get(0)) : null;
    }

    public static LogSeverity getLogSeverity(String string) {
        ArrayList<LogSeverity> arrayList = new ArrayList<LogSeverity>();
        for (LogSeverity logSeverity : LogSeverity.values()) {
            if (!logSeverity.name().toLowerCase().startsWith(string.toLowerCase())) continue;
            arrayList.add(logSeverity);
        }
        return arrayList.size() == 1 ? (LogSeverity)((Object)arrayList.get(0)) : null;
    }

    @Override
    protected String Command() {
        DebugType debugType = LogCommand.getDebugType(this.getCommandArg(0));
        LogSeverity logSeverity = LogCommand.getLogSeverity(this.getCommandArg(1));
        if (debugType == null || logSeverity == null) {
            return Translator.getText("UI_ServerOptionDesc_SetLogLevel", debugType == null ? "\"type\"" : debugType.name().toLowerCase(), logSeverity == null ? "\"severity\"" : logSeverity.name().toLowerCase());
        }
        DebugLog.enableLog(debugType, logSeverity);
        if (DebugType.Network.equals((Object)debugType)) {
            ZNet.SetLogLevel(logSeverity);
        }
        return String.format("Server \"%s\" log level is \"%s\"", debugType.name().toLowerCase(), logSeverity.name().toLowerCase());
    }
}

