/*
 * Decompiled with CFR 0.152.
 */
package zombie.commands.serverCommands;

import zombie.commands.AltCommandArgs;
import zombie.commands.CommandArgs;
import zombie.commands.CommandBase;
import zombie.commands.CommandHelp;
import zombie.commands.CommandName;
import zombie.commands.CommandNames;
import zombie.commands.RequiredRight;
import zombie.core.logger.LoggerManager;
import zombie.core.raknet.UdpConnection;
import zombie.network.GameServer;
import zombie.network.ServerOptions;
import zombie.network.ServerWorldDatabase;
import zombie.network.Userlog;

@CommandNames(value={@CommandName(name="kick"), @CommandName(name="kickuser")})
@AltCommandArgs(value={@CommandArgs(required={"(.+)"}), @CommandArgs(required={"(.+)", "-r", "(.+)"})})
@CommandHelp(helpText="UI_ServerOptionDesc_Kick")
@RequiredRight(requiredRights=56)
public class KickUserCommand
extends CommandBase {
    private String reason = "";

    public KickUserCommand(String string, String string2, String string3, UdpConnection udpConnection) {
        super(string, string2, string3, udpConnection);
    }

    @Override
    protected String Command() {
        String string = this.getCommandArg(0);
        if (this.hasOptionalArg(1)) {
            this.reason = this.getCommandArg(1);
        }
        LoggerManager.getLogger("admin").write(this.getExecutorUsername() + " kicked user " + string);
        ServerWorldDatabase.instance.addUserlog(string, Userlog.UserlogType.Kicked, this.reason, this.getExecutorUsername(), 1);
        boolean bl = false;
        block0: for (int i = 0; i < GameServer.udpEngine.connections.size(); ++i) {
            UdpConnection udpConnection = GameServer.udpEngine.connections.get(i);
            for (int j = 0; j < 4; ++j) {
                if (!string.equals(udpConnection.usernames[j])) continue;
                bl = true;
                if ("".equals(this.reason)) {
                    GameServer.kick(udpConnection, "UI_Policy_Kick", null);
                } else {
                    GameServer.kick(udpConnection, "You have been kicked from this server for the following reason: " + this.reason, null);
                }
                udpConnection.forceDisconnect("command-kick");
                GameServer.addDisconnect(udpConnection);
                continue block0;
            }
        }
        if (bl && ServerOptions.instance.BanKickGlobalSound.getValue()) {
            GameServer.PlaySoundAtEveryPlayer("RumbleThunder");
        }
        if (bl) {
            return "User " + string + " kicked.";
        }
        return "User " + string + " doesn't exist.";
    }
}

