/*
 * Decompiled with CFR 0.152.
 */
package zombie.commands.serverCommands;

import zombie.characters.IsoPlayer;
import zombie.commands.AltCommandArgs;
import zombie.commands.CommandArgs;
import zombie.commands.CommandBase;
import zombie.commands.CommandHelp;
import zombie.commands.CommandName;
import zombie.commands.CommandNames;
import zombie.commands.RequiredRight;
import zombie.core.logger.LoggerManager;
import zombie.core.raknet.UdpConnection;
import zombie.network.GameServer;

@CommandNames(value={@CommandName(name="godmod"), @CommandName(name="godmode")})
@AltCommandArgs(value={@CommandArgs(required={"(.+)"}, optional="(-true|-false)"), @CommandArgs(optional="(-true|-false)")})
@CommandHelp(helpText="UI_ServerOptionDesc_GodMod")
@RequiredRight(requiredRights=62)
public class GodModeCommand
extends CommandBase {
    public GodModeCommand(String string, String string2, String string3, UdpConnection udpConnection) {
        super(string, string2, string3, udpConnection);
    }

    @Override
    protected String Command() {
        IsoPlayer isoPlayer;
        String string = this.getExecutorUsername();
        String string2 = this.getCommandArg(0);
        String string3 = this.getCommandArg(1);
        if (this.getCommandArgsCount() == 2 || this.getCommandArgsCount() == 1 && !string2.equals("-true") && !string2.equals("-false")) {
            string = string2;
            if (this.connection != null && this.connection.accessLevel == 2 && !string.equals(string2)) {
                return "An Observer can only toggle god mode on himself";
            }
        }
        if ((isoPlayer = GameServer.getPlayerByUserNameForCommand(string)) != null) {
            string = isoPlayer.getDisplayName();
            if (string3 != null) {
                isoPlayer.setGodMod("-true".equals(string3));
            } else {
                isoPlayer.setGodMod(!isoPlayer.isGodMod());
            }
            GameServer.sendPlayerExtraInfo(isoPlayer, this.connection);
            if (isoPlayer.isGodMod()) {
                LoggerManager.getLogger("admin").write(this.getExecutorUsername() + " enabled godmode on " + string);
                return "User " + string + " is now invincible.";
            }
            LoggerManager.getLogger("admin").write(this.getExecutorUsername() + " disabled godmode on " + string);
            return "User " + string + " is no more invincible.";
        }
        return "User " + string + " not found.";
    }
}

