/*
 * Decompiled with CFR 0.152.
 */
package zombie.commands.serverCommands;

import java.sql.SQLException;
import zombie.commands.AltCommandArgs;
import zombie.commands.CommandArgs;
import zombie.commands.CommandBase;
import zombie.commands.CommandHelp;
import zombie.commands.CommandName;
import zombie.commands.RequiredRight;
import zombie.core.logger.LoggerManager;
import zombie.core.raknet.UdpConnection;
import zombie.core.znet.SteamUtils;
import zombie.network.GameServer;
import zombie.network.ServerOptions;
import zombie.network.ServerWorldDatabase;
import zombie.network.Userlog;

@CommandName(name="banuser")
@AltCommandArgs(value={@CommandArgs(required={"(.+)"}, argName="Ban User Only"), @CommandArgs(required={"(.+)", "-ip"}, argName="Ban User And IP"), @CommandArgs(required={"(.+)", "-r", "(.+)"}, argName="Ban User And Supply Reason"), @CommandArgs(required={"(.+)", "-ip", "-r", "(.+)"}, argName="Ban User And IP And Supply Reason")})
@CommandHelp(helpText="UI_ServerOptionDesc_BanUser")
@RequiredRight(requiredRights=48)
public class BanUserCommand
extends CommandBase {
    private String reason = "";
    public static final String banUser = "Ban User Only";
    public static final String banWithIP = "Ban User And IP";
    public static final String banWithReason = "Ban User And Supply Reason";
    public static final String banWithReasonIP = "Ban User And IP And Supply Reason";

    public BanUserCommand(String string, String string2, String string3, UdpConnection udpConnection) {
        super(string, string2, string3, udpConnection);
    }

    @Override
    protected String Command() throws SQLException {
        String string = this.getCommandArg(0);
        if (this.hasOptionalArg(1)) {
            this.reason = this.getCommandArg(1);
        }
        boolean bl = false;
        switch (this.argsName) {
            case "Ban User And IP": 
            case "Ban User And IP And Supply Reason": {
                bl = true;
            }
        }
        String string2 = ServerWorldDatabase.instance.banUser(string, true);
        ServerWorldDatabase.instance.addUserlog(string, Userlog.UserlogType.Banned, this.reason, this.getExecutorUsername(), 1);
        LoggerManager.getLogger("admin").write(this.getExecutorUsername() + " banned user " + string + (this.reason != null ? this.reason : ""), "IMPORTANT");
        int n = 0;
        for (int i = 0; i < GameServer.udpEngine.connections.size(); ++i) {
            UdpConnection udpConnection = GameServer.udpEngine.connections.get(i);
            if (!udpConnection.username.equals(string)) continue;
            n = 1;
            if (SteamUtils.isSteamModeEnabled()) {
                LoggerManager.getLogger("admin").write(this.getExecutorUsername() + " banned steamid " + udpConnection.steamID + "(" + udpConnection.username + ")" + (this.reason != null ? this.reason : ""), "IMPORTANT");
                String string3 = SteamUtils.convertSteamIDToString(udpConnection.steamID);
                ServerWorldDatabase.instance.banSteamID(string3, this.reason, true);
            }
            if (bl) {
                LoggerManager.getLogger("admin").write(this.getExecutorUsername() + " banned ip " + udpConnection.ip + "(" + udpConnection.username + ")" + (this.reason != null ? this.reason : ""), "IMPORTANT");
                ServerWorldDatabase.instance.banIp(udpConnection.ip, string, this.reason, true);
            }
            if ("".equals(this.reason)) {
                GameServer.kick(udpConnection, "UI_Policy_Ban", null);
            } else {
                GameServer.kick(udpConnection, "You have been banned from this server for the following reason: " + this.reason, null);
            }
            udpConnection.forceDisconnect("command-ban-ip");
            break;
        }
        if (n != 0 && ServerOptions.instance.BanKickGlobalSound.getValue()) {
            GameServer.PlaySoundAtEveryPlayer("Thunder");
        }
        return string2;
    }
}

