/*
 * Decompiled with CFR 0.152.
 */
package zombie.commands.serverCommands;

import zombie.characters.IsoPlayer;
import zombie.characters.skills.PerkFactory;
import zombie.commands.CommandArgs;
import zombie.commands.CommandBase;
import zombie.commands.CommandHelp;
import zombie.commands.CommandName;
import zombie.commands.RequiredRight;
import zombie.core.logger.LoggerManager;
import zombie.core.network.ByteBufferWriter;
import zombie.core.raknet.UdpConnection;
import zombie.network.GameServer;
import zombie.network.PacketTypes;
import zombie.network.packets.AddXp;

@CommandName(name="addxp")
@CommandArgs(required={"(.+)", "(\\S+)"})
@CommandHelp(helpText="UI_ServerOptionDesc_AddXp")
@RequiredRight(requiredRights=60)
public class AddXPCommand
extends CommandBase {
    public AddXPCommand(String string, String string2, String string3, UdpConnection udpConnection) {
        super(string, string2, string3, udpConnection);
    }

    @Override
    protected String Command() {
        String string = this.getCommandArg(0);
        String string2 = this.getCommandArg(1);
        IsoPlayer isoPlayer = GameServer.getPlayerByUserNameForCommand(string);
        if (isoPlayer == null) {
            return "No such user";
        }
        String string3 = isoPlayer.getDisplayName();
        String string4 = null;
        int n = 0;
        String[] stringArray = string2.split("=", 2);
        if (stringArray.length != 2) {
            return this.getHelp();
        }
        string4 = stringArray[0].trim();
        if (PerkFactory.Perks.FromString(string4) == PerkFactory.Perks.MAX) {
            String string5 = this.connection == null ? "\n" : " LINE ";
            StringBuilder stringBuilder = new StringBuilder();
            for (int i = 0; i < PerkFactory.PerkList.size(); ++i) {
                if (PerkFactory.PerkList.get(i) == PerkFactory.Perks.Passiv) continue;
                stringBuilder.append(PerkFactory.PerkList.get(i));
                if (i >= PerkFactory.PerkList.size()) continue;
                stringBuilder.append(string5);
            }
            return "List of available perks :" + string5 + stringBuilder.toString();
        }
        try {
            n = Integer.parseInt(stringArray[1]);
        }
        catch (NumberFormatException numberFormatException) {
            return this.getHelp();
        }
        IsoPlayer isoPlayer2 = GameServer.getPlayerByUserNameForCommand(string3);
        if (isoPlayer2 != null) {
            string3 = isoPlayer2.getDisplayName();
            UdpConnection udpConnection = GameServer.getConnectionFromPlayer(isoPlayer2);
            if (udpConnection != null) {
                AddXp addXp = new AddXp();
                addXp.set(isoPlayer, PerkFactory.Perks.FromString(string4), n);
                ByteBufferWriter byteBufferWriter = udpConnection.startPacket();
                PacketTypes.PacketType.AddXP.doPacket(byteBufferWriter);
                addXp.write(byteBufferWriter);
                PacketTypes.PacketType.AddXP.send(udpConnection);
                LoggerManager.getLogger("admin").write(this.getExecutorUsername() + " added " + n + " " + string4 + " xp's to " + string3);
                return "Added " + n + " " + string4 + " xp's to " + string3;
            }
        }
        return "User " + string3 + " not found.";
    }
}

