/*
 * Decompiled with CFR 0.152.
 */
package zombie.commands.serverCommands;

import zombie.characters.IsoPlayer;
import zombie.commands.AltCommandArgs;
import zombie.commands.CommandArgs;
import zombie.commands.CommandBase;
import zombie.commands.CommandHelp;
import zombie.commands.CommandName;
import zombie.commands.RequiredRight;
import zombie.core.logger.LoggerManager;
import zombie.core.network.ByteBufferWriter;
import zombie.core.raknet.UdpConnection;
import zombie.network.GameServer;
import zombie.network.PacketTypes;
import zombie.scripting.ScriptManager;
import zombie.scripting.objects.Item;

@CommandName(name="additem")
@AltCommandArgs(value={@CommandArgs(required={"(.+)", "([a-zA-Z0-9.-]*[a-zA-Z][a-zA-Z0-9_.-]*)"}, optional="(\\d+)", argName="add item to player"), @CommandArgs(required={"([a-zA-Z0-9.-]*[a-zA-Z][a-zA-Z0-9_.-]*)"}, optional="(\\d+)", argName="add item to me")})
@CommandHelp(helpText="UI_ServerOptionDesc_AddItem")
@RequiredRight(requiredRights=60)
public class AddItemCommand
extends CommandBase {
    public static final String toMe = "add item to me";
    public static final String toPlayer = "add item to player";

    public AddItemCommand(String string, String string2, String string3, UdpConnection udpConnection) {
        super(string, string2, string3, udpConnection);
    }

    @Override
    protected String Command() {
        String string;
        Object object;
        int n = 1;
        if (this.argsName.equals(toMe) && this.connection == null) {
            return "Pass username";
        }
        if (this.getCommandArgsCount() > 1) {
            int n2 = this.getCommandArgsCount();
            if (this.argsName.equals(toMe) && n2 == 2 || this.argsName.equals(toPlayer) && n2 == 3) {
                n = Integer.parseInt(this.getCommandArg(this.getCommandArgsCount() - 1));
            }
        }
        if (this.argsName.equals(toPlayer)) {
            object = GameServer.getPlayerByUserNameForCommand(this.getCommandArg(0));
            if (object == null) {
                return "No such user";
            }
            string = ((IsoPlayer)object).getDisplayName();
        } else {
            object = GameServer.getPlayerByRealUserName(this.getExecutorUsername());
            if (object == null) {
                return "No such user";
            }
            string = ((IsoPlayer)object).getDisplayName();
        }
        object = this.argsName.equals(toMe) ? this.getCommandArg(0) : this.getCommandArg(1);
        Item item = ScriptManager.instance.FindItem((String)object);
        if (item == null) {
            return "Item " + (String)object + " doesn't exist.";
        }
        IsoPlayer isoPlayer = GameServer.getPlayerByUserNameForCommand(string);
        if (isoPlayer != null) {
            string = isoPlayer.getDisplayName();
            UdpConnection udpConnection = GameServer.getConnectionByPlayerOnlineID(isoPlayer.OnlineID);
            if (udpConnection != null) {
                ByteBufferWriter byteBufferWriter = udpConnection.startPacket();
                PacketTypes.PacketType.AddItemInInventory.doPacket(byteBufferWriter);
                byteBufferWriter.putShort(isoPlayer.OnlineID);
                byteBufferWriter.putUTF((String)object);
                byteBufferWriter.putInt(n);
                PacketTypes.PacketType.AddItemInInventory.send(udpConnection);
                LoggerManager.getLogger("admin").write(this.getExecutorUsername() + " added item " + (String)object + " in " + string + "'s inventory");
                ByteBufferWriter byteBufferWriter2 = udpConnection.startPacket();
                PacketTypes.PacketType.RequestInventory.doPacket(byteBufferWriter2);
                byteBufferWriter2.putShort(isoPlayer.OnlineID);
                PacketTypes.PacketType.RequestInventory.send(udpConnection);
                return "Item " + (String)object + " Added in " + string + "'s inventory.";
            }
        }
        return "User " + string + " not found.";
    }
}

