/*
 * Decompiled with CFR 0.152.
 */
package zombie.commands;

import java.lang.annotation.Annotation;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import zombie.commands.CommandArgs;
import zombie.commands.CommandHelp;
import zombie.commands.CommandName;
import zombie.commands.DisabledCommand;
import zombie.commands.RequiredRight;
import zombie.commands.serverCommands.AddAllToWhiteListCommand;
import zombie.commands.serverCommands.AddItemCommand;
import zombie.commands.serverCommands.AddUserCommand;
import zombie.commands.serverCommands.AddUserToWhiteListCommand;
import zombie.commands.serverCommands.AddVehicleCommand;
import zombie.commands.serverCommands.AddXPCommand;
import zombie.commands.serverCommands.AlarmCommand;
import zombie.commands.serverCommands.BanSteamIDCommand;
import zombie.commands.serverCommands.BanUserCommand;
import zombie.commands.serverCommands.ChangeOptionCommand;
import zombie.commands.serverCommands.CheckModsNeedUpdate;
import zombie.commands.serverCommands.ChopperCommand;
import zombie.commands.serverCommands.ClearCommand;
import zombie.commands.serverCommands.ConnectionsCommand;
import zombie.commands.serverCommands.CreateHorde2Command;
import zombie.commands.serverCommands.CreateHordeCommand;
import zombie.commands.serverCommands.DebugPlayerCommand;
import zombie.commands.serverCommands.GodModeCommand;
import zombie.commands.serverCommands.GrantAdminCommand;
import zombie.commands.serverCommands.GunShotCommand;
import zombie.commands.serverCommands.HelpCommand;
import zombie.commands.serverCommands.InvisibleCommand;
import zombie.commands.serverCommands.KickUserCommand;
import zombie.commands.serverCommands.LightningCommand;
import zombie.commands.serverCommands.LogCommand;
import zombie.commands.serverCommands.NoClipCommand;
import zombie.commands.serverCommands.PlayersCommand;
import zombie.commands.serverCommands.QuitCommand;
import zombie.commands.serverCommands.ReleaseSafehouseCommand;
import zombie.commands.serverCommands.ReloadLuaCommand;
import zombie.commands.serverCommands.ReloadOptionsCommand;
import zombie.commands.serverCommands.RemoveAdminCommand;
import zombie.commands.serverCommands.RemoveUserFromWhiteList;
import zombie.commands.serverCommands.RemoveZombiesCommand;
import zombie.commands.serverCommands.ReplayCommands;
import zombie.commands.serverCommands.SaveCommand;
import zombie.commands.serverCommands.ServerMessageCommand;
import zombie.commands.serverCommands.SetAccessLevelCommand;
import zombie.commands.serverCommands.ShowOptionsCommand;
import zombie.commands.serverCommands.StartRainCommand;
import zombie.commands.serverCommands.StartStormCommand;
import zombie.commands.serverCommands.StatisticsCommand;
import zombie.commands.serverCommands.StopRainCommand;
import zombie.commands.serverCommands.StopWeatherCommand;
import zombie.commands.serverCommands.TeleportCommand;
import zombie.commands.serverCommands.TeleportToCommand;
import zombie.commands.serverCommands.ThunderCommand;
import zombie.commands.serverCommands.UnbanSteamIDCommand;
import zombie.commands.serverCommands.UnbanUserCommand;
import zombie.commands.serverCommands.VoiceBanCommand;
import zombie.core.Translator;
import zombie.core.raknet.UdpConnection;

public abstract class CommandBase {
    private final int playerType;
    private final String username;
    private final String command;
    private String[] commandArgs;
    private boolean parsingSuccessful = false;
    private boolean parsed = false;
    private String message = "";
    protected final UdpConnection connection;
    protected String argsName = "default args name. Nothing match";
    protected static final String defaultArgsName = "default args name. Nothing match";
    protected final String description;
    private static Class[] childrenClasses = new Class[]{SaveCommand.class, ServerMessageCommand.class, ConnectionsCommand.class, AddUserCommand.class, GrantAdminCommand.class, RemoveAdminCommand.class, DebugPlayerCommand.class, QuitCommand.class, AlarmCommand.class, ChopperCommand.class, AddAllToWhiteListCommand.class, KickUserCommand.class, TeleportCommand.class, TeleportToCommand.class, ReleaseSafehouseCommand.class, StartRainCommand.class, StopRainCommand.class, ThunderCommand.class, GunShotCommand.class, ReloadOptionsCommand.class, BanUserCommand.class, BanSteamIDCommand.class, UnbanUserCommand.class, UnbanSteamIDCommand.class, AddUserToWhiteListCommand.class, RemoveUserFromWhiteList.class, ChangeOptionCommand.class, ShowOptionsCommand.class, GodModeCommand.class, VoiceBanCommand.class, NoClipCommand.class, InvisibleCommand.class, HelpCommand.class, ClearCommand.class, PlayersCommand.class, AddItemCommand.class, AddXPCommand.class, AddVehicleCommand.class, CreateHordeCommand.class, CreateHorde2Command.class, ReloadLuaCommand.class, RemoveZombiesCommand.class, SetAccessLevelCommand.class, LogCommand.class, StatisticsCommand.class, LightningCommand.class, StopWeatherCommand.class, StartStormCommand.class, ReplayCommands.class, CheckModsNeedUpdate.class};

    public static Class[] getSubClasses() {
        return childrenClasses;
    }

    public static Class findCommandCls(String string) {
        for (Class clazz : childrenClasses) {
            CommandName[] commandNameArray;
            if (CommandBase.isDisabled(clazz)) continue;
            for (CommandName commandName : commandNameArray = (CommandName[])clazz.getAnnotationsByType(CommandName.class)) {
                Pattern pattern = Pattern.compile("^" + commandName.name() + "\\b", 2);
                if (!pattern.matcher(string).find()) continue;
                return clazz;
            }
        }
        return null;
    }

    public static String getHelp(Class clazz) {
        CommandHelp commandHelp = CommandBase.getAnnotation(CommandHelp.class, clazz);
        if (commandHelp == null) {
            return null;
        }
        if (commandHelp.shouldTranslated()) {
            String string = commandHelp.helpText();
            return Translator.getText(string);
        }
        return commandHelp.helpText();
    }

    public static String getCommandName(Class clazz) {
        Annotation[] annotationArray = clazz.getAnnotationsByType(CommandName.class);
        return ((CommandName)annotationArray[0]).name();
    }

    public static boolean isDisabled(Class clazz) {
        DisabledCommand disabledCommand = CommandBase.getAnnotation(DisabledCommand.class, clazz);
        return disabledCommand != null;
    }

    public static int accessLevelToInt(String string) {
        switch (string) {
            case "admin": {
                return 32;
            }
            case "observer": {
                return 2;
            }
            case "moderator": {
                return 16;
            }
            case "overseer": {
                return 8;
            }
            case "gm": {
                return 4;
            }
        }
        return 1;
    }

    protected CommandBase(String string, String string2, String string3, UdpConnection udpConnection) {
        this.username = string;
        this.command = string3;
        this.connection = udpConnection;
        this.playerType = CommandBase.accessLevelToInt(string2);
        ArrayList<String> arrayList = new ArrayList<String>();
        Matcher matcher = Pattern.compile("([^\"]\\S*|\".*?\")\\s*").matcher(string3);
        while (matcher.find()) {
            arrayList.add(matcher.group(1).replace("\"", ""));
        }
        this.commandArgs = new String[arrayList.size() - 1];
        for (int i = 1; i < arrayList.size(); ++i) {
            this.commandArgs[i - 1] = (String)arrayList.get(i);
        }
        this.description = "cmd=\"" + string3 + "\" user=\"" + string + "\" role=\"" + this.playerType + "\" " + (String)(udpConnection != null ? "guid=\"" + udpConnection.getConnectedGUID() + "\" id=\"" + udpConnection.idStr : "unknown connection") + "\"";
    }

    public String Execute() throws SQLException {
        if (this.canBeExecuted()) {
            return this.Command();
        }
        return this.message;
    }

    public boolean canBeExecuted() {
        if (this.parsed) {
            return this.parsingSuccessful;
        }
        if (!this.PlayerSatisfyRequiredRights()) {
            this.message = this.playerHasNoRightError();
            return false;
        }
        this.parsingSuccessful = this.parseCommand();
        return this.parsingSuccessful;
    }

    public boolean isCommandComeFromServerConsole() {
        return this.connection == null;
    }

    protected RequiredRight getRequiredRights() {
        return this.getClass().getAnnotation(RequiredRight.class);
    }

    protected CommandArgs[] getCommandArgVariants() {
        Class<?> clazz = this.getClass();
        return (CommandArgs[])clazz.getAnnotationsByType(CommandArgs.class);
    }

    public boolean hasHelp() {
        Class<?> clazz = this.getClass();
        CommandHelp commandHelp = clazz.getAnnotation(CommandHelp.class);
        return commandHelp != null;
    }

    protected String getHelp() {
        Class<?> clazz = this.getClass();
        return CommandBase.getHelp(clazz);
    }

    public String getCommandArg(Integer n) {
        if (this.commandArgs == null || n < 0 || n >= this.commandArgs.length) {
            return null;
        }
        return this.commandArgs[n];
    }

    public boolean hasOptionalArg(Integer n) {
        return this.commandArgs != null && n >= 0 && n < this.commandArgs.length;
    }

    public int getCommandArgsCount() {
        return this.commandArgs.length;
    }

    protected abstract String Command() throws SQLException;

    public boolean parseCommand() {
        CommandArgs[] commandArgsArray = this.getCommandArgVariants();
        if (commandArgsArray.length == 1 && commandArgsArray[0].varArgs()) {
            this.parsed = true;
            return true;
        }
        boolean bl = commandArgsArray.length != 0 && this.commandArgs.length != 0 || commandArgsArray.length == 0 && this.commandArgs.length == 0;
        ArrayList<String> arrayList = new ArrayList<String>();
        for (CommandArgs commandArgs : commandArgsArray) {
            arrayList.clear();
            this.message = "";
            int n = 0;
            bl = true;
            for (int i = 0; i < commandArgs.required().length; ++i) {
                String string = commandArgs.required()[i];
                if (n == this.commandArgs.length) {
                    bl = false;
                    break;
                }
                Matcher matcher = Pattern.compile(string).matcher(this.commandArgs[n]);
                if (matcher.matches()) {
                    for (int j = 0; j < matcher.groupCount(); ++j) {
                        arrayList.add(matcher.group(j + 1));
                    }
                } else {
                    bl = false;
                    break;
                }
                ++n;
            }
            if (!bl) continue;
            if (n == this.commandArgs.length) {
                this.argsName = commandArgs.argName();
                break;
            }
            if (!commandArgs.optional().equals("no value")) {
                Matcher matcher = Pattern.compile(commandArgs.optional()).matcher(this.commandArgs[n]);
                if (matcher.matches()) {
                    for (int i = 0; i < matcher.groupCount(); ++i) {
                        arrayList.add(matcher.group(i + 1));
                    }
                } else {
                    bl = false;
                }
            } else if (n < this.commandArgs.length) {
                bl = false;
            }
            if (!bl) continue;
            this.argsName = commandArgs.argName();
            break;
        }
        if (bl) {
            this.commandArgs = new String[arrayList.size()];
            this.commandArgs = arrayList.toArray(this.commandArgs);
        } else {
            this.message = this.invalidCommand();
            this.commandArgs = new String[0];
        }
        this.parsed = true;
        return bl;
    }

    protected int getAccessLevel() {
        return this.playerType;
    }

    protected String getExecutorUsername() {
        return this.username;
    }

    protected String getCommand() {
        return this.command;
    }

    protected static <T> T getAnnotation(Class<T> clazz, Class clazz2) {
        return clazz2.getAnnotation(clazz);
    }

    public boolean isParsingSuccessful() {
        if (!this.parsed) {
            this.parsingSuccessful = this.parseCommand();
        }
        return this.parsingSuccessful;
    }

    private boolean PlayerSatisfyRequiredRights() {
        RequiredRight requiredRight = this.getRequiredRights();
        return (this.playerType & requiredRight.requiredRights()) != 0;
    }

    private String invalidCommand() {
        if (this.hasHelp()) {
            return this.getHelp();
        }
        return Translator.getText("UI_command_arg_parse_failed", this.command);
    }

    private String playerHasNoRightError() {
        return Translator.getText("UI_has_no_right_to_execute_command", this.username, this.command);
    }
}

