/*
 * Decompiled with CFR 0.152.
 */
package zombie.chat.defaultChats;

import java.nio.ByteBuffer;
import zombie.Lua.LuaEventManager;
import zombie.Lua.LuaManager;
import zombie.characters.IsoPlayer;
import zombie.chat.ChatMessage;
import zombie.chat.ChatMode;
import zombie.chat.ChatSettings;
import zombie.chat.ChatTab;
import zombie.chat.defaultChats.RangeBasedChat;
import zombie.core.Color;
import zombie.core.math.PZMath;
import zombie.core.network.ByteBufferWriter;
import zombie.network.chat.ChatType;
import zombie.radio.ZomboidRadio;
import zombie.radio.devices.DeviceData;
import zombie.ui.UIFont;

public class RadioChat
extends RangeBasedChat {
    public RadioChat(ByteBuffer byteBuffer, ChatTab chatTab, IsoPlayer isoPlayer) {
        super(byteBuffer, ChatType.radio, chatTab, isoPlayer);
        if (!this.isCustomSettings()) {
            this.setSettings(RadioChat.getDefaultSettings());
        }
        this.customTag = "radio";
    }

    public RadioChat(int n, ChatTab chatTab) {
        super(n, ChatType.radio, chatTab);
        if (!this.isCustomSettings()) {
            this.setSettings(RadioChat.getDefaultSettings());
        }
        this.customTag = "radio";
    }

    public RadioChat() {
        super(ChatType.radio);
        this.setSettings(RadioChat.getDefaultSettings());
        this.customTag = "radio";
    }

    public static ChatSettings getDefaultSettings() {
        ChatSettings chatSettings = new ChatSettings();
        chatSettings.setBold(true);
        chatSettings.setFontColor(Color.lightGray);
        chatSettings.setShowAuthor(false);
        chatSettings.setShowChatTitle(true);
        chatSettings.setShowTimestamp(true);
        chatSettings.setUnique(true);
        chatSettings.setAllowColors(true);
        chatSettings.setAllowFonts(false);
        chatSettings.setAllowBBcode(true);
        chatSettings.setAllowImages(false);
        chatSettings.setAllowChatIcons(true);
        return chatSettings;
    }

    @Override
    public ChatMessage createMessage(String string) {
        ChatMessage chatMessage = super.createMessage(string);
        if (this.getMode() == ChatMode.SinglePlayer) {
            chatMessage.setOverHeadSpeech(true);
            chatMessage.setShowInChat(false);
        }
        chatMessage.setShouldAttractZombies(true);
        return chatMessage;
    }

    public ChatMessage createBroadcastingMessage(String string, int n) {
        ChatMessage chatMessage = super.createBubbleMessage(string);
        chatMessage.setAuthor("");
        chatMessage.setShouldAttractZombies(false);
        chatMessage.setRadioChannel(n);
        return chatMessage;
    }

    public ChatMessage createStaticSoundMessage(String string) {
        ChatMessage chatMessage = super.createBubbleMessage(string);
        chatMessage.setAuthor("");
        chatMessage.setShouldAttractZombies(false);
        return chatMessage;
    }

    @Override
    protected void showInSpeechBubble(ChatMessage chatMessage) {
        Color color = this.getColor();
        this.getSpeechBubble().addChatLine(chatMessage.getText(), color.r, color.g, color.b, UIFont.Dialogue, this.getRange(), this.customTag, this.isAllowBBcode(), this.isAllowImages(), this.isAllowChatIcons(), this.isAllowColors(), this.isAllowFonts(), this.isEqualizeLineHeights());
    }

    @Override
    public void showMessage(ChatMessage chatMessage) {
        if (this.isEnabled() && chatMessage.isShowInChat() && this.hasChatTab()) {
            LuaEventManager.triggerEvent("OnAddMessage", chatMessage, this.getTabID());
        }
    }

    @Override
    public void sendToServer(ChatMessage chatMessage, DeviceData deviceData) {
        if (deviceData != null) {
            int n = PZMath.fastfloor(this.getChatOwner().getX());
            int n2 = PZMath.fastfloor(this.getChatOwner().getY());
            int n3 = deviceData.getTransmitRange();
            ZomboidRadio.getInstance().SendTransmission(n, n2, chatMessage, n3);
        }
    }

    @Override
    public ChatMessage unpackMessage(ByteBuffer byteBuffer) {
        ChatMessage chatMessage = super.unpackMessage(byteBuffer);
        chatMessage.setRadioChannel(byteBuffer.getInt());
        chatMessage.setOverHeadSpeech(byteBuffer.get() == 1);
        chatMessage.setShowInChat(byteBuffer.get() == 1);
        chatMessage.setShouldAttractZombies(byteBuffer.get() == 1);
        return chatMessage;
    }

    @Override
    public void packMessage(ByteBufferWriter byteBufferWriter, ChatMessage chatMessage) {
        super.packMessage(byteBufferWriter, chatMessage);
        byteBufferWriter.putInt(chatMessage.getRadioChannel());
        byteBufferWriter.putBoolean(chatMessage.isOverHeadSpeech());
        byteBufferWriter.putBoolean(chatMessage.isShowInChat());
        byteBufferWriter.putBoolean(chatMessage.isShouldAttractZombies());
    }

    @Override
    public String getMessagePrefix(ChatMessage chatMessage) {
        StringBuilder stringBuilder = new StringBuilder(this.getChatSettingsTags());
        if (this.isShowTimestamp()) {
            stringBuilder.append("[").append(LuaManager.getHourMinuteJava()).append("]");
        }
        if (this.isShowTitle()) {
            stringBuilder.append("[").append(this.getTitle()).append("]");
        }
        if (this.isShowAuthor() && chatMessage.getAuthor() != null && !chatMessage.getAuthor().equals("")) {
            stringBuilder.append(" ").append(chatMessage.getAuthor()).append(" ");
        } else {
            stringBuilder.append(" ").append("Radio").append(" ");
        }
        stringBuilder.append(" (").append(this.getRadioChannelStr(chatMessage)).append("): ");
        return stringBuilder.toString();
    }

    private String getRadioChannelStr(ChatMessage chatMessage) {
        int n;
        StringBuilder stringBuilder = new StringBuilder();
        int n2 = chatMessage.getRadioChannel();
        for (n = n2 % 1000; n % 10 == 0 && n != 0; n /= 10) {
        }
        int n3 = n2 / 1000;
        stringBuilder.append(n3).append(".").append(n).append(" MHz");
        return stringBuilder.toString();
    }
}

