/*
 * Decompiled with CFR 0.152.
 */
package zombie.chat;

import java.util.ArrayList;
import java.util.HashMap;
import zombie.characters.IsoPlayer;
import zombie.core.Color;
import zombie.core.Colors;
import zombie.core.raknet.UdpConnection;
import zombie.core.textures.Texture;
import zombie.debug.DebugLog;
import zombie.iso.IsoGridSquare;
import zombie.iso.IsoObject;
import zombie.network.GameClient;
import zombie.network.GameServer;
import zombie.network.ServerOptions;
import zombie.network.chat.ChatType;

public final class ChatUtility {
    private static final boolean useEuclidean = true;
    private static final HashMap<String, String> allowedChatIcons = new HashMap();
    private static final HashMap<String, String> allowedChatIconsFull = new HashMap();
    private static final StringBuilder builder = new StringBuilder();
    private static final StringBuilder builderTest = new StringBuilder();

    private ChatUtility() {
    }

    public static float getScrambleValue(IsoObject isoObject, IsoPlayer isoPlayer, float f) {
        return ChatUtility.getScrambleValue(isoObject.getX(), isoObject.getY(), isoObject.getZ(), isoObject.getSquare(), isoPlayer, f);
    }

    public static float getScrambleValue(float f, float f2, float f3, IsoGridSquare isoGridSquare, IsoPlayer isoPlayer, float f4) {
        float f5;
        float f6 = 1.0f;
        boolean bl = false;
        boolean bl2 = false;
        if (isoGridSquare != null && isoPlayer.getSquare() != null) {
            if (isoPlayer.getBuilding() != null && isoGridSquare.getBuilding() != null && isoPlayer.getBuilding() == isoGridSquare.getBuilding()) {
                if (isoPlayer.getSquare().getRoom() == isoGridSquare.getRoom()) {
                    f6 = (float)((double)f6 * 2.0);
                    bl2 = true;
                } else if (Math.abs(isoPlayer.getZ() - f3) < 1.0f) {
                    f6 = (float)((double)f6 * 2.0);
                }
            } else if (isoPlayer.getBuilding() != null || isoGridSquare.getBuilding() != null) {
                f6 = (float)((double)f6 * 0.5);
                bl = true;
            }
            if (Math.abs(isoPlayer.getZ() - f3) >= 1.0f) {
                f6 = (float)((double)f6 - (double)f6 * ((double)Math.abs(isoPlayer.getZ() - f3) * 0.25));
                bl = true;
            }
        }
        float f7 = f4 * f6;
        float f8 = 1.0f;
        if (f6 > 0.0f && ChatUtility.playerWithinBounds(f, f2, isoPlayer, f7) && (f5 = ChatUtility.getDistance(f, f2, isoPlayer)) >= 0.0f && f5 < f7) {
            float f9 = f7 * 0.6f;
            if (bl2 || !bl && f5 < f9) {
                f8 = 0.0f;
            } else if (f7 - f9 != 0.0f && (f8 = (f5 - f9) / (f7 - f9)) < 0.2f) {
                f8 = 0.2f;
            }
        }
        return f8;
    }

    public static boolean playerWithinBounds(IsoObject isoObject, IsoObject isoObject2, float f) {
        return ChatUtility.playerWithinBounds(isoObject.getX(), isoObject.getY(), isoObject2, f);
    }

    public static boolean playerWithinBounds(float f, float f2, IsoObject isoObject, float f3) {
        if (isoObject == null) {
            return false;
        }
        return isoObject.getX() > f - f3 && isoObject.getX() < f + f3 && isoObject.getY() > f2 - f3 && isoObject.getY() < f2 + f3;
    }

    public static float getDistance(IsoObject isoObject, IsoPlayer isoPlayer) {
        if (isoPlayer == null) {
            return -1.0f;
        }
        return (float)Math.sqrt(Math.pow(isoObject.getX() - isoPlayer.x, 2.0) + Math.pow(isoObject.getY() - isoPlayer.y, 2.0));
    }

    public static float getDistance(float f, float f2, IsoPlayer isoPlayer) {
        if (isoPlayer == null) {
            return -1.0f;
        }
        return (float)Math.sqrt(Math.pow(f - isoPlayer.x, 2.0) + Math.pow(f2 - isoPlayer.y, 2.0));
    }

    public static UdpConnection findConnection(short s) {
        UdpConnection udpConnection = null;
        if (GameServer.udpEngine != null) {
            block0: for (int i = 0; i < GameServer.udpEngine.connections.size(); ++i) {
                UdpConnection udpConnection2 = GameServer.udpEngine.connections.get(i);
                for (int j = 0; j < udpConnection2.playerIDs.length; ++j) {
                    if (udpConnection2.playerIDs[j] != s) continue;
                    udpConnection = udpConnection2;
                    continue block0;
                }
            }
        }
        if (udpConnection == null) {
            DebugLog.log("Connection with PlayerID ='" + s + "' not found!");
        }
        return udpConnection;
    }

    public static UdpConnection findConnection(String string) {
        UdpConnection udpConnection = null;
        if (GameServer.udpEngine != null) {
            block0: for (int i = 0; i < GameServer.udpEngine.connections.size() && udpConnection == null; ++i) {
                UdpConnection udpConnection2 = GameServer.udpEngine.connections.get(i);
                for (int j = 0; j < udpConnection2.players.length; ++j) {
                    if (udpConnection2.players[j] == null || !udpConnection2.players[j].username.equalsIgnoreCase(string)) continue;
                    udpConnection = udpConnection2;
                    continue block0;
                }
            }
        }
        if (udpConnection == null) {
            DebugLog.log("Player with nickname = '" + string + "' not found!");
        }
        return udpConnection;
    }

    public static IsoPlayer findPlayer(int n) {
        IsoPlayer isoPlayer = null;
        if (GameServer.udpEngine != null) {
            block0: for (int i = 0; i < GameServer.udpEngine.connections.size(); ++i) {
                UdpConnection udpConnection = GameServer.udpEngine.connections.get(i);
                for (int j = 0; j < udpConnection.playerIDs.length; ++j) {
                    if (udpConnection.playerIDs[j] != n) continue;
                    isoPlayer = udpConnection.players[j];
                    continue block0;
                }
            }
        }
        if (isoPlayer == null) {
            DebugLog.log("Player with PlayerID ='" + n + "' not found!");
        }
        return isoPlayer;
    }

    public static String findPlayerName(int n) {
        return ChatUtility.findPlayer(n).getUsername();
    }

    public static IsoPlayer findPlayer(String string) {
        IsoPlayer isoPlayer = null;
        if (GameClient.bClient) {
            isoPlayer = GameClient.instance.getPlayerFromUsername(string);
        } else if (GameServer.bServer) {
            isoPlayer = GameServer.getPlayerByUserName(string);
        }
        if (isoPlayer == null) {
            DebugLog.log("Player with nickname = '" + string + "' not found!");
        }
        return isoPlayer;
    }

    public static ArrayList<ChatType> getAllowedChatStreams() {
        String string = ServerOptions.getInstance().ChatStreams.getValue();
        string = string.replaceAll("\"", "");
        String[] stringArray = string.split(",");
        ArrayList<ChatType> arrayList = new ArrayList<ChatType>();
        arrayList.add(ChatType.server);
        String[] stringArray2 = stringArray;
        int n = stringArray2.length;
        block20: for (int i = 0; i < n; ++i) {
            String string2;
            switch (string2 = stringArray2[i]) {
                case "s": {
                    arrayList.add(ChatType.say);
                    continue block20;
                }
                case "r": {
                    arrayList.add(ChatType.radio);
                    continue block20;
                }
                case "a": {
                    arrayList.add(ChatType.admin);
                    continue block20;
                }
                case "w": {
                    arrayList.add(ChatType.whisper);
                    continue block20;
                }
                case "y": {
                    arrayList.add(ChatType.shout);
                    continue block20;
                }
                case "sh": {
                    arrayList.add(ChatType.safehouse);
                    continue block20;
                }
                case "f": {
                    arrayList.add(ChatType.faction);
                    continue block20;
                }
                case "all": {
                    arrayList.add(ChatType.general);
                }
            }
        }
        return arrayList;
    }

    public static boolean chatStreamEnabled(ChatType chatType) {
        ArrayList<ChatType> arrayList = ChatUtility.getAllowedChatStreams();
        return arrayList.contains((Object)chatType);
    }

    public static void InitAllowedChatIcons() {
        allowedChatIcons.clear();
        Texture.collectAllIcons(allowedChatIcons, allowedChatIconsFull);
    }

    private static String getColorString(String string, boolean bl) {
        String[] stringArray;
        if (Colors.ColorExists(string)) {
            Color color = Colors.GetColorByName(string);
            if (bl) {
                return color.getRedFloat() + "," + color.getGreenFloat() + "," + color.getBlueFloat();
            }
            return color.getRed() + "," + color.getGreen() + "," + color.getBlue();
        }
        if (string.length() <= 11 && string.contains(",") && (stringArray = string.split(",")).length == 3) {
            int n = ChatUtility.parseColorInt(stringArray[0]);
            int n2 = ChatUtility.parseColorInt(stringArray[1]);
            int n3 = ChatUtility.parseColorInt(stringArray[2]);
            if (n != -1 && n2 != -1 && n3 != -1) {
                if (bl) {
                    return (float)n / 255.0f + "," + (float)n2 / 255.0f + "," + (float)n3 / 255.0f;
                }
                return n + "," + n2 + "," + n3;
            }
        }
        return null;
    }

    private static int parseColorInt(String string) {
        try {
            int n = Integer.parseInt(string);
            if (n >= 0 && n <= 255) {
                return n;
            }
            return -1;
        }
        catch (Exception exception) {
            return -1;
        }
    }

    public static String parseStringForChatBubble(String string) {
        try {
            builder.delete(0, builder.length());
            builderTest.delete(0, builderTest.length());
            string = string.replaceAll("\\[br/]", "");
            string = string.replaceAll("\\[cdt=", "");
            char[] cArray = string.toCharArray();
            boolean bl = false;
            boolean bl2 = false;
            int n = 0;
            for (int i = 0; i < cArray.length; ++i) {
                char c = cArray[i];
                if (c == '*') {
                    if (!bl) {
                        bl = true;
                        continue;
                    }
                    String string2 = builderTest.toString();
                    builderTest.delete(0, builderTest.length());
                    String string3 = ChatUtility.getColorString(string2, false);
                    if (string3 != null) {
                        if (bl2) {
                            builder.append("[/]");
                        }
                        builder.append("[col=");
                        builder.append(string3);
                        builder.append(']');
                        bl = false;
                        bl2 = true;
                        continue;
                    }
                    if (n < 10 && (string2.equalsIgnoreCase("music") || allowedChatIcons.containsKey(string2.toLowerCase()))) {
                        if (bl2) {
                            builder.append("[/]");
                            bl2 = false;
                        }
                        builder.append("[img=");
                        builder.append(string2.equalsIgnoreCase("music") ? "music" : allowedChatIcons.get(string2.toLowerCase()));
                        builder.append(']');
                        bl = false;
                        ++n;
                        continue;
                    }
                    builder.append('*');
                    builder.append(string2);
                    continue;
                }
                if (bl) {
                    builderTest.append(c);
                    continue;
                }
                builder.append(c);
            }
            if (bl) {
                builder.append('*');
                String string4 = builderTest.toString();
                if (string4.length() > 0) {
                    builder.append(string4);
                }
                if (bl2) {
                    builder.append("[/]");
                }
            }
            return builder.toString();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return string;
        }
    }

    public static String parseStringForChatLog(String string) {
        try {
            builder.delete(0, builder.length());
            builderTest.delete(0, builderTest.length());
            char[] cArray = string.toCharArray();
            boolean bl = false;
            boolean bl2 = false;
            int n = 0;
            for (int i = 0; i < cArray.length; ++i) {
                char c = cArray[i];
                if (c == '*') {
                    if (!bl) {
                        bl = true;
                        continue;
                    }
                    String string2 = builderTest.toString();
                    builderTest.delete(0, builderTest.length());
                    String string3 = ChatUtility.getColorString(string2, true);
                    if (string3 != null) {
                        builder.append(" <RGB:");
                        builder.append(string3);
                        builder.append('>');
                        bl = false;
                        bl2 = true;
                        continue;
                    }
                    if (n < 10 && (string2.equalsIgnoreCase("music") || allowedChatIconsFull.containsKey(string2.toLowerCase()))) {
                        if (bl2) {
                            builder.append(" <RGB:");
                            builder.append("1.0,1.0,1.0");
                            builder.append('>');
                            bl2 = false;
                        }
                        String string4 = string2.equalsIgnoreCase("music") ? "Icon_music_notes" : allowedChatIconsFull.get(string2.toLowerCase());
                        Texture texture = Texture.getSharedTexture(string4);
                        if (Texture.getSharedTexture(string4) != null) {
                            int n2 = (int)((float)texture.getWidth() * 0.5f);
                            int n3 = (int)((float)texture.getHeight() * 0.5f);
                            if (string2.equalsIgnoreCase("music")) {
                                n2 = (int)((float)texture.getWidth() * 0.75f);
                                n3 = (int)((float)texture.getHeight() * 0.75f);
                            }
                            builder.append("<IMAGE:");
                            builder.append(string4);
                            builder.append("," + n2 + "," + n3 + ">");
                            bl = false;
                            ++n;
                            continue;
                        }
                    }
                    builder.append('*');
                    builder.append(string2);
                    continue;
                }
                if (bl) {
                    builderTest.append(c);
                    continue;
                }
                builder.append(c);
            }
            if (bl) {
                builder.append('*');
                String string5 = builderTest.toString();
                if (string5.length() > 0) {
                    builder.append(string5);
                }
            }
            return builder.toString();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return string;
        }
    }
}

