/*
 * Decompiled with CFR 0.152.
 */
package zombie.chat;

import java.nio.ByteBuffer;
import zombie.GameWindow;
import zombie.core.Color;
import zombie.core.network.ByteBufferWriter;
import zombie.ui.UIFont;

public class ChatSettings {
    private boolean unique;
    private Color fontColor;
    private UIFont font;
    private FontSize fontSize;
    private boolean bold;
    private boolean allowImages;
    private boolean allowChatIcons;
    private boolean allowColors;
    private boolean allowFonts;
    private boolean allowBBcode;
    private boolean equalizeLineHeights;
    private boolean showAuthor;
    private boolean showTimestamp;
    private boolean showChatTitle;
    private boolean useOnlyActiveTab;
    private float range;
    private float zombieAttractionRange;
    public static final float infinityRange = -1.0f;

    public ChatSettings() {
        this.unique = true;
        this.fontColor = Color.white;
        this.font = UIFont.Dialogue;
        this.bold = true;
        this.showAuthor = true;
        this.showTimestamp = true;
        this.showChatTitle = true;
        this.range = -1.0f;
        this.zombieAttractionRange = -1.0f;
        this.useOnlyActiveTab = false;
        this.fontSize = FontSize.Medium;
    }

    public ChatSettings(ByteBuffer byteBuffer) {
        this.unique = byteBuffer.get() == 1;
        this.fontColor = new Color(byteBuffer.getFloat(), byteBuffer.getFloat(), byteBuffer.getFloat(), byteBuffer.getFloat());
        this.font = UIFont.FromString(GameWindow.ReadString(byteBuffer));
        this.bold = byteBuffer.get() == 1;
        this.allowImages = byteBuffer.get() == 1;
        this.allowChatIcons = byteBuffer.get() == 1;
        this.allowColors = byteBuffer.get() == 1;
        this.allowFonts = byteBuffer.get() == 1;
        this.allowBBcode = byteBuffer.get() == 1;
        this.equalizeLineHeights = byteBuffer.get() == 1;
        this.showAuthor = byteBuffer.get() == 1;
        this.showTimestamp = byteBuffer.get() == 1;
        this.showChatTitle = byteBuffer.get() == 1;
        this.range = byteBuffer.getFloat();
        this.zombieAttractionRange = byteBuffer.get() == 1 ? byteBuffer.getFloat() : this.range;
        this.fontSize = FontSize.Medium;
    }

    public boolean isUnique() {
        return this.unique;
    }

    public void setUnique(boolean bl) {
        this.unique = bl;
    }

    public Color getFontColor() {
        return this.fontColor;
    }

    public void setFontColor(Color color) {
        this.fontColor = color;
    }

    public void setFontColor(float f, float f2, float f3, float f4) {
        this.fontColor = new Color(f, f2, f3, f4);
    }

    public UIFont getFont() {
        return this.font;
    }

    public void setFont(UIFont uIFont) {
        this.font = uIFont;
    }

    public String getFontSize() {
        return this.fontSize.toString().toLowerCase();
    }

    public void setFontSize(String string) {
        switch (string) {
            case "small": 
            case "Small": {
                this.fontSize = FontSize.Small;
                break;
            }
            case "medium": 
            case "Medium": {
                this.fontSize = FontSize.Medium;
                break;
            }
            case "large": 
            case "Large": {
                this.fontSize = FontSize.Large;
                break;
            }
            default: {
                this.fontSize = FontSize.NotDefine;
            }
        }
    }

    public boolean isBold() {
        return this.bold;
    }

    public void setBold(boolean bl) {
        this.bold = bl;
    }

    public boolean isShowAuthor() {
        return this.showAuthor;
    }

    public void setShowAuthor(boolean bl) {
        this.showAuthor = bl;
    }

    public boolean isShowTimestamp() {
        return this.showTimestamp;
    }

    public void setShowTimestamp(boolean bl) {
        this.showTimestamp = bl;
    }

    public boolean isShowChatTitle() {
        return this.showChatTitle;
    }

    public void setShowChatTitle(boolean bl) {
        this.showChatTitle = bl;
    }

    public boolean isAllowImages() {
        return this.allowImages;
    }

    public void setAllowImages(boolean bl) {
        this.allowImages = bl;
    }

    public boolean isAllowChatIcons() {
        return this.allowChatIcons;
    }

    public void setAllowChatIcons(boolean bl) {
        this.allowChatIcons = bl;
    }

    public boolean isAllowColors() {
        return this.allowColors;
    }

    public void setAllowColors(boolean bl) {
        this.allowColors = bl;
    }

    public boolean isAllowFonts() {
        return this.allowFonts;
    }

    public void setAllowFonts(boolean bl) {
        this.allowFonts = bl;
    }

    public boolean isAllowBBcode() {
        return this.allowBBcode;
    }

    public void setAllowBBcode(boolean bl) {
        this.allowBBcode = bl;
    }

    public boolean isEqualizeLineHeights() {
        return this.equalizeLineHeights;
    }

    public void setEqualizeLineHeights(boolean bl) {
        this.equalizeLineHeights = bl;
    }

    public float getRange() {
        return this.range;
    }

    public void setRange(float f) {
        this.range = f;
    }

    public float getZombieAttractionRange() {
        if (this.zombieAttractionRange == -1.0f) {
            return this.range;
        }
        return this.zombieAttractionRange;
    }

    public void setZombieAttractionRange(float f) {
        this.zombieAttractionRange = f;
    }

    public boolean isUseOnlyActiveTab() {
        return this.useOnlyActiveTab;
    }

    public void setUseOnlyActiveTab(boolean bl) {
        this.useOnlyActiveTab = bl;
    }

    public void pack(ByteBufferWriter byteBufferWriter) {
        byteBufferWriter.putBoolean(this.unique);
        byteBufferWriter.putFloat(this.fontColor.r);
        byteBufferWriter.putFloat(this.fontColor.g);
        byteBufferWriter.putFloat(this.fontColor.b);
        byteBufferWriter.putFloat(this.fontColor.a);
        byteBufferWriter.putUTF(this.font.toString());
        byteBufferWriter.putBoolean(this.bold);
        byteBufferWriter.putBoolean(this.allowImages);
        byteBufferWriter.putBoolean(this.allowChatIcons);
        byteBufferWriter.putBoolean(this.allowColors);
        byteBufferWriter.putBoolean(this.allowFonts);
        byteBufferWriter.putBoolean(this.allowBBcode);
        byteBufferWriter.putBoolean(this.equalizeLineHeights);
        byteBufferWriter.putBoolean(this.showAuthor);
        byteBufferWriter.putBoolean(this.showTimestamp);
        byteBufferWriter.putBoolean(this.showChatTitle);
        byteBufferWriter.putFloat(this.range);
        byteBufferWriter.putBoolean(this.range != this.zombieAttractionRange);
        if (this.range != this.zombieAttractionRange) {
            byteBufferWriter.putFloat(this.zombieAttractionRange);
        }
    }

    public static enum FontSize {
        NotDefine,
        Small,
        Medium,
        Large;

    }
}

