/*
 * Decompiled with CFR 0.152.
 */
package zombie.chat;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import zombie.GameWindow;
import zombie.Lua.LuaEventManager;
import zombie.characters.Faction;
import zombie.characters.IsoPlayer;
import zombie.chat.ChatBase;
import zombie.chat.ChatMessage;
import zombie.chat.ChatTab;
import zombie.chat.ChatUtility;
import zombie.chat.ServerChatMessage;
import zombie.chat.WhisperChatCreation;
import zombie.chat.defaultChats.AdminChat;
import zombie.chat.defaultChats.FactionChat;
import zombie.chat.defaultChats.GeneralChat;
import zombie.chat.defaultChats.RadioChat;
import zombie.chat.defaultChats.SafehouseChat;
import zombie.chat.defaultChats.SayChat;
import zombie.chat.defaultChats.ServerChat;
import zombie.chat.defaultChats.ShoutChat;
import zombie.chat.defaultChats.WhisperChat;
import zombie.core.Core;
import zombie.core.Translator;
import zombie.core.logger.ExceptionLogger;
import zombie.core.logger.LoggerManager;
import zombie.core.logger.ZLogger;
import zombie.core.network.ByteBufferWriter;
import zombie.core.raknet.UdpConnection;
import zombie.core.raknet.VoiceManagerData;
import zombie.debug.DebugLog;
import zombie.inventory.types.Radio;
import zombie.iso.areas.SafeHouse;
import zombie.network.GameClient;
import zombie.network.PacketTypes;
import zombie.network.chat.ChatType;
import zombie.radio.devices.DeviceData;

public class ChatManager {
    private static ChatManager instance = null;
    private UdpConnection serverConnection = null;
    private final HashMap<Integer, ChatBase> mpChats;
    private final HashMap<String, WhisperChat> whisperChats;
    private final HashMap<String, WhisperChatCreation> whisperChatCreation = new HashMap();
    private final HashMap<Short, ChatTab> tabs;
    private ChatTab focusTab;
    private IsoPlayer player;
    private String myNickname;
    private boolean singlePlayerMode = false;
    private GeneralChat generalChat = null;
    private SayChat sayChat = null;
    private ShoutChat shoutChat = null;
    private FactionChat factionChat = null;
    private SafehouseChat safehouseChat = null;
    private RadioChat radioChat = null;
    private AdminChat adminChat = null;
    private ServerChat serverChat = null;
    private Stage chatManagerStage = Stage.notStarted;
    private static volatile ZLogger logger;
    private static final String logNamePrefix = "client chat";

    private ChatManager() {
        this.mpChats = new HashMap();
        this.tabs = new HashMap();
        this.whisperChats = new HashMap();
    }

    public static ChatManager getInstance() {
        if (instance == null) {
            instance = new ChatManager();
        }
        return instance;
    }

    public boolean isSinglePlayerMode() {
        return this.singlePlayerMode;
    }

    public boolean isWorking() {
        return this.chatManagerStage == Stage.working;
    }

    public void init(boolean bl, IsoPlayer isoPlayer) {
        LoggerManager.init();
        LoggerManager.createLogger("client chat " + isoPlayer.getDisplayName(), Core.bDebug);
        logger = LoggerManager.getLogger("client chat " + isoPlayer.getDisplayName());
        logger.write("Init chat system...", "info");
        logger.write("Mode: " + (bl ? "single player" : "multiplayer"), "info");
        logger.write("Chat owner: " + isoPlayer.getDisplayName(), "info");
        this.chatManagerStage = Stage.starting;
        this.singlePlayerMode = bl;
        this.generalChat = null;
        this.sayChat = null;
        this.shoutChat = null;
        this.factionChat = null;
        this.safehouseChat = null;
        this.radioChat = null;
        this.adminChat = null;
        this.serverChat = null;
        this.mpChats.clear();
        this.tabs.clear();
        this.focusTab = null;
        this.whisperChats.clear();
        this.player = isoPlayer;
        this.myNickname = this.player.username;
        if (bl) {
            this.serverConnection = null;
            this.sayChat = new SayChat();
            this.sayChat.Init();
            this.generalChat = new GeneralChat();
            this.shoutChat = new ShoutChat();
            this.shoutChat.Init();
            this.radioChat = new RadioChat();
            this.radioChat.Init();
            this.adminChat = new AdminChat();
        } else {
            this.serverConnection = GameClient.connection;
            LuaEventManager.triggerEvent("OnChatWindowInit");
        }
    }

    public void processInitPlayerChatPacket(ByteBuffer byteBuffer) {
        this.init(false, IsoPlayer.getInstance());
        int n = byteBuffer.getShort();
        for (int i = 0; i < n; ++i) {
            ChatTab chatTab = new ChatTab(byteBuffer.getShort(), GameWindow.ReadString(byteBuffer));
            this.tabs.put(chatTab.getID(), chatTab);
        }
        this.addTab((short)0);
        this.focusOnTab(this.tabs.get((short)0).getID());
        LuaEventManager.triggerEvent("OnSetDefaultTab", this.tabs.get((short)0).getTitle());
    }

    public void setFullyConnected() {
        this.chatManagerStage = Stage.working;
    }

    public void processAddTabPacket(ByteBuffer byteBuffer) {
        this.addTab(byteBuffer.getShort());
    }

    public void processRemoveTabPacket(ByteBuffer byteBuffer) {
        this.removeTab(byteBuffer.getShort());
    }

    public void processJoinChatPacket(ByteBuffer byteBuffer) {
        ChatType chatType = ChatType.valueOf(byteBuffer.getInt());
        ChatTab chatTab = this.tabs.get(byteBuffer.getShort());
        ChatBase chatBase = null;
        switch (chatType) {
            case general: {
                this.generalChat = new GeneralChat(byteBuffer, chatTab, this.player);
                chatBase = this.generalChat;
                break;
            }
            case say: {
                this.sayChat = new SayChat(byteBuffer, chatTab, this.player);
                this.sayChat.Init();
                chatBase = this.sayChat;
                break;
            }
            case shout: {
                this.shoutChat = new ShoutChat(byteBuffer, chatTab, this.player);
                this.shoutChat.Init();
                chatBase = this.shoutChat;
                break;
            }
            case whisper: {
                WhisperChat whisperChat = new WhisperChat(byteBuffer, chatTab, this.player);
                whisperChat.init();
                this.whisperChats.put(whisperChat.getCompanionName(), whisperChat);
                chatBase = whisperChat;
                break;
            }
            case faction: {
                this.factionChat = new FactionChat(byteBuffer, chatTab, this.player);
                chatBase = this.factionChat;
                break;
            }
            case safehouse: {
                this.safehouseChat = new SafehouseChat(byteBuffer, chatTab, this.player);
                chatBase = this.safehouseChat;
                break;
            }
            case radio: {
                this.radioChat = new RadioChat(byteBuffer, chatTab, this.player);
                this.radioChat.Init();
                chatBase = this.radioChat;
                break;
            }
            case admin: {
                this.adminChat = new AdminChat(byteBuffer, chatTab, this.player);
                chatBase = this.adminChat;
                break;
            }
            case server: {
                this.serverChat = new ServerChat(byteBuffer, chatTab, this.player);
                chatBase = this.serverChat;
                break;
            }
            default: {
                DebugLog.log("Chat of type '" + chatType.toString() + "' is not supported to join to");
                return;
            }
        }
        this.mpChats.put(chatBase.getID(), chatBase);
        chatBase.setFontSize(Core.getInstance().getOptionChatFontSize());
        chatBase.setShowTimestamp(Core.getInstance().isOptionShowChatTimestamp());
        chatBase.setShowTitle(Core.getInstance().isOptionShowChatTitle());
    }

    public void processLeaveChatPacket(ByteBuffer byteBuffer) {
        Integer n = byteBuffer.getInt();
        ChatType chatType = ChatType.valueOf(byteBuffer.getInt());
        switch (chatType) {
            case general: 
            case say: 
            case shout: 
            case radio: 
            case server: {
                DebugLog.log("Chat type is '" + chatType.toString() + "'. Can't leave it. Ignored.");
                break;
            }
            case admin: {
                this.mpChats.remove(n);
                this.removeTab(this.adminChat.getTabID());
                this.adminChat = null;
                DebugLog.log("You leaved admin chat");
                break;
            }
            case faction: {
                this.mpChats.remove(n);
                this.factionChat = null;
                DebugLog.log("You leaved faction chat");
                break;
            }
            case whisper: {
                this.whisperChats.remove(((WhisperChat)this.mpChats.get(n)).getCompanionName());
                this.mpChats.remove(n);
                break;
            }
            case safehouse: {
                this.mpChats.remove(n);
                this.safehouseChat = null;
                DebugLog.log("You leaved safehouse chat");
                break;
            }
            default: {
                DebugLog.log("Chat of type '" + chatType.toString() + "' is not supported to leave to");
            }
        }
    }

    public void processPlayerNotFound(String string) {
        logger.write("Got player not found packet", "info");
        WhisperChatCreation whisperChatCreation = this.whisperChatCreation.get(string);
        if (whisperChatCreation == null) {
            return;
        }
        whisperChatCreation.status = WhisperChat.ChatStatus.PlayerNotFound;
    }

    public ChatMessage unpackMessage(ByteBuffer byteBuffer) {
        int n = byteBuffer.getInt();
        ChatBase chatBase = this.mpChats.get(n);
        return chatBase.unpackMessage(byteBuffer);
    }

    public void processChatMessagePacket(ByteBuffer byteBuffer) {
        ChatMessage chatMessage = this.unpackMessage(byteBuffer);
        ChatBase chatBase = chatMessage.getChat();
        if (ChatUtility.chatStreamEnabled(chatBase.getType())) {
            chatBase.showMessage(chatMessage);
            logger.write("Got message from server: " + chatMessage, "info");
        } else {
            DebugLog.log("Can't process message '" + chatMessage.getText() + "' because '" + chatBase.getType() + "' chat is disabled");
            logger.write("Can't process message '" + chatMessage.getText() + "' because '" + chatBase.getType() + "' chat is disabled", "warning");
        }
    }

    public void updateChatSettings(String string, boolean bl, boolean bl2) {
        Core.getInstance().setOptionChatFontSize(string);
        Core.getInstance().setOptionShowChatTimestamp(bl);
        Core.getInstance().setOptionShowChatTitle(bl2);
        for (ChatBase chatBase : this.mpChats.values()) {
            chatBase.setFontSize(string);
            chatBase.setShowTimestamp(bl);
            chatBase.setShowTitle(bl2);
        }
    }

    public void showInfoMessage(String string) {
        ChatMessage chatMessage = this.sayChat.createInfoMessage(string);
        this.sayChat.showMessage(chatMessage);
    }

    public void showInfoMessage(String string, String string2) {
        if (this.sayChat == null) {
            return;
        }
        ChatMessage chatMessage = this.sayChat.createInfoMessage(string2);
        chatMessage.setAuthor(string);
        this.sayChat.showMessage(chatMessage);
    }

    public void sendMessageToChat(String string, ChatType chatType, String string2) {
        if ((string2 = string2.trim()).isEmpty()) {
            return;
        }
        ChatBase chatBase = this.getChat(chatType);
        if (chatBase == null) {
            if (Core.bDebug) {
                throw new IllegalArgumentException("Chat '" + chatType + "' is null. Chat should be init before use!");
            }
            this.showChatDisabledMessage(chatType);
            return;
        }
        ChatMessage chatMessage = chatBase.createMessage(string2);
        chatMessage.setAuthor(string);
        this.sendMessageToChat(chatBase, chatMessage);
    }

    public void sendMessageToChat(ChatType chatType, String string) {
        this.sendMessageToChat(this.player.getUsername(), chatType, string);
    }

    public synchronized void sendWhisperMessage(String string, String string2) {
        logger.write("Send message '" + string2 + "' for player '" + string + "' in whisper chat", "info");
        if (ChatUtility.chatStreamEnabled(ChatType.whisper)) {
            if (string == null || string.equalsIgnoreCase(this.myNickname)) {
                logger.write("Message can't be send to yourself");
                this.showServerChatMessage(Translator.getText("UI_chat_whisper_message_to_yourself_error"));
                return;
            }
            if (this.whisperChats.containsKey(string)) {
                WhisperChat whisperChat = this.whisperChats.get(string);
                this.sendMessageToChat(whisperChat, whisperChat.createMessage(string2));
                return;
            }
            if (this.whisperChatCreation.containsKey(string)) {
                WhisperChatCreation whisperChatCreation = this.whisperChatCreation.get(string);
                whisperChatCreation.messages.add(string2);
                return;
            }
            WhisperChatCreation whisperChatCreation = this.createWhisperChat(string);
            whisperChatCreation.messages.add(string2);
        } else {
            logger.write("Whisper chat is disabled", "info");
            this.showChatDisabledMessage(ChatType.whisper);
        }
    }

    public Boolean isPlayerCanUseChat(ChatType chatType) {
        if (!ChatUtility.chatStreamEnabled(chatType)) {
            return false;
        }
        switch (chatType) {
            case radio: {
                return this.isPlayerCanUseRadioChat();
            }
            case admin: {
                return this.player.isAccessLevel("admin");
            }
            case faction: {
                return Faction.isAlreadyInFaction(this.player);
            }
            case safehouse: {
                return SafeHouse.hasSafehouse(this.player) != null;
            }
        }
        return true;
    }

    public void focusOnTab(Short s) {
        for (ChatTab chatTab : this.tabs.values()) {
            if (chatTab.getID() != s.shortValue()) continue;
            this.focusTab = chatTab;
            return;
        }
        throw new RuntimeException("Tab with id = '" + s + "' not found");
    }

    public String getTabName(short s) {
        if (this.tabs.containsKey(s)) {
            return this.tabs.get(s).getTitle();
        }
        return Short.toString(s);
    }

    public ChatTab getFocusTab() {
        return this.focusTab;
    }

    public void showRadioMessage(ChatMessage chatMessage) {
        this.radioChat.showMessage(chatMessage);
    }

    public void showRadioMessage(String string, int n) {
        ChatMessage chatMessage = this.radioChat.createMessage(string);
        if (n != 0) {
            chatMessage.setRadioChannel(n);
        }
        this.radioChat.showMessage(chatMessage);
    }

    public void showStaticRadioSound(String string) {
        this.radioChat.showMessage(this.radioChat.createStaticSoundMessage(string));
    }

    public ChatMessage createRadiostationMessage(String string, int n) {
        return this.radioChat.createBroadcastingMessage(string, n);
    }

    public void showServerChatMessage(String string) {
        ServerChatMessage serverChatMessage = this.serverChat.createServerMessage(string);
        this.serverChat.showMessage(serverChatMessage);
    }

    private void addMessage(int n, String string, String string2) {
        ChatBase chatBase = this.mpChats.get(n);
        chatBase.showMessage(string2, string);
    }

    public void addMessage(String string, String string2) throws RuntimeException {
        if (this.generalChat == null) {
            throw new RuntimeException();
        }
        this.addMessage(this.generalChat.getID(), string, string2);
    }

    private void sendMessageToChat(ChatBase chatBase, ChatMessage chatMessage) {
        if (chatBase.getType() == ChatType.radio) {
            if (Core.bDebug) {
                throw new IllegalArgumentException("You can't send message to radio directly. Use radio and send say message");
            }
            DebugLog.log("You try to use radio chat directly. It's restricted. Try to use say chat");
            return;
        }
        chatBase.showMessage(chatMessage);
        if (chatBase.isEnabled()) {
            if (!this.isSinglePlayerMode() && !chatMessage.isLocal()) {
                DeviceData deviceData = this.getTransmittingRadio();
                chatBase.sendToServer(chatMessage, deviceData);
                if (deviceData != null && chatBase.isSendingToRadio()) {
                    ChatMessage chatMessage2 = this.radioChat.createMessage(chatMessage.getText());
                    chatMessage2.setRadioChannel(deviceData.getChannel());
                    this.radioChat.sendToServer(chatMessage2, deviceData);
                }
            }
        } else {
            this.showChatDisabledMessage(chatBase.getType());
        }
    }

    private ChatBase getChat(ChatType chatType) {
        if (chatType == ChatType.whisper) {
            throw new IllegalArgumentException("Whisper not unique chat");
        }
        switch (chatType) {
            case admin: {
                return this.adminChat;
            }
            case radio: {
                return this.radioChat;
            }
            case general: {
                return this.generalChat;
            }
            case say: {
                return this.sayChat;
            }
            case shout: {
                return this.shoutChat;
            }
            case faction: {
                return this.factionChat;
            }
            case safehouse: {
                return this.safehouseChat;
            }
            case server: {
                return this.serverChat;
            }
        }
        throw new IllegalArgumentException("Chat type is undefined");
    }

    private void addTab(short s) {
        ChatTab chatTab = this.tabs.get(s);
        if (chatTab.isEnabled()) {
            return;
        }
        chatTab.setEnabled(true);
        LuaEventManager.triggerEvent("OnTabAdded", chatTab.getTitle(), chatTab.getID());
    }

    private void removeTab(Short s) {
        ChatTab chatTab = this.tabs.get(s);
        if (!chatTab.isEnabled()) {
            return;
        }
        LuaEventManager.triggerEvent("OnTabRemoved", chatTab.getTitle(), chatTab.getID());
        chatTab.setEnabled(false);
    }

    private WhisperChatCreation createWhisperChat(String string) {
        logger.write("Whisper chat is not created for '" + string + "'", "info");
        WhisperChatCreation whisperChatCreation = new WhisperChatCreation();
        whisperChatCreation.destPlayerName = string;
        whisperChatCreation.status = WhisperChat.ChatStatus.Creating;
        whisperChatCreation.createTime = System.currentTimeMillis();
        this.whisperChatCreation.put(string, whisperChatCreation);
        ByteBufferWriter byteBufferWriter = this.serverConnection.startPacket();
        PacketTypes.PacketType.PlayerStartPMChat.doPacket(byteBufferWriter);
        byteBufferWriter.putUTF(this.myNickname);
        byteBufferWriter.putUTF(string);
        PacketTypes.PacketType.PlayerStartPMChat.send(this.serverConnection);
        logger.write("'Start PM chat' package sent. Waiting for a creating whisper chat by server...", "info");
        return whisperChatCreation;
    }

    public static void UpdateClient() {
        if (instance == null) {
            return;
        }
        try {
            instance.updateClient();
        }
        catch (Throwable throwable) {
            ExceptionLogger.logException(throwable);
        }
    }

    private void updateClient() {
        if (!this.isWorking()) {
            return;
        }
        this.updateWhisperChat();
    }

    private void updateWhisperChat() {
        if (this.whisperChatCreation.isEmpty()) {
            return;
        }
        long l = System.currentTimeMillis();
        ArrayList<WhisperChatCreation> arrayList = new ArrayList<WhisperChatCreation>(this.whisperChatCreation.values());
        for (WhisperChatCreation whisperChatCreation : arrayList) {
            if (this.whisperChats.containsKey(whisperChatCreation.destPlayerName)) {
                WhisperChat whisperChat = this.whisperChats.get(whisperChatCreation.destPlayerName);
                logger.write("Whisper chat created between '" + this.myNickname + "' and '" + whisperChatCreation.destPlayerName + "' and has id = " + whisperChat.getID(), "info");
                this.whisperChatCreation.remove(whisperChatCreation.destPlayerName);
                for (String string : whisperChatCreation.messages) {
                    this.sendMessageToChat(whisperChat, whisperChat.createMessage(string));
                }
                continue;
            }
            if (whisperChatCreation.status == WhisperChat.ChatStatus.PlayerNotFound) {
                logger.write("Player '" + whisperChatCreation.destPlayerName + "' is not found. Chat is not created", "info");
                this.whisperChatCreation.remove(whisperChatCreation.destPlayerName);
                this.showServerChatMessage(Translator.getText("UI_chat_whisper_player_not_found_error", whisperChatCreation.destPlayerName));
                continue;
            }
            if (whisperChatCreation.status != WhisperChat.ChatStatus.Creating || l - whisperChatCreation.createTime < 10000L) continue;
            logger.write("Whisper chat is not created by timeout. See server chat logs", "error");
            this.whisperChatCreation.remove(whisperChatCreation.destPlayerName);
        }
    }

    private void showChatDisabledMessage(ChatType chatType) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(Translator.getText("UI_chat_chat_disabled_msg", Translator.getText(chatType.getTitleID())));
        ArrayList<ChatType> arrayList = ChatUtility.getAllowedChatStreams();
        for (ChatType chatType2 : arrayList) {
            if (!this.isPlayerCanUseChat(chatType2).booleanValue()) continue;
            stringBuilder.append("    * ").append(Translator.getText(chatType2.getTitleID())).append(" <LINE> ");
        }
        this.showServerChatMessage(stringBuilder.toString());
    }

    private boolean isPlayerCanUseRadioChat() {
        Radio radio = this.player.getEquipedRadio();
        if (radio != null && radio.getDeviceData() != null) {
            boolean bl = radio.getDeviceData().getIsTurnedOn();
            bl &= radio.getDeviceData().getIsTwoWay();
            bl &= radio.getDeviceData().getIsPortable();
            return bl &= !radio.getDeviceData().getMicIsMuted();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DeviceData getTransmittingRadio() {
        if (this.player.getOnlineID() == -1) {
            return null;
        }
        VoiceManagerData voiceManagerData = VoiceManagerData.get(this.player.getOnlineID());
        ArrayList<VoiceManagerData.RadioData> arrayList = voiceManagerData.radioData;
        synchronized (arrayList) {
            return voiceManagerData.radioData.stream().filter(VoiceManagerData.RadioData::isTransmissionAvailable).findFirst().map(VoiceManagerData.RadioData::getDeviceData).orElse(null);
        }
    }

    private static enum Stage {
        notStarted,
        starting,
        working;

    }
}

