/*
 * Decompiled with CFR 0.152.
 */
package zombie.chat;

import java.util.ArrayList;
import java.util.HashSet;
import zombie.GameTime;
import zombie.characters.IsoPlayer;
import zombie.characters.Talker;
import zombie.chat.ChatElementOwner;
import zombie.chat.NineGridTexture;
import zombie.iso.objects.IsoRadio;
import zombie.iso.objects.IsoTelevision;
import zombie.network.GameServer;
import zombie.radio.ZomboidRadio;
import zombie.ui.TextDrawObject;
import zombie.ui.UIFont;
import zombie.vehicles.VehiclePart;

public class ChatElement
implements Talker {
    protected PlayerLines[] playerLines = new PlayerLines[4];
    protected ChatElementOwner owner;
    protected float historyVal = 1.0f;
    protected boolean historyInRange = false;
    protected float historyRange = 15.0f;
    protected boolean useEuclidean = true;
    protected boolean hasChatToDisplay = false;
    protected int maxChatLines = -1;
    protected int maxCharsPerLine = -1;
    protected String sayLine = null;
    protected String sayLineTag = null;
    protected TextDrawObject sayLineObject = null;
    protected boolean Speaking = false;
    protected String talkerType = "unknown";
    public static boolean doBackDrop = true;
    public static NineGridTexture backdropTexture;
    private int bufferX = 0;
    private int bufferY = 0;
    private static PlayerLinesList[] renderBatch;
    private static HashSet<String> noLogText;

    public ChatElement(ChatElementOwner chatElementOwner, int n, String string) {
        this.owner = chatElementOwner;
        this.setMaxChatLines(n);
        this.setMaxCharsPerLine(75);
        String string2 = this.talkerType = string != null ? string : this.talkerType;
        if (backdropTexture == null) {
            backdropTexture = new NineGridTexture("NineGridBlack", 5);
        }
    }

    public void setMaxChatLines(int n) {
        int n2 = n < 1 ? 1 : (n = n > 10 ? 10 : n);
        if (n != this.maxChatLines) {
            this.maxChatLines = n;
            for (int i = 0; i < this.playerLines.length; ++i) {
                this.playerLines[i] = new PlayerLines(this.maxChatLines);
            }
        }
    }

    public int getMaxChatLines() {
        return this.maxChatLines;
    }

    public void setMaxCharsPerLine(int n) {
        for (int i = 0; i < this.playerLines.length; ++i) {
            this.playerLines[i].setMaxCharsPerLine(n);
        }
        this.maxCharsPerLine = n;
    }

    @Override
    public boolean IsSpeaking() {
        return this.Speaking;
    }

    @Override
    public String getTalkerType() {
        return this.talkerType;
    }

    public void setTalkerType(String string) {
        this.talkerType = string == null ? "" : string;
    }

    @Override
    public String getSayLine() {
        return this.sayLine;
    }

    public String getSayLineTag() {
        if (this.Speaking && this.sayLineTag != null) {
            return this.sayLineTag;
        }
        return "";
    }

    public void setHistoryRange(float f) {
        this.historyRange = f;
    }

    public void setUseEuclidean(boolean bl) {
        this.useEuclidean = bl;
    }

    public boolean getHasChatToDisplay() {
        return this.hasChatToDisplay;
    }

    protected float getDistance(IsoPlayer isoPlayer) {
        if (isoPlayer == null) {
            return -1.0f;
        }
        if (this.useEuclidean) {
            return (float)Math.sqrt(Math.pow(this.owner.getX() - isoPlayer.x, 2.0) + Math.pow(this.owner.getY() - isoPlayer.y, 2.0));
        }
        return Math.abs(this.owner.getX() - isoPlayer.x) + Math.abs(this.owner.getY() - isoPlayer.y);
    }

    protected boolean playerWithinBounds(IsoPlayer isoPlayer, float f) {
        if (isoPlayer == null) {
            return false;
        }
        return isoPlayer.getX() > this.owner.getX() - f && isoPlayer.getX() < this.owner.getX() + f && isoPlayer.getY() > this.owner.getY() - f && isoPlayer.getY() < this.owner.getY() + f;
    }

    public void SayDebug(int n, String string) {
        if (!GameServer.bServer && n >= 0 && n < this.maxChatLines) {
            for (int i = 0; i < IsoPlayer.numPlayers; ++i) {
                IsoPlayer isoPlayer = IsoPlayer.players[i];
                if (isoPlayer == null) continue;
                PlayerLines playerLines = this.playerLines[i];
                if (n >= playerLines.chatLines.length) continue;
                if (playerLines.chatLines[n].getOriginal() != null && playerLines.chatLines[n].getOriginal().equals(string)) {
                    playerLines.chatLines[n].setInternalTickClock(playerLines.lineDisplayTime);
                    continue;
                }
                playerLines.chatLines[n].setSettings(true, true, true, true, true, true);
                playerLines.chatLines[n].setInternalTickClock(playerLines.lineDisplayTime);
                playerLines.chatLines[n].setCustomTag("default");
                playerLines.chatLines[n].setDefaultColors(1.0f, 1.0f, 1.0f, 1.0f);
                playerLines.chatLines[n].ReadString(UIFont.Medium, string, this.maxCharsPerLine);
            }
            this.sayLine = string;
            this.sayLineTag = "default";
            this.hasChatToDisplay = true;
        }
    }

    @Override
    public void Say(String string) {
        this.addChatLine(string, 1.0f, 1.0f, 1.0f, UIFont.Dialogue, 25.0f, "default", false, false, false, false, false, true);
    }

    public void addChatLine(String string, float f, float f2, float f3, float f4) {
        this.addChatLine(string, f, f2, f3, UIFont.Dialogue, f4, "default", false, false, false, false, false, true);
    }

    public void addChatLine(String string, float f, float f2, float f3) {
        this.addChatLine(string, f, f2, f3, UIFont.Dialogue, 25.0f, "default", false, false, false, false, false, true);
    }

    public void addChatLine(String string, float f, float f2, float f3, UIFont uIFont, float f4, String string2, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6) {
        if (!GameServer.bServer) {
            for (int i = 0; i < IsoPlayer.numPlayers; ++i) {
                String string3;
                PlayerLines playerLines;
                TextDrawObject textDrawObject;
                IsoPlayer isoPlayer = IsoPlayer.players[i];
                if (isoPlayer == null || isoPlayer.Traits.Deaf.isSet() && (!(this.owner instanceof IsoTelevision) ? this.owner instanceof IsoRadio || this.owner instanceof VehiclePart : !((IsoTelevision)this.owner).isFacing(isoPlayer))) continue;
                float f5 = this.getScrambleValue(isoPlayer, f4);
                if (!(f5 < 1.0f) || (textDrawObject = (playerLines = this.playerLines[i]).getNewLineObject()) == null) continue;
                textDrawObject.setSettings(bl, bl2, bl3, bl4, bl5, bl6);
                textDrawObject.setInternalTickClock(playerLines.lineDisplayTime);
                textDrawObject.setCustomTag(string2);
                if (f5 > 0.0f) {
                    string3 = ZomboidRadio.getInstance().scrambleString(string, (int)(100.0f * f5), true, "...");
                    textDrawObject.setDefaultColors(0.5f, 0.5f, 0.5f, 1.0f);
                } else {
                    string3 = string;
                    textDrawObject.setDefaultColors(f, f2, f3, 1.0f);
                }
                textDrawObject.ReadString(uIFont, string3, this.maxCharsPerLine);
                this.sayLine = string;
                this.sayLineTag = string2;
                this.hasChatToDisplay = true;
            }
        }
    }

    protected float getScrambleValue(IsoPlayer isoPlayer, float f) {
        float f2;
        if (this.owner == isoPlayer) {
            return 0.0f;
        }
        float f3 = 1.0f;
        boolean bl = false;
        boolean bl2 = false;
        if (this.owner.getSquare() != null && isoPlayer.getSquare() != null) {
            if (isoPlayer.getBuilding() != null && this.owner.getSquare().getBuilding() != null && isoPlayer.getBuilding() == this.owner.getSquare().getBuilding()) {
                if (isoPlayer.getSquare().getRoom() == this.owner.getSquare().getRoom()) {
                    f3 = (float)((double)f3 * 2.0);
                    bl2 = true;
                } else if (Math.abs(isoPlayer.getZ() - this.owner.getZ()) < 1.0f) {
                    f3 = (float)((double)f3 * 2.0);
                }
            } else if (isoPlayer.getBuilding() != null || this.owner.getSquare().getBuilding() != null) {
                f3 = (float)((double)f3 * 0.5);
                bl = true;
            }
            if (Math.abs(isoPlayer.getZ() - this.owner.getZ()) >= 1.0f) {
                f3 = (float)((double)f3 - (double)f3 * ((double)Math.abs(isoPlayer.getZ() - this.owner.getZ()) * 0.25));
                bl = true;
            }
        }
        float f4 = f * f3;
        float f5 = 1.0f;
        if (f3 > 0.0f && this.playerWithinBounds(isoPlayer, f4) && (f2 = this.getDistance(isoPlayer)) >= 0.0f && f2 < f4) {
            float f6 = f4 * 0.6f;
            if (bl2 || !bl && f2 < f6) {
                f5 = 0.0f;
            } else if (f4 - f6 != 0.0f && (f5 = (f2 - f6) / (f4 - f6)) < 0.2f) {
                f5 = 0.2f;
            }
        }
        return f5;
    }

    protected void updateChatLines() {
        this.Speaking = false;
        boolean bl = false;
        if (this.hasChatToDisplay) {
            this.hasChatToDisplay = false;
            for (int i = 0; i < IsoPlayer.numPlayers; ++i) {
                float f = 1.25f * GameTime.getInstance().getMultiplier();
                int n = this.playerLines[i].lineDisplayTime;
                for (TextDrawObject textDrawObject : this.playerLines[i].chatLines) {
                    float f2 = textDrawObject.updateInternalTickClock(f);
                    if (f2 <= 0.0f) continue;
                    this.hasChatToDisplay = true;
                    if (!bl && !textDrawObject.getCustomTag().equals("radio")) {
                        float f3 = f2 / ((float)n / 2.0f);
                        if (f3 >= 1.0f) {
                            this.Speaking = true;
                        }
                        bl = true;
                    }
                    f *= 1.2f;
                }
            }
        }
        if (!this.Speaking) {
            this.sayLine = null;
            this.sayLineTag = null;
        }
    }

    protected void updateHistory() {
        if (this.hasChatToDisplay) {
            this.historyInRange = false;
            IsoPlayer isoPlayer = IsoPlayer.getInstance();
            if (isoPlayer != null) {
                if (isoPlayer == this.owner) {
                    this.historyVal = 1.0f;
                } else {
                    this.historyInRange = this.playerWithinBounds(isoPlayer, this.historyRange);
                    if (this.historyInRange && this.historyVal != 1.0f) {
                        this.historyVal += 0.04f;
                        if (this.historyVal > 1.0f) {
                            this.historyVal = 1.0f;
                        }
                    }
                    if (!this.historyInRange && this.historyVal != 0.0f) {
                        this.historyVal -= 0.04f;
                        if (this.historyVal < 0.0f) {
                            this.historyVal = 0.0f;
                        }
                    }
                }
            }
        } else if (this.historyVal != 0.0f) {
            this.historyVal = 0.0f;
        }
    }

    public void update() {
        if (GameServer.bServer) {
            return;
        }
        this.updateChatLines();
        this.updateHistory();
    }

    public void renderBatched(int n, int n2, int n3) {
        this.renderBatched(n, n2, n3, false);
    }

    public void renderBatched(int n, int n2, int n3, boolean bl) {
        if (n < this.playerLines.length && this.hasChatToDisplay && !GameServer.bServer) {
            this.playerLines[n].renderX = n2;
            this.playerLines[n].renderY = n3;
            this.playerLines[n].ignoreRadioLines = bl;
            if (renderBatch[n] == null) {
                ChatElement.renderBatch[n] = new PlayerLinesList();
            }
            renderBatch[n].add(this.playerLines[n]);
        }
    }

    public void clear(int n) {
        this.playerLines[n].clear();
    }

    public static void RenderBatch(int n) {
        if (renderBatch[n] != null && renderBatch[n].size() > 0) {
            for (int i = 0; i < renderBatch[n].size(); ++i) {
                PlayerLines playerLines = (PlayerLines)renderBatch[n].get(i);
                playerLines.render();
            }
            renderBatch[n].clear();
        }
    }

    public static void NoRender(int n) {
        if (renderBatch[n] != null) {
            renderBatch[n].clear();
        }
    }

    public static void addNoLogText(String string) {
        if (string == null || string.isEmpty()) {
            return;
        }
        noLogText.add(string);
    }

    static {
        renderBatch = new PlayerLinesList[4];
        noLogText = new HashSet();
    }

    class PlayerLines {
        protected int lineDisplayTime = 314;
        protected int renderX = 0;
        protected int renderY = 0;
        protected boolean ignoreRadioLines = false;
        protected TextDrawObject[] chatLines;

        public PlayerLines(int n) {
            this.chatLines = new TextDrawObject[n];
            for (int i = 0; i < this.chatLines.length; ++i) {
                this.chatLines[i] = new TextDrawObject(0, 0, 0, true, true, true, true, true, true);
                this.chatLines[i].setDefaultFont(UIFont.Medium);
            }
        }

        public void setMaxCharsPerLine(int n) {
            for (int i = 0; i < this.chatLines.length; ++i) {
                this.chatLines[i].setMaxCharsPerLine(n);
            }
        }

        public TextDrawObject getNewLineObject() {
            if (this.chatLines != null && this.chatLines.length > 0) {
                TextDrawObject textDrawObject = this.chatLines[this.chatLines.length - 1];
                textDrawObject.Clear();
                for (int i = this.chatLines.length - 1; i > 0; --i) {
                    this.chatLines[i] = this.chatLines[i - 1];
                }
                this.chatLines[0] = textDrawObject;
                return this.chatLines[0];
            }
            return null;
        }

        public void render() {
            if (GameServer.bServer) {
                return;
            }
            if (ChatElement.this.hasChatToDisplay) {
                int n = 0;
                for (TextDrawObject textDrawObject : this.chatLines) {
                    boolean bl;
                    if (!textDrawObject.getEnabled()) continue;
                    if (textDrawObject.getWidth() <= 0 || textDrawObject.getHeight() <= 0) {
                        ++n;
                        continue;
                    }
                    float f = textDrawObject.getInternalClock();
                    if (f <= 0.0f || textDrawObject.getCustomTag().equals("radio") && this.ignoreRadioLines) continue;
                    float f2 = f / ((float)this.lineDisplayTime / 4.0f);
                    if (f2 > 1.0f) {
                        f2 = 1.0f;
                    }
                    this.renderY -= textDrawObject.getHeight() + 1;
                    boolean bl2 = bl = textDrawObject.getDefaultFontEnum() != UIFont.Dialogue;
                    if (doBackDrop && backdropTexture != null) {
                        backdropTexture.renderInnerBased(this.renderX - textDrawObject.getWidth() / 2, this.renderY, textDrawObject.getWidth(), textDrawObject.getHeight(), 0.0f, 0.0f, 0.0f, 0.4f);
                    }
                    if (n == 0) {
                        textDrawObject.Draw(this.renderX, this.renderY, bl, f2);
                    } else if (ChatElement.this.historyVal > 0.0f) {
                        textDrawObject.Draw(this.renderX, this.renderY, bl, f2 * ChatElement.this.historyVal);
                    }
                    ++n;
                }
            }
        }

        void clear() {
            if (!ChatElement.this.hasChatToDisplay) {
                return;
            }
            ChatElement.this.hasChatToDisplay = false;
            for (int i = 0; i < this.chatLines.length; ++i) {
                if (this.chatLines[i].getInternalClock() <= 0.0f) continue;
                this.chatLines[i].Clear();
                this.chatLines[i].updateInternalTickClock(this.chatLines[i].getInternalClock());
            }
            ChatElement.this.historyInRange = false;
            ChatElement.this.historyVal = 0.0f;
        }
    }

    class PlayerLinesList
    extends ArrayList<PlayerLines> {
        PlayerLinesList() {
        }
    }
}

