/*
 * Decompiled with CFR 0.152.
 */
package zombie.characters.skills;

import java.util.ArrayList;
import java.util.HashMap;
import zombie.core.Translator;
import zombie.core.math.PZMath;

public final class PerkFactory {
    public static final ArrayList<Perk> PerkList = new ArrayList();
    private static final HashMap<String, Perk> PerkById = new HashMap();
    private static final HashMap<String, Perk> PerkByName = new HashMap();
    private static final Perk[] PerkByIndex = new Perk[256];
    private static int NextPerkID = 0;
    static float PerkXPReqMultiplier = 1.5f;

    public static String getPerkName(Perk perk) {
        return perk.getName();
    }

    public static Perk getPerkFromName(String string) {
        return PerkByName.get(string);
    }

    public static Perk getPerk(Perk perk) {
        return perk;
    }

    public static Perk AddPerk(Perk perk, String string, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10) {
        return PerkFactory.AddPerk(perk, string, Perks.None, n, n2, n3, n4, n5, n6, n7, n8, n9, n10, false);
    }

    public static Perk AddPerk(Perk perk, String string, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, boolean bl) {
        return PerkFactory.AddPerk(perk, string, Perks.None, n, n2, n3, n4, n5, n6, n7, n8, n9, n10, bl);
    }

    public static Perk AddPerk(Perk perk, String string, Perk perk2, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10) {
        return PerkFactory.AddPerk(perk, string, perk2, n, n2, n3, n4, n5, n6, n7, n8, n9, n10, false);
    }

    public static Perk AddPerk(Perk perk, String string, Perk perk2, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, boolean bl) {
        Perk perk3 = perk;
        perk3.translation = string;
        perk3.name = Translator.getText("IGUI_perks_" + string);
        perk3.parent = perk2;
        perk3.passiv = bl;
        perk3.xp1 = (int)((float)n * PerkXPReqMultiplier);
        perk3.xp2 = (int)((float)n2 * PerkXPReqMultiplier);
        perk3.xp3 = (int)((float)n3 * PerkXPReqMultiplier);
        perk3.xp4 = (int)((float)n4 * PerkXPReqMultiplier);
        perk3.xp5 = (int)((float)n5 * PerkXPReqMultiplier);
        perk3.xp6 = (int)((float)n6 * PerkXPReqMultiplier);
        perk3.xp7 = (int)((float)n7 * PerkXPReqMultiplier);
        perk3.xp8 = (int)((float)n8 * PerkXPReqMultiplier);
        perk3.xp9 = (int)((float)n9 * PerkXPReqMultiplier);
        perk3.xp10 = (int)((float)n10 * PerkXPReqMultiplier);
        PerkByName.put(perk.getName(), perk3);
        PerkList.add(perk3);
        return perk3;
    }

    public static void init() {
        Perks.None.parent = Perks.None;
        Perks.MAX.parent = Perks.None;
        PerkFactory.AddPerk(Perks.Combat, "Combat", 50, 100, 200, 500, 1000, 2000, 3000, 4000, 5000, 6000);
        PerkFactory.AddPerk(Perks.Axe, "Axe", Perks.Combat, 50, 100, 200, 500, 1000, 2000, 3000, 4000, 5000, 6000);
        PerkFactory.AddPerk(Perks.Blunt, "Blunt", Perks.Combat, 50, 100, 200, 500, 1000, 2000, 3000, 4000, 5000, 6000);
        PerkFactory.AddPerk(Perks.SmallBlunt, "SmallBlunt", Perks.Combat, 50, 100, 200, 500, 1000, 2000, 3000, 4000, 5000, 6000);
        PerkFactory.AddPerk(Perks.LongBlade, "LongBlade", Perks.Combat, 50, 100, 200, 500, 1000, 2000, 3000, 4000, 5000, 6000);
        PerkFactory.AddPerk(Perks.SmallBlade, "SmallBlade", Perks.Combat, 50, 100, 200, 500, 1000, 2000, 3000, 4000, 5000, 6000);
        PerkFactory.AddPerk(Perks.Spear, "Spear", Perks.Combat, 50, 100, 200, 500, 1000, 2000, 3000, 4000, 5000, 6000);
        PerkFactory.AddPerk(Perks.Maintenance, "Maintenance", Perks.Combat, 50, 100, 200, 500, 1000, 2000, 3000, 4000, 5000, 6000);
        PerkFactory.AddPerk(Perks.Firearm, "Firearm", 50, 100, 200, 500, 1000, 2000, 3000, 4000, 5000, 6000);
        PerkFactory.AddPerk(Perks.Aiming, "Aiming", Perks.Firearm, 50, 100, 200, 500, 1000, 2000, 3000, 4000, 5000, 6000);
        PerkFactory.AddPerk(Perks.Reloading, "Reloading", Perks.Firearm, 50, 100, 200, 500, 1000, 2000, 3000, 4000, 5000, 6000);
        PerkFactory.AddPerk(Perks.Crafting, "Crafting", 50, 100, 200, 500, 1000, 2000, 3000, 4000, 5000, 6000);
        PerkFactory.AddPerk(Perks.Woodwork, "Carpentry", Perks.Crafting, 50, 100, 200, 500, 1000, 2000, 3000, 4000, 5000, 6000);
        PerkFactory.AddPerk(Perks.Cooking, "Cooking", Perks.Crafting, 50, 100, 200, 500, 1000, 2000, 3000, 4000, 5000, 6000);
        PerkFactory.AddPerk(Perks.Farming, "Farming", Perks.Crafting, 50, 100, 200, 500, 1000, 2000, 3000, 4000, 5000, 6000);
        PerkFactory.AddPerk(Perks.Doctor, "Doctor", Perks.Crafting, 50, 100, 200, 500, 1000, 2000, 3000, 4000, 5000, 6000);
        PerkFactory.AddPerk(Perks.Electricity, "Electricity", Perks.Crafting, 50, 100, 200, 500, 1000, 2000, 3000, 4000, 5000, 6000);
        PerkFactory.AddPerk(Perks.MetalWelding, "MetalWelding", Perks.Crafting, 50, 100, 200, 500, 1000, 2000, 3000, 4000, 5000, 6000);
        PerkFactory.AddPerk(Perks.Mechanics, "Mechanics", Perks.Crafting, 50, 100, 200, 500, 1000, 2000, 3000, 4000, 5000, 6000);
        PerkFactory.AddPerk(Perks.Tailoring, "Tailoring", Perks.Crafting, 50, 100, 200, 500, 1000, 2000, 3000, 4000, 5000, 6000);
        PerkFactory.AddPerk(Perks.Survivalist, "Survivalist", 50, 100, 200, 500, 1000, 2000, 3000, 4000, 5000, 6000);
        PerkFactory.AddPerk(Perks.Fishing, "Fishing", Perks.Survivalist, 50, 100, 200, 500, 1000, 2000, 3000, 4000, 5000, 6000);
        PerkFactory.AddPerk(Perks.Trapping, "Trapping", Perks.Survivalist, 50, 100, 200, 500, 1000, 2000, 3000, 4000, 5000, 6000);
        PerkFactory.AddPerk(Perks.PlantScavenging, "Foraging", Perks.Survivalist, 50, 100, 200, 500, 1000, 2000, 3000, 4000, 5000, 6000);
        PerkFactory.AddPerk(Perks.Passiv, "Passive", 50, 100, 200, 500, 1000, 2000, 3000, 4000, 5000, 6000, true);
        PerkFactory.AddPerk(Perks.Fitness, "Fitness", Perks.Passiv, 1000, 2000, 4000, 6000, 12000, 20000, 40000, 60000, 80000, 100000, true);
        PerkFactory.AddPerk(Perks.Strength, "Strength", Perks.Passiv, 1000, 2000, 4000, 6000, 12000, 20000, 40000, 60000, 80000, 100000, true);
        PerkFactory.AddPerk(Perks.Agility, "Agility", 50, 100, 200, 500, 1000, 2000, 3000, 4000, 5000, 6000);
        PerkFactory.AddPerk(Perks.Sprinting, "Sprinting", Perks.Agility, 50, 100, 200, 500, 1000, 2000, 3000, 4000, 5000, 6000);
        PerkFactory.AddPerk(Perks.Lightfoot, "Lightfooted", Perks.Agility, 50, 100, 200, 500, 1000, 2000, 3000, 4000, 5000, 6000);
        PerkFactory.AddPerk(Perks.Nimble, "Nimble", Perks.Agility, 50, 100, 200, 500, 1000, 2000, 3000, 4000, 5000, 6000);
        PerkFactory.AddPerk(Perks.Sneak, "Sneaking", Perks.Agility, 50, 100, 200, 500, 1000, 2000, 3000, 4000, 5000, 6000);
    }

    public static void initTranslations() {
        PerkByName.clear();
        for (Perk perk : PerkList) {
            perk.name = Translator.getText("IGUI_perks_" + perk.translation);
            PerkByName.put(perk.name, perk);
        }
    }

    public static void Reset() {
        NextPerkID = 0;
        for (int i = PerkByIndex.length - 1; i >= 0; --i) {
            Perk perk = PerkByIndex[i];
            if (perk == null) continue;
            if (perk.isCustom()) {
                PerkList.remove(perk);
                PerkById.remove(perk.getId());
                PerkByName.remove(perk.getName());
                PerkFactory.PerkByIndex[perk.index] = null;
                continue;
            }
            if (perk == Perks.MAX || NextPerkID != 0) continue;
            NextPerkID = i + 1;
        }
        Perks.MAX.index = NextPerkID;
    }

    public static final class Perk {
        private final String id;
        private int index;
        private boolean bCustom = false;
        public String translation;
        public String name;
        public boolean passiv = false;
        public int xp1;
        public int xp2;
        public int xp3;
        public int xp4;
        public int xp5;
        public int xp6;
        public int xp7;
        public int xp8;
        public int xp9;
        public int xp10;
        public Perk parent = Perks.None;

        public Perk(String string) {
            this.id = string;
            this.index = NextPerkID++;
            this.translation = string;
            this.name = string;
            PerkById.put(string, this);
            PerkFactory.PerkByIndex[this.index] = this;
            if (Perks.MAX != null) {
                Perks.MAX.index = PZMath.max(Perks.MAX.index, this.index + 1);
            }
        }

        public Perk(String string, Perk perk) {
            this(string);
            this.parent = perk;
        }

        public String getId() {
            return this.id;
        }

        public int index() {
            return this.index;
        }

        public void setCustom() {
            this.bCustom = true;
        }

        public boolean isCustom() {
            return this.bCustom;
        }

        public boolean isPassiv() {
            return this.passiv;
        }

        public Perk getParent() {
            return this.parent;
        }

        public String getName() {
            return this.name;
        }

        public Perk getType() {
            return this;
        }

        public int getXp1() {
            return this.xp1;
        }

        public int getXp2() {
            return this.xp2;
        }

        public int getXp3() {
            return this.xp3;
        }

        public int getXp4() {
            return this.xp4;
        }

        public int getXp5() {
            return this.xp5;
        }

        public int getXp6() {
            return this.xp6;
        }

        public int getXp7() {
            return this.xp7;
        }

        public int getXp8() {
            return this.xp8;
        }

        public int getXp9() {
            return this.xp9;
        }

        public int getXp10() {
            return this.xp10;
        }

        public float getXpForLevel(int n) {
            if (n == 1) {
                return this.xp1;
            }
            if (n == 2) {
                return this.xp2;
            }
            if (n == 3) {
                return this.xp3;
            }
            if (n == 4) {
                return this.xp4;
            }
            if (n == 5) {
                return this.xp5;
            }
            if (n == 6) {
                return this.xp6;
            }
            if (n == 7) {
                return this.xp7;
            }
            if (n == 8) {
                return this.xp8;
            }
            if (n == 9) {
                return this.xp9;
            }
            if (n == 10) {
                return this.xp10;
            }
            return -1.0f;
        }

        public float getTotalXpForLevel(int n) {
            int n2 = 0;
            for (int i = 1; i <= n; ++i) {
                float f = this.getXpForLevel(i);
                if (f == -1.0f) continue;
                n2 = (int)((float)n2 + f);
            }
            return n2;
        }

        public String toString() {
            return this.id;
        }
    }

    public static final class Perks {
        public static final Perk None = new Perk("None");
        public static final Perk Agility = new Perk("Agility");
        public static final Perk Cooking = new Perk("Cooking");
        public static final Perk Melee = new Perk("Melee");
        public static final Perk Crafting = new Perk("Crafting");
        public static final Perk Fitness = new Perk("Fitness");
        public static final Perk Strength = new Perk("Strength");
        public static final Perk Blunt = new Perk("Blunt");
        public static final Perk Axe = new Perk("Axe");
        public static final Perk Sprinting = new Perk("Sprinting");
        public static final Perk Lightfoot = new Perk("Lightfoot");
        public static final Perk Nimble = new Perk("Nimble");
        public static final Perk Sneak = new Perk("Sneak");
        public static final Perk Woodwork = new Perk("Woodwork");
        public static final Perk Aiming = new Perk("Aiming");
        public static final Perk Reloading = new Perk("Reloading");
        public static final Perk Farming = new Perk("Farming");
        public static final Perk Survivalist = new Perk("Survivalist");
        public static final Perk Fishing = new Perk("Fishing");
        public static final Perk Trapping = new Perk("Trapping");
        public static final Perk Passiv = new Perk("Passiv");
        public static final Perk Firearm = new Perk("Firearm");
        public static final Perk PlantScavenging = new Perk("PlantScavenging");
        public static final Perk Doctor = new Perk("Doctor");
        public static final Perk Electricity = new Perk("Electricity");
        public static final Perk Blacksmith = new Perk("Blacksmith");
        public static final Perk MetalWelding = new Perk("MetalWelding");
        public static final Perk Melting = new Perk("Melting");
        public static final Perk Mechanics = new Perk("Mechanics");
        public static final Perk Spear = new Perk("Spear");
        public static final Perk Maintenance = new Perk("Maintenance");
        public static final Perk SmallBlade = new Perk("SmallBlade");
        public static final Perk LongBlade = new Perk("LongBlade");
        public static final Perk SmallBlunt = new Perk("SmallBlunt");
        public static final Perk Combat = new Perk("Combat");
        public static final Perk Tailoring = new Perk("Tailoring");
        public static final Perk MAX = new Perk("MAX");

        public static int getMaxIndex() {
            return MAX.index();
        }

        public static Perk fromIndex(int n) {
            if (n < 0 || n > NextPerkID) {
                return null;
            }
            return PerkByIndex[n];
        }

        public static Perk FromString(String string) {
            return PerkById.getOrDefault(string, MAX);
        }
    }
}

