/*
 * Decompiled with CFR 0.152.
 */
package zombie.characters.action.conditions;

import org.w3c.dom.Element;
import zombie.characters.action.ActionContext;
import zombie.characters.action.IActionCondition;
import zombie.core.Core;
import zombie.core.skinnedmodel.advancedanimation.IAnimatable;
import zombie.core.skinnedmodel.advancedanimation.IAnimationVariableSource;
import zombie.core.skinnedmodel.advancedanimation.debug.AnimatorDebugMonitor;
import zombie.util.StringUtils;

public final class CharacterVariableCondition
implements IActionCondition {
    private Operator op;
    private Object lhsValue;
    private Object rhsValue;

    private static Object parseValue(String string, boolean bl) {
        if (string.length() <= 0) {
            return string;
        }
        char c = string.charAt(0);
        if (c == '-' || c == '+' || c >= '0' && c <= '9') {
            int n;
            int n2 = 0;
            if (c >= '0' && c <= '9') {
                n2 = c - 48;
            }
            for (n = 1; n < string.length(); ++n) {
                char c2 = string.charAt(n);
                if (c2 >= '0' && c2 <= '9') {
                    n2 = n2 * 10 + (c2 - 48);
                    continue;
                }
                if (c2 == ',') continue;
                if (c2 == '.') {
                    ++n;
                    break;
                }
                return string;
            }
            if (n == string.length()) {
                return n2;
            }
            float f = n2;
            float f2 = 10.0f;
            while (n < string.length()) {
                char c3 = string.charAt(n);
                if (c3 >= '0' && c3 <= '9') {
                    f += (float)(c3 - 48) / f2;
                    f2 *= 10.0f;
                } else if (c3 != ',') {
                    return string;
                }
                ++n;
            }
            if (c == '-') {
                f *= -1.0f;
            }
            return Float.valueOf(f);
        }
        if (string.equalsIgnoreCase("true") || string.equalsIgnoreCase("yes")) {
            return true;
        }
        if (string.equalsIgnoreCase("false") || string.equalsIgnoreCase("no")) {
            return false;
        }
        if (bl) {
            if (c == '\'' || c == '\"') {
                StringBuilder stringBuilder = new StringBuilder(string.length() - 2);
                block6: for (int i = 1; i < string.length(); ++i) {
                    char c4 = string.charAt(i);
                    switch (c4) {
                        case '\"': 
                        case '\'': {
                            if (c4 == c) {
                                return stringBuilder.toString();
                            }
                        }
                        default: {
                            stringBuilder.append(c4);
                            continue block6;
                        }
                        case '\\': {
                            stringBuilder.append(string.charAt(i));
                        }
                    }
                }
                return stringBuilder.toString();
            }
            return new CharacterVariableLookup(string);
        }
        return string;
    }

    private boolean load(Element element) {
        switch (element.getNodeName()) {
            case "isTrue": {
                this.op = Operator.Equal;
                this.lhsValue = new CharacterVariableLookup(element.getTextContent().trim());
                this.rhsValue = true;
                return true;
            }
            case "isFalse": {
                this.op = Operator.Equal;
                this.lhsValue = new CharacterVariableLookup(element.getTextContent().trim());
                this.rhsValue = false;
                return true;
            }
            case "compare": {
                switch (element.getAttribute("op").trim()) {
                    default: {
                        return false;
                    }
                    case "=": 
                    case "==": {
                        this.op = Operator.Equal;
                        break;
                    }
                    case "!=": 
                    case "<>": {
                        this.op = Operator.NotEqual;
                        break;
                    }
                    case "<": {
                        this.op = Operator.Less;
                        break;
                    }
                    case ">": {
                        this.op = Operator.Greater;
                        break;
                    }
                    case "<=": {
                        this.op = Operator.LessEqual;
                        break;
                    }
                    case ">=": {
                        this.op = Operator.GreaterEqual;
                    }
                }
                this.loadCompareValues(element);
                return true;
            }
            case "gtr": {
                this.op = Operator.Greater;
                this.loadCompareValues(element);
                return true;
            }
            case "less": {
                this.op = Operator.Less;
                this.loadCompareValues(element);
                return true;
            }
            case "equals": {
                this.op = Operator.Equal;
                this.loadCompareValues(element);
                return true;
            }
            case "notEquals": {
                this.op = Operator.NotEqual;
                this.loadCompareValues(element);
                return true;
            }
            case "lessEqual": {
                this.op = Operator.LessEqual;
                this.loadCompareValues(element);
                return true;
            }
            case "gtrEqual": {
                this.op = Operator.GreaterEqual;
                this.loadCompareValues(element);
                return true;
            }
        }
        return false;
    }

    private void loadCompareValues(Element element) {
        String string = element.getAttribute("a").trim();
        String string2 = element.getAttribute("b").trim();
        this.lhsValue = CharacterVariableCondition.parseValue(string, true);
        this.rhsValue = CharacterVariableCondition.parseValue(string2, false);
    }

    private static Object resolveValue(Object object, IAnimationVariableSource iAnimationVariableSource) {
        if (object instanceof CharacterVariableLookup) {
            String string = iAnimationVariableSource.getVariableString(((CharacterVariableLookup)object).variableName);
            if (string != null) {
                return CharacterVariableCondition.parseValue(string, false);
            }
            return null;
        }
        return object;
    }

    private boolean resolveCompareTo(int n) {
        switch (this.op) {
            case Equal: {
                return n == 0;
            }
            case NotEqual: {
                return n != 0;
            }
            case Less: {
                return n < 0;
            }
            case LessEqual: {
                return n <= 0;
            }
            case Greater: {
                return n > 0;
            }
            case GreaterEqual: {
                return n >= 0;
            }
        }
        return false;
    }

    @Override
    public boolean passes(ActionContext actionContext, int n) {
        boolean bl;
        IAnimatable iAnimatable = actionContext.getOwner();
        Object object = CharacterVariableCondition.resolveValue(this.lhsValue, iAnimatable);
        Object object2 = CharacterVariableCondition.resolveValue(this.rhsValue, iAnimatable);
        if (object == null && object2 instanceof String && StringUtils.isNullOrEmpty((String)object2)) {
            if (this.op == Operator.Equal) {
                return true;
            }
            if (this.op == Operator.NotEqual) {
                return false;
            }
            bl = true;
        }
        if (object == null || object2 == null) {
            return false;
        }
        if (object.getClass().equals(object2.getClass())) {
            if (object instanceof String) {
                return this.resolveCompareTo(((String)object).compareTo((String)object2));
            }
            if (object instanceof Integer) {
                return this.resolveCompareTo(((Integer)object).compareTo((Integer)object2));
            }
            if (object instanceof Float) {
                return this.resolveCompareTo(((Float)object).compareTo((Float)object2));
            }
            if (object instanceof Boolean) {
                return this.resolveCompareTo(((Boolean)object).compareTo((Boolean)object2));
            }
        }
        bl = object instanceof Integer;
        boolean bl2 = object instanceof Float;
        boolean bl3 = object2 instanceof Integer;
        boolean bl4 = object2 instanceof Float;
        if ((bl || bl2) && (bl3 || bl4)) {
            boolean bl5 = this.lhsValue instanceof CharacterVariableLookup;
            boolean bl6 = this.rhsValue instanceof CharacterVariableLookup;
            if (bl5 == bl6) {
                float f = bl2 ? ((Float)object).floatValue() : (float)((Integer)object).intValue();
                float f2 = bl4 ? ((Float)object2).floatValue() : (float)((Integer)object2).intValue();
                return this.resolveCompareTo(Float.compare(f, f2));
            }
            if (bl5) {
                if (bl4) {
                    float f = bl2 ? ((Float)object).floatValue() : (float)((Integer)object).intValue();
                    float f3 = ((Float)object2).floatValue();
                    return this.resolveCompareTo(Float.compare(f, f3));
                }
                int n2 = bl2 ? (int)((Float)object).floatValue() : (Integer)object;
                int n3 = (Integer)object2;
                return this.resolveCompareTo(Integer.compare(n2, n3));
            }
            if (bl2) {
                float f = ((Float)object).floatValue();
                float f4 = bl4 ? ((Float)object2).floatValue() : (float)((Integer)object2).intValue();
                return this.resolveCompareTo(Float.compare(f, f4));
            }
            int n4 = (Integer)object;
            int n5 = bl4 ? (int)((Float)object2).floatValue() : (Integer)object2;
            return this.resolveCompareTo(Integer.compare(n4, n5));
        }
        return false;
    }

    @Override
    public IActionCondition clone() {
        return this;
    }

    private static String getOpString(Operator operator) {
        switch (operator) {
            case Equal: {
                return " == ";
            }
            case NotEqual: {
                return " != ";
            }
            case Less: {
                return " < ";
            }
            case LessEqual: {
                return " <= ";
            }
            case Greater: {
                return " > ";
            }
            case GreaterEqual: {
                return " >=";
            }
        }
        return " ?? ";
    }

    private static String valueToString(Object object) {
        if (object instanceof String) {
            return "\"" + (String)object + "\"";
        }
        return object.toString();
    }

    @Override
    public String getDescription() {
        return CharacterVariableCondition.valueToString(this.lhsValue) + CharacterVariableCondition.getOpString(this.op) + CharacterVariableCondition.valueToString(this.rhsValue);
    }

    private static class CharacterVariableLookup {
        public String variableName;

        public CharacterVariableLookup(String string) {
            this.variableName = string;
            if (Core.bDebug) {
                AnimatorDebugMonitor.registerVariable(string);
            }
        }

        public String toString() {
            return this.variableName;
        }
    }

    static enum Operator {
        Equal,
        NotEqual,
        Less,
        Greater,
        LessEqual,
        GreaterEqual;

    }

    public static class Factory
    implements IActionCondition.IFactory {
        @Override
        public IActionCondition create(Element element) {
            CharacterVariableCondition characterVariableCondition = new CharacterVariableCondition();
            if (characterVariableCondition.load(element)) {
                return characterVariableCondition;
            }
            return null;
        }
    }
}

