/*
 * Decompiled with CFR 0.152.
 */
package zombie.characters.action;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;
import zombie.ZomboidFileSystem;
import zombie.characters.action.ActionState;
import zombie.characters.action.ActionTransition;
import zombie.debug.DebugLog;
import zombie.debug.DebugType;

public final class ActionGroup {
    private static final Map<String, ActionGroup> actionGroupMap = new HashMap<String, ActionGroup>();
    String initialState;
    private List<ActionState> states = new ArrayList<ActionState>();
    private Map<String, ActionState> stateLookup;

    public static ActionGroup getActionGroup(String string) {
        ActionGroup actionGroup = actionGroupMap.get(string = string.toLowerCase());
        if (actionGroup != null || actionGroupMap.containsKey(string)) {
            return actionGroup;
        }
        actionGroup = new ActionGroup();
        actionGroupMap.put(string, actionGroup);
        try {
            actionGroup.load(string);
        }
        catch (Exception exception) {
            DebugLog.ActionSystem.error("Error loading action group: " + string);
            exception.printStackTrace(DebugLog.ActionSystem);
        }
        return actionGroup;
    }

    public static void reloadAll() {
        for (Map.Entry<String, ActionGroup> entry : actionGroupMap.entrySet()) {
            ActionGroup actionGroup = entry.getValue();
            for (ActionState actionState : actionGroup.states) {
                actionState.resetForReload();
            }
            actionGroup.load(entry.getKey());
        }
    }

    void load(String string) {
        File file;
        File[] fileArray;
        File file2;
        if (DebugLog.isEnabled(DebugType.ActionSystem)) {
            DebugLog.ActionSystem.debugln("Loading ActionGroup: " + string);
        }
        if ((file2 = ZomboidFileSystem.instance.getMediaFile("actiongroups/" + string + "/actionGroup.xml")).exists() && file2.canRead()) {
            this.loadGroupData(file2);
        }
        if ((fileArray = (file = ZomboidFileSystem.instance.getMediaFile("actiongroups/" + string)).listFiles()) != null) {
            for (File file3 : fileArray) {
                if (!file3.isDirectory()) continue;
                String string2 = file3.getPath();
                ActionState actionState = this.getOrCreate(file3.getName());
                actionState.load(string2);
            }
        }
    }

    private void loadGroupData(File file) {
        Object object;
        Document document;
        Object object2;
        Object object3;
        try {
            object3 = DocumentBuilderFactory.newInstance();
            object2 = ((DocumentBuilderFactory)object3).newDocumentBuilder();
            document = ((DocumentBuilder)object2).parse(file);
        }
        catch (IOException | ParserConfigurationException | SAXException exception) {
            DebugLog.ActionSystem.error("Error loading: " + file.getPath());
            exception.printStackTrace(DebugLog.ActionSystem);
            return;
        }
        document.getDocumentElement().normalize();
        object3 = document.getDocumentElement();
        if (!object3.getNodeName().equals("actiongroup")) {
            DebugLog.ActionSystem.error("Error loading: " + file.getPath() + ", expected root element '<actiongroup>', received '<" + object3.getNodeName() + ">'");
            return;
        }
        for (object2 = object3.getFirstChild(); object2 != null; object2 = object2.getNextSibling()) {
            if (!object2.getNodeName().equals("inherit") || !(object2 instanceof Element)) continue;
            object = object2.getTextContent().trim();
            this.inherit(ActionGroup.getActionGroup((String)object));
        }
        block11: for (object2 = object3.getFirstChild(); object2 != null; object2 = object2.getNextSibling()) {
            if (!(object2 instanceof Element)) continue;
            object = (Element)object2;
            switch (object.getNodeName()) {
                case "initial": {
                    this.initialState = object.getTextContent().trim();
                    continue block11;
                }
                case "inherit": {
                    continue block11;
                }
                default: {
                    DebugLog.ActionSystem.warn("Warning: Unknown element '<>' in '" + file.getPath() + "'");
                }
            }
        }
    }

    private void inherit(ActionGroup actionGroup) {
        if (actionGroup == null) {
            return;
        }
        if (actionGroup.initialState != null) {
            this.initialState = actionGroup.initialState;
        }
        for (ActionState actionState : actionGroup.states) {
            ActionState actionState2 = this.getOrCreate(actionState.name);
            for (ActionTransition actionTransition : actionState.transitions) {
                actionState2.transitions.add(actionTransition.clone());
                actionState2.sortTransitions();
            }
        }
    }

    private void rebuildLookup() {
        HashMap<String, ActionState> hashMap = new HashMap<String, ActionState>();
        for (ActionState actionState : this.states) {
            hashMap.put(actionState.name.toLowerCase(), actionState);
        }
        this.stateLookup = hashMap;
    }

    public void addState(ActionState actionState) {
        this.states.add(actionState);
        this.stateLookup = null;
    }

    public ActionState get(String string) {
        if (this.stateLookup == null) {
            this.rebuildLookup();
        }
        return this.stateLookup.get(string.toLowerCase());
    }

    ActionState getOrCreate(String string) {
        ActionState actionState;
        if (this.stateLookup == null) {
            this.rebuildLookup();
        }
        if ((actionState = this.stateLookup.get(string = string.toLowerCase())) == null) {
            actionState = new ActionState(string);
            this.states.add(actionState);
            this.stateLookup.put(string, actionState);
        }
        return actionState;
    }

    public ActionState getInitialState() {
        ActionState actionState = null;
        if (this.initialState != null) {
            actionState = this.get(this.initialState);
        }
        if (actionState == null && this.states.size() > 0) {
            actionState = this.states.get(0);
        }
        return actionState;
    }

    public ActionState getDefaultState() {
        return this.getInitialState();
    }
}

