/*
 * Decompiled with CFR 0.152.
 */
package zombie.characters.action;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Predicate;
import zombie.characters.IsoPlayer;
import zombie.characters.IsoZombie;
import zombie.characters.action.ActionContextEvents;
import zombie.characters.action.ActionGroup;
import zombie.characters.action.ActionState;
import zombie.characters.action.ActionStateSnapshot;
import zombie.characters.action.ActionTransition;
import zombie.characters.action.IActionCondition;
import zombie.characters.action.IActionStateChanged;
import zombie.characters.action.conditions.CharacterVariableCondition;
import zombie.characters.action.conditions.EventNotOccurred;
import zombie.characters.action.conditions.EventOccurred;
import zombie.characters.action.conditions.LuaCall;
import zombie.core.profiling.PerformanceProfileProbe;
import zombie.core.skinnedmodel.advancedanimation.IAnimatable;
import zombie.debug.DebugLog;
import zombie.debug.DebugType;
import zombie.network.GameClient;
import zombie.util.StringUtils;
import zombie.util.list.PZArrayUtil;

public final class ActionContext {
    private final IAnimatable m_owner;
    private ActionGroup m_stateGroup;
    private ActionState m_currentState;
    private final ArrayList<ActionState> m_childStates = new ArrayList();
    private String m_previousStateName = null;
    private boolean m_statesChanged = false;
    public final ArrayList<IActionStateChanged> onStateChanged = new ArrayList();
    private final ActionContextEvents occurredEvents = new ActionContextEvents();

    public ActionContext(IAnimatable iAnimatable) {
        this.m_owner = iAnimatable;
    }

    public IAnimatable getOwner() {
        return this.m_owner;
    }

    public void update() {
        s_performance.update.invokeAndMeasure(this, ActionContext::updateInternal);
    }

    private void updateInternal() {
        if (this.m_currentState == null) {
            this.logCurrentState();
            return;
        }
        s_performance.evaluateCurrentStateTransitions.invokeAndMeasure(this, ActionContext::evaluateCurrentStateTransitions);
        s_performance.evaluateSubStateTransitions.invokeAndMeasure(this, ActionContext::evaluateSubStateTransitions);
        this.invokeAnyStateChangedEvents();
        this.logCurrentState();
    }

    public ActionState getNextState() {
        ActionState actionState;
        Object object;
        int n;
        Object object2 = null;
        for (n = 0; n < this.m_currentState.transitions.size(); ++n) {
            object = this.m_currentState.transitions.get(n);
            if (!((ActionTransition)object).passes(this, 0) || StringUtils.isNullOrWhitespace(((ActionTransition)object).transitionTo) || (actionState = this.m_stateGroup.get(((ActionTransition)object).transitionTo)) == null || this.hasChildState(actionState)) continue;
            if (((ActionTransition)object).asSubstate && this.currentStateSupportsChildState(actionState)) {
                this.tryAddChildState(actionState);
                continue;
            }
            object2 = actionState;
            break;
        }
        for (n = 0; n < this.childStateCount(); ++n) {
            object = null;
            actionState = this.getChildStateAt(n);
            for (int i = 0; i < actionState.transitions.size(); ++i) {
                ActionState actionState2;
                ActionTransition actionTransition = actionState.transitions.get(i);
                if (!actionTransition.passes(this, 1)) continue;
                if (actionTransition.transitionOut) {
                    --n;
                    break;
                }
                if (StringUtils.isNullOrWhitespace(actionTransition.transitionTo) || (actionState2 = this.m_stateGroup.get(actionTransition.transitionTo)) == null || this.hasChildState(actionState2)) continue;
                if (this.currentStateSupportsChildState(actionState2)) break;
                if (!actionTransition.forceParent) continue;
                object = actionState2;
                break;
            }
            if (object == this.m_currentState || object == null) continue;
            object2 = object;
        }
        return object2;
    }

    private void evaluateCurrentStateTransitions() {
        for (int i = 0; i < this.m_currentState.transitions.size(); ++i) {
            ActionTransition actionTransition = this.m_currentState.transitions.get(i);
            if (!actionTransition.passes(this, 0)) continue;
            if (StringUtils.isNullOrWhitespace(actionTransition.transitionTo)) {
                DebugLog.ActionSystem.warn("%s> Transition's target state not specified: \"%s\"", this.getOwner().getUID(), actionTransition.transitionTo);
                continue;
            }
            ActionState actionState = this.m_stateGroup.get(actionTransition.transitionTo);
            if (actionState == null) {
                DebugLog.ActionSystem.warn("%s> Transition's target state not found: \"%s\"", this.getOwner().getUID(), actionTransition.transitionTo);
                continue;
            }
            if (this.hasChildState(actionState)) continue;
            if (actionTransition.asSubstate && this.currentStateSupportsChildState(actionState)) {
                this.tryAddChildState(actionState);
                continue;
            }
            if (this.m_owner instanceof IsoPlayer) {
                DebugLog.log(DebugType.ActionSystem, "Player '" + ((IsoPlayer)this.m_owner).getUsername() + "' transits from " + this.m_currentState.getName() + " to " + actionTransition.transitionTo);
            }
            this.setCurrentState(actionState);
            break;
        }
    }

    private void evaluateSubStateTransitions() {
        for (int i = 0; i < this.childStateCount(); ++i) {
            ActionState actionState = null;
            ActionState actionState2 = this.getChildStateAt(i);
            for (int j = 0; j < actionState2.transitions.size(); ++j) {
                ActionTransition actionTransition = actionState2.transitions.get(j);
                if (!actionTransition.passes(this, 1)) continue;
                if (actionTransition.transitionOut) {
                    this.removeChildStateAt(i);
                    --i;
                    break;
                }
                if (StringUtils.isNullOrWhitespace(actionTransition.transitionTo)) continue;
                ActionState actionState3 = this.m_stateGroup.get(actionTransition.transitionTo);
                if (actionState3 == null) {
                    DebugLog.ActionSystem.warn("%s> Transition's target state not found: \"%s\"", this.getOwner().getUID(), actionTransition.transitionTo);
                    continue;
                }
                if (this.hasChildState(actionState3)) continue;
                if (this.currentStateSupportsChildState(actionState3)) {
                    this.m_childStates.set(i, actionState3);
                    this.onStatesChanged();
                    break;
                }
                if (!actionTransition.forceParent) continue;
                actionState = actionState3;
                break;
            }
            if (actionState == this.m_currentState || actionState == null) continue;
            this.setCurrentState(actionState);
        }
    }

    protected boolean currentStateSupportsChildState(ActionState actionState) {
        if (this.m_currentState == null) {
            return false;
        }
        return this.m_currentState.canHaveSubState(actionState);
    }

    private boolean hasChildState(ActionState actionState) {
        int n = this.indexOfChildState(actionState2 -> actionState2 == actionState);
        return n > -1;
    }

    public void setPlaybackStateSnapshot(ActionStateSnapshot actionStateSnapshot) {
        String string;
        int n;
        if (this.m_stateGroup == null) {
            return;
        }
        if (actionStateSnapshot.stateName == null) {
            DebugLog.General.warn("Snapshot not valid. Missing root state name.");
            return;
        }
        ActionState actionState = this.m_stateGroup.get(actionStateSnapshot.stateName);
        this.setCurrentState(actionState);
        if (PZArrayUtil.isNullOrEmpty(actionStateSnapshot.childStateNames)) {
            while (this.childStateCount() > 0) {
                this.removeChildStateAt(0);
            }
            return;
        }
        for (n = 0; n < this.childStateCount(); ++n) {
            string = this.getChildStateAt((int)n).name;
            boolean bl = StringUtils.contains(actionStateSnapshot.childStateNames, string, StringUtils::equalsIgnoreCase);
            if (bl) continue;
            this.removeChildStateAt(n);
            --n;
        }
        for (n = 0; n < actionStateSnapshot.childStateNames.length; ++n) {
            string = actionStateSnapshot.childStateNames[n];
            ActionState actionState2 = this.m_stateGroup.get(string);
            this.tryAddChildState(actionState2);
        }
    }

    public ActionStateSnapshot getPlaybackStateSnapshot() {
        if (this.m_currentState == null) {
            return null;
        }
        ActionStateSnapshot actionStateSnapshot = new ActionStateSnapshot();
        actionStateSnapshot.stateName = this.m_currentState.name;
        actionStateSnapshot.childStateNames = new String[this.m_childStates.size()];
        for (int i = 0; i < actionStateSnapshot.childStateNames.length; ++i) {
            actionStateSnapshot.childStateNames[i] = this.m_childStates.get((int)i).name;
        }
        return actionStateSnapshot;
    }

    protected boolean setCurrentState(ActionState actionState) {
        if (actionState == this.m_currentState) {
            return false;
        }
        this.m_previousStateName = this.m_currentState == null ? "" : this.m_currentState.getName();
        this.m_currentState = actionState;
        for (int i = 0; i < this.m_childStates.size(); ++i) {
            ActionState actionState2 = this.m_childStates.get(i);
            if (this.m_currentState.canHaveSubState(actionState2)) continue;
            this.removeChildStateAt(i);
            --i;
        }
        this.onStatesChanged();
        return true;
    }

    protected boolean tryAddChildState(ActionState actionState) {
        if (this.hasChildState(actionState)) {
            return false;
        }
        this.m_childStates.add(actionState);
        this.onStatesChanged();
        return true;
    }

    protected void removeChildStateAt(int n) {
        this.m_childStates.remove(n);
        this.onStatesChanged();
    }

    private void onStatesChanged() {
        this.m_statesChanged = true;
    }

    public void logCurrentState() {
        if (this.m_owner.isAnimationRecorderActive()) {
            this.m_owner.getAnimationPlayerRecorder().logActionState(this.m_currentState, this.m_childStates);
        }
    }

    private void invokeAnyStateChangedEvents() {
        if (!this.m_statesChanged) {
            return;
        }
        this.m_statesChanged = false;
        this.occurredEvents.clear();
        for (int i = 0; i < this.onStateChanged.size(); ++i) {
            IActionStateChanged iActionStateChanged = this.onStateChanged.get(i);
            iActionStateChanged.actionStateChanged(this);
        }
        if (this.m_owner instanceof IsoZombie) {
            ((IsoZombie)this.m_owner).networkAI.extraUpdate();
        }
    }

    public ActionState getCurrentState() {
        return this.m_currentState;
    }

    public void setGroup(ActionGroup actionGroup) {
        String string = this.m_currentState == null ? null : this.m_currentState.name;
        this.m_stateGroup = actionGroup;
        ActionState actionState = actionGroup.getInitialState();
        if (!StringUtils.equalsIgnoreCase(string, actionState.name)) {
            this.setCurrentState(actionState);
        } else {
            this.m_currentState = actionState;
        }
    }

    public ActionGroup getGroup() {
        return this.m_stateGroup;
    }

    public void reportEvent(String string) {
        this.reportEvent(-1, string);
    }

    public void reportEvent(int n, String string) {
        this.occurredEvents.add(string, n);
        if (GameClient.bClient && n == -1 && this.m_owner instanceof IsoPlayer && ((IsoPlayer)this.m_owner).isLocalPlayer()) {
            GameClient.sendEvent((IsoPlayer)this.m_owner, string);
        }
    }

    public final boolean hasChildStates() {
        return this.childStateCount() > 0;
    }

    public final int childStateCount() {
        return this.m_childStates != null ? this.m_childStates.size() : 0;
    }

    public final void foreachChildState(Consumer<ActionState> consumer) {
        for (int i = 0; i < this.childStateCount(); ++i) {
            ActionState actionState = this.getChildStateAt(i);
            consumer.accept(actionState);
        }
    }

    public final int indexOfChildState(Predicate<ActionState> predicate) {
        int n = -1;
        for (int i = 0; i < this.childStateCount(); ++i) {
            ActionState actionState = this.getChildStateAt(i);
            if (!predicate.test(actionState)) continue;
            n = i;
            break;
        }
        return n;
    }

    public final ActionState getChildStateAt(int n) {
        if (n < 0 || n >= this.childStateCount()) {
            throw new IndexOutOfBoundsException(String.format("Index %d out of bounds. childCount: %d", n, this.childStateCount()));
        }
        return this.m_childStates.get(n);
    }

    public List<ActionState> getChildStates() {
        return this.m_childStates;
    }

    public String getCurrentStateName() {
        return this.m_currentState.name;
    }

    public String getPreviousStateName() {
        return this.m_previousStateName;
    }

    public boolean hasEventOccurred(String string) {
        return this.hasEventOccurred(string, -1);
    }

    public boolean hasEventOccurred(String string, int n) {
        return this.occurredEvents.contains(string, n);
    }

    public void clearEvent(String string) {
        this.occurredEvents.clearEvent(string);
    }

    static {
        CharacterVariableCondition.Factory factory = new CharacterVariableCondition.Factory();
        IActionCondition.registerFactory("isTrue", factory);
        IActionCondition.registerFactory("isFalse", factory);
        IActionCondition.registerFactory("compare", factory);
        IActionCondition.registerFactory("gtr", factory);
        IActionCondition.registerFactory("less", factory);
        IActionCondition.registerFactory("equals", factory);
        IActionCondition.registerFactory("lessEqual", factory);
        IActionCondition.registerFactory("gtrEqual", factory);
        IActionCondition.registerFactory("notEquals", factory);
        IActionCondition.registerFactory("eventOccurred", new EventOccurred.Factory());
        IActionCondition.registerFactory("eventNotOccurred", new EventNotOccurred.Factory());
        IActionCondition.registerFactory("lua", new LuaCall.Factory());
    }

    private static class s_performance {
        static final PerformanceProfileProbe update = new PerformanceProfileProbe("ActionContext.update");
        static final PerformanceProfileProbe evaluateCurrentStateTransitions = new PerformanceProfileProbe("ActionContext.evaluateCurrentStateTransitions");
        static final PerformanceProfileProbe evaluateSubStateTransitions = new PerformanceProfileProbe("ActionContext.evaluateSubStateTransitions");

        private s_performance() {
        }
    }
}

