/*
 * Decompiled with CFR 0.152.
 */
package zombie.characters;

import java.io.IOException;
import java.util.HashSet;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import zombie.DummySoundManager;
import zombie.Lua.LuaManager;
import zombie.SoundManager;
import zombie.ZomboidFileSystem;
import zombie.characters.IsoZombie;
import zombie.characters.SurvivorFactory;
import zombie.core.Rand;
import zombie.iso.IsoCell;
import zombie.network.ServerMap;

public class ZombieIDMapTest
extends Assert {
    HashSet<Short> IDs = new HashSet();
    IsoCell cell = new IsoCell(300, 300);

    @BeforeClass
    public static void beforeAll() {
        try {
            Rand.init();
            ZomboidFileSystem.instance.init();
            LuaManager.init();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    @Test
    public void test10Allocations() {
        Rand.init();
        this.IDs.clear();
        int n = 10;
        for (int n2 = 0; n2 < n; n2 = (int)((short)(n2 + 1))) {
            short s = ServerMap.instance.getUniqueZombieId();
            System.out.println("id:" + s);
        }
    }

    @Test
    public void test32653Allocations() {
        Rand.init();
        this.IDs.clear();
        int n = 34653;
        long l = System.nanoTime();
        for (int i = 0; i < n; ++i) {
            short s = ServerMap.instance.getUniqueZombieId();
            ZombieIDMapTest.assertFalse((boolean)this.IDs.contains(s));
            this.IDs.add(s);
        }
        long l2 = System.nanoTime();
        float f = (float)(l2 - l) / 1000000.0f;
        System.out.println("time:" + f);
        System.out.println("time per task:" + f / (float)n);
    }

    @Test
    public void test32653Adds() {
        SoundManager.instance = new DummySoundManager();
        Rand.init();
        SurvivorFactory.addMaleForename("Bob");
        SurvivorFactory.addFemaleForename("Kate");
        SurvivorFactory.addSurname("Testova");
        this.IDs.clear();
        int n = 32653;
        long l = System.nanoTime();
        for (int n2 = 0; n2 < n; n2 = (int)((short)(n2 + 1))) {
            short s = ServerMap.instance.getUniqueZombieId();
            ZombieIDMapTest.assertNull((Object)ServerMap.instance.ZombieMap.get(s));
            ZombieIDMapTest.assertFalse((boolean)this.IDs.contains(s));
            IsoZombie isoZombie = new IsoZombie(this.cell);
            isoZombie.OnlineID = s;
            ServerMap.instance.ZombieMap.put(s, isoZombie);
            ZombieIDMapTest.assertEquals((long)s, (long)ServerMap.instance.ZombieMap.get((short)s).OnlineID);
            this.IDs.add(s);
        }
        long l2 = System.nanoTime();
        float f = (float)(l2 - l) / 1000000.0f;
        System.out.println("time:" + f);
        System.out.println("time per task:" + f / (float)n);
    }

    @Test
    public void test32653Process() {
        Rand.init();
        ServerMap.instance = new ServerMap();
        SoundManager.instance = new DummySoundManager();
        SurvivorFactory.addMaleForename("Bob");
        SurvivorFactory.addFemaleForename("Kate");
        SurvivorFactory.addSurname("Testova");
        this.IDs.clear();
        short s = 32653;
        long l = System.nanoTime();
        for (short s2 = 0; s2 < s; s2 = (short)(s2 + 1)) {
            ZombieIDMapTest.assertNull((Object)ServerMap.instance.ZombieMap.get(s2));
            IsoZombie isoZombie = new IsoZombie(this.cell);
            isoZombie.OnlineID = s2;
            ServerMap.instance.ZombieMap.put(s2, isoZombie);
            ZombieIDMapTest.assertEquals((long)s2, (long)ServerMap.instance.ZombieMap.get((short)s2).OnlineID);
        }
        long l2 = System.nanoTime();
        for (short s3 = 0; s3 < s; s3 = (short)(s3 + 1)) {
            ZombieIDMapTest.assertEquals((long)s3, (long)ServerMap.instance.ZombieMap.get((short)s3).OnlineID);
            ServerMap.instance.ZombieMap.remove(s3);
            ZombieIDMapTest.assertNull((Object)ServerMap.instance.ZombieMap.get(s3));
        }
        long l3 = System.nanoTime();
        for (short s4 = 0; s4 < s; s4 = (short)(s4 + 1)) {
            ZombieIDMapTest.assertNull((Object)ServerMap.instance.ZombieMap.get(s4));
            IsoZombie isoZombie = new IsoZombie(this.cell);
            isoZombie.OnlineID = s4;
            ServerMap.instance.ZombieMap.put(s4, isoZombie);
            ZombieIDMapTest.assertEquals((long)s4, (long)ServerMap.instance.ZombieMap.get((short)s4).OnlineID);
        }
        long l4 = System.nanoTime();
        for (short s5 = 0; s5 < s; s5 = (short)(s5 + 1)) {
            ZombieIDMapTest.assertEquals((long)s5, (long)ServerMap.instance.ZombieMap.get((short)s5).OnlineID);
            ServerMap.instance.ZombieMap.remove(s5);
            ZombieIDMapTest.assertNull((Object)ServerMap.instance.ZombieMap.get(s5));
        }
        long l5 = System.nanoTime();
        for (short s6 = 0; s6 < s; s6 = (short)(s6 + 1)) {
            ZombieIDMapTest.assertNull((Object)ServerMap.instance.ZombieMap.get(s6));
            IsoZombie isoZombie = new IsoZombie(this.cell);
            isoZombie.OnlineID = s6;
            ServerMap.instance.ZombieMap.put(s6, isoZombie);
            ZombieIDMapTest.assertEquals((long)s6, (long)ServerMap.instance.ZombieMap.get((short)s6).OnlineID);
        }
        long l6 = System.nanoTime();
        float f = (float)(l2 - l) / 1000000.0f;
        float f2 = (float)(l3 - l2) / 1000000.0f;
        float f3 = (float)(l4 - l3) / 1000000.0f;
        float f4 = (float)(l5 - l4) / 1000000.0f;
        float f5 = (float)(l6 - l5) / 1000000.0f;
        System.out.println("time1:" + f);
        System.out.println("time2:" + f2);
        System.out.println("time3:" + f3);
        System.out.println("time4:" + f4);
        System.out.println("time5:" + f5);
    }
}

