/*
 * Decompiled with CFR 0.152.
 */
package zombie.characters.WornItems;

import java.util.ArrayList;
import zombie.characters.WornItems.BodyLocation;

public final class BodyLocationGroup {
    protected final String id;
    protected final ArrayList<BodyLocation> locations = new ArrayList();

    public BodyLocationGroup(String string) {
        if (string == null) {
            throw new NullPointerException("id is null");
        }
        if (string.isEmpty()) {
            throw new IllegalArgumentException("id is empty");
        }
        this.id = string;
    }

    public BodyLocation getLocation(String string) {
        for (int i = 0; i < this.locations.size(); ++i) {
            BodyLocation bodyLocation = this.locations.get(i);
            if (!bodyLocation.isID(string)) continue;
            return bodyLocation;
        }
        return null;
    }

    public BodyLocation getLocationNotNull(String string) {
        BodyLocation bodyLocation = this.getLocation(string);
        if (bodyLocation == null) {
            throw new RuntimeException("unknown location \"" + string + "\"");
        }
        return bodyLocation;
    }

    public BodyLocation getOrCreateLocation(String string) {
        BodyLocation bodyLocation = this.getLocation(string);
        if (bodyLocation == null) {
            bodyLocation = new BodyLocation(this, string);
            this.locations.add(bodyLocation);
        }
        return bodyLocation;
    }

    public BodyLocation getLocationByIndex(int n) {
        if (n >= 0 && n < this.size()) {
            return this.locations.get(n);
        }
        return null;
    }

    public int size() {
        return this.locations.size();
    }

    public void setExclusive(String string, String string2) {
        BodyLocation bodyLocation = this.getLocationNotNull(string);
        BodyLocation bodyLocation2 = this.getLocationNotNull(string2);
        bodyLocation.setExclusive(string2);
        bodyLocation2.setExclusive(string);
    }

    public boolean isExclusive(String string, String string2) {
        BodyLocation bodyLocation = this.getLocationNotNull(string);
        this.checkValid(string2);
        return bodyLocation.exclusive.contains(string2);
    }

    public void setHideModel(String string, String string2) {
        BodyLocation bodyLocation = this.getLocationNotNull(string);
        this.checkValid(string2);
        bodyLocation.setHideModel(string2);
    }

    public boolean isHideModel(String string, String string2) {
        BodyLocation bodyLocation = this.getLocationNotNull(string);
        this.checkValid(string2);
        return bodyLocation.isHideModel(string2);
    }

    public int indexOf(String string) {
        for (int i = 0; i < this.locations.size(); ++i) {
            BodyLocation bodyLocation = this.locations.get(i);
            if (!bodyLocation.isID(string)) continue;
            return i;
        }
        return -1;
    }

    public void checkValid(String string) {
        if (string == null) {
            throw new NullPointerException("locationId is null");
        }
        if (string.isEmpty()) {
            throw new IllegalArgumentException("locationId is empty");
        }
        if (this.indexOf(string) == -1) {
            throw new RuntimeException("unknown location \"" + string + "\"");
        }
    }

    public void setMultiItem(String string, boolean bl) {
        BodyLocation bodyLocation = this.getLocationNotNull(string);
        bodyLocation.setMultiItem(bl);
    }

    public boolean isMultiItem(String string) {
        BodyLocation bodyLocation = this.getLocationNotNull(string);
        return bodyLocation.isMultiItem();
    }

    public ArrayList<BodyLocation> getAllLocations() {
        return this.locations;
    }
}

