/*
 * Decompiled with CFR 0.152.
 */
package zombie.characters;

import java.util.ArrayList;
import se.krka.kahlua.j2se.KahluaTableImpl;
import se.krka.kahlua.vm.KahluaTableIterator;
import zombie.Lua.LuaManager;
import zombie.characters.IsoZombie;
import zombie.core.Rand;
import zombie.core.skinnedmodel.population.OutfitRNG;
import zombie.core.skinnedmodel.visual.ItemVisual;
import zombie.scripting.ScriptManager;
import zombie.scripting.objects.Item;
import zombie.util.Type;

public class UnderwearDefinition {
    public static final UnderwearDefinition instance = new UnderwearDefinition();
    public boolean m_dirty = true;
    private static final ArrayList<OutfitUnderwearDefinition> m_outfitDefinition = new ArrayList();
    private static int baseChance = 50;

    public void checkDirty() {
        this.init();
    }

    private void init() {
        m_outfitDefinition.clear();
        KahluaTableImpl kahluaTableImpl = (KahluaTableImpl)LuaManager.env.rawget("UnderwearDefinition");
        if (kahluaTableImpl == null) {
            return;
        }
        baseChance = kahluaTableImpl.rawgetInt("baseChance");
        KahluaTableIterator kahluaTableIterator = kahluaTableImpl.iterator();
        while (kahluaTableIterator.advance()) {
            Object object;
            ArrayList<StringChance> arrayList = null;
            KahluaTableImpl kahluaTableImpl2 = Type.tryCastTo(kahluaTableIterator.getValue(), KahluaTableImpl.class);
            if (kahluaTableImpl2 == null) continue;
            KahluaTableImpl kahluaTableImpl3 = Type.tryCastTo(kahluaTableImpl2.rawget("top"), KahluaTableImpl.class);
            if (kahluaTableImpl3 != null) {
                arrayList = new ArrayList<StringChance>();
                object = kahluaTableImpl3.iterator();
                while (object.advance()) {
                    KahluaTableImpl kahluaTableImpl4 = Type.tryCastTo(object.getValue(), KahluaTableImpl.class);
                    if (kahluaTableImpl4 == null) continue;
                    arrayList.add(new StringChance(kahluaTableImpl4.rawgetStr("name"), kahluaTableImpl4.rawgetFloat("chance")));
                }
            }
            object = new OutfitUnderwearDefinition(arrayList, kahluaTableImpl2.rawgetStr("bottom"), kahluaTableImpl2.rawgetInt("chanceToSpawn"), kahluaTableImpl2.rawgetStr("gender"));
            m_outfitDefinition.add((OutfitUnderwearDefinition)object);
        }
    }

    public static void addRandomUnderwear(IsoZombie isoZombie) {
        Object object;
        OutfitUnderwearDefinition outfitUnderwearDefinition;
        int n;
        instance.checkDirty();
        if (Rand.Next(100) > baseChance) {
            return;
        }
        ArrayList<OutfitUnderwearDefinition> arrayList = new ArrayList<OutfitUnderwearDefinition>();
        int n2 = 0;
        for (n = 0; n < m_outfitDefinition.size(); ++n) {
            outfitUnderwearDefinition = m_outfitDefinition.get(n);
            if ((!isoZombie.isFemale() || !outfitUnderwearDefinition.female) && (isoZombie.isFemale() || outfitUnderwearDefinition.female)) continue;
            arrayList.add(outfitUnderwearDefinition);
            n2 += outfitUnderwearDefinition.chanceToSpawn;
        }
        n = OutfitRNG.Next(n2);
        outfitUnderwearDefinition = null;
        int n3 = 0;
        for (int i = 0; i < arrayList.size(); ++i) {
            object = (OutfitUnderwearDefinition)arrayList.get(i);
            if (n >= (n3 += ((OutfitUnderwearDefinition)object).chanceToSpawn)) continue;
            outfitUnderwearDefinition = object;
            break;
        }
        if (outfitUnderwearDefinition != null) {
            Item item = ScriptManager.instance.FindItem(outfitUnderwearDefinition.bottom);
            object = null;
            if (item != null) {
                object = isoZombie.getHumanVisual().addClothingItem(isoZombie.getItemVisuals(), item);
            }
            if (outfitUnderwearDefinition.top != null) {
                String string = null;
                n = OutfitRNG.Next(outfitUnderwearDefinition.topTotalChance);
                n3 = 0;
                for (int i = 0; i < outfitUnderwearDefinition.top.size(); ++i) {
                    StringChance stringChance = outfitUnderwearDefinition.top.get(i);
                    if (n >= (n3 = (int)((float)n3 + stringChance.chance))) continue;
                    string = stringChance.str;
                    break;
                }
                if (string != null && (item = ScriptManager.instance.FindItem(string)) != null) {
                    ItemVisual itemVisual = isoZombie.getHumanVisual().addClothingItem(isoZombie.getItemVisuals(), item);
                    if (Rand.Next(100) < 60 && itemVisual != null && object != null) {
                        itemVisual.setTint(((ItemVisual)object).getTint());
                    }
                }
            }
        }
    }

    private static final class StringChance {
        String str;
        float chance;

        public StringChance(String string, float f) {
            this.str = string;
            this.chance = f;
        }
    }

    public static final class OutfitUnderwearDefinition {
        public ArrayList<StringChance> top;
        public int topTotalChance = 0;
        public String bottom;
        public int chanceToSpawn;
        public boolean female = false;

        public OutfitUnderwearDefinition(ArrayList<StringChance> arrayList, String string, int n, String string2) {
            this.top = arrayList;
            if (arrayList != null) {
                for (int i = 0; i < arrayList.size(); ++i) {
                    this.topTotalChance = (int)((float)this.topTotalChance + arrayList.get((int)i).chance);
                }
            }
            this.bottom = string;
            this.chanceToSpawn = n;
            if ("female".equals(string2)) {
                this.female = true;
            }
        }
    }
}

