/*
 * Decompiled with CFR 0.152.
 */
package zombie.characters;

import java.util.ArrayList;
import zombie.characters.IsoGameCharacter;
import zombie.characters.IsoSurvivor;
import zombie.characters.SurvivorDesc;
import zombie.core.Rand;
import zombie.iso.IsoCell;

public final class SurvivorFactory {
    public static final ArrayList<String> FemaleForenames = new ArrayList();
    public static final ArrayList<String> MaleForenames = new ArrayList();
    public static final ArrayList<String> Surnames = new ArrayList();

    public static void Reset() {
        FemaleForenames.clear();
        MaleForenames.clear();
        Surnames.clear();
        SurvivorDesc.HairCommonColors.clear();
        SurvivorDesc.TrouserCommonColors.clear();
    }

    public static SurvivorDesc[] CreateFamily(int n) {
        SurvivorDesc[] survivorDescArray = new SurvivorDesc[n];
        for (int i = 0; i < n; ++i) {
            survivorDescArray[i] = SurvivorFactory.CreateSurvivor();
            if (i <= 0) continue;
            survivorDescArray[i].surname = survivorDescArray[0].surname;
        }
        return survivorDescArray;
    }

    public static SurvivorDesc CreateSurvivor() {
        switch (Rand.Next(3)) {
            case 0: {
                return SurvivorFactory.CreateSurvivor(SurvivorType.Friendly);
            }
            case 1: {
                return SurvivorFactory.CreateSurvivor(SurvivorType.Neutral);
            }
            case 2: {
                return SurvivorFactory.CreateSurvivor(SurvivorType.Aggressive);
            }
        }
        return null;
    }

    public static SurvivorDesc CreateSurvivor(SurvivorType survivorType, boolean bl) {
        SurvivorDesc survivorDesc = new SurvivorDesc();
        survivorDesc.setType(survivorType);
        IsoGameCharacter.getSurvivorMap().put(survivorDesc.ID, survivorDesc);
        survivorDesc.setFemale(bl);
        SurvivorFactory.randomName(survivorDesc);
        if (survivorDesc.isFemale()) {
            SurvivorFactory.setTorso(survivorDesc);
        } else {
            SurvivorFactory.setTorso(survivorDesc);
        }
        return survivorDesc;
    }

    public static void setTorso(SurvivorDesc survivorDesc) {
        survivorDesc.torso = survivorDesc.isFemale() ? "Kate" : "Male";
    }

    public static SurvivorDesc CreateSurvivor(SurvivorType survivorType) {
        return SurvivorFactory.CreateSurvivor(survivorType, Rand.Next(2) == 0);
    }

    public static SurvivorDesc[] CreateSurvivorGroup(int n) {
        SurvivorDesc[] survivorDescArray = new SurvivorDesc[n];
        for (int i = 0; i < n; ++i) {
            survivorDescArray[i] = SurvivorFactory.CreateSurvivor();
        }
        return survivorDescArray;
    }

    public static IsoSurvivor InstansiateInCell(SurvivorDesc survivorDesc, IsoCell isoCell, int n, int n2, int n3) {
        survivorDesc.Instance = new IsoSurvivor(survivorDesc, isoCell, n, n2, n3);
        return (IsoSurvivor)survivorDesc.Instance;
    }

    public static void randomName(SurvivorDesc survivorDesc) {
        survivorDesc.forename = survivorDesc.isFemale() ? FemaleForenames.get(Rand.Next(FemaleForenames.size())) : MaleForenames.get(Rand.Next(MaleForenames.size()));
        survivorDesc.surname = Surnames.get(Rand.Next(Surnames.size()));
    }

    public static void addSurname(String string) {
        Surnames.add(string);
    }

    public static void addFemaleForename(String string) {
        FemaleForenames.add(string);
    }

    public static void addMaleForename(String string) {
        MaleForenames.add(string);
    }

    public static String getRandomSurname() {
        return Surnames.get(Rand.Next(Surnames.size()));
    }

    public static String getRandomForename(boolean bl) {
        if (bl) {
            return FemaleForenames.get(Rand.Next(FemaleForenames.size()));
        }
        return MaleForenames.get(Rand.Next(MaleForenames.size()));
    }

    public static enum SurvivorType {
        Friendly,
        Neutral,
        Aggressive;

    }
}

