/*
 * Decompiled with CFR 0.152.
 */
package zombie.characters;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import se.krka.kahlua.vm.KahluaTable;
import zombie.GameWindow;
import zombie.Lua.LuaManager;
import zombie.characters.IsoGameCharacter;
import zombie.characters.SurvivorFactory;
import zombie.characters.SurvivorGroup;
import zombie.characters.WornItems.BodyLocations;
import zombie.characters.WornItems.WornItems;
import zombie.characters.professions.ProfessionFactory;
import zombie.characters.skills.PerkFactory;
import zombie.characters.traits.ObservationFactory;
import zombie.core.Color;
import zombie.core.ImmutableColor;
import zombie.core.Rand;
import zombie.core.skinnedmodel.population.OutfitRNG;
import zombie.core.skinnedmodel.visual.HumanVisual;
import zombie.core.skinnedmodel.visual.IHumanVisual;
import zombie.core.skinnedmodel.visual.ItemVisuals;
import zombie.core.textures.ColorInfo;
import zombie.inventory.InventoryItem;
import zombie.iso.IsoWorld;

public final class SurvivorDesc
implements IHumanVisual {
    public final HumanVisual humanVisual = new HumanVisual(this);
    public final WornItems wornItems = new WornItems(BodyLocations.getGroup("Human"));
    SurvivorGroup group = new SurvivorGroup();
    private static int IDCount = 0;
    public static final ArrayList<Color> TrouserCommonColors = new ArrayList();
    public static final ArrayList<ImmutableColor> HairCommonColors = new ArrayList();
    private final HashMap<PerkFactory.Perk, Integer> xpBoostMap = new HashMap();
    private KahluaTable metaTable;
    public String Profession = "";
    protected String forename = "None";
    protected int ID = 0;
    protected IsoGameCharacter Instance = null;
    private boolean bFemale = true;
    protected String surname = "None";
    private String InventoryScript = null;
    protected String torso = "Base_Torso";
    protected final HashMap<Integer, Integer> MetCount = new HashMap();
    protected float bravery = 1.0f;
    protected float loner = 0.0f;
    protected float aggressiveness = 1.0f;
    protected float compassion = 1.0f;
    protected float temper = 0.0f;
    protected float friendliness = 0.0f;
    private float favourindoors = 0.0f;
    protected float loyalty = 0.0f;
    public final ArrayList<String> extra = new ArrayList();
    private final ArrayList<ObservationFactory.Observation> Observations = new ArrayList(0);
    private SurvivorFactory.SurvivorType type = SurvivorFactory.SurvivorType.Neutral;
    public boolean bDead;

    @Override
    public HumanVisual getHumanVisual() {
        return this.humanVisual;
    }

    @Override
    public void getItemVisuals(ItemVisuals itemVisuals) {
        this.wornItems.getItemVisuals(itemVisuals);
    }

    @Override
    public boolean isFemale() {
        return this.bFemale;
    }

    @Override
    public boolean isZombie() {
        return false;
    }

    @Override
    public boolean isSkeleton() {
        return false;
    }

    public WornItems getWornItems() {
        return this.wornItems;
    }

    public void setWornItem(String string, InventoryItem inventoryItem) {
        this.wornItems.setItem(string, inventoryItem);
    }

    public InventoryItem getWornItem(String string) {
        return this.wornItems.getItem(string);
    }

    public void dressInNamedOutfit(String string) {
        ItemVisuals itemVisuals = new ItemVisuals();
        this.getHumanVisual().dressInNamedOutfit(string, itemVisuals);
        this.getWornItems().setFromItemVisuals(itemVisuals);
    }

    public SurvivorGroup getGroup() {
        return this.group;
    }

    public boolean isLeader() {
        return this.group.getLeader() == this;
    }

    public static int getIDCount() {
        return IDCount;
    }

    public void setProfessionSkills(ProfessionFactory.Profession profession) {
        this.getXPBoostMap().clear();
        this.getXPBoostMap().putAll(profession.XPBoostMap);
    }

    public HashMap<PerkFactory.Perk, Integer> getXPBoostMap() {
        return this.xpBoostMap;
    }

    public KahluaTable getMeta() {
        if (this.metaTable == null) {
            this.metaTable = (KahluaTable)LuaManager.caller.pcall(LuaManager.thread, LuaManager.env.rawget("createMetaSurvivor"), (Object)this)[1];
        }
        return this.metaTable;
    }

    public int getCalculatedToughness() {
        this.metaTable = this.getMeta();
        KahluaTable kahluaTable = (KahluaTable)LuaManager.env.rawget("MetaSurvivor");
        Double d = (Double)LuaManager.caller.pcall(LuaManager.thread, kahluaTable.rawget("getCalculatedToughness"), (Object)this.metaTable)[1];
        return d.intValue();
    }

    public static void setIDCount(int n) {
        IDCount = n;
    }

    public boolean isDead() {
        return this.bDead;
    }

    public SurvivorDesc() {
        this.ID = IDCount++;
        IsoWorld.instance.SurvivorDescriptors.put(this.ID, this);
        this.doStats();
    }

    public SurvivorDesc(boolean bl) {
        this.ID = IDCount++;
        this.doStats();
    }

    public SurvivorDesc(SurvivorDesc survivorDesc) {
        this.aggressiveness = survivorDesc.aggressiveness;
        this.bDead = survivorDesc.bDead;
        this.bFemale = survivorDesc.bFemale;
        this.bravery = survivorDesc.bravery;
        this.compassion = survivorDesc.compassion;
        this.extra.addAll(survivorDesc.extra);
        this.favourindoors = survivorDesc.favourindoors;
        this.forename = survivorDesc.forename;
        this.friendliness = survivorDesc.friendliness;
        this.InventoryScript = survivorDesc.InventoryScript;
        this.loner = survivorDesc.loner;
        this.loyalty = survivorDesc.loyalty;
        this.Profession = survivorDesc.Profession;
        this.surname = survivorDesc.surname;
        this.temper = survivorDesc.temper;
        this.torso = survivorDesc.torso;
        this.type = survivorDesc.type;
    }

    public void meet(SurvivorDesc survivorDesc) {
        if (this.MetCount.containsKey(survivorDesc.ID)) {
            this.MetCount.put(survivorDesc.ID, this.MetCount.get(survivorDesc.ID) + 1);
        } else {
            this.MetCount.put(survivorDesc.ID, 1);
        }
        if (survivorDesc.MetCount.containsKey(this.ID)) {
            survivorDesc.MetCount.put(this.ID, survivorDesc.MetCount.get(this.ID) + 1);
        } else {
            survivorDesc.MetCount.put(this.ID, 1);
        }
    }

    public boolean hasObservation(String string) {
        for (int i = 0; i < this.Observations.size(); ++i) {
            if (!string.equals(this.Observations.get(i).getTraitID())) continue;
            return true;
        }
        return false;
    }

    private void savePerk(ByteBuffer byteBuffer, PerkFactory.Perk perk) throws IOException {
        GameWindow.WriteStringUTF(byteBuffer, perk == null ? "" : perk.getId());
    }

    private PerkFactory.Perk loadPerk(ByteBuffer byteBuffer, int n) throws IOException {
        if (n >= 152) {
            String string = GameWindow.ReadStringUTF(byteBuffer);
            PerkFactory.Perk perk = PerkFactory.Perks.FromString(string);
            return perk == PerkFactory.Perks.MAX ? null : perk;
        }
        int n2 = byteBuffer.getInt();
        if (n2 < 0 || n2 >= PerkFactory.Perks.MAX.index()) {
            return null;
        }
        PerkFactory.Perk perk = PerkFactory.Perks.fromIndex(n2);
        return perk == PerkFactory.Perks.MAX ? null : perk;
    }

    public void load(ByteBuffer byteBuffer, int n, IsoGameCharacter isoGameCharacter) throws IOException {
        Object object;
        int n2;
        int n3;
        this.ID = byteBuffer.getInt();
        IsoWorld.instance.SurvivorDescriptors.put(this.ID, this);
        this.forename = GameWindow.ReadString(byteBuffer);
        this.surname = GameWindow.ReadString(byteBuffer);
        this.torso = GameWindow.ReadString(byteBuffer);
        this.bFemale = byteBuffer.getInt() == 1;
        this.Profession = GameWindow.ReadString(byteBuffer);
        this.doStats();
        if (IDCount < this.ID) {
            IDCount = this.ID;
        }
        this.extra.clear();
        if (byteBuffer.getInt() == 1) {
            n3 = byteBuffer.getInt();
            for (n2 = 0; n2 < n3; ++n2) {
                object = GameWindow.ReadString(byteBuffer);
                this.extra.add((String)object);
            }
        }
        n3 = byteBuffer.getInt();
        for (n2 = 0; n2 < n3; ++n2) {
            object = this.loadPerk(byteBuffer, n);
            int n4 = byteBuffer.getInt();
            if (object == null) continue;
            this.getXPBoostMap().put((PerkFactory.Perk)object, n4);
        }
        this.Instance = isoGameCharacter;
    }

    public void save(ByteBuffer byteBuffer) throws IOException {
        byteBuffer.putInt(this.ID);
        GameWindow.WriteString(byteBuffer, this.forename);
        GameWindow.WriteString(byteBuffer, this.surname);
        GameWindow.WriteString(byteBuffer, this.torso);
        byteBuffer.putInt(this.bFemale ? 1 : 0);
        GameWindow.WriteString(byteBuffer, this.Profession);
        if (!this.extra.isEmpty()) {
            byteBuffer.putInt(1);
            byteBuffer.putInt(this.extra.size());
            for (int i = 0; i < this.extra.size(); ++i) {
                String object = this.extra.get(i);
                GameWindow.WriteString(byteBuffer, object);
            }
        } else {
            byteBuffer.putInt(0);
        }
        byteBuffer.putInt(this.getXPBoostMap().size());
        for (Map.Entry<PerkFactory.Perk, Integer> entry : this.getXPBoostMap().entrySet()) {
            this.savePerk(byteBuffer, entry.getKey());
            byteBuffer.putInt(entry.getValue());
        }
    }

    public void loadCompact(ByteBuffer byteBuffer) {
        this.ID = -1;
        this.torso = GameWindow.ReadString(byteBuffer);
        this.bFemale = byteBuffer.get() == 1;
        this.extra.clear();
        if (byteBuffer.get() == 1) {
            int n = byteBuffer.get();
            for (int i = 0; i < n; ++i) {
                String string = GameWindow.ReadString(byteBuffer);
                this.extra.add(string);
            }
        }
    }

    public void saveCompact(ByteBuffer byteBuffer) throws UnsupportedEncodingException {
        GameWindow.WriteString(byteBuffer, this.torso);
        byteBuffer.put(this.bFemale ? (byte)1 : 0);
        if (!this.extra.isEmpty()) {
            byteBuffer.put((byte)1);
            byteBuffer.put((byte)this.extra.size());
            for (String string : this.extra) {
                GameWindow.WriteString(byteBuffer, string);
            }
        } else {
            byteBuffer.put((byte)0);
        }
    }

    public void addObservation(String string) {
        ObservationFactory.Observation observation = ObservationFactory.getObservation(string);
        if (observation == null) {
            return;
        }
        this.Observations.add(observation);
    }

    private void doStats() {
        this.bravery = Rand.Next(2) == 0 ? 10.0f : 0.0f;
        this.aggressiveness = Rand.Next(2) == 0 ? 10.0f : 0.0f;
        this.compassion = 10.0f - this.aggressiveness;
        this.loner = Rand.Next(2) == 0 ? 10.0f : 0.0f;
        this.temper = Rand.Next(2) == 0 ? 10.0f : 0.0f;
        this.friendliness = 10.0f - this.loner;
        this.favourindoors = Rand.Next(2) == 0 ? 10.0f : 0.0f;
        this.loyalty = Rand.Next(2) == 0 ? 10.0f : 0.0f;
    }

    public int getMetCount(SurvivorDesc survivorDesc) {
        if (this.MetCount.containsKey(survivorDesc.ID)) {
            return this.MetCount.get(survivorDesc.ID);
        }
        return 0;
    }

    public String getForename() {
        return this.forename;
    }

    public void setForename(String string) {
        this.forename = string;
    }

    public int getID() {
        return this.ID;
    }

    public void setID(int n) {
        this.ID = n;
    }

    public IsoGameCharacter getInstance() {
        return this.Instance;
    }

    public void setInstance(IsoGameCharacter isoGameCharacter) {
        this.Instance = isoGameCharacter;
    }

    public String getSurname() {
        return this.surname;
    }

    public void setSurname(String string) {
        this.surname = string;
    }

    public String getInventoryScript() {
        return this.InventoryScript;
    }

    public void setInventoryScript(String string) {
        this.InventoryScript = string;
    }

    public String getTorso() {
        return this.torso;
    }

    public void setTorso(String string) {
        this.torso = string;
    }

    public HashMap<Integer, Integer> getMetCount() {
        return this.MetCount;
    }

    public float getBravery() {
        return this.bravery;
    }

    public void setBravery(float f) {
        this.bravery = f;
    }

    public float getLoner() {
        return this.loner;
    }

    public void setLoner(float f) {
        this.loner = f;
    }

    public float getAggressiveness() {
        return this.aggressiveness;
    }

    public void setAggressiveness(float f) {
        this.aggressiveness = f;
    }

    public float getCompassion() {
        return this.compassion;
    }

    public void setCompassion(float f) {
        this.compassion = f;
    }

    public float getTemper() {
        return this.temper;
    }

    public void setTemper(float f) {
        this.temper = f;
    }

    public float getFriendliness() {
        return this.friendliness;
    }

    public void setFriendliness(float f) {
        this.friendliness = f;
    }

    public float getFavourindoors() {
        return this.favourindoors;
    }

    public void setFavourindoors(float f) {
        this.favourindoors = f;
    }

    public float getLoyalty() {
        return this.loyalty;
    }

    public void setLoyalty(float f) {
        this.loyalty = f;
    }

    public String getProfession() {
        return this.Profession;
    }

    public void setProfession(String string) {
        this.Profession = string;
    }

    public boolean isAggressive() {
        for (ObservationFactory.Observation observation : this.Observations) {
            if (!"Aggressive".equals(observation.getTraitID())) continue;
            return true;
        }
        return false;
    }

    public ArrayList<ObservationFactory.Observation> getObservations() {
        return this.Observations;
    }

    public boolean isFriendly() {
        for (ObservationFactory.Observation observation : this.Observations) {
            if (!"Friendly".equals(observation.getTraitID())) continue;
            return true;
        }
        return false;
    }

    public SurvivorFactory.SurvivorType getType() {
        return this.type;
    }

    public void setType(SurvivorFactory.SurvivorType survivorType) {
        this.type = survivorType;
    }

    public void setFemale(boolean bl) {
        this.bFemale = bl;
    }

    public ArrayList<String> getExtras() {
        return this.extra;
    }

    public ArrayList<ImmutableColor> getCommonHairColor() {
        return HairCommonColors;
    }

    public static void addTrouserColor(ColorInfo colorInfo) {
        TrouserCommonColors.add(colorInfo.toColor());
    }

    public static void addHairColor(ColorInfo colorInfo) {
        HairCommonColors.add(colorInfo.toImmutableColor());
    }

    public static Color getRandomSkinColor() {
        if (OutfitRNG.Next(3) == 0) {
            return new Color(OutfitRNG.Next(0.5f, 0.6f), OutfitRNG.Next(0.3f, 0.4f), OutfitRNG.Next(0.15f, 0.23f));
        }
        return new Color(OutfitRNG.Next(0.9f, 1.0f), OutfitRNG.Next(0.75f, 0.88f), OutfitRNG.Next(0.45f, 0.58f));
    }
}

