/*
 * Decompiled with CFR 0.152.
 */
package zombie.characters;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import zombie.core.math.PZMath;

public final class Stats {
    public float Anger = 0.0f;
    public float boredom = 0.0f;
    public float endurance = 1.0f;
    public boolean enduranceRecharging = false;
    public float endurancelast = 1.0f;
    public float endurancedanger = 0.25f;
    public float endurancewarn = 0.5f;
    public float fatigue = 0.0f;
    public float fitness = 1.0f;
    public float hunger = 0.0f;
    public float idleboredom = 0.0f;
    public float morale = 0.5f;
    public float stress = 0.0f;
    public float Fear = 0.0f;
    public float Panic = 0.0f;
    public float Sanity = 1.0f;
    public float Sickness = 0.0f;
    public float Boredom = 0.0f;
    public float Pain = 0.0f;
    public float Drunkenness = 0.0f;
    public int NumVisibleZombies = 0;
    public int LastNumVisibleZombies = 0;
    public boolean Tripping = false;
    public float TrippingRotAngle = 0.0f;
    public float thirst = 0.0f;
    public int NumChasingZombies = 0;
    public int LastVeryCloseZombies = 0;
    public static int NumCloseZombies = 0;
    public int LastNumChasingZombies = 0;
    public float stressFromCigarettes = 0.0f;
    public float ChasingZombiesDanger;
    public int MusicZombiesVisible = 0;
    public int MusicZombiesTargeting = 0;

    public int getNumVisibleZombies() {
        return this.NumVisibleZombies;
    }

    public int getNumChasingZombies() {
        return this.LastNumChasingZombies;
    }

    public int getNumVeryCloseZombies() {
        return this.LastVeryCloseZombies;
    }

    public void load(DataInputStream dataInputStream) throws IOException {
        this.Anger = dataInputStream.readFloat();
        this.boredom = dataInputStream.readFloat();
        this.endurance = dataInputStream.readFloat();
        this.fatigue = dataInputStream.readFloat();
        this.fitness = dataInputStream.readFloat();
        this.hunger = dataInputStream.readFloat();
        this.morale = dataInputStream.readFloat();
        this.stress = dataInputStream.readFloat();
        this.Fear = dataInputStream.readFloat();
        this.Panic = dataInputStream.readFloat();
        this.Sanity = dataInputStream.readFloat();
        this.Sickness = dataInputStream.readFloat();
        this.Boredom = dataInputStream.readFloat();
        this.Pain = dataInputStream.readFloat();
        this.Drunkenness = dataInputStream.readFloat();
        this.thirst = dataInputStream.readFloat();
    }

    public void load(ByteBuffer byteBuffer, int n) throws IOException {
        this.Anger = byteBuffer.getFloat();
        this.boredom = byteBuffer.getFloat();
        this.endurance = byteBuffer.getFloat();
        this.fatigue = byteBuffer.getFloat();
        this.fitness = byteBuffer.getFloat();
        this.hunger = byteBuffer.getFloat();
        this.morale = byteBuffer.getFloat();
        this.stress = byteBuffer.getFloat();
        this.Fear = byteBuffer.getFloat();
        this.Panic = byteBuffer.getFloat();
        this.Sanity = byteBuffer.getFloat();
        this.Sickness = byteBuffer.getFloat();
        this.Boredom = byteBuffer.getFloat();
        this.Pain = byteBuffer.getFloat();
        this.Drunkenness = byteBuffer.getFloat();
        this.thirst = byteBuffer.getFloat();
        if (n >= 97) {
            this.stressFromCigarettes = byteBuffer.getFloat();
        }
    }

    public void save(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeFloat(this.Anger);
        dataOutputStream.writeFloat(this.boredom);
        dataOutputStream.writeFloat(this.endurance);
        dataOutputStream.writeFloat(this.fatigue);
        dataOutputStream.writeFloat(this.fitness);
        dataOutputStream.writeFloat(this.hunger);
        dataOutputStream.writeFloat(this.morale);
        dataOutputStream.writeFloat(this.stress);
        dataOutputStream.writeFloat(this.Fear);
        dataOutputStream.writeFloat(this.Panic);
        dataOutputStream.writeFloat(this.Sanity);
        dataOutputStream.writeFloat(this.Sickness);
        dataOutputStream.writeFloat(this.Boredom);
        dataOutputStream.writeFloat(this.Pain);
        dataOutputStream.writeFloat(this.Drunkenness);
        dataOutputStream.writeFloat(this.thirst);
    }

    public void save(ByteBuffer byteBuffer) throws IOException {
        byteBuffer.putFloat(this.Anger);
        byteBuffer.putFloat(this.boredom);
        byteBuffer.putFloat(this.endurance);
        byteBuffer.putFloat(this.fatigue);
        byteBuffer.putFloat(this.fitness);
        byteBuffer.putFloat(this.hunger);
        byteBuffer.putFloat(this.morale);
        byteBuffer.putFloat(this.stress);
        byteBuffer.putFloat(this.Fear);
        byteBuffer.putFloat(this.Panic);
        byteBuffer.putFloat(this.Sanity);
        byteBuffer.putFloat(this.Sickness);
        byteBuffer.putFloat(this.Boredom);
        byteBuffer.putFloat(this.Pain);
        byteBuffer.putFloat(this.Drunkenness);
        byteBuffer.putFloat(this.thirst);
        byteBuffer.putFloat(this.stressFromCigarettes);
    }

    public float getAnger() {
        return this.Anger;
    }

    public void setAnger(float f) {
        this.Anger = f;
    }

    public float getBoredom() {
        return this.boredom;
    }

    public void setBoredom(float f) {
        this.boredom = f;
    }

    public float getEndurance() {
        return this.endurance;
    }

    public void setEndurance(float f) {
        this.endurance = f;
    }

    public float getEndurancelast() {
        return this.endurancelast;
    }

    public void setEndurancelast(float f) {
        this.endurancelast = f;
    }

    public float getEndurancedanger() {
        return this.endurancedanger;
    }

    public void setEndurancedanger(float f) {
        this.endurancedanger = f;
    }

    public float getEndurancewarn() {
        return this.endurancewarn;
    }

    public void setEndurancewarn(float f) {
        this.endurancewarn = f;
    }

    public boolean getEnduranceRecharging() {
        return this.enduranceRecharging;
    }

    public float getFatigue() {
        return this.fatigue;
    }

    public void setFatigue(float f) {
        this.fatigue = f;
    }

    public float getFitness() {
        return this.fitness;
    }

    public void setFitness(float f) {
        this.fitness = f;
    }

    public float getHunger() {
        return this.hunger;
    }

    public void setHunger(float f) {
        this.hunger = f;
    }

    public float getIdleboredom() {
        return this.idleboredom;
    }

    public void setIdleboredom(float f) {
        this.idleboredom = f;
    }

    public float getMorale() {
        return this.morale;
    }

    public void setMorale(float f) {
        this.morale = f;
    }

    public float getStress() {
        return this.stress + this.getStressFromCigarettes();
    }

    public void setStress(float f) {
        this.stress = f;
    }

    public float getStressFromCigarettes() {
        return this.stressFromCigarettes;
    }

    public void setStressFromCigarettes(float f) {
        this.stressFromCigarettes = PZMath.clamp(f, 0.0f, this.getMaxStressFromCigarettes());
    }

    public float getMaxStressFromCigarettes() {
        return 0.51f;
    }

    public float getFear() {
        return this.Fear;
    }

    public void setFear(float f) {
        this.Fear = f;
    }

    public float getPanic() {
        return this.Panic;
    }

    public void setPanic(float f) {
        this.Panic = f;
    }

    public float getSanity() {
        return this.Sanity;
    }

    public void setSanity(float f) {
        this.Sanity = f;
    }

    public float getSickness() {
        return this.Sickness;
    }

    public void setSickness(float f) {
        this.Sickness = f;
    }

    public float getPain() {
        return this.Pain;
    }

    public void setPain(float f) {
        this.Pain = f;
    }

    public float getDrunkenness() {
        return this.Drunkenness;
    }

    public void setDrunkenness(float f) {
        this.Drunkenness = f;
    }

    public int getVisibleZombies() {
        return this.NumVisibleZombies;
    }

    public void setNumVisibleZombies(int n) {
        this.NumVisibleZombies = n;
    }

    public boolean isTripping() {
        return this.Tripping;
    }

    public void setTripping(boolean bl) {
        this.Tripping = bl;
    }

    public float getTrippingRotAngle() {
        return this.TrippingRotAngle;
    }

    public void setTrippingRotAngle(float f) {
        this.TrippingRotAngle = f;
    }

    public float getThirst() {
        return this.thirst;
    }

    public void setThirst(float f) {
        this.thirst = f;
    }

    public void resetStats() {
        this.Anger = 0.0f;
        this.boredom = 0.0f;
        this.fatigue = 0.0f;
        this.hunger = 0.0f;
        this.idleboredom = 0.0f;
        this.morale = 0.5f;
        this.stress = 0.0f;
        this.Fear = 0.0f;
        this.Panic = 0.0f;
        this.Sanity = 1.0f;
        this.Sickness = 0.0f;
        this.Boredom = 0.0f;
        this.Pain = 0.0f;
        this.Drunkenness = 0.0f;
        this.thirst = 0.0f;
    }
}

