/*
 * Decompiled with CFR 0.152.
 */
package zombie.characters;

import java.lang.constant.Constable;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import zombie.GameTime;
import zombie.characters.IsoGameCharacter;
import zombie.characters.IsoPlayer;
import zombie.characters.Safety;
import zombie.core.Core;
import zombie.core.logger.LoggerManager;
import zombie.core.math.PZMath;
import zombie.debug.DebugLog;
import zombie.debug.LogSeverity;
import zombie.iso.areas.NonPvpZone;
import zombie.network.GameServer;
import zombie.network.ServerOptions;
import zombie.util.Type;

public class SafetySystemManager {
    private static final LinkedHashMap<String, Float> playerCooldown = new LinkedHashMap();
    private static final LinkedHashMap<String, Boolean> playerSafety = new LinkedHashMap();
    private static final LinkedHashMap<String, Long> playerDelay = new LinkedHashMap();
    private static final long safetyDelay = 1500L;

    private static void updateTimers(Safety safety) {
        float f = GameTime.instance.getRealworldSecondsSinceLastUpdate();
        if (safety.getToggle() > 0.0f) {
            safety.setToggle(safety.getToggle() - f);
            if (safety.getToggle() <= 0.0f) {
                safety.setToggle(0.0f);
                if (!safety.isLast()) {
                    safety.setEnabled(!safety.isEnabled());
                }
            }
        } else if (safety.getCooldown() > 0.0f) {
            safety.setCooldown(safety.getCooldown() - f);
        } else {
            safety.setCooldown(0.0f);
        }
    }

    private static void updateNonPvpZone(IsoPlayer isoPlayer, boolean bl) {
        if (bl && !isoPlayer.networkAI.wasNonPvpZone) {
            SafetySystemManager.storeSafety(isoPlayer);
            GameServer.sendChangeSafety(isoPlayer.getSafety());
        } else if (!bl && isoPlayer.networkAI.wasNonPvpZone) {
            SafetySystemManager.restoreSafety(isoPlayer);
            GameServer.sendChangeSafety(isoPlayer.getSafety());
        }
        isoPlayer.networkAI.wasNonPvpZone = bl;
    }

    static void update(IsoPlayer isoPlayer) {
        boolean bl;
        boolean bl2 = bl = NonPvpZone.getNonPvpZone(PZMath.fastfloor(isoPlayer.getX()), PZMath.fastfloor(isoPlayer.getY())) != null;
        if (!bl) {
            SafetySystemManager.updateTimers(isoPlayer.getSafety());
        }
        if (GameServer.bServer) {
            SafetySystemManager.updateNonPvpZone(isoPlayer, bl);
        }
    }

    public static void clear() {
        playerCooldown.clear();
        playerSafety.clear();
        playerDelay.clear();
    }

    public static void clearSafety(IsoPlayer isoPlayer) {
        if (isoPlayer != null) {
            Safety safety = isoPlayer.getSafety();
            LoggerManager.getLogger("pvp").write(String.format("user \"%s\" clear safety %s", isoPlayer.getUsername(), safety.getDescription()), "INFO");
            playerCooldown.remove(isoPlayer.getUsername());
            playerSafety.remove(isoPlayer.getUsername());
            playerDelay.remove(isoPlayer.getUsername());
        } else if (Core.bDebug) {
            DebugLog.Combat.debugln("ClearSafety: player not found");
        }
    }

    public static void storeSafety(IsoPlayer isoPlayer) {
        try {
            if (isoPlayer != null && isoPlayer.isAlive()) {
                Iterator<Map.Entry<String, Constable>> iterator;
                Safety safety = isoPlayer.getSafety();
                LoggerManager.getLogger("pvp").write(String.format("user \"%s\" store safety %s", isoPlayer.getUsername(), safety.getDescription()), "INFO");
                playerSafety.put(isoPlayer.getUsername(), safety.isEnabled());
                playerCooldown.put(isoPlayer.getUsername(), Float.valueOf(safety.getCooldown()));
                playerDelay.put(isoPlayer.getUsername(), System.currentTimeMillis());
                if (playerCooldown.size() > ServerOptions.instance.MaxPlayers.getValue() * 1000 && (iterator = playerCooldown.entrySet().iterator()).hasNext()) {
                    iterator.next();
                    iterator.remove();
                }
                if (playerSafety.size() > ServerOptions.instance.MaxPlayers.getValue() * 1000 && (iterator = playerSafety.entrySet().iterator()).hasNext()) {
                    iterator.next();
                    iterator.remove();
                }
                if (playerDelay.size() > ServerOptions.instance.MaxPlayers.getValue() * 1000 && (iterator = playerDelay.entrySet().iterator()).hasNext()) {
                    iterator.next();
                    iterator.remove();
                }
            } else if (Core.bDebug) {
                DebugLog.Combat.debugln("StoreSafety: player not found");
            }
        }
        catch (Exception exception) {
            DebugLog.Multiplayer.printException(exception, "StoreSafety failed", LogSeverity.Error);
        }
    }

    public static void restoreSafety(IsoPlayer isoPlayer) {
        try {
            if (isoPlayer != null) {
                Safety safety = isoPlayer.getSafety();
                if (playerSafety.containsKey(isoPlayer.getUsername())) {
                    safety.setEnabled((Boolean)playerSafety.remove(isoPlayer.getUsername()));
                }
                if (playerCooldown.containsKey(isoPlayer.getUsername())) {
                    safety.setCooldown(((Float)playerCooldown.remove(isoPlayer.getUsername())).floatValue());
                }
                playerDelay.put(isoPlayer.getUsername(), System.currentTimeMillis());
                LoggerManager.getLogger("pvp").write(String.format("user \"%s\" restore safety %s", isoPlayer.getUsername(), safety.getDescription()), "INFO");
            } else if (Core.bDebug) {
                DebugLog.Combat.debugln("RestoreSafety: player not found");
            }
        }
        catch (Exception exception) {
            DebugLog.Multiplayer.printException(exception, "RestoreSafety failed", LogSeverity.Error);
        }
    }

    public static void updateOptions() {
        block3: {
            boolean bl;
            block2: {
                boolean bl2 = ServerOptions.instance.PVP.getValue();
                bl = ServerOptions.instance.SafetySystem.getValue();
                if (bl2) break block2;
                SafetySystemManager.clear();
                for (IsoPlayer isoPlayer : GameServer.IDToPlayerMap.values()) {
                    if (isoPlayer == null) continue;
                    isoPlayer.getSafety().setEnabled(true);
                    isoPlayer.getSafety().setLast(false);
                    isoPlayer.getSafety().setCooldown(0.0f);
                    isoPlayer.getSafety().setToggle(0.0f);
                    GameServer.sendChangeSafety(isoPlayer.getSafety());
                }
                break block3;
            }
            if (bl) break block3;
            SafetySystemManager.clear();
            for (IsoPlayer isoPlayer : GameServer.IDToPlayerMap.values()) {
                if (isoPlayer == null) continue;
                isoPlayer.getSafety().setEnabled(false);
                isoPlayer.getSafety().setLast(false);
                isoPlayer.getSafety().setCooldown(0.0f);
                isoPlayer.getSafety().setToggle(0.0f);
                GameServer.sendChangeSafety(isoPlayer.getSafety());
            }
        }
    }

    public static boolean checkUpdateDelay(IsoGameCharacter isoGameCharacter, IsoGameCharacter isoGameCharacter2) {
        boolean bl = false;
        IsoPlayer isoPlayer = Type.tryCastTo(isoGameCharacter, IsoPlayer.class);
        IsoPlayer isoPlayer2 = Type.tryCastTo(isoGameCharacter2, IsoPlayer.class);
        if (isoPlayer != null && isoPlayer2 != null) {
            boolean bl2;
            long l;
            long l2 = System.currentTimeMillis();
            if (playerDelay.containsKey(isoPlayer.getUsername())) {
                l = l2 - playerDelay.getOrDefault(isoPlayer.getUsername(), 0L);
                bl = bl2 = l < 1500L;
                if (!bl2) {
                    playerDelay.remove(isoPlayer.getUsername());
                }
            }
            if (playerDelay.containsKey(isoPlayer2.getUsername())) {
                l = l2 - playerDelay.getOrDefault(isoPlayer2.getUsername(), 0L);
                boolean bl3 = bl2 = l < 1500L;
                if (!bl) {
                    bl = bl2;
                }
                if (!bl2) {
                    playerDelay.remove(isoPlayer2.getUsername());
                }
            }
        }
        return bl;
    }
}

