/*
 * Decompiled with CFR 0.152.
 */
package zombie.characters;

import zombie.ai.states.ZombieTurnAlerted;
import zombie.characters.IsoPlayer;
import zombie.characters.IsoZombie;
import zombie.core.skinnedmodel.advancedanimation.IAnimatable;
import zombie.network.GameClient;
import zombie.network.GameServer;

public class NetworkZombieVariables {
    public static int getInt(IsoZombie isoZombie, short s) {
        switch (s) {
            case 0: {
                return (int)(isoZombie.Health * 1000.0f);
            }
            case 2: {
                return (int)(isoZombie.speedMod * 1000.0f);
            }
            case 1: {
                if (isoZombie.target == null) {
                    return -1;
                }
                return ((IAnimatable)((Object)isoZombie.target)).getOnlineID();
            }
            case 3: {
                return (int)isoZombie.TimeSinceSeenFlesh;
            }
            case 4: {
                Float f = (Float)isoZombie.getStateMachineParams(ZombieTurnAlerted.instance()).get(ZombieTurnAlerted.PARAM_TARGET_ANGLE);
                if (f == null) {
                    return 0;
                }
                return f.intValue();
            }
        }
        return 0;
    }

    public static void setInt(IsoZombie isoZombie, short s, int n) {
        switch (s) {
            case 0: {
                isoZombie.Health = (float)n / 1000.0f;
                break;
            }
            case 2: {
                isoZombie.speedMod = (float)n / 1000.0f;
                break;
            }
            case 1: {
                if (n == -1) {
                    isoZombie.setTargetSeenTime(0.0f);
                    isoZombie.target = null;
                    break;
                }
                IsoPlayer isoPlayer = GameClient.IDToPlayerMap.get((short)n);
                if (GameServer.bServer) {
                    isoPlayer = GameServer.IDToPlayerMap.get((short)n);
                }
                if (isoPlayer == isoZombie.target) break;
                isoZombie.setTargetSeenTime(0.0f);
                isoZombie.target = isoPlayer;
                break;
            }
            case 3: {
                isoZombie.TimeSinceSeenFlesh = n;
                break;
            }
            case 4: {
                isoZombie.getStateMachineParams(ZombieTurnAlerted.instance()).put(ZombieTurnAlerted.PARAM_TARGET_ANGLE, Float.valueOf(n));
                break;
            }
        }
    }

    public static short getBooleanVariables(IsoZombie isoZombie) {
        short s = 0;
        s = (short)(s | (isoZombie.isFakeDead() ? 1 : 0));
        s = (short)(s | (isoZombie.bLunger ? 2 : 0));
        s = (short)(s | (isoZombie.bRunning ? 4 : 0));
        s = (short)(s | (isoZombie.isCrawling() ? 8 : 0));
        s = (short)(s | (isoZombie.isSitAgainstWall() ? 16 : 0));
        s = (short)(s | (isoZombie.isReanimatedPlayer() ? 32 : 0));
        s = (short)(s | (isoZombie.isOnFire() ? 64 : 0));
        s = (short)(s | (isoZombie.isUseless() ? 128 : 0));
        s = (short)(s | (isoZombie.isOnFloor() ? 256 : 0));
        return s;
    }

    public static void setBooleanVariables(IsoZombie isoZombie, short s) {
        isoZombie.setFakeDead((s & 1) != 0);
        isoZombie.bLunger = (s & 2) != 0;
        isoZombie.bRunning = (s & 4) != 0;
        isoZombie.setCrawler((s & 8) != 0);
        isoZombie.setSitAgainstWall((s & 0x10) != 0);
        isoZombie.setReanimatedPlayer((s & 0x20) != 0);
        if ((s & 0x40) != 0) {
            isoZombie.SetOnFire();
        } else {
            isoZombie.StopBurning();
        }
        isoZombie.setUseless((s & 0x80) != 0);
        if (isoZombie.isReanimatedPlayer()) {
            isoZombie.setOnFloor((s & 0x100) != 0);
        }
    }

    public static class VariablesInt {
        public static final short health = 0;
        public static final short target = 1;
        public static final short speedMod = 2;
        public static final short timeSinceSeenFlesh = 3;
        public static final short smParamTargetAngle = 4;
        public static final short MAX = 5;
    }
}

