/*
 * Decompiled with CFR 0.152.
 */
package zombie.characters;

import zombie.GameTime;
import zombie.ai.states.ClimbOverFenceState;
import zombie.ai.states.ClimbOverWallState;
import zombie.ai.states.ClimbThroughWindowState;
import zombie.ai.states.LungeState;
import zombie.ai.states.PathFindState;
import zombie.ai.states.ThumpState;
import zombie.ai.states.WalkTowardState;
import zombie.characters.IsoGameCharacter;
import zombie.characters.IsoPlayer;
import zombie.characters.IsoZombie;
import zombie.characters.NetworkCharacter;
import zombie.characters.NetworkCharacterAI;
import zombie.characters.NetworkTeleport;
import zombie.characters.NetworkZombieMind;
import zombie.characters.NetworkZombieVariables;
import zombie.core.Core;
import zombie.core.math.PZMath;
import zombie.core.utils.UpdateTimer;
import zombie.debug.DebugLog;
import zombie.debug.DebugOptions;
import zombie.debug.DebugType;
import zombie.iso.IsoDirections;
import zombie.iso.IsoObject;
import zombie.iso.IsoUtils;
import zombie.iso.Vector2;
import zombie.network.GameClient;
import zombie.network.GameServer;
import zombie.network.NetworkVariables;
import zombie.network.packets.ZombiePacket;
import zombie.popman.NetworkZombieSimulator;
import zombie.vehicles.PathFindBehavior2;

public class NetworkZombieAI
extends NetworkCharacterAI {
    private final UpdateTimer timer;
    private final PathFindBehavior2 pfb2;
    public final IsoZombie zombie;
    public boolean usePathFind = false;
    public float targetX = 0.0f;
    public float targetY = 0.0f;
    public int targetZ = 0;
    public boolean isClimbing;
    private byte flags;
    private byte direction;
    public final NetworkZombieMind mindSync;
    public short reanimatedBodyID;
    public boolean DebugInterfaceActive = false;

    public NetworkZombieAI(IsoGameCharacter isoGameCharacter) {
        super(isoGameCharacter);
        this.zombie = (IsoZombie)isoGameCharacter;
        this.isClimbing = false;
        this.flags = 0;
        this.pfb2 = this.zombie.getPathFindBehavior2();
        this.timer = new UpdateTimer();
        this.mindSync = new NetworkZombieMind(this.zombie);
        isoGameCharacter.ulBeatenVehicle.Reset(400L);
        this.reanimatedBodyID = (short)-1;
    }

    @Override
    public void reset() {
        super.reset();
        this.usePathFind = true;
        this.targetX = this.zombie.getX();
        this.targetY = this.zombie.getY();
        this.targetZ = (byte)this.zombie.getZ();
        this.isClimbing = false;
        this.flags = 0;
        this.zombie.getHitDir().set(0.0f, 0.0f);
        this.reanimatedBodyID = (short)-1;
    }

    public void extraUpdate() {
        NetworkZombieSimulator.getInstance().addExtraUpdate(this.zombie);
    }

    private long getUpdateTime() {
        return this.timer.getTime();
    }

    public void setUpdateTimer(float f) {
        this.timer.reset(PZMath.clamp((int)f, 200, 3800));
    }

    private void setUsingExtrapolation(ZombiePacket zombiePacket, int n) {
        if (this.zombie.isMoving()) {
            Vector2 vector22 = this.zombie.dir.ToVector();
            this.zombie.networkCharacter.checkReset(n);
            NetworkCharacter.Transform transform = this.zombie.networkCharacter.predict(500, n, this.zombie.x, this.zombie.y, vector22.x, vector22.y);
            zombiePacket.x = transform.position.x;
            zombiePacket.y = transform.position.y;
            zombiePacket.z = (byte)this.zombie.z;
            zombiePacket.moveType = NetworkVariables.PredictionTypes.Moving;
            this.setUpdateTimer(300.0f);
        } else {
            zombiePacket.x = this.zombie.x;
            zombiePacket.y = this.zombie.y;
            zombiePacket.z = (byte)this.zombie.z;
            zombiePacket.moveType = NetworkVariables.PredictionTypes.Static;
            this.setUpdateTimer(2280.0f);
        }
    }

    private void setUsingThump(ZombiePacket zombiePacket) {
        zombiePacket.x = ((IsoObject)this.zombie.getThumpTarget()).getX();
        zombiePacket.y = ((IsoObject)this.zombie.getThumpTarget()).getY();
        zombiePacket.z = (byte)((IsoObject)this.zombie.getThumpTarget()).getZ();
        zombiePacket.moveType = NetworkVariables.PredictionTypes.Thump;
        this.setUpdateTimer(2280.0f);
    }

    private void setUsingClimb(ZombiePacket zombiePacket) {
        zombiePacket.x = this.zombie.getTarget().getX();
        zombiePacket.y = this.zombie.getTarget().getY();
        zombiePacket.z = (byte)this.zombie.getTarget().getZ();
        zombiePacket.moveType = NetworkVariables.PredictionTypes.Climb;
        this.setUpdateTimer(2280.0f);
    }

    private void setUsingLungeState(ZombiePacket zombiePacket, long l) {
        if (this.zombie.target == null) {
            this.setUsingExtrapolation(zombiePacket, (int)l);
            return;
        }
        float f = IsoUtils.DistanceTo(this.zombie.target.x, this.zombie.target.y, this.zombie.x, this.zombie.y);
        if (f > 5.0f) {
            zombiePacket.x = (this.zombie.x + this.zombie.target.x) * 0.5f;
            zombiePacket.y = (this.zombie.y + this.zombie.target.y) * 0.5f;
            zombiePacket.z = (byte)this.zombie.target.z;
            float f2 = f * 0.5f / 5.0E-4f * this.zombie.speedMod;
            zombiePacket.moveType = NetworkVariables.PredictionTypes.LungeHalf;
            this.setUpdateTimer(f2 * 0.6f);
        } else {
            zombiePacket.x = this.zombie.target.x;
            zombiePacket.y = this.zombie.target.y;
            zombiePacket.z = (byte)this.zombie.target.z;
            float f3 = f / 5.0E-4f * this.zombie.speedMod;
            zombiePacket.moveType = NetworkVariables.PredictionTypes.Lunge;
            this.setUpdateTimer(f3 * 0.6f);
        }
    }

    private void setUsingWalkTowardState(ZombiePacket zombiePacket) {
        float f;
        if (this.zombie.getPath2() == null) {
            float f2 = this.pfb2.getPathLength();
            if (f2 > 5.0f) {
                zombiePacket.x = (this.zombie.x + this.pfb2.getTargetX()) * 0.5f;
                zombiePacket.y = (this.zombie.y + this.pfb2.getTargetY()) * 0.5f;
                zombiePacket.z = (byte)this.pfb2.getTargetZ();
                f = f2 * 0.5f / 5.0E-4f * this.zombie.speedMod;
                zombiePacket.moveType = NetworkVariables.PredictionTypes.WalkHalf;
            } else {
                zombiePacket.x = this.pfb2.getTargetX();
                zombiePacket.y = this.pfb2.getTargetY();
                zombiePacket.z = (byte)this.pfb2.getTargetZ();
                f = f2 / 5.0E-4f * this.zombie.speedMod;
                zombiePacket.moveType = NetworkVariables.PredictionTypes.Walk;
            }
        } else {
            zombiePacket.x = this.pfb2.pathNextX;
            zombiePacket.y = this.pfb2.pathNextY;
            zombiePacket.z = (byte)this.zombie.z;
            f = IsoUtils.DistanceTo(this.zombie.x, this.zombie.y, this.pfb2.pathNextX, this.pfb2.pathNextY) / 5.0E-4f * this.zombie.speedMod;
            zombiePacket.moveType = NetworkVariables.PredictionTypes.Walk;
        }
        this.setUpdateTimer(f * 0.6f);
    }

    private void setUsingPathFindState(ZombiePacket zombiePacket) {
        zombiePacket.x = this.pfb2.pathNextX;
        zombiePacket.y = this.pfb2.pathNextY;
        zombiePacket.z = (byte)this.zombie.z;
        float f = IsoUtils.DistanceTo(this.zombie.x, this.zombie.y, this.pfb2.pathNextX, this.pfb2.pathNextY) / 5.0E-4f * this.zombie.speedMod;
        zombiePacket.moveType = NetworkVariables.PredictionTypes.PathFind;
        this.setUpdateTimer(f * 0.6f);
    }

    public void set(ZombiePacket zombiePacket) {
        int n = (int)(GameTime.getServerTime() / 1000000L);
        zombiePacket.booleanVariables = NetworkZombieVariables.getBooleanVariables(this.zombie);
        zombiePacket.realHealth = (short)NetworkZombieVariables.getInt(this.zombie, (short)0);
        zombiePacket.target = (short)NetworkZombieVariables.getInt(this.zombie, (short)1);
        zombiePacket.speedMod = (short)NetworkZombieVariables.getInt(this.zombie, (short)2);
        zombiePacket.timeSinceSeenFlesh = NetworkZombieVariables.getInt(this.zombie, (short)3);
        zombiePacket.smParamTargetAngle = NetworkZombieVariables.getInt(this.zombie, (short)4);
        zombiePacket.walkType = NetworkVariables.WalkType.fromString(this.zombie.getVariableString("zombieWalkType"));
        zombiePacket.realX = this.zombie.x;
        zombiePacket.realY = this.zombie.y;
        zombiePacket.realZ = (byte)this.zombie.z;
        zombiePacket.realState = this.zombie.realState = NetworkVariables.ZombieState.fromString(this.zombie.getAdvancedAnimator().getCurrentStateName());
        zombiePacket.reanimatedBodyID = this.reanimatedBodyID;
        if (this.zombie.getThumpTarget() != null && this.zombie.getCurrentState() == ThumpState.instance()) {
            this.setUsingThump(zombiePacket);
        } else if (!(this.zombie.getTarget() == null || this.isClimbing || this.zombie.getCurrentState() != ClimbOverFenceState.instance() && this.zombie.getCurrentState() != ClimbOverWallState.instance() && this.zombie.getCurrentState() != ClimbThroughWindowState.instance())) {
            this.setUsingClimb(zombiePacket);
            this.isClimbing = true;
        } else if (this.zombie.getCurrentState() == WalkTowardState.instance()) {
            this.setUsingWalkTowardState(zombiePacket);
        } else if (this.zombie.getCurrentState() == LungeState.instance()) {
            this.setUsingLungeState(zombiePacket, n);
        } else if (this.zombie.getCurrentState() == PathFindState.instance() && this.zombie.isMoving()) {
            this.setUsingPathFindState(zombiePacket);
        } else {
            this.setUsingExtrapolation(zombiePacket, n);
        }
        Vector2 vector22 = this.zombie.dir.ToVector();
        this.zombie.networkCharacter.updateExtrapolationPoint(n, this.zombie.x, this.zombie.y, vector22.x, vector22.y);
        if (DebugOptions.instance.MultiplayerLogPrediction.getValue() && Core.bDebug) {
            DebugLog.log(DebugType.Multiplayer, NetworkZombieAI.getPredictionDebug(this.zombie, zombiePacket, n, this.getUpdateTime()));
        }
    }

    public void parse(ZombiePacket zombiePacket) {
        int n = (int)(GameTime.getServerTime() / 1000000L);
        if (DebugOptions.instance.MultiplayerLogPrediction.getValue()) {
            this.zombie.getNetworkCharacterAI().addTeleportData(n, NetworkZombieAI.getPredictionDebug(this.zombie, zombiePacket, n, n));
        }
        if (this.usePathFind) {
            this.pfb2.pathToLocationF(zombiePacket.x, zombiePacket.y, zombiePacket.z);
            this.pfb2.walkingOnTheSpot.reset(this.zombie.x, this.zombie.y);
        }
        this.targetX = zombiePacket.x;
        this.targetY = zombiePacket.y;
        this.targetZ = zombiePacket.z;
        this.predictionType = zombiePacket.moveType;
        NetworkZombieVariables.setInt(this.zombie, (short)1, zombiePacket.target);
        NetworkZombieVariables.setInt(this.zombie, (short)3, zombiePacket.timeSinceSeenFlesh);
        if (this.zombie.isRemoteZombie()) {
            NetworkZombieVariables.setInt(this.zombie, (short)2, zombiePacket.speedMod);
            NetworkZombieVariables.setInt(this.zombie, (short)4, zombiePacket.smParamTargetAngle);
            NetworkZombieVariables.setBooleanVariables(this.zombie, zombiePacket.booleanVariables);
            this.zombie.setWalkType(zombiePacket.walkType.toString());
            this.zombie.realState = zombiePacket.realState;
        }
        this.zombie.realx = zombiePacket.realX;
        this.zombie.realy = zombiePacket.realY;
        this.zombie.realz = zombiePacket.realZ;
        if ((IsoUtils.DistanceToSquared(this.zombie.x, this.zombie.y, this.zombie.realx, this.zombie.realy) > 9.0f || this.zombie.z != (float)this.zombie.realz) && (this.zombie.isRemoteZombie() || IsoPlayer.getInstance() != null && IsoUtils.DistanceToSquared(this.zombie.x, this.zombie.y, IsoPlayer.getInstance().x, IsoPlayer.getInstance().y) > 2.0f)) {
            NetworkTeleport.teleport(this.zombie, NetworkTeleport.Type.teleportation, this.zombie.realx, this.zombie.realy, this.zombie.realz, 1.0f);
        }
    }

    public void preupdate() {
        if (GameClient.bClient) {
            if (this.zombie.target != null) {
                this.zombie.setTargetSeenTime(this.zombie.getTargetSeenTime() + GameTime.getInstance().getRealworldSecondsSinceLastUpdate());
            }
        } else if (GameServer.bServer) {
            byte by;
            byte by2 = (byte)((this.zombie.getVariableBoolean("bMoving") ? 1 : 0) | (this.zombie.getVariableBoolean("bPathfind") ? 2 : 0));
            if (this.flags != by2) {
                this.flags = by2;
                this.extraUpdate();
            }
            if (this.direction != (by = (byte)IsoDirections.fromAngleActual(this.zombie.getForwardDirection()).index())) {
                this.direction = by;
                this.extraUpdate();
            }
        }
    }

    public static String getPredictionDebug(IsoGameCharacter isoGameCharacter, ZombiePacket zombiePacket, int n, long l) {
        return String.format("Prediction Z_%d [type=%s, distance=%f], time [current=%d, next=%d], states [current=%s, previous=%s]", zombiePacket.id, zombiePacket.moveType.toString(), Float.valueOf(IsoUtils.DistanceTo(isoGameCharacter.x, isoGameCharacter.y, zombiePacket.x, zombiePacket.y)), n, l - (long)n, isoGameCharacter.getCurrentStateName(), isoGameCharacter.getPreviousStateName());
    }
}

