/*
 * Decompiled with CFR 0.152.
 */
package zombie.characters;

import zombie.Lua.LuaManager;
import zombie.characters.IsoGameCharacter;
import zombie.characters.IsoZombie;
import zombie.core.Core;
import zombie.debug.DebugOptions;
import zombie.iso.IsoDirections;
import zombie.iso.IsoGridSquare;
import zombie.iso.IsoUtils;
import zombie.iso.IsoWorld;
import zombie.network.MPStatisticClient;
import zombie.network.NetworkVariables;
import zombie.network.packets.PlayerPacket;

public class NetworkTeleport {
    public static boolean enable = true;
    public static boolean enableInstantTeleport = true;
    private Type teleportType = Type.none;
    private IsoGameCharacter character = null;
    private boolean setNewPos = false;
    private float nx = 0.0f;
    private float ny = 0.0f;
    private byte nz = 0;
    public float ndirection;
    private float tx = 0.0f;
    private float ty = 0.0f;
    private byte tz = 0;
    private long startTime;
    private long duration;

    public NetworkTeleport(IsoGameCharacter isoGameCharacter, Type type, float f, float f2, byte by, float f3) {
        this.character = isoGameCharacter;
        this.setNewPos = false;
        this.nx = f;
        this.ny = f2;
        this.nz = by;
        this.teleportType = type;
        this.startTime = System.currentTimeMillis();
        this.duration = (long)(1000.0 * (double)f3);
        isoGameCharacter.setTeleport(this);
        if (Core.bDebug && isoGameCharacter.getNetworkCharacterAI() != null && DebugOptions.instance.MultiplayerShowTeleport.getValue()) {
            isoGameCharacter.getNetworkCharacterAI().setTeleportDebug(new NetworkTeleportDebug(isoGameCharacter.getOnlineID(), isoGameCharacter.x, isoGameCharacter.y, isoGameCharacter.z, f, f2, by, isoGameCharacter.getNetworkCharacterAI().predictionType));
        }
    }

    public void process(int n) {
        if (!enable) {
            this.character.setX(this.nx);
            this.character.setY(this.ny);
            this.character.setZ(this.nz);
            this.character.ensureOnTile();
            this.character.setTeleport(null);
            this.character = null;
            return;
        }
        boolean bl = this.character.getCurrentSquare().isCanSee(n);
        float f = Math.min(1.0f, (float)(System.currentTimeMillis() - this.startTime) / (float)this.duration);
        switch (this.teleportType) {
            case disappearing: {
                if (f < 0.99f) {
                    this.character.setAlpha(n, Math.min(this.character.getAlpha(n), 1.0f - f));
                    break;
                }
                this.stop(n);
                break;
            }
            case teleportation: {
                if (f < 0.5f) {
                    if (this.character.isoPlayer != null && (this.character.isoPlayer == null || !this.character.isoPlayer.spottedByPlayer)) break;
                    this.character.setAlpha(n, Math.min(this.character.getAlpha(n), 1.0f - f * 2.0f));
                    break;
                }
                if (f < 0.99f) {
                    if (!this.setNewPos) {
                        this.setNewPos = true;
                        this.character.setX(this.nx);
                        this.character.setY(this.ny);
                        this.character.setZ(this.nz);
                        this.character.ensureOnTile();
                        this.character.getNetworkCharacterAI().resetSpeedLimiter();
                    }
                    if (this.character.isoPlayer != null && (this.character.isoPlayer == null || !this.character.isoPlayer.spottedByPlayer)) break;
                    this.character.setAlpha(n, Math.min(this.character.getTargetAlpha(n), (f - 0.5f) * 2.0f));
                    break;
                }
                this.stop(n);
                break;
            }
            case materialization: {
                if (f < 0.99f) {
                    this.character.setAlpha(n, Math.min(this.character.getTargetAlpha(n), f));
                    break;
                }
                this.stop(n);
            }
        }
    }

    public void stop(int n) {
        this.character.setTeleport(null);
        switch (this.teleportType) {
            case disappearing: {
                this.character.setAlpha(n, Math.min(this.character.getAlpha(n), 0.0f));
            }
        }
        this.character = null;
    }

    public static boolean teleport(IsoGameCharacter isoGameCharacter, Type type, float f, float f2, byte by, float f3) {
        if (!enable) {
            return false;
        }
        if (isoGameCharacter.getCurrentSquare() != null && enableInstantTeleport) {
            IsoGridSquare isoGridSquare;
            boolean bl = false;
            for (int i = 0; i < 4; ++i) {
                if (!isoGameCharacter.getCurrentSquare().isCanSee(i)) continue;
                bl = true;
                break;
            }
            if ((isoGridSquare = LuaManager.GlobalObject.getCell().getGridSquare((int)f, (int)f2, by)) != null) {
                for (int i = 0; i < 4; ++i) {
                    if (!isoGridSquare.isCanSee(i)) continue;
                    bl = true;
                    break;
                }
            }
            if (!bl) {
                isoGameCharacter.setX(f);
                isoGameCharacter.setY(f2);
                isoGameCharacter.setZ(by);
                isoGameCharacter.ensureOnTile();
                return false;
            }
        }
        if (!isoGameCharacter.isTeleporting()) {
            if (isoGameCharacter instanceof IsoZombie) {
                MPStatisticClient.getInstance().incrementZombiesTeleports();
            } else {
                MPStatisticClient.getInstance().incrementRemotePlayersTeleports();
            }
            new NetworkTeleport(isoGameCharacter, type, f, f2, by, f3);
            return true;
        }
        return false;
    }

    public static boolean teleport(IsoGameCharacter isoGameCharacter, PlayerPacket playerPacket, float f) {
        IsoGridSquare isoGridSquare;
        if (!enable) {
            return false;
        }
        if (LuaManager.GlobalObject.getCell().getGridSquare((int)playerPacket.x, (int)playerPacket.y, playerPacket.z) == null) {
            isoGameCharacter.setX(playerPacket.x);
            isoGameCharacter.setY(playerPacket.y);
            isoGameCharacter.setZ(playerPacket.z);
            isoGameCharacter.realx = playerPacket.realx;
            isoGameCharacter.realy = playerPacket.realy;
            isoGameCharacter.realz = playerPacket.realz;
            isoGameCharacter.realdir = IsoDirections.fromIndex(playerPacket.realdir);
            isoGameCharacter.ensureOnTile();
        }
        if (isoGameCharacter.getCurrentSquare() != null && enableInstantTeleport) {
            boolean bl = false;
            for (int i = 0; i < 4; ++i) {
                if (!isoGameCharacter.getCurrentSquare().isCanSee(i)) continue;
                bl = true;
                break;
            }
            if ((isoGridSquare = LuaManager.GlobalObject.getCell().getGridSquare((int)playerPacket.x, (int)playerPacket.y, playerPacket.z)) != null) {
                for (int i = 0; i < 4; ++i) {
                    if (!isoGridSquare.isCanSee(i)) continue;
                    bl = true;
                    break;
                }
            }
            if (!bl) {
                isoGameCharacter.setX(playerPacket.x);
                isoGameCharacter.setY(playerPacket.y);
                isoGameCharacter.setZ(playerPacket.z);
                isoGameCharacter.ensureOnTile();
                return false;
            }
        }
        if (!isoGameCharacter.isTeleporting()) {
            if (isoGameCharacter instanceof IsoZombie) {
                MPStatisticClient.getInstance().incrementZombiesTeleports();
            } else {
                MPStatisticClient.getInstance().incrementRemotePlayersTeleports();
            }
            IsoGridSquare isoGridSquare2 = IsoWorld.instance.CurrentCell.getGridSquare(isoGameCharacter.x, isoGameCharacter.y, isoGameCharacter.z);
            if (isoGridSquare2 == null) {
                isoGridSquare = IsoWorld.instance.CurrentCell.getGridSquare(playerPacket.realx, playerPacket.realy, (double)playerPacket.realz);
                isoGameCharacter.setAlphaAndTarget(0.0f);
                isoGameCharacter.setX(playerPacket.realx);
                isoGameCharacter.setY(playerPacket.realy);
                isoGameCharacter.setZ(playerPacket.realz);
                isoGameCharacter.ensureOnTile();
                float f2 = 0.5f;
                NetworkTeleport networkTeleport = new NetworkTeleport(isoGameCharacter, Type.materialization, f2 * playerPacket.x + (1.0f - f2) * playerPacket.realx, f2 * playerPacket.y + (1.0f - f2) * playerPacket.realy, (byte)(f2 * (float)playerPacket.z + (1.0f - f2) * (float)playerPacket.realz), f);
                networkTeleport.ndirection = playerPacket.direction;
                networkTeleport.tx = playerPacket.x;
                networkTeleport.ty = playerPacket.y;
                networkTeleport.tz = playerPacket.z;
                return true;
            }
            float f3 = 0.5f;
            NetworkTeleport networkTeleport = new NetworkTeleport(isoGameCharacter, Type.teleportation, f3 * playerPacket.x + (1.0f - f3) * playerPacket.realx, f3 * playerPacket.y + (1.0f - f3) * playerPacket.realy, (byte)(f3 * (float)playerPacket.z + (1.0f - f3) * (float)playerPacket.realz), f);
            networkTeleport.ndirection = playerPacket.direction;
            networkTeleport.tx = playerPacket.x;
            networkTeleport.ty = playerPacket.y;
            networkTeleport.tz = playerPacket.z;
            return true;
        }
        return false;
    }

    public static void update(IsoGameCharacter isoGameCharacter, PlayerPacket playerPacket) {
        if (isoGameCharacter.isTeleporting()) {
            NetworkTeleport networkTeleport = isoGameCharacter.getTeleport();
            if (networkTeleport.teleportType != Type.teleportation) {
                return;
            }
            float f = Math.min(1.0f, (float)(System.currentTimeMillis() - networkTeleport.startTime) / (float)networkTeleport.duration);
            if (f < 0.5f) {
                float f2 = 0.5f;
                networkTeleport.nx = f2 * playerPacket.x + (1.0f - f2) * playerPacket.realx;
                networkTeleport.ny = f2 * playerPacket.y + (1.0f - f2) * playerPacket.realy;
                networkTeleport.nz = (byte)(f2 * (float)playerPacket.z + (1.0f - f2) * (float)playerPacket.realz);
            }
            networkTeleport.ndirection = playerPacket.direction;
            networkTeleport.tx = playerPacket.x;
            networkTeleport.ty = playerPacket.y;
            networkTeleport.tz = playerPacket.z;
            return;
        }
    }

    public static enum Type {
        none,
        disappearing,
        teleportation,
        materialization;

    }

    public static class NetworkTeleportDebug {
        short id;
        float nx;
        float ny;
        float nz;
        float lx;
        float ly;
        float lz;
        NetworkVariables.PredictionTypes type;

        public NetworkTeleportDebug(short s, float f, float f2, float f3, float f4, float f5, float f6, NetworkVariables.PredictionTypes predictionTypes) {
            this.id = s;
            this.nx = f4;
            this.ny = f5;
            this.nz = f6;
            this.lx = f;
            this.ly = f2;
            this.lz = f3;
            this.type = predictionTypes;
        }

        public float getDistance() {
            return IsoUtils.DistanceTo(this.lx, this.ly, this.lz, this.nx, this.ny, this.nz);
        }
    }
}

