/*
 * Decompiled with CFR 0.152.
 */
package zombie.characters;

import zombie.ai.states.FishingState;
import zombie.characters.IsoPlayer;
import zombie.core.Core;
import zombie.iso.Vector2;
import zombie.network.GameClient;

public class NetworkPlayerVariables {
    static Vector2 deferredMovement = new Vector2();

    public static int getBooleanVariables(IsoPlayer isoPlayer) {
        int n = 0;
        n |= isoPlayer.isSneaking() ? 1 : 0;
        n |= isoPlayer.isOnFire() ? 2 : 0;
        n |= isoPlayer.isAsleep() ? 4 : 0;
        n |= FishingState.instance().equals(isoPlayer.getCurrentState()) ? 8 : 0;
        n |= isoPlayer.isRunning() ? 16 : 0;
        n |= isoPlayer.isSprinting() ? 32 : 0;
        n |= isoPlayer.isAiming() ? 64 : 0;
        n |= isoPlayer.isCharging ? 128 : 0;
        n |= isoPlayer.isChargingLT ? 256 : 0;
        n |= isoPlayer.bDoShove ? 512 : 0;
        isoPlayer.getDeferredMovement(deferredMovement);
        n |= deferredMovement.getLength() > 0.0f ? 1024 : 0;
        n |= isoPlayer.isOnFloor() ? 2048 : 0;
        n |= isoPlayer.isGhostMode() ? 4096 : 0;
        n |= Core.bDebug ? 8192 : 0;
        n |= isoPlayer.isNoClip() ? 16384 : 0;
        if (GameClient.bClient && GameClient.connection.accessLevel != 1 || !isoPlayer.isAccessLevel("None")) {
            n |= 0x8000;
        }
        n |= isoPlayer.isSitOnGround() ? 131072 : 0;
        return n |= "fall".equals(isoPlayer.getVariableString("ClimbFenceOutcome")) ? 262144 : 0;
    }

    public static void setBooleanVariables(IsoPlayer isoPlayer, int n) {
        boolean bl;
        isoPlayer.setSneaking((n & 1) != 0);
        if ((n & 2) != 0) {
            isoPlayer.SetOnFire();
        } else {
            isoPlayer.StopBurning();
        }
        isoPlayer.setAsleep((n & 4) != 0);
        boolean bl2 = bl = (n & 8) != 0;
        if (FishingState.instance().equals(isoPlayer.getCurrentState()) && !bl) {
            isoPlayer.SetVariable("FishingFinished", "true");
        }
        isoPlayer.setRunning((n & 0x10) != 0);
        isoPlayer.setSprinting((n & 0x20) != 0);
        isoPlayer.setIsAiming((n & 0x40) != 0);
        isoPlayer.isCharging = (n & 0x80) != 0;
        boolean bl3 = isoPlayer.isChargingLT = (n & 0x100) != 0;
        if (!isoPlayer.bDoShove && (n & 0x200) != 0) {
            isoPlayer.setDoShove((n & 0x200) != 0);
        }
        isoPlayer.networkAI.moving = (n & 0x400) != 0;
        isoPlayer.setOnFloor((n & 0x800) != 0);
        isoPlayer.setSitOnGround((n & 0x20000) != 0);
        isoPlayer.networkAI.climbFenceOutcomeFall = (n & 0x40000) != 0;
    }
}

