/*
 * Decompiled with CFR 0.152.
 */
package zombie.characters;

import java.util.ArrayList;
import java.util.LinkedList;
import zombie.GameTime;
import zombie.SystemDisabler;
import zombie.ai.states.CollideWithWallState;
import zombie.characters.IsoGameCharacter;
import zombie.characters.IsoPlayer;
import zombie.characters.NetworkCharacter;
import zombie.characters.NetworkCharacterAI;
import zombie.characters.NetworkPlayerVariables;
import zombie.core.Rand;
import zombie.core.math.PZMath;
import zombie.core.utils.UpdateTimer;
import zombie.debug.DebugLog;
import zombie.debug.DebugOptions;
import zombie.input.GameKeyboard;
import zombie.iso.IsoDirections;
import zombie.iso.Vector2;
import zombie.network.GameClient;
import zombie.network.GameServer;
import zombie.network.NetworkVariables;
import zombie.network.packets.EventPacket;
import zombie.network.packets.PlayerPacket;
import zombie.scripting.ScriptManager;
import zombie.scripting.objects.Recipe;
import zombie.vehicles.BaseVehicle;
import zombie.vehicles.PathFindBehavior2;
import zombie.vehicles.PolygonalMap2;
import zombie.vehicles.VehicleManager;

public class NetworkPlayerAI
extends NetworkCharacterAI {
    public final LinkedList<EventPacket> events = new LinkedList();
    IsoPlayer player;
    private PathFindBehavior2 pfb2 = null;
    private final UpdateTimer timer = new UpdateTimer();
    private byte lastDirection = 0;
    private boolean needUpdate = false;
    private boolean blockUpdate = false;
    public boolean usePathFind = false;
    public float collidePointX;
    public float collidePointY;
    public float targetX = 0.0f;
    public float targetY = 0.0f;
    public int targetZ = 0;
    public boolean needToMovingUsingPathFinder = false;
    public boolean forcePathFinder = false;
    public Vector2 direction = new Vector2();
    public Vector2 distance = new Vector2();
    public boolean moving = false;
    public byte footstepSoundRadius = 0;
    public int lastBooleanVariables = 0;
    public float lastForwardDirection = 0.0f;
    public float lastPlayerMoveDirLen = 0.0f;
    private boolean pressedMovement = false;
    private boolean pressedCancelAction = false;
    public boolean climbFenceOutcomeFall = false;
    private long accessLevelTimestamp = 0L;
    boolean wasNonPvpZone = false;
    private Vector2 tempo = new Vector2();
    private static final int predictInterval = 1000;

    public NetworkPlayerAI(IsoGameCharacter isoGameCharacter) {
        super(isoGameCharacter);
        this.player = (IsoPlayer)isoGameCharacter;
        this.pfb2 = this.player.getPathFindBehavior2();
        isoGameCharacter.ulBeatenVehicle.Reset(200L);
        this.collidePointX = -1.0f;
        this.collidePointY = -1.0f;
        this.wasNonPvpZone = false;
    }

    public void needToUpdate() {
        this.needUpdate = true;
    }

    public void setBlockUpdate(boolean bl) {
        this.blockUpdate = bl;
    }

    public boolean isNeedToUpdate() {
        int n = NetworkPlayerVariables.getBooleanVariables(this.player);
        byte by = (byte)(this.player.playerMoveDir.getDirection() * 10.0f);
        if ((this.timer.check() || n != this.lastBooleanVariables || this.lastDirection != by) && !this.blockUpdate || this.needUpdate) {
            this.lastDirection = by;
            this.needUpdate = false;
            return true;
        }
        return false;
    }

    public void setUpdateTimer(float f) {
        this.timer.reset(PZMath.clamp((int)f, 200, 3800));
    }

    private void setUsingCollide(PlayerPacket playerPacket, int n) {
        if (SystemDisabler.useNetworkCharacter) {
            this.player.networkCharacter.checkResetPlayer(n);
        }
        playerPacket.x = this.player.getCurrentSquare().getX();
        playerPacket.y = this.player.getCurrentSquare().getY();
        playerPacket.z = (byte)this.player.getCurrentSquare().getZ();
        playerPacket.usePathFinder = false;
        playerPacket.moveType = NetworkVariables.PredictionTypes.Thump;
    }

    private void setUsingExtrapolation(PlayerPacket playerPacket, int n, int n2) {
        Object object;
        Vector2 vector22 = this.player.dir.ToVector();
        if (SystemDisabler.useNetworkCharacter) {
            this.player.networkCharacter.checkResetPlayer(n);
        }
        if (!this.player.isPlayerMoving()) {
            playerPacket.x = this.player.x;
            playerPacket.y = this.player.y;
            playerPacket.z = (byte)this.player.z;
            playerPacket.usePathFinder = false;
            playerPacket.moveType = NetworkVariables.PredictionTypes.Static;
            return;
        }
        Vector2 vector23 = this.tempo;
        if (SystemDisabler.useNetworkCharacter) {
            object = this.player.networkCharacter.predict(n2, n, this.player.x, this.player.y, vector22.x, vector22.y);
            vector23.x = ((NetworkCharacter.Transform)object).position.x;
            vector23.y = ((NetworkCharacter.Transform)object).position.y;
        } else {
            this.player.getDeferredMovement(vector23);
            vector23.x = this.player.x + vector23.x * 0.03f * (float)n2;
            vector23.y = this.player.y + vector23.y * 0.03f * (float)n2;
        }
        if (this.player.z == this.pfb2.getTargetZ() && !PolygonalMap2.instance.lineClearCollide(this.player.x, this.player.y, vector23.x, vector23.y, (int)this.player.z, null)) {
            playerPacket.x = vector23.x;
            playerPacket.y = vector23.y;
            playerPacket.z = (byte)this.pfb2.getTargetZ();
        } else {
            object = PolygonalMap2.instance.getCollidepoint(this.player.x, this.player.y, vector23.x, vector23.y, (int)this.player.z, null, 2);
            playerPacket.collidePointX = ((Vector2)object).x;
            playerPacket.collidePointY = ((Vector2)object).y;
            playerPacket.x = ((Vector2)object).x + (this.player.dir == IsoDirections.N || this.player.dir == IsoDirections.S ? 0.0f : (this.player.dir.index() >= IsoDirections.NW.index() && this.player.dir.index() <= IsoDirections.SW.index() ? -1.0f : 1.0f));
            playerPacket.y = ((Vector2)object).y + (this.player.dir == IsoDirections.W || this.player.dir == IsoDirections.E ? 0.0f : (this.player.dir.index() >= IsoDirections.SW.index() && this.player.dir.index() <= IsoDirections.SE.index() ? 1.0f : -1.0f));
            playerPacket.z = (byte)this.player.z;
        }
        playerPacket.usePathFinder = false;
        playerPacket.moveType = NetworkVariables.PredictionTypes.Moving;
    }

    private void setUsingPathFindState(PlayerPacket playerPacket, int n) {
        if (SystemDisabler.useNetworkCharacter) {
            this.player.networkCharacter.checkResetPlayer(n);
        }
        playerPacket.x = this.pfb2.pathNextX;
        playerPacket.y = this.pfb2.pathNextY;
        playerPacket.z = (byte)this.player.z;
        playerPacket.usePathFinder = true;
        playerPacket.moveType = NetworkVariables.PredictionTypes.PathFind;
    }

    public boolean set(PlayerPacket playerPacket) {
        int n = (int)(GameTime.getServerTime() / 1000000L);
        playerPacket.realx = this.player.x;
        playerPacket.realy = this.player.y;
        playerPacket.realz = (byte)this.player.z;
        playerPacket.realdir = (byte)this.player.dir.index();
        playerPacket.realt = n;
        if (this.player.vehicle == null) {
            playerPacket.VehicleID = (short)-1;
            playerPacket.VehicleSeat = (short)-1;
        } else {
            playerPacket.VehicleID = this.player.vehicle.VehicleID;
            playerPacket.VehicleSeat = (short)this.player.vehicle.getSeat(this.player);
        }
        boolean bl = this.timer.check();
        playerPacket.collidePointX = -1.0f;
        playerPacket.collidePointY = -1.0f;
        if (bl) {
            this.setUpdateTimer(600.0f);
        }
        if (this.player.getCurrentState() == CollideWithWallState.instance()) {
            this.setUsingCollide(playerPacket, n);
        } else if (this.pfb2.isMovingUsingPathFind()) {
            this.setUsingPathFindState(playerPacket, n);
        } else {
            this.setUsingExtrapolation(playerPacket, n, 1000);
        }
        boolean bl2 = (double)this.player.playerMoveDir.getLength() < 0.01 && this.lastPlayerMoveDirLen > 0.01f;
        this.lastPlayerMoveDirLen = this.player.playerMoveDir.getLength();
        playerPacket.booleanVariables = NetworkPlayerVariables.getBooleanVariables(this.player);
        boolean bl3 = this.lastBooleanVariables != playerPacket.booleanVariables;
        this.lastBooleanVariables = playerPacket.booleanVariables;
        playerPacket.direction = this.player.getForwardDirection().getDirection();
        boolean bl4 = Math.abs(this.lastForwardDirection - playerPacket.direction) > 0.2f;
        this.lastForwardDirection = playerPacket.direction;
        playerPacket.footstepSoundRadius = this.footstepSoundRadius;
        return bl || bl3 || bl4 || this.player.isJustMoved() || bl2;
    }

    public void parse(PlayerPacket playerPacket) {
        if (this.player.isTeleporting()) {
            return;
        }
        this.targetX = PZMath.roundFromEdges(playerPacket.x);
        this.targetY = PZMath.roundFromEdges(playerPacket.y);
        this.targetZ = playerPacket.z;
        this.predictionType = playerPacket.moveType;
        this.needToMovingUsingPathFinder = playerPacket.usePathFinder;
        this.direction.set((float)Math.cos(playerPacket.direction), (float)Math.sin(playerPacket.direction));
        this.distance.set(playerPacket.x - this.player.x, playerPacket.y - this.player.y);
        if (this.usePathFind) {
            this.pfb2.pathToLocationF(playerPacket.x, playerPacket.y, playerPacket.z);
            this.pfb2.walkingOnTheSpot.reset(this.player.x, this.player.y);
        }
        BaseVehicle baseVehicle = VehicleManager.instance.getVehicleByID(playerPacket.VehicleID);
        NetworkPlayerVariables.setBooleanVariables(this.player, playerPacket.booleanVariables);
        this.player.setbSeenThisFrame(false);
        this.player.setbCouldBeSeenThisFrame(false);
        this.player.TimeSinceLastNetData = 0;
        this.player.ensureOnTile();
        this.player.realx = playerPacket.realx;
        this.player.realy = playerPacket.realy;
        this.player.realz = playerPacket.realz;
        this.player.realdir = IsoDirections.fromIndex(playerPacket.realdir);
        if (GameServer.bServer) {
            this.player.setForwardDirection(this.direction);
        }
        this.collidePointX = playerPacket.collidePointX;
        this.collidePointY = playerPacket.collidePointY;
        playerPacket.variables.apply(this.player);
        this.footstepSoundRadius = playerPacket.footstepSoundRadius;
        if (this.player.getVehicle() == null) {
            if (baseVehicle != null) {
                if (playerPacket.VehicleSeat < 0 || playerPacket.VehicleSeat >= baseVehicle.getMaxPassengers()) {
                    DebugLog.log(this.player.getUsername() + " invalid seat vehicle " + baseVehicle.VehicleID + " seat " + playerPacket.VehicleSeat);
                } else {
                    IsoGameCharacter isoGameCharacter = baseVehicle.getCharacter(playerPacket.VehicleSeat);
                    if (isoGameCharacter == null) {
                        if (GameServer.bDebug) {
                            DebugLog.log(this.player.getUsername() + " got in vehicle " + baseVehicle.VehicleID + " seat " + playerPacket.VehicleSeat);
                        }
                        baseVehicle.enterRSync(playerPacket.VehicleSeat, this.player, baseVehicle);
                    } else if (isoGameCharacter != this.player) {
                        DebugLog.log(this.player.getUsername() + " got in same seat as " + ((IsoPlayer)isoGameCharacter).getUsername());
                        this.player.sendObjectChange("exitVehicle");
                    }
                }
            }
        } else if (baseVehicle != null) {
            if (baseVehicle != this.player.getVehicle() || this.player.getVehicle().getSeat(this.player) == -1) {
                DebugLog.log(this.player.getUsername() + " vehicle/seat remote " + baseVehicle.VehicleID + "/" + playerPacket.VehicleSeat + " local " + this.player.getVehicle().VehicleID + "/" + this.player.getVehicle().getSeat(this.player));
                this.player.sendObjectChange("exitVehicle");
            } else {
                IsoGameCharacter isoGameCharacter = baseVehicle.getCharacter(playerPacket.VehicleSeat);
                if (isoGameCharacter == null) {
                    if (baseVehicle.getSeat(this.player) != playerPacket.VehicleSeat) {
                        baseVehicle.switchSeat(this.player, playerPacket.VehicleSeat);
                    }
                } else if (isoGameCharacter != this.player) {
                    DebugLog.log(this.player.getUsername() + " switched to same seat as " + ((IsoPlayer)isoGameCharacter).getUsername());
                    this.player.sendObjectChange("exitVehicle");
                }
            }
        } else {
            this.player.getVehicle().exitRSync(this.player);
            this.player.setVehicle(null);
        }
        this.setPressedMovement(false);
        this.setPressedCancelAction(false);
    }

    public boolean isPressedMovement() {
        return this.pressedMovement;
    }

    public void setPressedMovement(boolean bl) {
        boolean bl2 = !this.pressedMovement && bl;
        this.pressedMovement = bl;
        if (this.player.isLocal() && bl2) {
            GameClient.sendEvent(this.player, "Update");
        }
    }

    public boolean isPressedCancelAction() {
        return this.pressedCancelAction;
    }

    public void setPressedCancelAction(boolean bl) {
        boolean bl2 = !this.pressedCancelAction && bl;
        this.pressedCancelAction = bl;
        if (this.player.isLocal() && bl2) {
            GameClient.sendEvent(this.player, "Update");
        }
    }

    public void setCheckAccessLevelDelay(long l) {
        this.accessLevelTimestamp = System.currentTimeMillis() + l;
    }

    public boolean doCheckAccessLevel() {
        if (this.accessLevelTimestamp == 0L) {
            return true;
        }
        if (System.currentTimeMillis() > this.accessLevelTimestamp) {
            this.accessLevelTimestamp = 0L;
            return true;
        }
        return false;
    }

    public void update() {
        if (DebugOptions.instance.MultiplayerHotKey.getValue() && GameKeyboard.isKeyPressed(45) && GameKeyboard.isKeyDown(56)) {
            DebugLog.Multiplayer.noise("multiplayer hot key pressed");
            ArrayList<Recipe> arrayList = ScriptManager.instance.getAllRecipes();
            Recipe recipe = arrayList.get(Rand.Next(arrayList.size()));
            recipe.TimeToMake = Rand.Next(Short.MAX_VALUE);
            DebugLog.Multiplayer.debugln("Failed recipe \"%s\"", recipe.getOriginalname());
        }
    }

    public boolean isDismantleAllowed() {
        return true;
    }
}

