/*
 * Decompiled with CFR 0.152.
 */
package zombie.characters.Moodles;

import zombie.characters.BodyDamage.Thermoregulator;
import zombie.characters.IsoGameCharacter;
import zombie.characters.IsoPlayer;
import zombie.characters.Moodles.MoodleType;
import zombie.core.Color;
import zombie.iso.weather.Temperature;
import zombie.ui.MoodlesUI;

public final class Moodle {
    MoodleType Type;
    private int Level;
    IsoGameCharacter Parent;
    private int painTimer = 0;
    private Color chevronColor = Color.white;
    private boolean chevronIsUp = true;
    private int chevronCount = 0;
    private int chevronMax = 0;
    private static Color colorNeg = new Color(0.88235295f, 0.15686275f, 0.15686275f);
    private static Color colorPos = new Color(0.15686275f, 0.88235295f, 0.15686275f);
    private int cantSprintTimer = 300;

    public Moodle(MoodleType moodleType, IsoGameCharacter isoGameCharacter) {
        this(moodleType, isoGameCharacter, 0);
    }

    public Moodle(MoodleType moodleType, IsoGameCharacter isoGameCharacter, int n) {
        this.Parent = isoGameCharacter;
        this.Type = moodleType;
        this.Level = 0;
        this.chevronMax = n;
    }

    public int getChevronCount() {
        return this.chevronCount;
    }

    public boolean isChevronIsUp() {
        return this.chevronIsUp;
    }

    public Color getChevronColor() {
        return this.chevronColor;
    }

    public boolean chevronDifference(int n, boolean bl, Color color) {
        return n != this.chevronCount || bl != this.chevronIsUp || color != this.chevronColor;
    }

    public void setChevron(int n, boolean bl, Color color) {
        if (n < 0) {
            n = 0;
        }
        if (n > this.chevronMax) {
            n = this.chevronMax;
        }
        this.chevronCount = n;
        this.chevronIsUp = bl;
        this.chevronColor = color != null ? color : Color.white;
    }

    public int getLevel() {
        return this.Level;
    }

    public void SetLevel(int n) {
        if (n < 0) {
            n = 0;
        }
        if (n > 4) {
            n = 4;
        }
        this.Level = n;
    }

    public boolean Update() {
        int n;
        boolean bl = false;
        if (this.Parent.isDead()) {
            n = 0;
            if (this.Type != MoodleType.Dead && this.Type != MoodleType.Zombie) {
                n = 0;
                if (n != this.getLevel()) {
                    this.SetLevel(n);
                    bl = true;
                }
                return bl;
            }
        }
        if (this.Type == MoodleType.CantSprint) {
            n = 0;
            if (((IsoPlayer)this.Parent).MoodleCantSprint) {
                n = 1;
                --this.cantSprintTimer;
                MoodlesUI.getInstance().wiggle(MoodleType.CantSprint);
                if (this.cantSprintTimer == 0) {
                    n = 0;
                    this.cantSprintTimer = 300;
                    ((IsoPlayer)this.Parent).MoodleCantSprint = false;
                }
            }
            if (n != this.getLevel()) {
                this.SetLevel(n);
                bl = true;
            }
        }
        if (this.Type == MoodleType.Endurance) {
            n = 0;
            if (this.Parent.getBodyDamage().getHealth() != 0.0f) {
                n = this.Parent.getStats().endurance > 0.75f ? 0 : (this.Parent.getStats().endurance > 0.5f ? 1 : (this.Parent.getStats().endurance > 0.25f ? 2 : (this.Parent.getStats().endurance > 0.1f ? 3 : 4)));
            }
            if (n != this.getLevel()) {
                this.SetLevel(n);
                bl = true;
            }
        }
        if (this.Type == MoodleType.Angry) {
            n = 0;
            if (this.Parent.getStats().Anger > 0.75f) {
                n = 4;
            } else if (this.Parent.getStats().Anger > 0.5f) {
                n = 3;
            } else if (this.Parent.getStats().Anger > 0.25f) {
                n = 2;
            } else if (this.Parent.getStats().Anger > 0.1f) {
                n = 1;
            }
            if (n != this.getLevel()) {
                this.SetLevel(n);
                bl = true;
            }
        }
        if (this.Type == MoodleType.Tired) {
            n = 0;
            if (this.Parent.getBodyDamage().getHealth() != 0.0f) {
                if (this.Parent.getStats().fatigue > 0.6f) {
                    n = 1;
                }
                if (this.Parent.getStats().fatigue > 0.7f) {
                    n = 2;
                }
                if (this.Parent.getStats().fatigue > 0.8f) {
                    n = 3;
                }
                if (this.Parent.getStats().fatigue > 0.9f) {
                    n = 4;
                }
            }
            if (n != this.getLevel()) {
                this.SetLevel(n);
                bl = true;
            }
        }
        if (this.Type == MoodleType.Hungry) {
            n = 0;
            if (this.Parent.getBodyDamage().getHealth() != 0.0f) {
                if (this.Parent.getStats().hunger > 0.15f) {
                    n = 1;
                }
                if (this.Parent.getStats().hunger > 0.25f) {
                    n = 2;
                }
                if (this.Parent.getStats().hunger > 0.45f) {
                    n = 3;
                }
                if (this.Parent.getStats().hunger > 0.7f) {
                    n = 4;
                }
            }
            if (n != this.getLevel()) {
                this.SetLevel(n);
                bl = true;
            }
        }
        if (this.Type == MoodleType.Panic) {
            n = 0;
            if (this.Parent.getBodyDamage().getHealth() != 0.0f) {
                if (this.Parent.getStats().Panic > 6.0f) {
                    n = 1;
                }
                if (this.Parent.getStats().Panic > 30.0f) {
                    n = 2;
                }
                if (this.Parent.getStats().Panic > 65.0f) {
                    n = 3;
                }
                if (this.Parent.getStats().Panic > 80.0f) {
                    n = 4;
                }
            }
            if (n != this.getLevel()) {
                this.SetLevel(n);
                bl = true;
            }
        }
        if (this.Type == MoodleType.Sick) {
            n = 0;
            if (this.Parent.getBodyDamage().getHealth() != 0.0f) {
                this.Parent.getStats().Sickness = this.Parent.getBodyDamage().getApparentInfectionLevel() / 100.0f;
                if (this.Parent.getStats().Sickness > 0.25f) {
                    n = 1;
                }
                if (this.Parent.getStats().Sickness > 0.5f) {
                    n = 2;
                }
                if (this.Parent.getStats().Sickness > 0.75f) {
                    n = 3;
                }
                if (this.Parent.getStats().Sickness > 0.9f) {
                    n = 4;
                }
            }
            if (n != this.getLevel()) {
                this.SetLevel(n);
                bl = true;
            }
        }
        if (this.Type == MoodleType.Bored) {
            n = 0;
            if (this.Parent.getBodyDamage().getHealth() != 0.0f) {
                this.Parent.getStats().Boredom = this.Parent.getBodyDamage().getBoredomLevel() / 100.0f;
                if (this.Parent.getStats().Boredom > 0.25f) {
                    n = 1;
                }
                if (this.Parent.getStats().Boredom > 0.5f) {
                    n = 2;
                }
                if (this.Parent.getStats().Boredom > 0.75f) {
                    n = 3;
                }
                if (this.Parent.getStats().Boredom > 0.9f) {
                    n = 4;
                }
            }
            if (n != this.getLevel()) {
                this.SetLevel(n);
                bl = true;
            }
        }
        if (this.Type == MoodleType.Unhappy) {
            n = 0;
            if (this.Parent.getBodyDamage().getHealth() != 0.0f) {
                if (this.Parent.getBodyDamage().getUnhappynessLevel() > 20.0f) {
                    n = 1;
                }
                if (this.Parent.getBodyDamage().getUnhappynessLevel() > 45.0f) {
                    n = 2;
                }
                if (this.Parent.getBodyDamage().getUnhappynessLevel() > 60.0f) {
                    n = 3;
                }
                if (this.Parent.getBodyDamage().getUnhappynessLevel() > 80.0f) {
                    n = 4;
                }
            }
            if (n != this.getLevel()) {
                this.SetLevel(n);
                bl = true;
            }
        }
        if (this.Type == MoodleType.Stress) {
            n = 0;
            if (this.Parent.getStats().getStress() > 0.9f) {
                n = 4;
            } else if (this.Parent.getStats().getStress() > 0.75f) {
                n = 3;
            } else if (this.Parent.getStats().getStress() > 0.5f) {
                n = 2;
            } else if (this.Parent.getStats().getStress() > 0.25f) {
                n = 1;
            }
            if (n != this.getLevel()) {
                this.SetLevel(n);
                bl = true;
            }
        }
        if (this.Type == MoodleType.Thirst) {
            n = 0;
            if (this.Parent.getStats().thirst > 0.12f) {
                n = 1;
            }
            if (this.Parent.getStats().thirst > 0.25f) {
                n = 2;
            }
            if (this.Parent.getStats().thirst > 0.7f) {
                n = 3;
            }
            if (this.Parent.getStats().thirst > 0.84f) {
                n = 4;
            }
            if (n != this.getLevel()) {
                this.SetLevel(n);
                bl = true;
            }
        }
        if (this.Type == MoodleType.Bleeding) {
            n = 0;
            if (this.Parent.getBodyDamage().getHealth() != 0.0f && (n = this.Parent.getBodyDamage().getNumPartsBleeding()) > 4) {
                n = 4;
            }
            if (n != this.getLevel()) {
                this.SetLevel(n);
                bl = true;
            }
        }
        if (this.Type == MoodleType.Wet) {
            n = 0;
            if (this.Parent.getBodyDamage().getHealth() != 0.0f) {
                if (this.Parent.getBodyDamage().getWetness() > 15.0f) {
                    n = 1;
                }
                if (this.Parent.getBodyDamage().getWetness() > 40.0f) {
                    n = 2;
                }
                if (this.Parent.getBodyDamage().getWetness() > 70.0f) {
                    n = 3;
                }
                if (this.Parent.getBodyDamage().getWetness() > 90.0f) {
                    n = 4;
                }
            }
            if (n != this.getLevel()) {
                this.SetLevel(n);
                bl = true;
            }
        }
        if (this.Type == MoodleType.HasACold) {
            n = 0;
            if (this.Parent.getBodyDamage().getHealth() != 0.0f) {
                if (this.Parent.getBodyDamage().getColdStrength() > 20.0f) {
                    n = 1;
                }
                if (this.Parent.getBodyDamage().getColdStrength() > 40.0f) {
                    n = 2;
                }
                if (this.Parent.getBodyDamage().getColdStrength() > 60.0f) {
                    n = 3;
                }
                if (this.Parent.getBodyDamage().getColdStrength() > 75.0f) {
                    n = 4;
                }
            }
            if (n != this.getLevel()) {
                this.SetLevel(n);
                bl = true;
            }
        }
        if (this.Type == MoodleType.Injured) {
            n = 0;
            if (this.Parent.getBodyDamage().getHealth() != 0.0f) {
                if (100.0f - this.Parent.getBodyDamage().getHealth() > 20.0f) {
                    n = 1;
                }
                if (100.0f - this.Parent.getBodyDamage().getHealth() > 40.0f) {
                    n = 2;
                }
                if (100.0f - this.Parent.getBodyDamage().getHealth() > 60.0f) {
                    n = 3;
                }
                if (100.0f - this.Parent.getBodyDamage().getHealth() > 75.0f) {
                    n = 4;
                }
            }
            if (n != this.getLevel()) {
                this.SetLevel(n);
                bl = true;
            }
        }
        if (this.Type == MoodleType.Pain) {
            ++this.painTimer;
            if (this.painTimer < 120) {
                return false;
            }
            this.painTimer = 0;
            n = 0;
            if (this.Parent.getBodyDamage().getHealth() != 0.0f) {
                if (this.Parent.getStats().Pain > 10.0f) {
                    n = 1;
                }
                if (this.Parent.getStats().Pain > 20.0f) {
                    n = 2;
                }
                if (this.Parent.getStats().Pain > 50.0f) {
                    n = 3;
                }
                if (this.Parent.getStats().Pain > 75.0f) {
                    n = 4;
                }
            }
            if (n != this.getLevel()) {
                this.SetLevel(n);
                bl = true;
            }
        }
        if (this.Type == MoodleType.HeavyLoad) {
            n = 0;
            float f = this.Parent.getInventory().getCapacityWeight();
            float f2 = this.Parent.getMaxWeight();
            float f3 = f / f2;
            if (this.Parent.getBodyDamage().getHealth() != 0.0f) {
                if ((double)f3 >= 1.75) {
                    n = 4;
                } else if ((double)f3 >= 1.5) {
                    n = 3;
                } else if ((double)f3 >= 1.25) {
                    n = 2;
                } else if (f3 > 1.0f) {
                    n = 1;
                }
            }
            if (n != this.getLevel()) {
                this.SetLevel(n);
                bl = true;
            }
        }
        if (this.Type == MoodleType.Drunk) {
            n = 0;
            if (this.Parent.getBodyDamage().getHealth() != 0.0f) {
                if (this.Parent.getStats().Drunkenness > 10.0f) {
                    n = 1;
                }
                if (this.Parent.getStats().Drunkenness > 30.0f) {
                    n = 2;
                }
                if (this.Parent.getStats().Drunkenness > 50.0f) {
                    n = 3;
                }
                if (this.Parent.getStats().Drunkenness > 70.0f) {
                    n = 4;
                }
            }
            if (n != this.getLevel()) {
                this.SetLevel(n);
                bl = true;
            }
        }
        if (this.Type == MoodleType.Dead) {
            n = 0;
            if (this.Parent.isDead()) {
                n = 4;
                if (!this.Parent.getBodyDamage().IsFakeInfected() && this.Parent.getBodyDamage().getInfectionLevel() >= 0.001f) {
                    n = 0;
                }
            }
            if (n != this.getLevel()) {
                this.SetLevel(n);
                bl = true;
            }
        }
        if (this.Type == MoodleType.Zombie) {
            n = 0;
            if (this.Parent.isDead() && !this.Parent.getBodyDamage().IsFakeInfected() && this.Parent.getBodyDamage().getInfectionLevel() >= 0.001f) {
                n = 4;
            }
            if (n != this.getLevel()) {
                this.SetLevel(n);
                bl = true;
            }
        }
        if (this.Type == MoodleType.FoodEaten) {
            n = 0;
            if (this.Parent.getBodyDamage().getHealth() != 0.0f) {
                if (this.Parent.getBodyDamage().getHealthFromFoodTimer() > 0.0f) {
                    n = 1;
                }
                if (this.Parent.getBodyDamage().getHealthFromFoodTimer() > (float)this.Parent.getBodyDamage().getStandardHealthFromFoodTime()) {
                    n = 2;
                }
                if (this.Parent.getBodyDamage().getHealthFromFoodTimer() > (float)this.Parent.getBodyDamage().getStandardHealthFromFoodTime() * 2.0f) {
                    n = 3;
                }
                if (this.Parent.getBodyDamage().getHealthFromFoodTimer() > (float)this.Parent.getBodyDamage().getStandardHealthFromFoodTime() * 3.0f) {
                    n = 4;
                }
            }
            if (n != this.getLevel()) {
                this.SetLevel(n);
                bl = true;
            }
        }
        n = this.chevronCount;
        boolean bl2 = this.chevronIsUp;
        Color color = this.chevronColor;
        if ((this.Type == MoodleType.Hyperthermia || this.Type == MoodleType.Hypothermia) && this.Parent instanceof IsoPlayer) {
            if (this.Parent.getBodyDamage().getTemperature() < 36.5f || this.Parent.getBodyDamage().getTemperature() > 37.5f) {
                Thermoregulator thermoregulator = this.Parent.getBodyDamage().getThermoregulator();
                if (thermoregulator == null) {
                    n = 0;
                } else {
                    bl2 = thermoregulator.thermalChevronUp();
                    n = thermoregulator.thermalChevronCount();
                }
            } else {
                n = 0;
            }
        }
        if (this.Type == MoodleType.Hyperthermia) {
            int n2 = 0;
            if (n > 0) {
                Color color2 = color = bl2 ? colorNeg : colorPos;
            }
            if (this.Parent.getBodyDamage().getTemperature() != 0.0f) {
                if (this.Parent.getBodyDamage().getTemperature() > 37.5f) {
                    n2 = 1;
                }
                if (this.Parent.getBodyDamage().getTemperature() > 39.0f) {
                    n2 = 2;
                }
                if (this.Parent.getBodyDamage().getTemperature() > 40.0f) {
                    n2 = 3;
                }
                if (this.Parent.getBodyDamage().getTemperature() > 41.0f) {
                    n2 = 4;
                }
            }
            if (n2 != this.getLevel() || n2 > 0 && this.chevronDifference(n, bl2, color)) {
                this.SetLevel(n2);
                this.setChevron(n, bl2, color);
                bl = true;
            }
        }
        if (this.Type == MoodleType.Hypothermia) {
            int n3 = 0;
            if (n > 0) {
                Color color3 = color = bl2 ? colorPos : colorNeg;
            }
            if (this.Parent.getBodyDamage().getTemperature() != 0.0f) {
                if (this.Parent.getBodyDamage().getTemperature() < 36.5f && this.Parent.getStats().Drunkenness <= 30.0f) {
                    n3 = 1;
                }
                if (this.Parent.getBodyDamage().getTemperature() < 35.0f && this.Parent.getStats().Drunkenness <= 70.0f) {
                    n3 = 2;
                }
                if (this.Parent.getBodyDamage().getTemperature() < 30.0f) {
                    n3 = 3;
                }
                if (this.Parent.getBodyDamage().getTemperature() < 25.0f) {
                    n3 = 4;
                }
            }
            if (n3 != this.getLevel() || n3 > 0 && this.chevronDifference(n, bl2, color)) {
                this.SetLevel(n3);
                this.setChevron(n, bl2, color);
                bl = true;
            }
        }
        if (this.Type == MoodleType.Windchill) {
            int n4 = 0;
            if (this.Parent instanceof IsoPlayer) {
                float f = Temperature.getWindChillAmountForPlayer((IsoPlayer)this.Parent);
                if (f > 5.0f) {
                    n4 = 1;
                }
                if (f > 10.0f) {
                    n4 = 2;
                }
                if (f > 15.0f) {
                    n4 = 3;
                }
                if (f > 20.0f) {
                    n4 = 4;
                }
            }
            if (n4 != this.getLevel()) {
                this.SetLevel(n4);
                bl = true;
            }
        }
        return bl;
    }
}

