/*
 * Decompiled with CFR 0.152.
 */
package zombie.characters;

import fmod.fmod.BaseSoundListener;
import fmod.fmod.DummySoundListener;
import fmod.fmod.FMODSoundEmitter;
import fmod.fmod.SoundListener;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import org.joml.Vector3f;
import zombie.DebugFileWatcher;
import zombie.GameSounds;
import zombie.GameTime;
import zombie.GameWindow;
import zombie.Lua.LuaEventManager;
import zombie.PredicatedFileWatcher;
import zombie.SandboxOptions;
import zombie.SoundManager;
import zombie.SystemDisabler;
import zombie.ZomboidFileSystem;
import zombie.ZomboidGlobals;
import zombie.ai.State;
import zombie.ai.sadisticAIDirector.SleepingEvent;
import zombie.ai.states.BumpedState;
import zombie.ai.states.ClimbDownSheetRopeState;
import zombie.ai.states.ClimbOverFenceState;
import zombie.ai.states.ClimbOverWallState;
import zombie.ai.states.ClimbSheetRopeState;
import zombie.ai.states.ClimbThroughWindowState;
import zombie.ai.states.CloseWindowState;
import zombie.ai.states.CollideWithWallState;
import zombie.ai.states.FakeDeadZombieState;
import zombie.ai.states.FishingState;
import zombie.ai.states.FitnessState;
import zombie.ai.states.ForecastBeatenPlayerState;
import zombie.ai.states.IdleState;
import zombie.ai.states.OpenWindowState;
import zombie.ai.states.PathFindState;
import zombie.ai.states.PlayerActionsState;
import zombie.ai.states.PlayerAimState;
import zombie.ai.states.PlayerEmoteState;
import zombie.ai.states.PlayerExtState;
import zombie.ai.states.PlayerFallDownState;
import zombie.ai.states.PlayerFallingState;
import zombie.ai.states.PlayerGetUpState;
import zombie.ai.states.PlayerHitReactionPVPState;
import zombie.ai.states.PlayerHitReactionState;
import zombie.ai.states.PlayerKnockedDown;
import zombie.ai.states.PlayerOnGroundState;
import zombie.ai.states.PlayerSitOnGroundState;
import zombie.ai.states.PlayerStrafeState;
import zombie.ai.states.SmashWindowState;
import zombie.ai.states.StaggerBackState;
import zombie.ai.states.SwipeStatePlayer;
import zombie.audio.BaseSoundEmitter;
import zombie.audio.DummySoundEmitter;
import zombie.audio.FMODParameterList;
import zombie.audio.GameSound;
import zombie.audio.parameters.ParameterCharacterMovementSpeed;
import zombie.audio.parameters.ParameterEquippedBaggageContainer;
import zombie.audio.parameters.ParameterFootstepMaterial;
import zombie.audio.parameters.ParameterFootstepMaterial2;
import zombie.audio.parameters.ParameterLocalPlayer;
import zombie.audio.parameters.ParameterMeleeHitSurface;
import zombie.audio.parameters.ParameterPlayerHealth;
import zombie.audio.parameters.ParameterRoomType;
import zombie.audio.parameters.ParameterShoeType;
import zombie.audio.parameters.ParameterVehicleHitLocation;
import zombie.characters.AttachedItems.AttachedItems;
import zombie.characters.BodyDamage.BodyDamage;
import zombie.characters.BodyDamage.BodyPart;
import zombie.characters.BodyDamage.BodyPartType;
import zombie.characters.BodyDamage.Fitness;
import zombie.characters.BodyDamage.Nutrition;
import zombie.characters.CharacterTimedActions.BaseAction;
import zombie.characters.ClothingWetness;
import zombie.characters.HitReactionNetworkAI;
import zombie.characters.IsoGameCharacter;
import zombie.characters.IsoLivingCharacter;
import zombie.characters.IsoSurvivor;
import zombie.characters.IsoZombie;
import zombie.characters.MPDebugAI;
import zombie.characters.Moodles.MoodleType;
import zombie.characters.Moodles.Moodles;
import zombie.characters.NetworkCharacterAI;
import zombie.characters.NetworkPlayerAI;
import zombie.characters.NetworkTeleport;
import zombie.characters.SafetySystemManager;
import zombie.characters.SurvivorDesc;
import zombie.characters.TriggerXmlFile;
import zombie.characters.ZombiesZoneDefinition;
import zombie.characters.action.ActionContext;
import zombie.characters.action.ActionGroup;
import zombie.characters.skills.PerkFactory;
import zombie.commands.PlayerType;
import zombie.core.Color;
import zombie.core.Core;
import zombie.core.Rand;
import zombie.core.Translator;
import zombie.core.logger.ExceptionLogger;
import zombie.core.logger.LoggerManager;
import zombie.core.math.PZMath;
import zombie.core.network.ByteBufferWriter;
import zombie.core.opengl.Shader;
import zombie.core.profiling.PerformanceProfileProbe;
import zombie.core.raknet.UdpConnection;
import zombie.core.skinnedmodel.ModelManager;
import zombie.core.skinnedmodel.advancedanimation.AnimEvent;
import zombie.core.skinnedmodel.advancedanimation.AnimLayer;
import zombie.core.skinnedmodel.animation.AnimationPlayer;
import zombie.core.skinnedmodel.visual.BaseVisual;
import zombie.core.skinnedmodel.visual.HumanVisual;
import zombie.core.skinnedmodel.visual.IHumanVisual;
import zombie.core.skinnedmodel.visual.ItemVisuals;
import zombie.core.textures.ColorInfo;
import zombie.debug.DebugLog;
import zombie.debug.DebugOptions;
import zombie.debug.DebugType;
import zombie.gameStates.MainScreenState;
import zombie.input.GameKeyboard;
import zombie.input.JoypadManager;
import zombie.input.Mouse;
import zombie.inventory.InventoryItem;
import zombie.inventory.InventoryItemFactory;
import zombie.inventory.types.Clothing;
import zombie.inventory.types.DrainableComboItem;
import zombie.inventory.types.HandWeapon;
import zombie.inventory.types.WeaponType;
import zombie.iso.IsoCamera;
import zombie.iso.IsoCell;
import zombie.iso.IsoChunk;
import zombie.iso.IsoDirections;
import zombie.iso.IsoGridSquare;
import zombie.iso.IsoMetaGrid;
import zombie.iso.IsoMovingObject;
import zombie.iso.IsoObject;
import zombie.iso.IsoPhysicsObject;
import zombie.iso.IsoUtils;
import zombie.iso.IsoWorld;
import zombie.iso.SliceY;
import zombie.iso.SpriteDetails.IsoFlagType;
import zombie.iso.SpriteDetails.IsoObjectType;
import zombie.iso.Vector2;
import zombie.iso.areas.SafeHouse;
import zombie.iso.objects.IsoBarricade;
import zombie.iso.objects.IsoCurtain;
import zombie.iso.objects.IsoDeadBody;
import zombie.iso.objects.IsoDoor;
import zombie.iso.objects.IsoThumpable;
import zombie.iso.objects.IsoWindow;
import zombie.iso.objects.IsoWindowFrame;
import zombie.iso.weather.ClimateManager;
import zombie.network.BodyDamageSync;
import zombie.network.GameClient;
import zombie.network.GameServer;
import zombie.network.PassengerMap;
import zombie.network.ReplayManager;
import zombie.network.ServerLOS;
import zombie.network.ServerMap;
import zombie.network.ServerOptions;
import zombie.network.ServerWorldDatabase;
import zombie.network.packets.EventPacket;
import zombie.network.packets.hit.AttackVars;
import zombie.network.packets.hit.HitInfo;
import zombie.savefile.ClientPlayerDB;
import zombie.savefile.PlayerDB;
import zombie.scripting.objects.VehicleScript;
import zombie.ui.TutorialManager;
import zombie.ui.UIManager;
import zombie.util.StringUtils;
import zombie.util.Type;
import zombie.util.list.PZArrayUtil;
import zombie.vehicles.BaseVehicle;
import zombie.vehicles.PathFindBehavior2;
import zombie.vehicles.PolygonalMap2;
import zombie.vehicles.VehiclePart;
import zombie.vehicles.VehicleWindow;
import zombie.vehicles.VehiclesDB2;
import zombie.world.WorldDictionary;

public final class IsoPlayer
extends IsoLivingCharacter
implements IHumanVisual {
    private String attackType = null;
    public static String DEATH_MUSIC_NAME = "PlayerDied";
    private boolean allowSprint = true;
    private boolean allowRun = true;
    public static boolean isTestAIMode = false;
    public static final boolean NoSound = false;
    private static final float TIME_RIGHT_PRESSED_SECONDS = 0.15f;
    public static int assumedPlayer = 0;
    public static int numPlayers = 1;
    public static final short MAX = 4;
    public static final IsoPlayer[] players = new IsoPlayer[4];
    private static IsoPlayer instance;
    private static final Object instanceLock;
    private static final Vector2 testHitPosition;
    private static int FollowDeadCount;
    private static final Stack<String> StaticTraits;
    private boolean ignoreAutoVault = false;
    public int remoteSneakLvl = 0;
    public int remoteStrLvl = 0;
    public int remoteFitLvl = 0;
    public boolean canSeeAll = false;
    public boolean canHearAll = false;
    public boolean MoodleCantSprint = false;
    private static final Vector2 tempo;
    private static final Vector2 tempVector2;
    private static final String forwardStr = "Forward";
    private static final String backwardStr = "Backward";
    private static final String leftStr = "Left";
    private static final String rightStr = "Right";
    private static boolean CoopPVP;
    private boolean ignoreContextKey = false;
    private boolean ignoreInputsForDirection = false;
    private boolean showMPInfos = false;
    public long lastRemoteUpdate = 0L;
    public boolean spottedByPlayer = false;
    private HashMap<Integer, Integer> spottedPlayerTimer = new HashMap();
    private float extUpdateCount = 0.0f;
    private static final int s_randomIdleFidgetInterval = 5000;
    public boolean attackStarted = false;
    private static final PredicatedFileWatcher m_isoPlayerTriggerWatcher;
    private final PredicatedFileWatcher m_setClothingTriggerWatcher;
    private static Vector2 tempVector2_1;
    private static Vector2 tempVector2_2;
    protected final HumanVisual humanVisual = new HumanVisual(this);
    protected final ItemVisuals itemVisuals = new ItemVisuals();
    public boolean targetedByZombie = false;
    public float lastTargeted = 1.0E8f;
    public float TimeSinceOpenDoor;
    public boolean bRemote;
    public int TimeSinceLastNetData = 0;
    public String accessLevel = "";
    public String tagPrefix = "";
    public boolean showTag = true;
    public boolean factionPvp = false;
    public short OnlineID = 1;
    public int OnlineChunkGridWidth;
    public boolean bJoypadMovementActive = true;
    public boolean bJoypadIgnoreAimUntilCentered;
    public boolean bJoypadIgnoreChargingRT = false;
    protected boolean bJoypadBDown = false;
    protected boolean bJoypadSprint = false;
    public boolean mpTorchCone = false;
    public float mpTorchDist = 0.0f;
    public float mpTorchStrength = 0.0f;
    public int PlayerIndex = 0;
    public int serverPlayerIndex = 1;
    public float useChargeDelta = 0.0f;
    public int JoypadBind = -1;
    public float ContextPanic = 0.0f;
    public float numNearbyBuildingsRooms = 0.0f;
    public boolean isCharging = false;
    public boolean isChargingLT = false;
    private boolean bLookingWhileInVehicle = false;
    private boolean climbOverWallSuccess;
    private boolean climbOverWallStruggle;
    private boolean JustMoved = false;
    public boolean L3Pressed = false;
    public boolean R3Pressed = false;
    public float maxWeightDelta = 1.0f;
    public float CurrentSpeed = 0.0f;
    public float MaxSpeed = 0.09f;
    public boolean bDeathFinished = false;
    public boolean isSpeek;
    public boolean isVoiceMute;
    public final Vector2 playerMoveDir = new Vector2(0.0f, 0.0f);
    public BaseSoundListener soundListener;
    public String username = "Bob";
    public boolean dirtyRecalcGridStack = true;
    public float dirtyRecalcGridStackTime = 10.0f;
    public float runningTime = 0.0f;
    public float timePressedContext = 0.0f;
    public float chargeTime = 0.0f;
    public float useChargeTime = 0.0f;
    public boolean bPressContext = false;
    public float closestZombie = 1000000.0f;
    public final Vector2 lastAngle = new Vector2();
    public String SaveFileName;
    public boolean bBannedAttacking = false;
    public int sqlID = -1;
    protected int ClearSpottedTimer = -1;
    protected float timeSinceLastStab = 0.0f;
    protected Stack<IsoMovingObject> LastSpotted = new Stack();
    protected boolean bChangeCharacterDebounce = false;
    protected int followID = 0;
    protected final Stack<IsoGameCharacter> FollowCamStack = new Stack();
    protected boolean bSeenThisFrame = false;
    protected boolean bCouldBeSeenThisFrame = false;
    protected float AsleepTime = 0.0f;
    protected final Stack<IsoMovingObject> spottedList = new Stack();
    protected int TicksSinceSeenZombie = 9999999;
    protected boolean Waiting = true;
    protected IsoSurvivor DragCharacter = null;
    protected float heartDelay = 30.0f;
    protected float heartDelayMax = 30.0f;
    protected long heartEventInstance;
    protected long worldAmbianceInstance;
    protected String Forname = "Bob";
    protected String Surname = "Smith";
    protected int DialogMood = 1;
    protected int ping = 0;
    protected IsoMovingObject DragObject = null;
    private double lastSeenZombieTime = 2.0;
    private BaseSoundEmitter testemitter;
    private int checkSafehouse = 200;
    private boolean attackFromBehind = false;
    private float TimeRightPressed = 0.0f;
    private long aimKeyDownMS = 0L;
    private long runKeyDownMS = 0L;
    private long sprintKeyDownMS = 0L;
    private int hypothermiaCache = -1;
    private int hyperthermiaCache = -1;
    private float ticksSincePressedMovement = 0.0f;
    private boolean flickTorch = false;
    private float checkNearbyRooms = 0.0f;
    private boolean bUseVehicle = false;
    private boolean bUsedVehicle;
    private float useVehicleDuration;
    private static final Vector3f tempVector3f;
    private final InputState inputState = new InputState();
    private boolean isWearingNightVisionGoggles = false;
    @Deprecated
    private Integer transactionID = 0;
    private float MoveSpeed = 0.06f;
    private int offSetXUI = 0;
    private int offSetYUI = 0;
    private float combatSpeed = 1.0f;
    private double HoursSurvived = 0.0;
    private boolean noClip = false;
    private boolean authorizeMeleeAction = true;
    private boolean authorizeShoveStomp = true;
    private boolean blockMovement = false;
    private Nutrition nutrition;
    private Fitness fitness;
    private boolean forceOverrideAnim = false;
    private boolean initiateAttack = false;
    private final ColorInfo tagColor = new ColorInfo(1.0f, 1.0f, 1.0f, 1.0f);
    private String displayName = null;
    private boolean seeNonPvpZone = false;
    private final HashMap<Long, Long> mechanicsItem = new HashMap();
    private int sleepingPillsTaken = 0;
    private long lastPillsTaken = 0L;
    private long heavyBreathInstance = 0L;
    private String heavyBreathSoundName = null;
    private boolean allChatMuted = false;
    private boolean forceAim = false;
    private boolean forceRun = false;
    private boolean forceSprint = false;
    private boolean bMultiplayer;
    private String SaveFileIP;
    private BaseVehicle vehicle4testCollision = null;
    private long steamID;
    private final VehicleContainerData vehicleContainerData = new VehicleContainerData();
    private boolean isWalking = false;
    private int footInjuryTimer = 0;
    private boolean bSneakDebounce;
    private float m_turnDelta = 0.0f;
    protected boolean m_isPlayerMoving = false;
    private float m_walkSpeed = 0.0f;
    private float m_walkInjury = 0.0f;
    private float m_runSpeed = 0.0f;
    private float m_idleSpeed = 0.0f;
    private float m_deltaX = 0.0f;
    private float m_deltaY = 0.0f;
    private float m_windspeed = 0.0f;
    private float m_windForce = 0.0f;
    private float m_IPX = 0.0f;
    private float m_IPY = 0.0f;
    private float pressedRunTimer = 0.0f;
    private boolean pressedRun = false;
    private boolean m_meleePressed = false;
    private boolean m_lastAttackWasShove = false;
    private boolean m_isPerformingAnAction = false;
    private ArrayList<String> alreadyReadBook = new ArrayList();
    public byte bleedingLevel = 0;
    public final NetworkPlayerAI networkAI;
    public ReplayManager replay = null;
    private static final ArrayList<IsoPlayer> RecentlyRemoved;
    private boolean pathfindRun = false;
    private static final MoveVars s_moveVars;
    int atkTimer = 0;
    private static final ArrayList<HitInfo> s_targetsProne;
    private static final ArrayList<HitInfo> s_targetsStanding;
    private boolean bReloadButtonDown = false;
    private boolean bRackButtonDown = false;
    private boolean bReloadKeyDown = false;
    private boolean bRackKeyDown = false;
    private long AttackAnimThrowTimer = System.currentTimeMillis();
    String WeaponT = null;
    private final ParameterCharacterMovementSpeed parameterCharacterMovementSpeed = new ParameterCharacterMovementSpeed(this);
    private final ParameterEquippedBaggageContainer parameterEquippedBaggageContainer = new ParameterEquippedBaggageContainer(this);
    private final ParameterFootstepMaterial parameterFootstepMaterial = new ParameterFootstepMaterial(this);
    private final ParameterFootstepMaterial2 parameterFootstepMaterial2 = new ParameterFootstepMaterial2(this);
    private final ParameterLocalPlayer parameterLocalPlayer = new ParameterLocalPlayer(this);
    private final ParameterMeleeHitSurface parameterMeleeHitSurface = new ParameterMeleeHitSurface(this);
    private final ParameterPlayerHealth parameterPlayerHealth = new ParameterPlayerHealth(this);
    private final ParameterVehicleHitLocation parameterVehicleHitLocation = new ParameterVehicleHitLocation();
    private final ParameterShoeType parameterShoeType = new ParameterShoeType(this);

    public IsoPlayer(IsoCell isoCell) {
        this(isoCell, null, 0, 0, 0);
    }

    public IsoPlayer(IsoCell isoCell, SurvivorDesc survivorDesc, int n, int n2, int n3) {
        super(isoCell, n, n2, n3);
        this.registerVariableCallbacks();
        this.Traits.addAll(StaticTraits);
        StaticTraits.clear();
        this.dir = IsoDirections.W;
        this.nutrition = new Nutrition(this);
        this.fitness = new Fitness(this);
        this.initWornItems("Human");
        this.initAttachedItems("Human");
        this.clothingWetness = new ClothingWetness(this);
        this.descriptor = survivorDesc != null ? survivorDesc : new SurvivorDesc();
        this.setFemale(this.descriptor.isFemale());
        this.Dressup(this.descriptor);
        this.getHumanVisual().copyFrom(this.descriptor.humanVisual);
        this.InitSpriteParts(this.descriptor);
        LuaEventManager.triggerEvent("OnCreateLivingCharacter", this, this.descriptor);
        if (GameClient.bClient || !GameServer.bServer) {
            // empty if block
        }
        this.descriptor.Instance = this;
        this.SpeakColour = new Color(Rand.Next(135) + 120, Rand.Next(135) + 120, Rand.Next(135) + 120, 255);
        if (GameClient.bClient) {
            if (Core.getInstance().getMpTextColor() != null) {
                this.SpeakColour = new Color(Core.getInstance().getMpTextColor().r, Core.getInstance().getMpTextColor().g, Core.getInstance().getMpTextColor().b, 1.0f);
            } else {
                Core.getInstance().setMpTextColor(new ColorInfo(this.SpeakColour.r, this.SpeakColour.g, this.SpeakColour.b, 1.0f));
                try {
                    Core.getInstance().saveOptions();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }
        if (Core.GameMode.equals("LastStand")) {
            this.Traits.add("Strong");
        }
        if (this.Traits.Strong.isSet()) {
            this.maxWeightDelta = 1.5f;
        }
        if (this.Traits.Weak.isSet()) {
            this.maxWeightDelta = 0.75f;
        }
        if (this.Traits.Feeble.isSet()) {
            this.maxWeightDelta = 0.9f;
        }
        if (this.Traits.Stout.isSet()) {
            this.maxWeightDelta = 1.25f;
        }
        this.descriptor.temper = 5.0f;
        if (this.Traits.ShortTemper.isSet()) {
            this.descriptor.temper = 7.5f;
        } else if (this.Traits.Patient.isSet()) {
            this.descriptor.temper = 2.5f;
        }
        if (this.Traits.Injured.isSet()) {
            this.getBodyDamage().AddRandomDamage();
        }
        this.bMultiplayer = GameServer.bServer || GameClient.bClient;
        this.vehicle4testCollision = null;
        if (Core.bDebug && DebugOptions.instance.CheatPlayerStartInvisible.getValue()) {
            this.setGhostMode(true);
            this.setGodMod(true);
        }
        this.actionContext.setGroup(ActionGroup.getActionGroup("player"));
        this.initializeStates();
        DebugFileWatcher.instance.add(m_isoPlayerTriggerWatcher);
        this.m_setClothingTriggerWatcher = new PredicatedFileWatcher(ZomboidFileSystem.instance.getMessagingDirSub("Trigger_SetClothing.xml"), TriggerXmlFile.class, this::onTrigger_setClothingToXmlTriggerFile);
        this.networkAI = new NetworkPlayerAI(this);
        this.initFMODParameters();
    }

    public void setOnlineID(short s) {
        this.OnlineID = s;
    }

    private void registerVariableCallbacks() {
        this.setVariable("CombatSpeed", () -> Float.valueOf(this.combatSpeed), f -> {
            this.combatSpeed = f.floatValue();
        });
        this.setVariable("TurnDelta", () -> Float.valueOf(this.m_turnDelta), f -> {
            this.m_turnDelta = f.floatValue();
        });
        this.setVariable("sneaking", this::isSneaking, this::setSneaking);
        this.setVariable("initiateAttack", () -> this.initiateAttack, this::setInitiateAttack);
        this.setVariable("isMoving", this::isPlayerMoving);
        this.setVariable("isRunning", this::isRunning, this::setRunning);
        this.setVariable("isSprinting", this::isSprinting, this::setSprinting);
        this.setVariable("run", this::isRunning, this::setRunning);
        this.setVariable("sprint", this::isSprinting, this::setSprinting);
        this.setVariable("isStrafing", this::isStrafing);
        this.setVariable("WalkSpeed", () -> Float.valueOf(this.m_walkSpeed), f -> {
            this.m_walkSpeed = f.floatValue();
        });
        this.setVariable("WalkInjury", () -> Float.valueOf(this.m_walkInjury), f -> {
            this.m_walkInjury = f.floatValue();
        });
        this.setVariable("RunSpeed", () -> Float.valueOf(this.m_runSpeed), f -> {
            this.m_runSpeed = f.floatValue();
        });
        this.setVariable("IdleSpeed", () -> Float.valueOf(this.m_idleSpeed), f -> {
            this.m_idleSpeed = f.floatValue();
        });
        this.setVariable("DeltaX", () -> Float.valueOf(this.m_deltaX), f -> {
            this.m_deltaX = f.floatValue();
        });
        this.setVariable("DeltaY", () -> Float.valueOf(this.m_deltaY), f -> {
            this.m_deltaY = f.floatValue();
        });
        this.setVariable("Windspeed", () -> Float.valueOf(this.m_windspeed), f -> {
            this.m_windspeed = f.floatValue();
        });
        this.setVariable("WindForce", () -> Float.valueOf(this.m_windForce), f -> {
            this.m_windForce = f.floatValue();
        });
        this.setVariable("IPX", () -> Float.valueOf(this.m_IPX), f -> {
            this.m_IPX = f.floatValue();
        });
        this.setVariable("IPY", () -> Float.valueOf(this.m_IPY), f -> {
            this.m_IPY = f.floatValue();
        });
        this.setVariable("attacktype", () -> this.attackType);
        this.setVariable("aim", this::isAiming);
        this.setVariable("bdoshove", () -> this.bDoShove);
        this.setVariable("bfalling", () -> this.z > 0.0f && this.fallTime > 2.0f);
        this.setVariable("baimatfloor", this::isAimAtFloor);
        this.setVariable("attackfrombehind", () -> this.attackFromBehind);
        this.setVariable("bundervehicle", this::isUnderVehicle);
        this.setVariable("reanimatetimer", this::getReanimateTimer);
        this.setVariable("isattacking", this::isAttacking);
        this.setVariable("beensprintingfor", this::getBeenSprintingFor);
        this.setVariable("bannedAttacking", () -> this.bBannedAttacking);
        this.setVariable("meleePressed", () -> this.m_meleePressed);
        this.setVariable("AttackAnim", this::isAttackAnim, this::setAttackAnim);
        this.setVariable("Weapon", this::getWeaponType, this::setWeaponType);
        this.setVariable("BumpFall", false);
        this.setVariable("bClient", () -> GameClient.bClient);
        this.setVariable("IsPerformingAnAction", this::isPerformingAnAction, this::setPerformingAnAction);
    }

    @Override
    public Vector2 getDeferredMovement(Vector2 vector22) {
        super.getDeferredMovement(vector22);
        if (DebugOptions.instance.CheatPlayerInvisibleSprint.getValue() && this.isGhostMode() && (this.IsRunning() || this.isSprinting()) && !this.isCurrentState(ClimbOverFenceState.instance()) && !this.isCurrentState(ClimbThroughWindowState.instance())) {
            if (this.getPath2() == null && !this.pressedMovement(false)) {
                return vector22.set(0.0f, 0.0f);
            }
            if (this.getCurrentBuilding() != null) {
                vector22.scale(2.5f);
                return vector22;
            }
            vector22.scale(7.5f);
        }
        return vector22;
    }

    @Override
    public float getTurnDelta() {
        if (DebugOptions.instance.CheatPlayerInvisibleSprint.getValue() && this.isGhostMode() && (this.isRunning() || this.isSprinting())) {
            return 10.0f;
        }
        return super.getTurnDelta();
    }

    public void setPerformingAnAction(boolean bl) {
        this.m_isPerformingAnAction = bl;
    }

    public boolean isPerformingAnAction() {
        return this.m_isPerformingAnAction;
    }

    @Override
    public boolean isAttacking() {
        return !StringUtils.isNullOrWhitespace(this.getAttackType());
    }

    @Override
    public boolean shouldBeTurning() {
        if (this.isPerformingAnAction()) {
            // empty if block
        }
        return super.shouldBeTurning();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void invokeOnPlayerInstance(Runnable runnable) {
        Object object = instanceLock;
        synchronized (object) {
            if (instance != null) {
                runnable.run();
            }
        }
    }

    public static IsoPlayer getInstance() {
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setInstance(IsoPlayer isoPlayer) {
        Object object = instanceLock;
        synchronized (object) {
            instance = isoPlayer;
        }
    }

    public static boolean hasInstance() {
        return instance != null;
    }

    private static void onTrigger_ResetIsoPlayerModel(String string) {
        if (instance != null) {
            DebugLog.log(DebugType.General, "DebugFileWatcher Hit. Resetting player model: " + string);
            instance.resetModel();
        } else {
            DebugLog.log(DebugType.General, "DebugFileWatcher Hit. Player instance null : " + string);
        }
    }

    public static Stack<String> getStaticTraits() {
        return StaticTraits;
    }

    public static int getFollowDeadCount() {
        return FollowDeadCount;
    }

    public static void setFollowDeadCount(int n) {
        FollowDeadCount = n;
    }

    public static ArrayList<String> getAllFileNames() {
        ArrayList<String> arrayList = new ArrayList<String>();
        String string = ZomboidFileSystem.instance.getCurrentSaveDir();
        for (int i = 1; i < 100; ++i) {
            File file = new File(string + File.separator + "map_p" + i + ".bin");
            if (!file.exists()) continue;
            arrayList.add("map_p" + i + ".bin");
        }
        return arrayList;
    }

    public static String getUniqueFileName() {
        int n = 0;
        String string = ZomboidFileSystem.instance.getCurrentSaveDir();
        for (int i = 1; i < 100; ++i) {
            File file = new File(string + File.separator + "map_p" + i + ".bin");
            if (!file.exists()) continue;
            n = i;
        }
        return ZomboidFileSystem.instance.getFileNameInCurrentSave("map_p" + ++n + ".bin");
    }

    public static ArrayList<IsoPlayer> getAllSavedPlayers() {
        ArrayList<IsoPlayer> arrayList = GameClient.bClient ? ClientPlayerDB.getInstance().getAllNetworkPlayers() : PlayerDB.getInstance().getAllLocalPlayers();
        for (int i = arrayList.size() - 1; i >= 0; --i) {
            if (!arrayList.get(i).isDead()) continue;
            arrayList.remove(i);
        }
        return arrayList;
    }

    public static boolean isServerPlayerIDValid(String string) {
        if (GameClient.bClient) {
            String string2 = ServerOptions.instance.ServerPlayerID.getValue();
            if (string2 == null || string2.isEmpty()) {
                return true;
            }
            return string2.equals(string);
        }
        return true;
    }

    public static int getPlayerIndex() {
        if (instance == null) {
            return assumedPlayer;
        }
        return IsoPlayer.instance.PlayerIndex;
    }

    public static boolean allPlayersDead() {
        for (int i = 0; i < numPlayers; ++i) {
            if (players[i] == null || players[i].isDead()) continue;
            return false;
        }
        return IsoWorld.instance == null || IsoWorld.instance.AddCoopPlayers.isEmpty();
    }

    public static ArrayList<IsoPlayer> getPlayers() {
        return new ArrayList<IsoPlayer>(Arrays.asList(players));
    }

    public static boolean allPlayersAsleep() {
        int n = 0;
        int n2 = 0;
        for (int i = 0; i < numPlayers; ++i) {
            if (players[i] == null || players[i].isDead()) continue;
            ++n;
            if (players[i] == null || !players[i].isAsleep()) continue;
            ++n2;
        }
        return n > 0 && n == n2;
    }

    public static boolean getCoopPVP() {
        return CoopPVP;
    }

    public static void setCoopPVP(boolean bl) {
        CoopPVP = bl;
    }

    public void TestZombieSpotPlayer(IsoMovingObject isoMovingObject) {
        float f;
        if (GameServer.bServer && isoMovingObject instanceof IsoZombie && ((IsoZombie)isoMovingObject).target != this && ((IsoZombie)isoMovingObject).isLeadAggro(this)) {
            GameServer.updateZombieControl((IsoZombie)isoMovingObject, (short)1, this.OnlineID);
            return;
        }
        isoMovingObject.spotted(this, false);
        if (isoMovingObject instanceof IsoZombie && (f = isoMovingObject.DistTo(this)) < this.closestZombie && !isoMovingObject.isOnFloor()) {
            this.closestZombie = f;
        }
    }

    public float getPathSpeed() {
        float f = this.getMoveSpeed() * 0.9f;
        switch (this.Moodles.getMoodleLevel(MoodleType.Endurance)) {
            case 1: {
                f *= 0.95f;
                break;
            }
            case 2: {
                f *= 0.9f;
                break;
            }
            case 3: {
                f *= 0.8f;
                break;
            }
            case 4: {
                f *= 0.6f;
            }
        }
        if (this.stats.enduranceRecharging) {
            f *= 0.85f;
        }
        if (this.getMoodles().getMoodleLevel(MoodleType.HeavyLoad) > 0) {
            float f2 = this.getInventory().getCapacityWeight();
            float f3 = this.getMaxWeight();
            float f4 = Math.min(2.0f, f2 / f3) - 1.0f;
            f *= 0.65f + 0.35f * (1.0f - f4);
        }
        return f;
    }

    public boolean isGhostMode() {
        return this.isInvisible();
    }

    public void setGhostMode(boolean bl) {
        this.setInvisible(bl);
    }

    public boolean isSeeEveryone() {
        return Core.bDebug && DebugOptions.instance.CheatPlayerSeeEveryone.getValue();
    }

    public boolean zombiesSwitchOwnershipEachUpdate() {
        return SystemDisabler.zombiesSwitchOwnershipEachUpdate;
    }

    public Vector2 getPlayerMoveDir() {
        return this.playerMoveDir;
    }

    public void setPlayerMoveDir(Vector2 vector22) {
        this.playerMoveDir.set(vector22);
    }

    @Override
    public void MoveUnmodded(Vector2 vector22) {
        if (this.getSlowFactor() > 0.0f) {
            vector22.x *= 1.0f - this.getSlowFactor();
            vector22.y *= 1.0f - this.getSlowFactor();
        }
        super.MoveUnmodded(vector22);
    }

    public void nullifyAiming() {
        if (this.isForceAim()) {
            this.toggleForceAim();
        }
        this.isCharging = false;
        this.setIsAiming(false);
    }

    public boolean isAimKeyDown() {
        if (this.PlayerIndex != 0) {
            return false;
        }
        int n = Core.getInstance().getKey("Aim");
        boolean bl = GameKeyboard.isKeyDown(n);
        if (!bl) {
            return false;
        }
        boolean bl2 = n == 29 || n == 157;
        return !bl2 || !UIManager.isMouseOverInventory();
    }

    private void initializeStates() {
        HashMap<String, State> hashMap = this.getStateUpdateLookup();
        hashMap.clear();
        if (this.getVehicle() == null) {
            hashMap.put("actions", PlayerActionsState.instance());
            hashMap.put("aim", PlayerAimState.instance());
            hashMap.put("climbfence", ClimbOverFenceState.instance());
            hashMap.put("climbdownrope", ClimbDownSheetRopeState.instance());
            hashMap.put("climbrope", ClimbSheetRopeState.instance());
            hashMap.put("climbwall", ClimbOverWallState.instance());
            hashMap.put("climbwindow", ClimbThroughWindowState.instance());
            hashMap.put("emote", PlayerEmoteState.instance());
            hashMap.put("ext", PlayerExtState.instance());
            hashMap.put("sitext", PlayerExtState.instance());
            hashMap.put("falldown", PlayerFallDownState.instance());
            hashMap.put("falling", PlayerFallingState.instance());
            hashMap.put("getup", PlayerGetUpState.instance());
            hashMap.put("idle", IdleState.instance());
            hashMap.put("melee", SwipeStatePlayer.instance());
            hashMap.put("shove", SwipeStatePlayer.instance());
            hashMap.put("ranged", SwipeStatePlayer.instance());
            hashMap.put("onground", PlayerOnGroundState.instance());
            hashMap.put("knockeddown", PlayerKnockedDown.instance());
            hashMap.put("openwindow", OpenWindowState.instance());
            hashMap.put("closewindow", CloseWindowState.instance());
            hashMap.put("smashwindow", SmashWindowState.instance());
            hashMap.put("fishing", FishingState.instance());
            hashMap.put("fitness", FitnessState.instance());
            hashMap.put("hitreaction", PlayerHitReactionState.instance());
            hashMap.put("hitreactionpvp", PlayerHitReactionPVPState.instance());
            hashMap.put("hitreaction-hit", PlayerHitReactionPVPState.instance());
            hashMap.put("collide", CollideWithWallState.instance());
            hashMap.put("bumped", BumpedState.instance());
            hashMap.put("bumped-bump", BumpedState.instance());
            hashMap.put("sitonground", PlayerSitOnGroundState.instance());
            hashMap.put("strafe", PlayerStrafeState.instance());
        } else {
            hashMap.put("aim", PlayerAimState.instance());
            hashMap.put("idle", IdleState.instance());
            hashMap.put("melee", SwipeStatePlayer.instance());
            hashMap.put("shove", SwipeStatePlayer.instance());
            hashMap.put("ranged", SwipeStatePlayer.instance());
        }
    }

    @Override
    public ActionContext getActionContext() {
        return this.actionContext;
    }

    @Override
    protected void onAnimPlayerCreated(AnimationPlayer animationPlayer) {
        super.onAnimPlayerCreated(animationPlayer);
        animationPlayer.addBoneReparent("Bip01_L_Thigh", "Bip01");
        animationPlayer.addBoneReparent("Bip01_R_Thigh", "Bip01");
        animationPlayer.addBoneReparent("Bip01_L_Clavicle", "Bip01_Spine1");
        animationPlayer.addBoneReparent("Bip01_R_Clavicle", "Bip01_Spine1");
        animationPlayer.addBoneReparent("Bip01_Prop1", "Bip01_R_Hand");
        animationPlayer.addBoneReparent("Bip01_Prop2", "Bip01_L_Hand");
    }

    @Override
    public String GetAnimSetName() {
        return this.getVehicle() == null ? "player" : "player-vehicle";
    }

    public boolean IsInMeleeAttack() {
        return this.isCurrentState(SwipeStatePlayer.instance());
    }

    @Override
    public void load(ByteBuffer byteBuffer, int n, boolean bl) throws IOException {
        int n2;
        int n3;
        byte by = byteBuffer.get();
        byte by2 = byteBuffer.get();
        super.load(byteBuffer, n, bl);
        this.setHoursSurvived(byteBuffer.getDouble());
        SurvivorDesc survivorDesc = this.descriptor;
        this.setFemale(survivorDesc.isFemale());
        this.InitSpriteParts(survivorDesc);
        this.SpeakColour = new Color(Rand.Next(135) + 120, Rand.Next(135) + 120, Rand.Next(135) + 120, 255);
        if (GameClient.bClient) {
            if (Core.getInstance().getMpTextColor() != null) {
                this.SpeakColour = new Color(Core.getInstance().getMpTextColor().r, Core.getInstance().getMpTextColor().g, Core.getInstance().getMpTextColor().b, 1.0f);
            } else {
                Core.getInstance().setMpTextColor(new ColorInfo(this.SpeakColour.r, this.SpeakColour.g, this.SpeakColour.b, 1.0f));
                try {
                    Core.getInstance().saveOptions();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }
        this.setZombieKills(byteBuffer.getInt());
        ArrayList arrayList = this.savedInventoryItems;
        int n4 = byteBuffer.get();
        for (n3 = 0; n3 < n4; ++n3) {
            String string = GameWindow.ReadString(byteBuffer);
            n2 = byteBuffer.getShort();
            if (n2 < 0 || n2 >= arrayList.size() || this.wornItems.getBodyLocationGroup().getLocation(string) == null) continue;
            this.wornItems.setItem(string, (InventoryItem)arrayList.get(n2));
        }
        n3 = byteBuffer.getShort();
        if (n3 >= 0 && n3 < arrayList.size()) {
            this.leftHandItem = (InventoryItem)arrayList.get(n3);
        }
        if ((n3 = byteBuffer.getShort()) >= 0 && n3 < arrayList.size()) {
            this.rightHandItem = (InventoryItem)arrayList.get(n3);
        }
        this.setVariable("Weapon", WeaponType.getWeaponType((IsoGameCharacter)this).type);
        this.setSurvivorKills(byteBuffer.getInt());
        this.initSpritePartsEmpty();
        this.nutrition.load(byteBuffer);
        this.setAllChatMuted(byteBuffer.get() == 1);
        this.tagPrefix = GameWindow.ReadString(byteBuffer);
        this.setTagColor(new ColorInfo(byteBuffer.getFloat(), byteBuffer.getFloat(), byteBuffer.getFloat(), 1.0f));
        this.setDisplayName(GameWindow.ReadString(byteBuffer));
        this.showTag = byteBuffer.get() == 1;
        boolean bl2 = this.factionPvp = byteBuffer.get() == 1;
        if (n >= 176) {
            boolean bl3 = this.noClip = byteBuffer.get() == 1;
        }
        if (byteBuffer.get() == 1) {
            this.savedVehicleX = byteBuffer.getFloat();
            this.savedVehicleY = byteBuffer.getFloat();
            this.savedVehicleSeat = byteBuffer.get();
            this.savedVehicleRunning = byteBuffer.get() == 1;
            this.z = 0.0f;
        }
        int n5 = byteBuffer.getInt();
        for (n2 = 0; n2 < n5; ++n2) {
            this.mechanicsItem.put(byteBuffer.getLong(), byteBuffer.getLong());
        }
        this.fitness.load(byteBuffer, n);
        if (n >= 184) {
            n2 = byteBuffer.getShort();
            for (int i = 0; i < n2; ++i) {
                short s = byteBuffer.getShort();
                String string = WorldDictionary.getItemTypeFromID(s);
                if (string == null) continue;
                this.alreadyReadBook.add(string);
            }
        } else if (n >= 182) {
            n2 = byteBuffer.getInt();
            for (int i = 0; i < n2; ++i) {
                this.alreadyReadBook.add(GameWindow.ReadString(byteBuffer));
            }
        }
        if (n >= 189) {
            this.loadKnownMediaLines(byteBuffer, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void save(ByteBuffer byteBuffer, boolean bl) throws IOException {
        IsoPlayer isoPlayer = instance;
        instance = this;
        try {
            super.save(byteBuffer, bl);
        }
        finally {
            instance = isoPlayer;
        }
        byteBuffer.putDouble(this.getHoursSurvived());
        byteBuffer.putInt(this.getZombieKills());
        if (this.wornItems.size() > 127) {
            throw new RuntimeException("too many worn items");
        }
        byteBuffer.put((byte)this.wornItems.size());
        this.wornItems.forEach(wornItem -> {
            GameWindow.WriteString(byteBuffer, wornItem.getLocation());
            byteBuffer.putShort((short)this.savedInventoryItems.indexOf(wornItem.getItem()));
        });
        byteBuffer.putShort((short)this.savedInventoryItems.indexOf(this.getPrimaryHandItem()));
        byteBuffer.putShort((short)this.savedInventoryItems.indexOf(this.getSecondaryHandItem()));
        byteBuffer.putInt(this.getSurvivorKills());
        this.nutrition.save(byteBuffer);
        byteBuffer.put(this.isAllChatMuted() ? (byte)1 : 0);
        GameWindow.WriteString(byteBuffer, this.tagPrefix);
        byteBuffer.putFloat(this.getTagColor().r);
        byteBuffer.putFloat(this.getTagColor().g);
        byteBuffer.putFloat(this.getTagColor().b);
        GameWindow.WriteString(byteBuffer, this.displayName);
        byteBuffer.put(this.showTag ? (byte)1 : 0);
        byteBuffer.put(this.factionPvp ? (byte)1 : 0);
        byteBuffer.put(this.isNoClip() ? (byte)1 : 0);
        if (this.vehicle != null) {
            byteBuffer.put((byte)1);
            byteBuffer.putFloat(this.vehicle.x);
            byteBuffer.putFloat(this.vehicle.y);
            byteBuffer.put((byte)this.vehicle.getSeat(this));
            byteBuffer.put(this.vehicle.isEngineRunning() ? (byte)1 : 0);
        } else {
            byteBuffer.put((byte)0);
        }
        byteBuffer.putInt(this.mechanicsItem.size());
        for (Long l : this.mechanicsItem.keySet()) {
            byteBuffer.putLong(l);
            byteBuffer.putLong(this.mechanicsItem.get(l));
        }
        this.fitness.save(byteBuffer);
        byteBuffer.putShort((short)this.alreadyReadBook.size());
        for (int i = 0; i < this.alreadyReadBook.size(); ++i) {
            byteBuffer.putShort(WorldDictionary.getItemRegistryID(this.alreadyReadBook.get(i)));
        }
        this.saveKnownMediaLines(byteBuffer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save() throws IOException {
        Object object = SliceY.SliceBufferLock;
        synchronized (object) {
            ByteBuffer byteBuffer = SliceY.SliceBuffer;
            byteBuffer.clear();
            byteBuffer.put((byte)80);
            byteBuffer.put((byte)76);
            byteBuffer.put((byte)89);
            byteBuffer.put((byte)82);
            byteBuffer.putInt(195);
            GameWindow.WriteString(byteBuffer, this.bMultiplayer ? ServerOptions.instance.ServerPlayerID.getValue() : "");
            byteBuffer.putInt((int)(this.x / 10.0f));
            byteBuffer.putInt((int)(this.y / 10.0f));
            byteBuffer.putInt((int)this.x);
            byteBuffer.putInt((int)this.y);
            byteBuffer.putInt((int)this.z);
            this.save(byteBuffer);
            File file = new File(ZomboidFileSystem.instance.getFileNameInCurrentSave("map_p.bin"));
            if (!Core.getInstance().isNoSave()) {
                try (FileOutputStream fileOutputStream = new FileOutputStream(file);
                     BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(fileOutputStream);){
                    bufferedOutputStream.write(byteBuffer.array(), 0, byteBuffer.position());
                }
            }
            if (this.getVehicle() != null && !GameClient.bClient) {
                VehiclesDB2.instance.updateVehicleAndTrailer(this.getVehicle());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(String string) throws IOException {
        this.SaveFileName = string;
        Object object = SliceY.SliceBufferLock;
        synchronized (object) {
            SliceY.SliceBuffer.clear();
            SliceY.SliceBuffer.putInt(195);
            GameWindow.WriteString(SliceY.SliceBuffer, this.bMultiplayer ? ServerOptions.instance.ServerPlayerID.getValue() : "");
            this.save(SliceY.SliceBuffer);
            File file = new File(string).getAbsoluteFile();
            try (FileOutputStream fileOutputStream = new FileOutputStream(file);
                 BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(fileOutputStream);){
                bufferedOutputStream.write(SliceY.SliceBuffer.array(), 0, SliceY.SliceBuffer.position());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load(String string) throws IOException {
        File file = new File(string).getAbsoluteFile();
        if (!file.exists()) {
            return;
        }
        this.SaveFileName = string;
        try (FileInputStream fileInputStream = new FileInputStream(file);
             BufferedInputStream bufferedInputStream = new BufferedInputStream(fileInputStream);){
            Object object = SliceY.SliceBufferLock;
            synchronized (object) {
                SliceY.SliceBuffer.clear();
                int n = bufferedInputStream.read(SliceY.SliceBuffer.array());
                SliceY.SliceBuffer.limit(n);
                int n2 = SliceY.SliceBuffer.getInt();
                if (n2 >= 69) {
                    this.SaveFileIP = GameWindow.ReadStringUTF(SliceY.SliceBuffer);
                    if (n2 < 71) {
                        this.SaveFileIP = ServerOptions.instance.ServerPlayerID.getValue();
                    }
                } else if (GameClient.bClient) {
                    this.SaveFileIP = ServerOptions.instance.ServerPlayerID.getValue();
                }
                this.load(SliceY.SliceBuffer, n2);
            }
        }
    }

    @Override
    public void removeFromWorld() {
        this.getEmitter().stopOrTriggerSoundByName("BurningFlesh");
        this.removedFromWorldMS = System.currentTimeMillis();
        if (!RecentlyRemoved.contains(this)) {
            RecentlyRemoved.add(this);
        }
        super.removeFromWorld();
    }

    public static void UpdateRemovedEmitters() {
        IsoCell isoCell = IsoWorld.instance.CurrentCell;
        long l = System.currentTimeMillis();
        for (int i = RecentlyRemoved.size() - 1; i >= 0; --i) {
            IsoPlayer isoPlayer = RecentlyRemoved.get(i);
            if ((isoCell.getObjectList().contains(isoPlayer) || isoCell.getAddList().contains(isoPlayer)) && !isoCell.getRemoveList().contains(isoPlayer)) {
                RecentlyRemoved.remove(i);
                continue;
            }
            isoPlayer.getFMODParameters().update();
            isoPlayer.getEmitter().tick();
            if (l - isoPlayer.removedFromWorldMS <= 5000L) continue;
            isoPlayer.getEmitter().stopAll();
            RecentlyRemoved.remove(i);
        }
    }

    public static void Reset() {
        RecentlyRemoved.clear();
    }

    public void setVehicle4TestCollision(BaseVehicle baseVehicle) {
        this.vehicle4testCollision = baseVehicle;
    }

    public boolean isSaveFileInUse() {
        for (int i = 0; i < numPlayers; ++i) {
            IsoPlayer isoPlayer = players[i];
            if (isoPlayer == null) continue;
            if (this.sqlID != -1 && this.sqlID == isoPlayer.sqlID) {
                return true;
            }
            if (this.SaveFileName == null || !this.SaveFileName.equals(isoPlayer.SaveFileName)) continue;
            return true;
        }
        return false;
    }

    public void removeSaveFile() {
        try {
            File file;
            if (PlayerDB.isAvailable()) {
                PlayerDB.getInstance().saveLocalPlayersForce();
            }
            if (this.isNPC() && this.SaveFileName != null && (file = new File(this.SaveFileName).getAbsoluteFile()).exists()) {
                file.delete();
            }
        }
        catch (Exception exception) {
            ExceptionLogger.logException(exception);
        }
    }

    public boolean isSaveFileIPValid() {
        return IsoPlayer.isServerPlayerIDValid(this.SaveFileIP);
    }

    @Override
    public String getObjectName() {
        return "Player";
    }

    public int getJoypadBind() {
        return this.JoypadBind;
    }

    public boolean isLBPressed() {
        if (this.JoypadBind == -1) {
            return false;
        }
        return JoypadManager.instance.isLBPressed(this.JoypadBind);
    }

    public Vector2 getControllerAimDir(Vector2 vector22) {
        if (GameWindow.ActivatedJoyPad != null && this.JoypadBind != -1 && this.bJoypadMovementActive) {
            float f = JoypadManager.instance.getAimingAxisX(this.JoypadBind);
            float f2 = JoypadManager.instance.getAimingAxisY(this.JoypadBind);
            if (this.bJoypadIgnoreAimUntilCentered) {
                if (vector22.set(f, f2).getLengthSquared() > 0.0f) {
                    return vector22.set(0.0f, 0.0f);
                }
                this.bJoypadIgnoreAimUntilCentered = false;
            }
            if (vector22.set(f, f2).getLength() < 0.3f) {
                f2 = 0.0f;
                f = 0.0f;
            }
            if (f != 0.0f || f2 != 0.0f) {
                vector22.set(f, f2);
                vector22.normalize();
                vector22.rotate(-0.7853982f);
            } else {
                return vector22.set(0.0f, 0.0f);
            }
        }
        return vector22;
    }

    public Vector2 getMouseAimVector(Vector2 vector22) {
        int n = Mouse.getX();
        int n2 = Mouse.getY();
        vector22.x = IsoUtils.XToIso(n, (float)n2 + 55.0f * this.def.getScaleY(), this.getZ()) - this.getX();
        vector22.y = IsoUtils.YToIso(n, (float)n2 + 55.0f * this.def.getScaleY(), this.getZ()) - this.getY();
        vector22.normalize();
        return vector22;
    }

    public Vector2 getAimVector(Vector2 vector22) {
        if (this.JoypadBind == -1) {
            return this.getMouseAimVector(vector22);
        }
        return this.getControllerAimDir(vector22);
    }

    @Override
    public float getGlobalMovementMod(boolean bl) {
        if (this.isGhostMode() || this.isNoClip()) {
            return 1.0f;
        }
        return super.getGlobalMovementMod(bl);
    }

    @Override
    public boolean isInTrees2(boolean bl) {
        if (this.isGhostMode() || this.isNoClip()) {
            return false;
        }
        return super.isInTrees2(bl);
    }

    @Override
    public float getMoveSpeed() {
        float f = 1.0f;
        for (int i = BodyPartType.ToIndex(BodyPartType.UpperLeg_L); i <= BodyPartType.ToIndex(BodyPartType.Foot_R); ++i) {
            BodyPart bodyPart = this.getBodyDamage().getBodyPart(BodyPartType.FromIndex(i));
            float f2 = 1.0f;
            if (bodyPart.getFractureTime() > 20.0f) {
                f2 = 0.4f;
                if (bodyPart.getFractureTime() > 50.0f) {
                    f2 = 0.3f;
                }
                if (bodyPart.getSplintFactor() > 0.0f) {
                    f2 += bodyPart.getSplintFactor() / 10.0f;
                }
            }
            if (bodyPart.getFractureTime() < 20.0f && bodyPart.getSplintFactor() > 0.0f) {
                f2 = 0.8f;
            }
            if (f2 > 0.7f && bodyPart.getDeepWoundTime() > 0.0f) {
                f2 = 0.7f;
                if (bodyPart.bandaged()) {
                    f2 += 0.2f;
                }
            }
            if (!(f2 < f)) continue;
            f = f2;
        }
        if (f != 1.0f) {
            return this.MoveSpeed * f;
        }
        if (this.getMoodles().getMoodleLevel(MoodleType.Panic) >= 4 && this.Traits.AdrenalineJunkie.isSet()) {
            float f3 = 1.0f;
            int n = this.getMoodles().getMoodleLevel(MoodleType.Panic) + 1;
            return this.MoveSpeed * (f3 += (float)n / 50.0f);
        }
        return this.MoveSpeed;
    }

    public void setMoveSpeed(float f) {
        this.MoveSpeed = f;
    }

    @Override
    public float getTorchStrength() {
        if (this.bRemote) {
            return this.mpTorchStrength;
        }
        InventoryItem inventoryItem = this.getActiveLightItem();
        if (inventoryItem != null) {
            return inventoryItem.getLightStrength();
        }
        return 0.0f;
    }

    public float getInvAimingMod() {
        int n = this.getPerkLevel(PerkFactory.Perks.Aiming);
        if (n == 1) {
            return 0.9f;
        }
        if (n == 2) {
            return 0.86f;
        }
        if (n == 3) {
            return 0.82f;
        }
        if (n == 4) {
            return 0.74f;
        }
        if (n == 5) {
            return 0.7f;
        }
        if (n == 6) {
            return 0.66f;
        }
        if (n == 7) {
            return 0.62f;
        }
        if (n == 8) {
            return 0.58f;
        }
        if (n == 9) {
            return 0.54f;
        }
        if (n == 10) {
            return 0.5f;
        }
        return 0.9f;
    }

    public float getAimingMod() {
        int n = this.getPerkLevel(PerkFactory.Perks.Aiming);
        if (n == 1) {
            return 1.1f;
        }
        if (n == 2) {
            return 1.14f;
        }
        if (n == 3) {
            return 1.18f;
        }
        if (n == 4) {
            return 1.22f;
        }
        if (n == 5) {
            return 1.26f;
        }
        if (n == 6) {
            return 1.3f;
        }
        if (n == 7) {
            return 1.34f;
        }
        if (n == 8) {
            return 1.36f;
        }
        if (n == 9) {
            return 1.4f;
        }
        if (n == 10) {
            return 1.5f;
        }
        return 1.0f;
    }

    public float getReloadingMod() {
        int n = this.getPerkLevel(PerkFactory.Perks.Reloading);
        return 3.5f - (float)n * 0.25f;
    }

    public float getAimingRangeMod() {
        int n = this.getPerkLevel(PerkFactory.Perks.Aiming);
        if (n == 1) {
            return 1.2f;
        }
        if (n == 2) {
            return 1.28f;
        }
        if (n == 3) {
            return 1.36f;
        }
        if (n == 4) {
            return 1.42f;
        }
        if (n == 5) {
            return 1.5f;
        }
        if (n == 6) {
            return 1.58f;
        }
        if (n == 7) {
            return 1.66f;
        }
        if (n == 8) {
            return 1.72f;
        }
        if (n == 9) {
            return 1.8f;
        }
        if (n == 10) {
            return 2.0f;
        }
        return 1.1f;
    }

    public boolean isPathfindRunning() {
        return this.pathfindRun;
    }

    public void setPathfindRunning(boolean bl) {
        this.pathfindRun = bl;
    }

    public boolean isBannedAttacking() {
        return this.bBannedAttacking;
    }

    public void setBannedAttacking(boolean bl) {
        this.bBannedAttacking = bl;
    }

    public float getInvAimingRangeMod() {
        int n = this.getPerkLevel(PerkFactory.Perks.Aiming);
        if (n == 1) {
            return 0.8f;
        }
        if (n == 2) {
            return 0.7f;
        }
        if (n == 3) {
            return 0.62f;
        }
        if (n == 4) {
            return 0.56f;
        }
        if (n == 5) {
            return 0.45f;
        }
        if (n == 6) {
            return 0.38f;
        }
        if (n == 7) {
            return 0.31f;
        }
        if (n == 8) {
            return 0.24f;
        }
        if (n == 9) {
            return 0.17f;
        }
        if (n == 10) {
            return 0.1f;
        }
        return 0.8f;
    }

    private void updateCursorVisibility() {
        if (!this.isAiming()) {
            return;
        }
        if (this.PlayerIndex != 0 || this.JoypadBind != -1 || this.isDead()) {
            return;
        }
        if (Core.getInstance().getOptionShowCursorWhileAiming()) {
            return;
        }
        if (Core.getInstance().getIsoCursorVisibility() == 0) {
            return;
        }
        if (UIManager.isForceCursorVisible()) {
            return;
        }
        int n = Mouse.getXA();
        int n2 = Mouse.getYA();
        if (n < IsoCamera.getScreenLeft(0) || n > IsoCamera.getScreenLeft(0) + IsoCamera.getScreenWidth(0)) {
            return;
        }
        if (n2 < IsoCamera.getScreenTop(0) || n2 > IsoCamera.getScreenTop(0) + IsoCamera.getScreenHeight(0)) {
            return;
        }
        Mouse.setCursorVisible(false);
    }

    @Override
    public void render(float f, float f2, float f3, ColorInfo colorInfo, boolean bl, boolean bl2, Shader shader) {
        if (DebugOptions.instance.Character.Debug.Render.DisplayRoomAndZombiesZone.getValue()) {
            IsoMetaGrid.Zone zone;
            Object object = "";
            if (this.getCurrentRoomDef() != null) {
                object = this.getCurrentRoomDef().name;
            }
            if ((zone = ZombiesZoneDefinition.getDefinitionZoneAt((int)f, (int)f2, (int)f3)) != null) {
                object = (String)object + " - " + zone.name + " / " + zone.type;
            }
            this.Say((String)object);
        }
        if (!IsoPlayer.getInstance().checkCanSeeClient(this)) {
            this.setTargetAlpha(0.0f);
            IsoPlayer.getInstance().spottedPlayerTimer.remove(this.getRemoteID());
        } else {
            this.setTargetAlpha(1.0f);
        }
        super.render(f, f2, f3, colorInfo, bl, bl2, shader);
    }

    @Override
    public void renderlast() {
        super.renderlast();
        if (DebugOptions.instance.Character.Debug.Render.FMODRoomType.getValue() && this.isLocalPlayer()) {
            ParameterRoomType.render(this);
        }
    }

    public float doBeatenVehicle(float f) {
        if (GameClient.bClient && this.isLocalPlayer()) {
            this.changeState(ForecastBeatenPlayerState.instance());
            return 0.0f;
        }
        if (!GameClient.bClient && !this.isLocalPlayer()) {
            return 0.0f;
        }
        float f2 = this.getDamageFromHitByACar(f);
        LuaEventManager.triggerEvent("OnPlayerGetDamage", this, "CARHITDAMAGE", Float.valueOf(f2));
        if (this.isAlive()) {
            if (GameClient.bClient) {
                if (this.isCurrentState(PlayerSitOnGroundState.instance())) {
                    this.setKnockedDown(true);
                    this.setReanimateTimer(20.0f);
                } else if (this.isOnFloor() || f > 15.0f || this.isCurrentState(PlayerHitReactionState.instance()) || this.isCurrentState(PlayerGetUpState.instance()) || this.isCurrentState(PlayerOnGroundState.instance())) {
                    this.setHitReaction("HitReaction");
                    this.actionContext.reportEvent("washit");
                    this.setVariable("hitpvp", false);
                    this.setKnockedDown(true);
                    this.setReanimateTimer(20.0f);
                } else {
                    this.setHitReaction("HitReaction");
                    this.actionContext.reportEvent("washit");
                    this.setVariable("hitpvp", false);
                }
            } else if (this.getCurrentState() != PlayerHitReactionState.instance() && this.getCurrentState() != PlayerFallDownState.instance() && this.getCurrentState() != PlayerOnGroundState.instance() && !this.isKnockedDown()) {
                if (f2 > 15.0f) {
                    this.setKnockedDown(true);
                    this.setReanimateTimer(20 + Rand.Next(60));
                }
                this.setHitReaction("HitReaction");
                this.actionContext.reportEvent("washit");
            }
        }
        return f2;
    }

    @Override
    public void update() {
        s_performance.update.invokeAndMeasure(this, IsoPlayer::updateInternal1);
    }

    private void updateInternal1() {
        if (GameClient.bClient && !this.isLocal() && System.currentTimeMillis() - this.lastRemoteUpdate > 5000L) {
            GameClient.receivePlayerTimeout(this.OnlineID);
        }
        if (this.replay != null) {
            this.replay.update();
        }
        boolean bl = this.updateInternal2();
        GameClient.instance.sendPlayer2(this);
        if (bl) {
            if (!this.bRemote) {
                this.updateLOS();
            }
            super.update();
        }
    }

    private void setBeenMovingSprinting() {
        if (this.isJustMoved()) {
            this.setBeenMovingFor(this.getBeenMovingFor() + 1.25f * GameTime.getInstance().getMultiplier());
        } else {
            this.setBeenMovingFor(this.getBeenMovingFor() - 0.625f * GameTime.getInstance().getMultiplier());
        }
        if (this.isJustMoved() && this.isSprinting()) {
            this.setBeenSprintingFor(this.getBeenSprintingFor() + 1.25f * GameTime.getInstance().getMultiplier());
        } else {
            this.setBeenSprintingFor(0.0f);
        }
    }

    private boolean updateInternal2() {
        float f;
        Object object;
        if (isTestAIMode) {
            this.isNPC = true;
        }
        if (!this.attackStarted) {
            this.setInitiateAttack(false);
            this.setAttackType(null);
        }
        this.runningTime = (this.isRunning() || this.isSprinting()) && this.getDeferredMovement(tempo).getLengthSquared() > 0.0f ? (this.runningTime += GameTime.getInstance().getMultiplier() / 1.6f) : 0.0f;
        if (this.getLastCollideTime() > 0.0f) {
            this.setLastCollideTime(this.getLastCollideTime() - GameTime.getInstance().getMultiplier() / 1.6f);
        }
        this.updateDeathDragDown();
        this.updateGodModeKey();
        if (GameClient.bClient) {
            this.networkAI.update();
        }
        this.doDeferredMovement();
        if (GameServer.bServer) {
            this.vehicle4testCollision = null;
        } else if (GameClient.bClient) {
            if (this.vehicle4testCollision != null) {
                if (!this.isLocal()) {
                    this.vehicle4testCollision.updateHitByVehicle(this);
                }
                this.vehicle4testCollision = null;
            }
        } else {
            this.updateHitByVehicle();
            this.vehicle4testCollision = null;
        }
        this.updateEmitter();
        this.updateMechanicsItems();
        this.updateHeavyBreathing();
        this.updateTemperatureCheck();
        this.updateAimingStance();
        if (SystemDisabler.doCharacterStats) {
            this.nutrition.update();
        }
        this.fitness.update();
        this.updateSoundListener();
        SafetySystemManager.update(this);
        if (!GameClient.bClient && !GameServer.bServer && this.bDeathFinished) {
            return false;
        }
        if (!GameClient.bClient && this.getCurrentBuildingDef() != null && !this.isInvisible()) {
            this.getCurrentBuildingDef().setHasBeenVisited(true);
        }
        if (this.checkSafehouse > 0 && GameServer.bServer) {
            --this.checkSafehouse;
            if (this.checkSafehouse == 0) {
                this.checkSafehouse = 200;
                SafeHouse safeHouse = SafeHouse.isSafeHouse(this.getCurrentSquare(), null, false);
                if (safeHouse != null) {
                    safeHouse.updateSafehouse(this);
                    safeHouse.checkTrespass(this);
                }
            }
        }
        if (this.bRemote && this.TimeSinceLastNetData > 600) {
            IsoWorld.instance.CurrentCell.getObjectList().remove(this);
            if (this.movingSq != null) {
                this.movingSq.getMovingObjects().remove(this);
            }
        }
        this.TimeSinceLastNetData = (int)((float)this.TimeSinceLastNetData + GameTime.instance.getMultiplier());
        this.TimeSinceOpenDoor += GameTime.instance.getMultiplier();
        this.lastTargeted += GameTime.instance.getMultiplier();
        this.targetedByZombie = false;
        this.checkActionGroup();
        if (this.updateRemotePlayer()) {
            if (this.updateWhileDead()) {
                return true;
            }
            this.updateHeartSound();
            this.checkIsNearWall();
            this.updateExt();
            this.setBeenMovingSprinting();
            return true;
        }
        assert (!GameServer.bServer);
        assert (!this.bRemote);
        assert (!GameClient.bClient || this.isLocalPlayer());
        IsoCamera.CamCharacter = this;
        instance = this;
        if (this.isLocalPlayer()) {
            IsoCamera.cameras[this.PlayerIndex].update();
            if (UIManager.getMoodleUI(this.PlayerIndex) != null) {
                UIManager.getMoodleUI(this.PlayerIndex).setCharacter(this);
            }
        }
        if (this.closestZombie > 1.2f) {
            this.slowTimer = -1.0f;
            this.slowFactor = 0.0f;
        }
        this.ContextPanic -= 1.5f * GameTime.instance.getTimeDelta();
        if (this.ContextPanic < 0.0f) {
            this.ContextPanic = 0.0f;
        }
        this.lastSeenZombieTime += (double)(GameTime.instance.getGameWorldSecondsSinceLastUpdate() / 60.0f / 60.0f);
        LuaEventManager.triggerEvent("OnPlayerUpdate", this);
        if (this.pressedMovement(false)) {
            this.ContextPanic = 0.0f;
            this.ticksSincePressedMovement = 0.0f;
        } else {
            this.ticksSincePressedMovement += GameTime.getInstance().getMultiplier() / 1.6f;
        }
        this.setVariable("pressedMovement", this.pressedMovement(true));
        if (this.updateWhileDead()) {
            return true;
        }
        this.updateHeartSound();
        this.updateEquippedBaggageContainer();
        this.updateWorldAmbiance();
        this.updateSneakKey();
        this.checkIsNearWall();
        this.updateExt();
        this.updateInteractKeyPanic();
        if (this.isAsleep()) {
            this.m_isPlayerMoving = false;
        }
        if (this.getVehicle() != null && this.getVehicle().isDriver(this) && this.getVehicle().hasHorn() && Core.getInstance().getKey("Shout") == Core.getInstance().getKey("VehicleHorn") || this.isAsleep() || this.PlayerIndex != 0 || this.Speaking || !GameKeyboard.isKeyDown(Core.getInstance().getKey("Shout")) || !this.isNPC) {
            // empty if block
        }
        if (this.getIgnoreMovement() || this.isAsleep()) {
            return true;
        }
        if (this.checkActionsBlockingMovement()) {
            if (this.getVehicle() != null && this.getVehicle().getDriver() == this && this.getVehicle().getController() != null) {
                this.getVehicle().getController().clientControls.reset();
                this.getVehicle().updatePhysics();
            }
            return true;
        }
        this.enterExitVehicle();
        this.checkActionGroup();
        this.checkReloading();
        this.checkWalkTo();
        if (this.checkActionsBlockingMovement()) {
            return true;
        }
        if (this.getVehicle() != null) {
            this.updateWhileInVehicle();
            return true;
        }
        this.checkVehicleContainers();
        this.setCollidable(true);
        this.updateCursorVisibility();
        this.bSeenThisFrame = false;
        this.bCouldBeSeenThisFrame = false;
        if (IsoCamera.CamCharacter == null && GameClient.bClient) {
            IsoCamera.CamCharacter = instance;
        }
        if (this.updateUseKey()) {
            return true;
        }
        this.updateEnableModelsKey();
        this.updateChangeCharacterKey();
        boolean bl = false;
        boolean bl2 = false;
        this.setRunning(false);
        this.setSprinting(false);
        this.useChargeTime = this.chargeTime;
        if (!this.isBlockMovement() && !this.isNPC) {
            this.chargeTime = this.isCharging || this.isChargingLT ? (this.chargeTime += 1.0f * GameTime.instance.getMultiplier()) : 0.0f;
            this.UpdateInputState(this.inputState);
            bl2 = this.inputState.bMelee;
            bl = this.inputState.isAttacking;
            this.setRunning(this.inputState.bRunning);
            this.setSprinting(this.inputState.bSprinting);
            if (this.isSprinting() && !this.isJustMoved()) {
                this.setSprinting(false);
            }
            if (this.isSprinting()) {
                this.setRunning(false);
            }
            if (this.inputState.bSprinting && !this.isSprinting()) {
                this.setRunning(true);
            }
            this.setIsAiming(this.inputState.isAiming);
            this.isCharging = this.inputState.isCharging;
            this.isChargingLT = this.inputState.isChargingLT;
            this.updateMovementRates();
            if (this.isAiming()) {
                this.StopAllActionQueueAiming();
            }
            if (bl) {
                this.setIsAiming(true);
            }
            this.Waiting = false;
            if (this.isAiming()) {
                this.setMoving(false);
                this.setRunning(false);
                this.setSprinting(false);
            }
            ++this.TicksSinceSeenZombie;
        }
        if ((double)this.playerMoveDir.x == 0.0 && (double)this.playerMoveDir.y == 0.0) {
            this.setForceRun(false);
            this.setForceSprint(false);
        }
        this.movementLastFrame.x = this.playerMoveDir.x;
        this.movementLastFrame.y = this.playerMoveDir.y;
        if (this.stateMachine.getCurrent() == StaggerBackState.instance() || this.stateMachine.getCurrent() == FakeDeadZombieState.instance() || UIManager.speedControls == null) {
            return true;
        }
        if (GameKeyboard.isKeyDown(88) && Translator.debug) {
            Translator.loadFiles();
        }
        this.setJustMoved(false);
        MoveVars moveVars = s_moveVars;
        this.updateMovementFromInput(moveVars);
        if (!this.JustMoved && this.hasPath() && !this.getPathFindBehavior2().bStopping) {
            this.JustMoved = true;
        }
        float f2 = moveVars.strafeX;
        float f3 = moveVars.strafeY;
        if (this.isJustMoved() && !this.isNPC && !this.hasPath()) {
            if (UIManager.getSpeedControls().getCurrentGameSpeed() > 1) {
                UIManager.getSpeedControls().SetCurrentGameSpeed(1);
            }
        } else if (this.stats.endurance < this.stats.endurancedanger && Rand.Next((int)(300.0f * GameTime.instance.getInvMultiplier())) == 0) {
            this.xp.AddXP(PerkFactory.Perks.Fitness, 1.0f);
        }
        this.setBeenMovingSprinting();
        float f4 = 1.0f;
        float f5 = 0.0f;
        if (this.isJustMoved() && !this.isNPC) {
            f5 = this.isRunning() || this.isSprinting() ? 1.5f : 1.0f;
        }
        if ((f4 *= f5) > 1.0f) {
            f4 *= this.getSprintMod();
        }
        if (f4 > 1.0f && this.Traits.Athletic.isSet()) {
            f4 *= 1.2f;
        }
        if (f4 > 1.0f) {
            if (this.Traits.Overweight.isSet()) {
                f4 *= 0.99f;
            }
            if (this.Traits.Obese.isSet()) {
                f4 *= 0.85f;
            }
            if (this.getNutrition().getWeight() > 120.0) {
                f4 *= 0.97f;
            }
            if (this.Traits.OutOfShape.isSet()) {
                f4 *= 0.99f;
            }
            if (this.Traits.Unfit.isSet()) {
                f4 *= 0.8f;
            }
        }
        this.updateEndurance(f4);
        if (this.isAiming() && this.isJustMoved()) {
            f4 *= 0.7f;
        }
        if (this.isAiming()) {
            f4 *= this.getNimbleMod();
        }
        this.isWalking = false;
        if (f4 > 0.0f && !this.isNPC) {
            this.isWalking = true;
            LuaEventManager.triggerEvent("OnPlayerMove", this);
        }
        if (this.isJustMoved()) {
            this.sprite.Animate = true;
        }
        if (this.isNPC && this.GameCharacterAIBrain != null) {
            bl2 = this.GameCharacterAIBrain.HumanControlVars.bMelee;
            this.bBannedAttacking = this.GameCharacterAIBrain.HumanControlVars.bBannedAttacking;
        }
        this.m_meleePressed = bl2;
        if (bl2) {
            if (!this.m_lastAttackWasShove) {
                this.setMeleeDelay(Math.min(this.getMeleeDelay(), 2.0f));
            }
            if (!this.bBannedAttacking && this.isAuthorizeShoveStomp() && this.CanAttack() && this.getMeleeDelay() <= 0.0f) {
                this.setDoShove(true);
                if (!this.isCharging && !this.isChargingLT) {
                    this.setIsAiming(false);
                }
                this.AttemptAttack(this.useChargeTime);
                this.useChargeTime = 0.0f;
                this.chargeTime = 0.0f;
            }
        } else if (this.isAiming() && this.CanAttack()) {
            if (this.DragCharacter != null) {
                this.DragObject = null;
                this.DragCharacter.Dragging = false;
                this.DragCharacter = null;
            }
            if (bl && !this.bBannedAttacking) {
                this.sprite.Animate = true;
                if (this.getRecoilDelay() <= 0.0f && this.getMeleeDelay() <= 0.0f) {
                    this.AttemptAttack(this.useChargeTime);
                }
                this.useChargeTime = 0.0f;
                this.chargeTime = 0.0f;
            }
        }
        if (this.isAiming() && !this.isNPC) {
            if (this.JoypadBind == -1 || this.bJoypadMovementActive) {
                object = tempVector2.set(0.0f, 0.0f);
                if (GameWindow.ActivatedJoyPad != null && this.JoypadBind != -1) {
                    this.getControllerAimDir((Vector2)object);
                } else {
                    this.getMouseAimVector((Vector2)object);
                }
                if (((Vector2)object).getLengthSquared() > 0.0f) {
                    this.DirectionFromVector((Vector2)object);
                    this.setForwardDirection((Vector2)object);
                }
            } else if (this.getForwardDirection().getLengthSquared() > 0.0f) {
                this.DirectionFromVector(this.getForwardDirection());
            }
            moveVars.NewFacing = this.dir;
        }
        if (this.getForwardDirection().x == 0.0f && this.getForwardDirection().y == 0.0f) {
            this.setForwardDirection(this.dir.ToVector());
        }
        if (this.lastAngle.x != this.getForwardDirection().x || this.lastAngle.y != this.getForwardDirection().y) {
            this.lastAngle.x = this.getForwardDirection().x;
            this.lastAngle.y = this.getForwardDirection().y;
            this.dirtyRecalcGridStackTime = 2.0f;
        }
        this.stats.endurance = PZMath.clamp(this.stats.endurance, 0.0f, 1.0f);
        object = this.getAnimationPlayer();
        if (object != null && ((AnimationPlayer)object).isReady()) {
            float f6 = ((AnimationPlayer)object).getAngle() + ((AnimationPlayer)object).getTwistAngle();
            this.dir = IsoDirections.fromAngle(tempVector2.setLengthAndDirection(f6, 1.0f));
        } else if (!(this.bFalling || this.isAiming() || bl)) {
            this.dir = moveVars.NewFacing;
        }
        if (this.isAiming() && (GameWindow.ActivatedJoyPad == null || this.JoypadBind == -1)) {
            this.playerMoveDir.x = moveVars.moveX;
            this.playerMoveDir.y = moveVars.moveY;
        }
        if (!this.isAiming() && this.isJustMoved()) {
            this.playerMoveDir.x = this.getForwardDirection().x;
            this.playerMoveDir.y = this.getForwardDirection().y;
        }
        this.CurrentSpeed = this.isJustMoved() ? (this.isSprinting() ? 1.5f : (this.isRunning() ? 1.0f : 0.5f)) : 0.0f;
        boolean bl3 = this.IsInMeleeAttack();
        if (!this.CharacterActions.isEmpty()) {
            BaseAction baseAction = (BaseAction)this.CharacterActions.get(0);
            if (baseAction.overrideAnimation) {
                bl3 = true;
            }
        }
        if (!bl3 && !this.isForceOverrideAnim()) {
            if (this.getPath2() == null) {
                if (this.CurrentSpeed > 0.0f && (!this.bClimbing || this.lastFallSpeed > 0.0f)) {
                    if (this.isRunning() || this.isSprinting()) {
                        this.StopAllActionQueueRunning();
                    } else {
                        this.StopAllActionQueueWalking();
                    }
                }
            } else {
                this.StopAllActionQueueWalking();
            }
        }
        if (this.slowTimer > 0.0f) {
            this.slowTimer -= GameTime.instance.getRealworldSecondsSinceLastUpdate();
            this.CurrentSpeed *= 1.0f - this.slowFactor;
            this.slowFactor -= GameTime.instance.getMultiplier() / 100.0f;
            if (this.slowFactor < 0.0f) {
                this.slowFactor = 0.0f;
            }
        } else {
            this.slowFactor = 0.0f;
        }
        this.playerMoveDir.setLength(this.CurrentSpeed);
        if (this.playerMoveDir.x != 0.0f || this.playerMoveDir.y != 0.0f) {
            this.dirtyRecalcGridStackTime = 10.0f;
        }
        if (this.getPath2() != null && this.current != this.last) {
            this.dirtyRecalcGridStackTime = 10.0f;
        }
        this.closestZombie = 1000000.0f;
        this.weight = 0.3f;
        this.separate();
        this.updateSleepingPillsTaken();
        this.updateTorchStrength();
        if (this.isNPC && this.GameCharacterAIBrain != null) {
            this.GameCharacterAIBrain.postUpdateHuman(this);
            this.setInitiateAttack(this.GameCharacterAIBrain.HumanControlVars.initiateAttack);
            this.setRunning(this.GameCharacterAIBrain.HumanControlVars.bRunning);
            f2 = this.GameCharacterAIBrain.HumanControlVars.strafeX;
            f3 = this.GameCharacterAIBrain.HumanControlVars.strafeY;
            this.setJustMoved(this.GameCharacterAIBrain.HumanControlVars.JustMoved);
            this.updateMovementRates();
        }
        this.m_isPlayerMoving = this.isJustMoved() || this.getPath2() != null && !this.getPathFindBehavior2().bStopping;
        boolean bl4 = this.isInTrees();
        if (bl4) {
            f = "parkranger".equals(this.getDescriptor().getProfession()) ? 1.3f : 1.0f;
            float f7 = f = "lumberjack".equals(this.getDescriptor().getProfession()) ? 1.15f : f;
            if (this.isRunning()) {
                f *= 1.1f;
            }
            this.setVariable("WalkSpeedTrees", f);
        }
        if ((bl4 || this.m_walkSpeed < 0.4f || this.m_walkInjury > 0.5f) && this.isSprinting() && !this.isGhostMode()) {
            if ((double)this.runSpeedModifier < 1.0) {
                this.setMoodleCantSprint(true);
            }
            this.setSprinting(false);
            this.setRunning(true);
            if (this.isInTreesNoBush()) {
                this.setForceSprint(false);
                this.setBumpType("left");
                this.setVariable("BumpDone", false);
                this.setVariable("BumpFall", true);
                this.setVariable("TripObstacleType", "tree");
                this.actionContext.reportEvent("wasBumped");
            }
        }
        this.m_deltaX = f2;
        this.m_deltaY = f3;
        this.m_windspeed = ClimateManager.getInstance().getWindSpeedMovement();
        f = this.getForwardDirection().getDirectionNeg();
        this.m_windForce = ClimateManager.getInstance().getWindForceMovement(this, f);
        return true;
    }

    private void updateMovementFromInput(MoveVars moveVars) {
        moveVars.moveX = 0.0f;
        moveVars.moveY = 0.0f;
        moveVars.strafeX = 0.0f;
        moveVars.strafeY = 0.0f;
        moveVars.NewFacing = this.dir;
        if (TutorialManager.instance.StealControl) {
            return;
        }
        if (this.isBlockMovement()) {
            return;
        }
        if (this.isNPC) {
            return;
        }
        if (MPDebugAI.updateMovementFromInput(this, moveVars)) {
            return;
        }
        if (this.fallTime > 2.0f) {
            return;
        }
        if (GameWindow.ActivatedJoyPad != null && this.JoypadBind != -1) {
            this.updateMovementFromJoypad(moveVars);
        }
        if (this.PlayerIndex == 0 && this.JoypadBind == -1) {
            this.updateMovementFromKeyboardMouse(moveVars);
        }
        if (this.isJustMoved()) {
            this.getForwardDirection().normalize();
            UIManager.speedControls.SetCurrentGameSpeed(1);
        }
    }

    private void updateMovementFromJoypad(MoveVars moveVars) {
        Object object;
        this.playerMoveDir.x = 0.0f;
        this.playerMoveDir.y = 0.0f;
        this.getJoypadAimVector(tempVector2);
        float f = IsoPlayer.tempVector2.x;
        float f2 = IsoPlayer.tempVector2.y;
        Vector2 vector22 = this.getJoypadMoveVector(tempVector2);
        if (vector22.getLength() > 1.0f) {
            vector22.setLength(1.0f);
        }
        if (this.isAutoWalk()) {
            if (vector22.getLengthSquared() < 0.25f) {
                vector22.set(this.getAutoWalkDirection());
            } else {
                this.setAutoWalkDirection(vector22);
                this.getAutoWalkDirection().normalize();
            }
        }
        float f3 = vector22.x;
        float f4 = vector22.y;
        if (Math.abs(f3) > 0.0f) {
            this.playerMoveDir.x += 0.04f * f3;
            this.playerMoveDir.y -= 0.04f * f3;
            this.setJustMoved(true);
        }
        if (Math.abs(f4) > 0.0f) {
            this.playerMoveDir.y += 0.04f * f4;
            this.playerMoveDir.x += 0.04f * f4;
            this.setJustMoved(true);
        }
        this.playerMoveDir.setLength(0.05f * (float)Math.pow(vector22.getLength(), 9.0));
        if (f != 0.0f || f2 != 0.0f) {
            object = tempVector2.set(f, f2);
            ((Vector2)object).normalize();
            moveVars.NewFacing = IsoDirections.fromAngle((Vector2)object);
        } else if ((f3 != 0.0f || f4 != 0.0f) && this.playerMoveDir.getLengthSquared() > 0.0f) {
            vector22 = tempVector2.set(this.playerMoveDir);
            vector22.normalize();
            moveVars.NewFacing = IsoDirections.fromAngle(vector22);
        }
        object = this.getPathFindBehavior2();
        if (this.playerMoveDir.x == 0.0f && this.playerMoveDir.y == 0.0f && this.getPath2() != null && ((PathFindBehavior2)object).isStrafing() && !((PathFindBehavior2)object).bStopping) {
            this.playerMoveDir.set(((PathFindBehavior2)object).getTargetX() - this.x, ((PathFindBehavior2)object).getTargetY() - this.y);
            this.playerMoveDir.normalize();
        }
        if (this.playerMoveDir.x != 0.0f || this.playerMoveDir.y != 0.0f) {
            if (this.isStrafing()) {
                tempo.set(this.playerMoveDir.x, -this.playerMoveDir.y);
                tempo.normalize();
                float f5 = this.legsSprite.modelSlot.model.AnimPlayer.getRenderedAngle();
                if ((double)f5 > Math.PI * 2) {
                    f5 = (float)((double)f5 - Math.PI * 2);
                }
                if (f5 < 0.0f) {
                    f5 = (float)((double)f5 + Math.PI * 2);
                }
                tempo.rotate(f5);
                moveVars.strafeX = IsoPlayer.tempo.x;
                moveVars.strafeY = IsoPlayer.tempo.y;
                this.m_IPX = this.playerMoveDir.x;
                this.m_IPY = this.playerMoveDir.y;
            } else {
                moveVars.moveX = this.playerMoveDir.x;
                moveVars.moveY = this.playerMoveDir.y;
                tempo.set(this.playerMoveDir);
                tempo.normalize();
                this.setForwardDirection(tempo);
            }
        }
    }

    private void updateMovementFromKeyboardMouse(MoveVars moveVars) {
        int n = Core.getInstance().getKey(leftStr);
        int n2 = Core.getInstance().getKey(rightStr);
        int n3 = Core.getInstance().getKey(forwardStr);
        int n4 = Core.getInstance().getKey(backwardStr);
        boolean bl = GameKeyboard.isKeyDown(n);
        boolean bl2 = GameKeyboard.isKeyDown(n2);
        boolean bl3 = GameKeyboard.isKeyDown(n3);
        boolean bl4 = GameKeyboard.isKeyDown(n4);
        if ((bl || bl2 || bl3 || bl4) && (n == 30 || n2 == 30 || n3 == 30 || n4 == 30) && (GameKeyboard.isKeyDown(29) || GameKeyboard.isKeyDown(157)) && UIManager.isMouseOverInventory() && Core.getInstance().isSelectingAll()) {
            return;
        }
        if (!this.isIgnoreInputsForDirection()) {
            if (Core.bAltMoveMethod) {
                if (bl && !bl2) {
                    moveVars.moveX -= 0.04f;
                    moveVars.NewFacing = IsoDirections.W;
                }
                if (bl2 && !bl) {
                    moveVars.moveX += 0.04f;
                    moveVars.NewFacing = IsoDirections.E;
                }
                if (bl3 && !bl4) {
                    moveVars.moveY -= 0.04f;
                    moveVars.NewFacing = moveVars.NewFacing == IsoDirections.W ? IsoDirections.NW : (moveVars.NewFacing == IsoDirections.E ? IsoDirections.NE : IsoDirections.N);
                }
                if (bl4 && !bl3) {
                    moveVars.moveY += 0.04f;
                    moveVars.NewFacing = moveVars.NewFacing == IsoDirections.W ? IsoDirections.SW : (moveVars.NewFacing == IsoDirections.E ? IsoDirections.SE : IsoDirections.S);
                }
            } else {
                if (bl) {
                    moveVars.moveX = -1.0f;
                } else if (bl2) {
                    moveVars.moveX = 1.0f;
                }
                if (bl3) {
                    moveVars.moveY = 1.0f;
                } else if (bl4) {
                    moveVars.moveY = -1.0f;
                }
                if (moveVars.moveX != 0.0f || moveVars.moveY != 0.0f) {
                    tempo.set(moveVars.moveX, moveVars.moveY);
                    tempo.normalize();
                    moveVars.NewFacing = IsoDirections.fromAngle(tempo);
                }
            }
        }
        PathFindBehavior2 pathFindBehavior2 = this.getPathFindBehavior2();
        if (moveVars.moveX == 0.0f && moveVars.moveY == 0.0f && this.getPath2() != null && (pathFindBehavior2.isStrafing() || this.isAiming()) && !pathFindBehavior2.bStopping) {
            Vector2 vector22 = tempo.set(pathFindBehavior2.getTargetX() - this.x, pathFindBehavior2.getTargetY() - this.y);
            Vector2 vector23 = tempo2.set(-1.0f, 0.0f);
            float f = 1.0f;
            float f2 = vector22.dot(vector23);
            float f3 = f2 / f;
            vector23 = tempo2.set(0.0f, -1.0f);
            f2 = vector22.dot(vector23);
            float f4 = f2 / f;
            tempo.set(f4, f3);
            tempo.normalize();
            tempo.rotate(0.7853982f);
            moveVars.moveX = IsoPlayer.tempo.x;
            moveVars.moveY = IsoPlayer.tempo.y;
        }
        if (moveVars.moveX != 0.0f || moveVars.moveY != 0.0f) {
            if (this.stateMachine.getCurrent() == PathFindState.instance()) {
                this.setDefaultState();
            }
            this.setJustMoved(true);
            this.setMoveDelta(1.0f);
            if (this.isStrafing()) {
                tempo.set(moveVars.moveX, moveVars.moveY);
                tempo.normalize();
                float f = this.legsSprite.modelSlot.model.AnimPlayer.getRenderedAngle();
                f = (float)((double)f + 0.7853981633974483);
                if ((double)f > Math.PI * 2) {
                    f = (float)((double)f - Math.PI * 2);
                }
                if (f < 0.0f) {
                    f = (float)((double)f + Math.PI * 2);
                }
                tempo.rotate(f);
                moveVars.strafeX = IsoPlayer.tempo.x;
                moveVars.strafeY = IsoPlayer.tempo.y;
                this.m_IPX = moveVars.moveX;
                this.m_IPY = moveVars.moveY;
            } else {
                tempo.set(moveVars.moveX, -moveVars.moveY);
                tempo.normalize();
                tempo.rotate(-0.7853982f);
                this.setForwardDirection(tempo);
            }
        }
    }

    private void updateAimingStance() {
        boolean bl;
        HitInfo hitInfo;
        if (this.isVariable("LeftHandMask", "RaiseHand")) {
            this.clearVariable("LeftHandMask");
        }
        if (!this.isAiming() || this.isCurrentState(SwipeStatePlayer.instance())) {
            return;
        }
        HandWeapon handWeapon = Type.tryCastTo(this.getPrimaryHandItem(), HandWeapon.class);
        handWeapon = handWeapon == null ? this.bareHands : handWeapon;
        SwipeStatePlayer.instance().calcValidTargets(this, handWeapon, true, s_targetsProne, s_targetsStanding);
        HitInfo hitInfo2 = s_targetsStanding.isEmpty() ? null : s_targetsStanding.get(0);
        HitInfo hitInfo3 = hitInfo = s_targetsProne.isEmpty() ? null : s_targetsProne.get(0);
        if (SwipeStatePlayer.instance().isProneTargetBetter(this, hitInfo2, hitInfo)) {
            hitInfo2 = null;
        }
        boolean bl2 = bl = this.isAttackAnim() || this.getVariableBoolean("ShoveAnim") || this.getVariableBoolean("StompAnim");
        if (!bl) {
            this.setAimAtFloor(false);
        }
        if (hitInfo2 != null) {
            if (!bl) {
                this.setAimAtFloor(false);
            }
        } else if (hitInfo != null && !bl) {
            this.setAimAtFloor(true);
        }
        if (hitInfo2 != null) {
            boolean bl3;
            boolean bl4 = bl3 = !this.isAttackAnim() && handWeapon.getSwingAnim() != null && handWeapon.CloseKillMove != null && hitInfo2.distSq < handWeapon.getMinRange() * handWeapon.getMinRange();
            if (bl3 && (this.getSecondaryHandItem() == null || this.getSecondaryHandItem().getItemReplacementSecondHand() == null)) {
                this.setVariable("LeftHandMask", "RaiseHand");
            }
        }
        SwipeStatePlayer.instance().hitInfoPool.release((List<HitInfo>)s_targetsStanding);
        SwipeStatePlayer.instance().hitInfoPool.release((List<HitInfo>)s_targetsProne);
        s_targetsStanding.clear();
        s_targetsProne.clear();
    }

    @Override
    protected void calculateStats() {
        if (this.bRemote) {
            return;
        }
        super.calculateStats();
    }

    @Override
    protected void updateStats_Sleeping() {
        boolean bl;
        float f;
        float f2;
        float f3 = 2.0f;
        if (IsoPlayer.allPlayersAsleep()) {
            f3 *= GameTime.instance.getDeltaMinutesPerDay();
        }
        this.stats.endurance = (float)((double)this.stats.endurance + ZomboidGlobals.ImobileEnduranceReduce * SandboxOptions.instance.getEnduranceRegenMultiplier() * (double)this.getRecoveryMod() * (double)GameTime.instance.getMultiplier() * (double)f3);
        if (this.stats.endurance > 1.0f) {
            this.stats.endurance = 1.0f;
        }
        if (this.stats.fatigue > 0.0f) {
            f2 = 1.0f;
            if (this.Traits.Insomniac.isSet()) {
                f2 *= 0.5f;
            }
            if (this.Traits.NightOwl.isSet()) {
                f2 *= 1.4f;
            }
            f = 1.0f;
            if ("goodBed".equals(this.getBedType())) {
                f = 1.1f;
            }
            if ("badBed".equals(this.getBedType())) {
                f = 0.9f;
            }
            if ("floor".equals(this.getBedType())) {
                f = 0.6f;
            }
            float f4 = 1.0f / GameTime.instance.getMinutesPerDay() / 60.0f * GameTime.instance.getMultiplier() / 2.0f;
            this.timeOfSleep += f4;
            if (this.timeOfSleep > this.delayToActuallySleep) {
                float f5 = 1.0f;
                if (this.Traits.NeedsLessSleep.isSet()) {
                    f5 *= 0.75f;
                } else if (this.Traits.NeedsMoreSleep.isSet()) {
                    f5 *= 1.18f;
                }
                float f6 = 1.0f;
                if (this.stats.fatigue <= 0.3f) {
                    f6 = 7.0f * f5;
                    this.stats.fatigue -= f4 / f6 * 0.3f * f2 * f;
                } else {
                    f6 = 5.0f * f5;
                    this.stats.fatigue -= f4 / f6 * 0.7f * f2 * f;
                }
            }
            if (this.stats.fatigue < 0.0f) {
                this.stats.fatigue = 0.0f;
            }
        }
        if (this.Moodles.getMoodleLevel(MoodleType.FoodEaten) == 0) {
            f2 = this.getAppetiteMultiplier();
            this.stats.hunger = (float)((double)this.stats.hunger + ZomboidGlobals.HungerIncreaseWhileAsleep * SandboxOptions.instance.getStatsDecreaseMultiplier() * (double)f2 * (double)GameTime.instance.getMultiplier() * (double)GameTime.instance.getDeltaMinutesPerDay() * this.getHungerMultiplier());
        } else {
            this.stats.hunger += (float)(ZomboidGlobals.HungerIncreaseWhenWellFed * SandboxOptions.instance.getStatsDecreaseMultiplier() * ZomboidGlobals.HungerIncreaseWhileAsleep * SandboxOptions.instance.getStatsDecreaseMultiplier() * (double)GameTime.instance.getMultiplier() * this.getHungerMultiplier() * (double)GameTime.instance.getDeltaMinutesPerDay());
        }
        if (this.ForceWakeUpTime == 0.0f) {
            this.ForceWakeUpTime = 9.0f;
        }
        f2 = GameTime.getInstance().getTimeOfDay();
        f = GameTime.getInstance().getLastTimeOfDay();
        if (f > f2) {
            if (f < this.ForceWakeUpTime) {
                f2 += 24.0f;
            } else {
                f -= 24.0f;
            }
        }
        boolean bl2 = bl = f2 >= this.ForceWakeUpTime && f < this.ForceWakeUpTime;
        if (this.getAsleepTime() > 16.0f) {
            bl = true;
        }
        if (GameClient.bClient || numPlayers > 1) {
            boolean bl3 = bl = bl || this.pressedAim() || this.pressedMovement(false);
        }
        if (this.ForceWakeUp) {
            bl = true;
        }
        if (this.Asleep && bl) {
            this.ForceWakeUp = false;
            SoundManager.instance.setMusicWakeState(this, "WakeNormal");
            SleepingEvent.instance.wakeUp(this);
            this.ForceWakeUpTime = -1.0f;
            if (GameClient.bClient) {
                GameClient.instance.sendPlayer(this);
            }
            this.dirtyRecalcGridStackTime = 20.0f;
        }
    }

    public void updateEnduranceWhileSitting() {
        float f = (float)ZomboidGlobals.SittingEnduranceMultiplier;
        f *= 1.0f - this.stats.fatigue;
        this.stats.endurance = (float)((double)this.stats.endurance + ZomboidGlobals.ImobileEnduranceReduce * SandboxOptions.instance.getEnduranceRegenMultiplier() * (double)this.getRecoveryMod() * (double)(f *= GameTime.instance.getMultiplier()));
        this.stats.endurance = PZMath.clamp(this.stats.endurance, 0.0f, 1.0f);
    }

    private void updateEndurance(float f) {
        if (this.isSitOnGround()) {
            this.updateEnduranceWhileSitting();
            return;
        }
        float f2 = 1.0f;
        if (this.isSneaking()) {
            f2 = 1.5f;
        }
        if (this.CurrentSpeed > 0.0f && (this.isRunning() || this.isSprinting())) {
            double d = ZomboidGlobals.RunningEnduranceReduce;
            if (this.isSprinting()) {
                d = ZomboidGlobals.SprintingEnduranceReduce;
            }
            float f3 = 1.4f;
            if (this.Traits.Overweight.isSet()) {
                f3 = 2.9f;
            }
            if (this.Traits.Athletic.isSet()) {
                f3 = 0.8f;
            }
            f3 *= 2.3f;
            f3 *= this.getPacingMod();
            f3 *= this.getHyperthermiaMod();
            float f4 = 0.7f;
            if (this.Traits.Asthmatic.isSet()) {
                f4 = 1.4f;
            }
            if (this.Moodles.getMoodleLevel(MoodleType.HeavyLoad) == 0) {
                this.stats.endurance = (float)((double)this.stats.endurance - d * (double)f3 * 0.5 * (double)f4 * (double)GameTime.instance.getMultiplier() * (double)f2);
            } else {
                float f5 = 2.8f;
                switch (this.Moodles.getMoodleLevel(MoodleType.HeavyLoad)) {
                    case 1: {
                        f5 = 1.5f;
                        break;
                    }
                    case 2: {
                        f5 = 1.9f;
                        break;
                    }
                    case 3: {
                        f5 = 2.3f;
                    }
                }
                this.stats.endurance = (float)((double)this.stats.endurance - d * (double)f3 * 0.5 * (double)f4 * (double)GameTime.instance.getMultiplier() * (double)f5 * (double)f2);
            }
        } else if (this.CurrentSpeed > 0.0f && this.Moodles.getMoodleLevel(MoodleType.HeavyLoad) > 2) {
            float f6 = 0.7f;
            if (this.Traits.Asthmatic.isSet()) {
                f6 = 1.4f;
            }
            float f7 = 1.4f;
            if (this.Traits.Overweight.isSet()) {
                f7 = 2.9f;
            }
            if (this.Traits.Athletic.isSet()) {
                f7 = 0.8f;
            }
            f7 *= 3.0f;
            f7 *= this.getPacingMod();
            f7 *= this.getHyperthermiaMod();
            float f8 = 2.8f;
            switch (this.Moodles.getMoodleLevel(MoodleType.HeavyLoad)) {
                case 2: {
                    f8 = 1.5f;
                    break;
                }
                case 3: {
                    f8 = 1.9f;
                    break;
                }
                case 4: {
                    f8 = 2.3f;
                }
            }
            this.stats.endurance = (float)((double)this.stats.endurance - ZomboidGlobals.RunningEnduranceReduce * (double)f7 * 0.5 * (double)f6 * (double)f2 * (double)GameTime.instance.getMultiplier() * (double)f8 / 2.0);
        }
        switch (this.Moodles.getMoodleLevel(MoodleType.Endurance)) {
            case 1: {
                f *= 0.95f;
                break;
            }
            case 2: {
                f *= 0.9f;
                break;
            }
            case 3: {
                f *= 0.8f;
                break;
            }
            case 4: {
                f *= 0.6f;
            }
        }
        if (this.stats.enduranceRecharging) {
            f *= 0.85f;
        }
        if (!this.isPlayerMoving()) {
            float f9 = 1.0f;
            f9 *= 1.0f - this.stats.fatigue;
            f9 *= GameTime.instance.getMultiplier();
            if (this.Moodles.getMoodleLevel(MoodleType.HeavyLoad) <= 1) {
                this.stats.endurance = (float)((double)this.stats.endurance + ZomboidGlobals.ImobileEnduranceReduce * SandboxOptions.instance.getEnduranceRegenMultiplier() * (double)this.getRecoveryMod() * (double)f9);
            }
        }
        if (!this.isSprinting() && !this.isRunning() && this.CurrentSpeed > 0.0f) {
            float f10 = 1.0f;
            f10 *= 1.0f - this.stats.fatigue;
            f10 *= GameTime.instance.getMultiplier();
            if (this.getMoodles().getMoodleLevel(MoodleType.Endurance) < 2) {
                if (this.Moodles.getMoodleLevel(MoodleType.HeavyLoad) <= 1) {
                    this.stats.endurance = (float)((double)this.stats.endurance + ZomboidGlobals.ImobileEnduranceReduce / 4.0 * SandboxOptions.instance.getEnduranceRegenMultiplier() * (double)this.getRecoveryMod() * (double)f10);
                }
            } else {
                this.stats.endurance = (float)((double)this.stats.endurance - ZomboidGlobals.RunningEnduranceReduce / 7.0 * (double)f2);
            }
        }
    }

    private boolean checkActionsBlockingMovement() {
        if (this.CharacterActions.isEmpty()) {
            return false;
        }
        BaseAction baseAction = (BaseAction)this.CharacterActions.get(0);
        return baseAction.blockMovementEtc;
    }

    private void updateInteractKeyPanic() {
        if (this.PlayerIndex != 0) {
            return;
        }
        if (GameKeyboard.isKeyPressed(Core.getInstance().getKey("Interact"))) {
            this.ContextPanic += 0.6f;
        }
    }

    private void updateSneakKey() {
        if (this.PlayerIndex != 0) {
            this.bSneakDebounce = false;
            return;
        }
        if (!this.isBlockMovement() && GameKeyboard.isKeyDown(Core.getInstance().getKey("Crouch"))) {
            if (!this.bSneakDebounce) {
                this.setSneaking(!this.isSneaking());
                this.bSneakDebounce = true;
            }
        } else {
            this.bSneakDebounce = false;
        }
    }

    private void updateChangeCharacterKey() {
        if (!Core.bDebug) {
            return;
        }
        if (this.PlayerIndex != 0 || !GameKeyboard.isKeyDown(22)) {
            this.bChangeCharacterDebounce = false;
            return;
        }
        if (this.bChangeCharacterDebounce) {
            return;
        }
        this.FollowCamStack.clear();
        this.bChangeCharacterDebounce = true;
        for (int i = 0; i < this.getCell().getObjectList().size(); ++i) {
            IsoMovingObject isoMovingObject = this.getCell().getObjectList().get(i);
            if (!(isoMovingObject instanceof IsoSurvivor)) continue;
            this.FollowCamStack.add((IsoSurvivor)isoMovingObject);
        }
        if (!this.FollowCamStack.isEmpty()) {
            if (this.followID >= this.FollowCamStack.size()) {
                this.followID = 0;
            }
            IsoCamera.SetCharacterToFollow((IsoGameCharacter)this.FollowCamStack.get(this.followID));
            ++this.followID;
        }
    }

    private void updateEnableModelsKey() {
        if (!Core.bDebug) {
            return;
        }
        if (this.PlayerIndex == 0 && GameKeyboard.isKeyPressed(Core.getInstance().getKey("ToggleModelsEnabled"))) {
            ModelManager.instance.bDebugEnableModels = !ModelManager.instance.bDebugEnableModels;
        }
    }

    private void updateDeathDragDown() {
        if (this.isDead()) {
            return;
        }
        if (!this.isDeathDragDown()) {
            return;
        }
        if (this.isGodMod()) {
            this.setDeathDragDown(false);
            return;
        }
        if ("EndDeath".equals(this.getHitReaction())) {
            return;
        }
        for (int i = -1; i <= 1; ++i) {
            for (int j = -1; j <= 1; ++j) {
                IsoGridSquare isoGridSquare = this.getCell().getGridSquare((int)this.x + j, (int)this.y + i, (int)this.z);
                if (isoGridSquare == null) continue;
                for (int k = 0; k < isoGridSquare.getMovingObjects().size(); ++k) {
                    IsoMovingObject isoMovingObject = isoGridSquare.getMovingObjects().get(k);
                    IsoZombie isoZombie = Type.tryCastTo(isoMovingObject, IsoZombie.class);
                    if (isoZombie == null || !isoZombie.isAlive() || isoZombie.isOnFloor()) continue;
                    this.setAttackedBy(isoZombie);
                    this.setHitReaction("EndDeath");
                    this.setBlockMovement(true);
                    return;
                }
            }
        }
        this.setDeathDragDown(false);
        if (GameClient.bClient) {
            DebugLog.Multiplayer.warn("UpdateDeathDragDown: no zombies found around player \"%s\"", this.getUsername());
            this.setHitFromBehind(false);
            this.Kill(null);
        }
    }

    private void updateGodModeKey() {
        int n;
        if (!Core.bDebug) {
            return;
        }
        if (!GameKeyboard.isKeyPressed(Core.getInstance().getKey("ToggleGodModeInvisible"))) {
            return;
        }
        IsoGameCharacter isoGameCharacter = null;
        for (n = 0; n < numPlayers; n += 1) {
            if (players[n] == null || players[n].isDead()) continue;
            isoGameCharacter = players[n];
            break;
        }
        if (this == isoGameCharacter) {
            n = !isoGameCharacter.isGodMod() ? 1 : 0;
            DebugLog.General.println("Toggle GodMode: %s", n != 0 ? "ON" : "OFF");
            isoGameCharacter.setInvisible(n != 0);
            ((IsoPlayer)isoGameCharacter).setGhostMode(n != 0);
            isoGameCharacter.setGodMod(n != 0);
            for (int i = 0; i < numPlayers; ++i) {
                if (players[i] == null || players[i] == isoGameCharacter) continue;
                players[i].setInvisible(n != 0);
                players[i].setGhostMode(n != 0);
                players[i].setGodMod(n != 0);
            }
            if (GameClient.bClient) {
                GameClient.sendPlayerExtraInfo((IsoPlayer)isoGameCharacter);
            }
        }
    }

    private void checkReloading() {
        boolean bl;
        HandWeapon handWeapon = Type.tryCastTo(this.getPrimaryHandItem(), HandWeapon.class);
        if (handWeapon == null || !handWeapon.isReloadable(this)) {
            return;
        }
        boolean bl2 = false;
        boolean bl3 = false;
        if (this.JoypadBind != -1 && this.bJoypadMovementActive) {
            bl = JoypadManager.instance.isRBPressed(this.JoypadBind);
            if (bl) {
                bl2 = !this.bReloadButtonDown;
            }
            this.bReloadButtonDown = bl;
            bl = JoypadManager.instance.isLBPressed(this.JoypadBind);
            if (bl) {
                bl3 = !this.bRackButtonDown;
            }
            this.bRackButtonDown = bl;
        }
        if (this.PlayerIndex == 0) {
            bl = GameKeyboard.isKeyDown(Core.getInstance().getKey("ReloadWeapon"));
            if (bl) {
                bl2 = !this.bReloadKeyDown;
            }
            this.bReloadKeyDown = bl;
            bl = GameKeyboard.isKeyDown(Core.getInstance().getKey("Rack Firearm"));
            if (bl) {
                bl3 = !this.bRackKeyDown;
            }
            this.bRackKeyDown = bl;
        }
        if (bl2) {
            this.setVariable("WeaponReloadType", handWeapon.getWeaponReloadType());
            LuaEventManager.triggerEvent("OnPressReloadButton", this, handWeapon);
        } else if (bl3) {
            this.setVariable("WeaponReloadType", handWeapon.getWeaponReloadType());
            LuaEventManager.triggerEvent("OnPressRackButton", this, handWeapon);
        }
    }

    @Override
    public void postupdate() {
        s_performance.postUpdate.invokeAndMeasure(this, IsoPlayer::postupdateInternal);
    }

    private void postupdateInternal() {
        boolean bl = this.hasHitReaction();
        super.postupdate();
        if (bl && this.hasHitReaction() && !this.isCurrentState(PlayerHitReactionState.instance()) && !this.isCurrentState(PlayerHitReactionPVPState.instance())) {
            this.setHitReaction("");
        }
        this.highlightRangedTargets();
        if (this.isNPC) {
            GameTime gameTime = GameTime.getInstance();
            float f = 1.0f / gameTime.getMinutesPerDay() / 60.0f * gameTime.getMultiplier() / 2.0f;
            if (Core.bLastStand) {
                f = 1.0f / gameTime.getMinutesPerDay() / 60.0f * gameTime.getUnmoddedMultiplier() / 2.0f;
            }
            this.setHoursSurvived(this.getHoursSurvived() + (double)f);
        }
        this.getBodyDamage().setBodyPartsLastState();
    }

    private void highlightRangedTargets() {
        if (!this.isLocalPlayer() || this.isNPC) {
            return;
        }
        if (!this.isAiming()) {
            return;
        }
        if (Core.getInstance().getOptionAimOutline() == 1) {
            return;
        }
        s_performance.highlightRangedTargets.invokeAndMeasure(this, IsoPlayer::highlightRangedTargetsInternal);
    }

    private void highlightRangedTargetsInternal() {
        HandWeapon handWeapon = Type.tryCastTo(this.getPrimaryHandItem(), HandWeapon.class);
        if (handWeapon == null || handWeapon.getSwingAnim() == null || handWeapon.getCondition() <= 0) {
            handWeapon = this.bareHands;
        }
        if (Core.getInstance().getOptionAimOutline() == 2 && !handWeapon.isRanged()) {
            return;
        }
        AttackVars attackVars = new AttackVars();
        ArrayList<HitInfo> arrayList = new ArrayList<HitInfo>();
        boolean bl = this.bDoShove;
        HandWeapon handWeapon2 = this.getUseHandWeapon();
        this.setDoShove(false);
        this.setUseHandWeapon(handWeapon);
        SwipeStatePlayer.instance().CalcAttackVars(this, attackVars);
        SwipeStatePlayer.instance().CalcHitList(this, false, attackVars, arrayList);
        for (int i = 0; i < arrayList.size(); ++i) {
            HitInfo hitInfo = arrayList.get(i);
            IsoMovingObject isoMovingObject = hitInfo.getObject();
            if (isoMovingObject instanceof IsoZombie || isoMovingObject instanceof IsoPlayer) {
                ColorInfo colorInfo = new ColorInfo();
                Core.getInstance().getBadHighlitedColor().interp(Core.getInstance().getGoodHighlitedColor(), (float)hitInfo.chance / 100.0f, colorInfo);
                isoMovingObject.bOutline[this.PlayerIndex] = true;
                if (isoMovingObject.outlineColor[this.PlayerIndex] == null) {
                    isoMovingObject.outlineColor[this.PlayerIndex] = new ColorInfo();
                }
                isoMovingObject.outlineColor[this.PlayerIndex].set(colorInfo);
            }
            if (hitInfo.window.getObject() == null) continue;
            hitInfo.window.getObject().setHighlightColor(0.8f, 0.1f, 0.1f, 0.5f);
            hitInfo.window.getObject().setHighlighted(true);
        }
        this.setDoShove(bl);
        this.setUseHandWeapon(handWeapon2);
    }

    @Override
    public boolean isSolidForSeparate() {
        if (this.isGhostMode()) {
            return false;
        }
        return super.isSolidForSeparate();
    }

    @Override
    public boolean isPushableForSeparate() {
        if (this.isCurrentState(PlayerHitReactionState.instance())) {
            return false;
        }
        if (this.isCurrentState(SwipeStatePlayer.instance())) {
            return false;
        }
        return super.isPushableForSeparate();
    }

    @Override
    public boolean isPushedByForSeparate(IsoMovingObject isoMovingObject) {
        if (!this.isPlayerMoving() && isoMovingObject.isZombie() && ((IsoZombie)isoMovingObject).isAttacking()) {
            return false;
        }
        if (!(!GameClient.bClient || this.isLocalPlayer() && this.isJustMoved())) {
            return false;
        }
        return super.isPushedByForSeparate(isoMovingObject);
    }

    private void updateExt() {
        if (this.isSneaking()) {
            return;
        }
        this.extUpdateCount += GameTime.getInstance().getMultiplier() / 0.8f;
        if (!this.getAdvancedAnimator().containsAnyIdleNodes() && !this.isSitOnGround()) {
            this.extUpdateCount = 0.0f;
        }
        if (this.extUpdateCount <= 5000.0f) {
            return;
        }
        this.extUpdateCount = 0.0f;
        if (this.stats.NumVisibleZombies != 0 || this.stats.NumChasingZombies != 0) {
            return;
        }
        if (!Rand.NextBool(3)) {
            return;
        }
        if (!this.getAdvancedAnimator().containsAnyIdleNodes() && !this.isSitOnGround()) {
            return;
        }
        this.onIdlePerformFidgets();
        this.reportEvent("EventDoExt");
    }

    private void onIdlePerformFidgets() {
        Moodles moodles = this.getMoodles();
        BodyDamage bodyDamage = this.getBodyDamage();
        if (moodles.getMoodleLevel(MoodleType.Hypothermia) > 0 && Rand.NextBool(7)) {
            this.setVariable("Ext", "Shiver");
            return;
        }
        if (moodles.getMoodleLevel(MoodleType.Hyperthermia) > 0 && Rand.NextBool(7)) {
            this.setVariable("Ext", "WipeBrow");
            return;
        }
        if (moodles.getMoodleLevel(MoodleType.Sick) > 0 && Rand.NextBool(7)) {
            if (Rand.NextBool(4)) {
                this.setVariable("Ext", "Cough");
            } else {
                this.setVariable("Ext", "PainStomach" + (Rand.Next(2) + 1));
            }
            return;
        }
        if (moodles.getMoodleLevel(MoodleType.Endurance) > 2 && Rand.NextBool(10)) {
            if (Rand.NextBool(5) && !this.isSitOnGround()) {
                this.setVariable("Ext", "BentDouble");
            } else {
                this.setVariable("Ext", "WipeBrow");
            }
            return;
        }
        if (moodles.getMoodleLevel(MoodleType.Tired) > 2 && Rand.NextBool(10)) {
            if (Rand.NextBool(7)) {
                this.setVariable("Ext", "TiredStretch");
            } else if (Rand.NextBool(7)) {
                this.setVariable("Ext", "Sway");
            } else {
                this.setVariable("Ext", "Yawn");
            }
            return;
        }
        if (bodyDamage.doBodyPartsHaveInjuries(BodyPartType.Head, BodyPartType.Neck) && Rand.NextBool(7)) {
            if (bodyDamage.areBodyPartsBleeding(BodyPartType.Head, BodyPartType.Neck) && Rand.NextBool(2)) {
                this.setVariable("Ext", "WipeHead");
            } else {
                this.setVariable("Ext", "PainHead" + (Rand.Next(2) + 1));
            }
            return;
        }
        if (bodyDamage.doBodyPartsHaveInjuries(BodyPartType.UpperArm_L, BodyPartType.ForeArm_L) && Rand.NextBool(7)) {
            if (bodyDamage.areBodyPartsBleeding(BodyPartType.UpperArm_L, BodyPartType.ForeArm_L) && Rand.NextBool(2)) {
                this.setVariable("Ext", "WipeArmL");
            } else {
                this.setVariable("Ext", "PainArmL");
            }
            return;
        }
        if (bodyDamage.doBodyPartsHaveInjuries(BodyPartType.UpperArm_R, BodyPartType.ForeArm_R) && Rand.NextBool(7)) {
            if (bodyDamage.areBodyPartsBleeding(BodyPartType.UpperArm_R, BodyPartType.ForeArm_R) && Rand.NextBool(2)) {
                this.setVariable("Ext", "WipeArmR");
            } else {
                this.setVariable("Ext", "PainArmR");
            }
            return;
        }
        if (bodyDamage.doesBodyPartHaveInjury(BodyPartType.Hand_L) && Rand.NextBool(7)) {
            this.setVariable("Ext", "PainHandL");
            return;
        }
        if (bodyDamage.doesBodyPartHaveInjury(BodyPartType.Hand_R) && Rand.NextBool(7)) {
            this.setVariable("Ext", "PainHandR");
            return;
        }
        if (!this.isSitOnGround() && bodyDamage.doBodyPartsHaveInjuries(BodyPartType.UpperLeg_L, BodyPartType.LowerLeg_L) && Rand.NextBool(7)) {
            if (bodyDamage.areBodyPartsBleeding(BodyPartType.UpperLeg_L, BodyPartType.LowerLeg_L) && Rand.NextBool(2)) {
                this.setVariable("Ext", "WipeLegL");
            } else {
                this.setVariable("Ext", "PainLegL");
            }
            return;
        }
        if (!this.isSitOnGround() && bodyDamage.doBodyPartsHaveInjuries(BodyPartType.UpperLeg_R, BodyPartType.LowerLeg_R) && Rand.NextBool(7)) {
            if (bodyDamage.areBodyPartsBleeding(BodyPartType.UpperLeg_R, BodyPartType.LowerLeg_R) && Rand.NextBool(2)) {
                this.setVariable("Ext", "WipeLegR");
            } else {
                this.setVariable("Ext", "PainLegR");
            }
            return;
        }
        if (bodyDamage.doBodyPartsHaveInjuries(BodyPartType.Torso_Upper, BodyPartType.Torso_Lower) && Rand.NextBool(7)) {
            if (bodyDamage.areBodyPartsBleeding(BodyPartType.Torso_Upper, BodyPartType.Torso_Lower) && Rand.NextBool(2)) {
                this.setVariable("Ext", "WipeTorso" + (Rand.Next(2) + 1));
            } else {
                this.setVariable("Ext", "PainTorso");
            }
            return;
        }
        if (WeaponType.getWeaponType(this) != WeaponType.barehand) {
            this.setVariable("Ext", "" + (Rand.Next(5) + 1));
            return;
        }
        if (Rand.NextBool(10)) {
            this.setVariable("Ext", "ChewNails");
            return;
        }
        if (Rand.NextBool(10)) {
            this.setVariable("Ext", "ShiftWeight");
            return;
        }
        if (Rand.NextBool(10)) {
            this.setVariable("Ext", "PullAtColar");
            return;
        }
        if (Rand.NextBool(10)) {
            this.setVariable("Ext", "BridgeNose");
            return;
        }
        this.setVariable("Ext", "" + (Rand.Next(5) + 1));
    }

    private boolean updateUseKey() {
        if (GameServer.bServer) {
            return false;
        }
        if (!this.isLocalPlayer()) {
            return false;
        }
        if (this.PlayerIndex != 0) {
            return false;
        }
        this.timePressedContext += GameTime.instance.getRealworldSecondsSinceLastUpdate();
        boolean bl = GameKeyboard.isKeyDown(Core.getInstance().getKey("Interact"));
        if (bl && this.timePressedContext < 0.5f) {
            this.bPressContext = true;
        } else {
            if (this.bPressContext && (Core.CurrentTextEntryBox != null && Core.CurrentTextEntryBox.DoingTextEntry || !GameKeyboard.doLuaKeyPressed)) {
                this.bPressContext = false;
            }
            if (this.bPressContext && this.doContext(this.dir)) {
                this.timePressedContext = 0.0f;
                this.bPressContext = false;
                return true;
            }
            if (!bl) {
                this.bPressContext = false;
                this.timePressedContext = 0.0f;
            }
        }
        return false;
    }

    private void updateHitByVehicle() {
        if (GameServer.bServer) {
            return;
        }
        if (!this.isLocalPlayer()) {
            return;
        }
        if (this.vehicle4testCollision == null || !this.ulBeatenVehicle.Check() || SandboxOptions.instance.DamageToPlayerFromHitByACar.getValue() <= 1) {
            return;
        }
        BaseVehicle baseVehicle = this.vehicle4testCollision;
        this.vehicle4testCollision = null;
        if (!baseVehicle.isEngineRunning() || this.getVehicle() == baseVehicle) {
            return;
        }
        float f = baseVehicle.jniLinearVelocity.x;
        float f2 = baseVehicle.jniLinearVelocity.z;
        float f3 = (float)Math.sqrt(f * f + f2 * f2);
        Vector2 vector22 = (Vector2)BaseVehicle.TL_vector2_pool.get().alloc();
        Vector2 vector23 = baseVehicle.testCollisionWithCharacter(this, 0.20000002f, vector22);
        if (vector23 != null && vector23.x != -1.0f) {
            vector23.x = (vector23.x - baseVehicle.x) * f3 * 1.0f + this.x;
            vector23.y = (vector23.y - baseVehicle.y) * f3 * 1.0f + this.x;
            if (this.isOnFloor()) {
                int n = baseVehicle.testCollisionWithProneCharacter(this, false);
                if (n > 0) {
                    this.doBeatenVehicle(Math.max(f3 * 6.0f, 5.0f));
                }
                this.doBeatenVehicle(0.0f);
            } else if (this.getCurrentState() != PlayerFallDownState.instance() && f3 > 0.1f) {
                this.doBeatenVehicle(Math.max(f3 * 2.0f, 5.0f));
            }
        }
        BaseVehicle.TL_vector2_pool.get().release(vector22);
    }

    private void updateSoundListener() {
        if (GameServer.bServer) {
            return;
        }
        if (!this.isLocalPlayer()) {
            return;
        }
        if (this.soundListener == null) {
            this.soundListener = Core.SoundDisabled ? new DummySoundListener(this.PlayerIndex) : new SoundListener(this.PlayerIndex);
        }
        this.soundListener.setPos(this.x, this.y, this.z);
        this.checkNearbyRooms -= GameTime.getInstance().getMultiplier() / 1.6f;
        if (this.checkNearbyRooms <= 0.0f) {
            this.checkNearbyRooms = 30.0f;
            this.numNearbyBuildingsRooms = IsoWorld.instance.MetaGrid.countNearbyBuildingsRooms(this);
        }
        if (this.testemitter == null) {
            this.testemitter = Core.SoundDisabled ? new DummySoundEmitter() : new FMODSoundEmitter();
            this.testemitter.setPos(this.x, this.y, this.z);
        }
        this.soundListener.tick();
        this.testemitter.tick();
    }

    @Override
    public void updateMovementRates() {
        this.calculateWalkSpeed();
        this.m_idleSpeed = this.calculateIdleSpeed();
        this.updateFootInjuries();
    }

    public void pressedAttack(boolean bl) {
        Serializable serializable;
        int n;
        String string;
        boolean bl2 = GameClient.bClient && !this.isLocalPlayer();
        boolean bl3 = this.isSprinting();
        this.setSprinting(false);
        this.setForceSprint(false);
        if (this.attackStarted || this.isCurrentState(PlayerHitReactionState.instance())) {
            return;
        }
        if (GameClient.bClient && this.isCurrentState(PlayerHitReactionPVPState.instance()) && !ServerOptions.instance.PVPMeleeWhileHitReaction.getValue()) {
            return;
        }
        if (this.primaryHandModel != null && !StringUtils.isNullOrEmpty(this.primaryHandModel.maskVariableValue) && this.secondaryHandModel != null && !StringUtils.isNullOrEmpty(this.secondaryHandModel.maskVariableValue)) {
            this.setDoShove(false);
            this.setForceShove(false);
            this.setInitiateAttack(false);
            this.attackStarted = false;
            this.setAttackType(null);
            return;
        }
        if (this.getPrimaryHandItem() != null && this.getPrimaryHandItem().getItemReplacementPrimaryHand() != null && this.getSecondaryHandItem() != null && this.getSecondaryHandItem().getItemReplacementSecondHand() != null) {
            this.setDoShove(false);
            this.setForceShove(false);
            this.setInitiateAttack(false);
            this.attackStarted = false;
            this.setAttackType(null);
            return;
        }
        if (!this.attackStarted) {
            this.setVariable("StartedAttackWhileSprinting", bl3);
        }
        this.setInitiateAttack(true);
        this.attackStarted = true;
        if (!bl2) {
            this.setCriticalHit(false);
        }
        this.setAttackFromBehind(false);
        WeaponType weaponType = WeaponType.getWeaponType(this);
        if (!GameClient.bClient || this.isLocalPlayer()) {
            this.setAttackType(PZArrayUtil.pickRandom(weaponType.possibleAttack));
        }
        if (!GameClient.bClient || this.isLocalPlayer()) {
            this.combatSpeed = this.calculateCombatSpeed();
        }
        if (bl) {
            SwipeStatePlayer.instance().CalcAttackVars(this, this.attackVars);
        }
        if ((string = this.getVariableString("Weapon")) != null && string.equals("throwing") && !this.attackVars.bDoShove) {
            this.setAttackAnimThrowTimer(2000L);
            this.setIsAiming(true);
        }
        if (bl2) {
            this.attackVars.bDoShove = this.isDoShove();
            this.attackVars.bAimAtFloor = this.isAimAtFloor();
        }
        if (this.attackVars.bDoShove && !this.isAuthorizeShoveStomp()) {
            this.setDoShove(false);
            this.setForceShove(false);
            this.setInitiateAttack(false);
            this.attackStarted = false;
            this.setAttackType(null);
            return;
        }
        this.useHandWeapon = this.attackVars.getWeapon(this);
        this.setAimAtFloor(this.attackVars.bAimAtFloor);
        this.setDoShove(this.attackVars.bDoShove);
        this.targetOnGround = (IsoGameCharacter)this.attackVars.targetOnGround.getMovingObject();
        if (this.attackVars.getWeapon(this) != null && !StringUtils.isNullOrEmpty(this.attackVars.getWeapon(this).getFireMode())) {
            this.setVariable("FireMode", this.attackVars.getWeapon(this).getFireMode());
        } else {
            this.clearVariable("FireMode");
        }
        if (this.useHandWeapon != null && weaponType.isRanged && !this.bDoShove) {
            n = this.useHandWeapon.getRecoilDelay();
            serializable = Float.valueOf((float)n * (1.0f - (float)this.getPerkLevel(PerkFactory.Perks.Aiming) / 30.0f));
            this.setRecoilDelay(((Float)serializable).intValue());
        }
        if ((n = Rand.Next(0, 3)) == 0) {
            this.setVariable("AttackVariationX", Rand.Next(-1.0f, -0.5f));
        }
        if (n == 1) {
            this.setVariable("AttackVariationX", 0.0f);
        }
        if (n == 2) {
            this.setVariable("AttackVariationX", Rand.Next(0.5f, 1.0f));
        }
        this.setVariable("AttackVariationY", 0.0f);
        if (bl) {
            SwipeStatePlayer.instance().CalcHitList(this, true, this.attackVars, this.hitList);
        }
        serializable = null;
        if (!this.hitList.isEmpty()) {
            serializable = Type.tryCastTo(((HitInfo)this.hitList.get(0)).getObject(), IsoGameCharacter.class);
        }
        if (serializable == null) {
            if (this.isAiming() && !this.m_meleePressed && this.useHandWeapon != this.bareHands) {
                this.setDoShove(false);
                this.setForceShove(false);
            }
            this.m_lastAttackWasShove = this.bDoShove;
            if (weaponType.canMiss && !this.isAimAtFloor() && (!GameClient.bClient || this.isLocalPlayer())) {
                this.setAttackType("miss");
            }
            if (this.isAiming() && this.bDoShove) {
                this.setVariable("bShoveAiming", true);
            } else {
                this.clearVariable("bShoveAiming");
            }
            return;
        }
        if (!GameClient.bClient || this.isLocalPlayer()) {
            this.setAttackFromBehind(this.isBehind((IsoGameCharacter)serializable));
        }
        float f = IsoUtils.DistanceTo(((IsoGameCharacter)serializable).x, ((IsoGameCharacter)serializable).y, this.x, this.y);
        this.setVariable("TargetDist", f);
        int n2 = this.calculateCritChance((IsoGameCharacter)serializable);
        if (serializable instanceof IsoZombie) {
            IsoZombie isoZombie = this.getClosestZombieToOtherZombie((IsoZombie)serializable);
            if (!this.attackVars.bAimAtFloor && (double)f > 1.25 && weaponType == WeaponType.spear && (isoZombie == null || (double)IsoUtils.DistanceTo(((IsoGameCharacter)serializable).x, ((IsoGameCharacter)serializable).y, isoZombie.x, isoZombie.y) > 1.7)) {
                if (!GameClient.bClient || this.isLocalPlayer()) {
                    this.setAttackType("overhead");
                }
                n2 += 30;
            }
        }
        if (this.isLocalPlayer() && !((IsoMovingObject)serializable).isOnFloor()) {
            ((IsoGameCharacter)serializable).setHitFromBehind(this.isAttackFromBehind());
        }
        if (this.isAttackFromBehind()) {
            n2 = serializable instanceof IsoZombie && ((IsoZombie)serializable).target == null ? (n2 += 30) : (n2 += 5);
        }
        if (serializable instanceof IsoPlayer && weaponType.isRanged && !this.bDoShove) {
            n2 = (int)(this.attackVars.getWeapon(this).getStopPower() * (1.0f + (float)this.getPerkLevel(PerkFactory.Perks.Aiming) / 15.0f));
        }
        if (!GameClient.bClient || this.isLocalPlayer()) {
            this.setCriticalHit(Rand.Next(100) < n2);
            if (DebugOptions.instance.MultiplayerCriticalHit.getValue()) {
                this.setCriticalHit(true);
            }
            if (this.isAttackFromBehind() && this.attackVars.bCloseKill && serializable instanceof IsoZombie && ((IsoZombie)serializable).target == null) {
                this.setCriticalHit(true);
            }
            if (this.isCriticalHit() && !this.attackVars.bCloseKill && !this.bDoShove && weaponType == WeaponType.knife) {
                this.setCriticalHit(false);
            }
            this.setAttackWasSuperAttack(false);
            if (this.stats.NumChasingZombies > 1 && this.attackVars.bCloseKill && !this.bDoShove && weaponType == WeaponType.knife) {
                this.setCriticalHit(false);
            }
        }
        if (this.isCriticalHit()) {
            this.combatSpeed *= 1.1f;
        }
        if (Core.bDebug) {
            DebugLog.Combat.debugln("Hit zombie dist: " + f + " crit: " + this.isCriticalHit() + " (" + n2 + "%) from behind: " + this.isAttackFromBehind());
        }
        if (this.isAiming() && this.bDoShove) {
            this.setVariable("bShoveAiming", true);
        } else {
            this.clearVariable("bShoveAiming");
        }
        if (this.useHandWeapon != null && weaponType.isRanged) {
            this.setRecoilDelay(this.useHandWeapon.getRecoilDelay() - this.getPerkLevel(PerkFactory.Perks.Aiming) * 2);
        }
        this.m_lastAttackWasShove = this.bDoShove;
    }

    public void setAttackAnimThrowTimer(long l) {
        this.AttackAnimThrowTimer = System.currentTimeMillis() + l;
    }

    public boolean isAttackAnimThrowTimeOut() {
        return this.AttackAnimThrowTimer <= System.currentTimeMillis();
    }

    private boolean getAttackAnim() {
        return false;
    }

    private String getWeaponType() {
        if (!this.isAttackAnimThrowTimeOut()) {
            return "throwing";
        }
        return this.WeaponT;
    }

    private void setWeaponType(String string) {
        this.WeaponT = string;
    }

    public int calculateCritChance(IsoGameCharacter isoGameCharacter) {
        if (this.bDoShove) {
            int n = 35;
            if (isoGameCharacter instanceof IsoPlayer) {
                IsoPlayer isoPlayer = (IsoPlayer)isoGameCharacter;
                n = 20;
                if (GameClient.bClient && !isoPlayer.isLocalPlayer()) {
                    n = (int)((double)n - (double)isoPlayer.remoteStrLvl * 1.5);
                    n = isoPlayer.getNutrition().getWeight() < 80.0 ? (int)((double)n + Math.abs((isoPlayer.getNutrition().getWeight() - 80.0) / 2.0)) : (int)((double)n - (isoPlayer.getNutrition().getWeight() - 80.0) / 2.0);
                }
            }
            n -= this.getMoodles().getMoodleLevel(MoodleType.Endurance) * 5;
            n -= this.getMoodles().getMoodleLevel(MoodleType.HeavyLoad) * 5;
            n = (int)((double)n - (double)this.getMoodles().getMoodleLevel(MoodleType.Panic) * 1.3);
            return n += this.getPerkLevel(PerkFactory.Perks.Strength) * 2;
        }
        if (this.bDoShove && isoGameCharacter.getStateMachine().getCurrent() == StaggerBackState.instance() && isoGameCharacter instanceof IsoZombie) {
            return 100;
        }
        if (this.getPrimaryHandItem() == null || !(this.getPrimaryHandItem() instanceof HandWeapon)) {
            return 0;
        }
        HandWeapon handWeapon = (HandWeapon)this.getPrimaryHandItem();
        int n = (int)handWeapon.getCriticalChance();
        if (handWeapon.isAlwaysKnockdown()) {
            return 100;
        }
        WeaponType weaponType = WeaponType.getWeaponType(this);
        if (weaponType.isRanged) {
            n = (int)((float)n + (float)handWeapon.getAimingPerkCritModifier() * ((float)this.getPerkLevel(PerkFactory.Perks.Aiming) / 2.0f));
            if (this.getBeenMovingFor() > (float)(handWeapon.getAimingTime() + this.getPerkLevel(PerkFactory.Perks.Aiming) * 2)) {
                n = (int)((float)n - (this.getBeenMovingFor() - (float)(handWeapon.getAimingTime() + this.getPerkLevel(PerkFactory.Perks.Aiming) * 2)));
            }
            n += this.getPerkLevel(PerkFactory.Perks.Aiming) * 3;
            float f = this.DistToProper(isoGameCharacter);
            if (f < 4.0f) {
                n = (int)((float)n + (4.0f - f) * 7.0f);
            } else if (f >= 4.0f) {
                n = (int)((float)n - (f - 4.0f) * 7.0f);
            }
            if ("Auto".equals(this.getVariableString("FireMode"))) {
                n -= this.shootInARow * 10;
            }
        } else {
            if (handWeapon.isTwoHandWeapon() && (this.getPrimaryHandItem() != handWeapon || this.getSecondaryHandItem() != handWeapon)) {
                n -= n / 3;
            }
            if (this.chargeTime < 2.0f) {
                n -= n / 5;
            }
            int n2 = this.getPerkLevel(PerkFactory.Perks.Blunt);
            if (handWeapon.getCategories().contains("Axe")) {
                n2 = this.getPerkLevel(PerkFactory.Perks.Axe);
            }
            if (handWeapon.getCategories().contains("LongBlade")) {
                n2 = this.getPerkLevel(PerkFactory.Perks.LongBlade);
            }
            if (handWeapon.getCategories().contains("Spear")) {
                n2 = this.getPerkLevel(PerkFactory.Perks.Spear);
            }
            if (handWeapon.getCategories().contains("SmallBlade")) {
                n2 = this.getPerkLevel(PerkFactory.Perks.SmallBlade);
            }
            if (handWeapon.getCategories().contains("SmallBlunt")) {
                n2 = this.getPerkLevel(PerkFactory.Perks.SmallBlunt);
            }
            n += n2 * 3;
            if (isoGameCharacter instanceof IsoPlayer) {
                IsoPlayer isoPlayer = (IsoPlayer)isoGameCharacter;
                if (GameClient.bClient && !isoPlayer.isLocalPlayer()) {
                    n = (int)((double)n - (double)isoPlayer.remoteStrLvl * 1.5);
                    n = isoPlayer.getNutrition().getWeight() < 80.0 ? (int)((double)n + Math.abs((isoPlayer.getNutrition().getWeight() - 80.0) / 2.0)) : (int)((double)n - (isoPlayer.getNutrition().getWeight() - 80.0) / 2.0);
                }
            }
        }
        n -= this.getMoodles().getMoodleLevel(MoodleType.Endurance) * 5;
        n -= this.getMoodles().getMoodleLevel(MoodleType.HeavyLoad) * 5;
        n = (int)((double)n - (double)this.getMoodles().getMoodleLevel(MoodleType.Panic) * 1.3);
        if (SandboxOptions.instance.Lore.Toughness.getValue() == 1) {
            n -= 6;
        }
        if (SandboxOptions.instance.Lore.Toughness.getValue() == 3) {
            n += 6;
        }
        if (n < 10) {
            n = 10;
        }
        if (n > 90) {
            n = 90;
        }
        return n;
    }

    private void checkJoypadIgnoreAimUntilCentered() {
        float f;
        float f2;
        if (!this.bJoypadIgnoreAimUntilCentered) {
            return;
        }
        if (GameWindow.ActivatedJoyPad != null && this.JoypadBind != -1 && this.bJoypadMovementActive && (f2 = JoypadManager.instance.getAimingAxisX(this.JoypadBind)) * f2 + (f = JoypadManager.instance.getAimingAxisY(this.JoypadBind)) + f <= 0.0f) {
            this.bJoypadIgnoreAimUntilCentered = false;
        }
    }

    public boolean isAimControlActive() {
        if (this.isForceAim()) {
            return true;
        }
        if (this.isAimKeyDown()) {
            return true;
        }
        return GameWindow.ActivatedJoyPad != null && this.JoypadBind != -1 && this.bJoypadMovementActive && this.getJoypadAimVector(tempo).getLengthSquared() > 0.0f;
    }

    private Vector2 getJoypadAimVector(Vector2 vector22) {
        float f;
        if (this.bJoypadIgnoreAimUntilCentered) {
            return vector22.set(0.0f, 0.0f);
        }
        float f2 = JoypadManager.instance.getAimingAxisY(this.JoypadBind);
        float f3 = JoypadManager.instance.getAimingAxisX(this.JoypadBind);
        if (f3 * f3 + f2 * f2 < (f = JoypadManager.instance.getDeadZone(this.JoypadBind, 0)) * f) {
            f2 = 0.0f;
            f3 = 0.0f;
        }
        return vector22.set(f3, f2);
    }

    private Vector2 getJoypadMoveVector(Vector2 vector22) {
        float f;
        float f2 = JoypadManager.instance.getMovementAxisY(this.JoypadBind);
        float f3 = JoypadManager.instance.getMovementAxisX(this.JoypadBind);
        if (f3 * f3 + f2 * f2 < (f = JoypadManager.instance.getDeadZone(this.JoypadBind, 0)) * f) {
            f2 = 0.0f;
            f3 = 0.0f;
        }
        vector22.set(f3, f2);
        if (this.isIgnoreInputsForDirection()) {
            vector22.set(0.0f, 0.0f);
        }
        return vector22;
    }

    private void updateToggleToAim() {
        if (this.PlayerIndex != 0) {
            return;
        }
        if (!Core.getInstance().isToggleToAim()) {
            this.setForceAim(false);
            return;
        }
        boolean bl = this.isAimKeyDown();
        long l = System.currentTimeMillis();
        if (bl) {
            if (this.aimKeyDownMS == 0L) {
                this.aimKeyDownMS = l;
            }
        } else {
            if (this.aimKeyDownMS != 0L && l - this.aimKeyDownMS < 500L) {
                this.toggleForceAim();
            } else if (this.isForceAim()) {
                if (this.aimKeyDownMS != 0L) {
                    this.toggleForceAim();
                } else {
                    boolean bl2;
                    int n = Core.getInstance().getKey("Aim");
                    boolean bl3 = bl2 = n == 29 || n == 157;
                    if (bl2 && UIManager.isMouseOverInventory()) {
                        this.toggleForceAim();
                    }
                }
            }
            this.aimKeyDownMS = 0L;
        }
    }

    private void UpdateInputState(InputState inputState) {
        inputState.bMelee = false;
        if (MPDebugAI.updateInputState(this, inputState)) {
            return;
        }
        if (GameWindow.ActivatedJoyPad != null && this.JoypadBind != -1) {
            if (this.bJoypadMovementActive) {
                inputState.isAttacking = this.isCharging;
                if (this.bJoypadIgnoreChargingRT) {
                    inputState.isAttacking = false;
                }
                if (this.bJoypadIgnoreAimUntilCentered) {
                    float f = JoypadManager.instance.getAimingAxisX(this.JoypadBind);
                    float f2 = JoypadManager.instance.getAimingAxisY(this.JoypadBind);
                    if (f == 0.0f && f2 == 0.0f) {
                        this.bJoypadIgnoreAimUntilCentered = false;
                    }
                }
            }
            if (this.isChargingLT) {
                inputState.bMelee = true;
                inputState.isAttacking = false;
            }
        } else {
            boolean bl = inputState.isAttacking = this.isCharging && Mouse.isButtonDownUICheck(0);
            if (GameKeyboard.isKeyDown(Core.getInstance().getKey("Melee")) && this.authorizeMeleeAction) {
                inputState.bMelee = true;
                inputState.isAttacking = false;
            }
        }
        if (GameWindow.ActivatedJoyPad != null && this.JoypadBind != -1) {
            if (this.bJoypadMovementActive) {
                inputState.isCharging = JoypadManager.instance.isRTPressed(this.JoypadBind);
                inputState.isChargingLT = JoypadManager.instance.isLTPressed(this.JoypadBind);
                if (this.bJoypadIgnoreChargingRT && !inputState.isCharging) {
                    this.bJoypadIgnoreChargingRT = false;
                }
            }
            inputState.isAiming = false;
            inputState.bRunning = false;
            inputState.bSprinting = false;
            Vector2 vector22 = this.getJoypadAimVector(tempVector2);
            if (vector22.x != 0.0f || vector22.y != 0.0f) {
                inputState.isAiming = true;
            } else {
                inputState.isCharging = false;
                Vector2 vector23 = this.getJoypadMoveVector(tempVector2);
                if (this.isAutoWalk() && vector23.getLengthSquared() == 0.0f) {
                    vector23.set(this.getAutoWalkDirection());
                }
                if (vector23.x != 0.0f || vector23.y != 0.0f) {
                    if (this.isAllowRun()) {
                        inputState.bRunning = JoypadManager.instance.isRTPressed(this.JoypadBind);
                    }
                    inputState.isAttacking = false;
                    inputState.bMelee = false;
                    this.bJoypadIgnoreChargingRT = true;
                    inputState.isCharging = false;
                    boolean bl = JoypadManager.instance.isBPressed(this.JoypadBind);
                    if (inputState.bRunning && bl && !this.bJoypadBDown) {
                        this.bJoypadSprint = !this.bJoypadSprint;
                    }
                    this.bJoypadBDown = bl;
                    inputState.bSprinting = this.bJoypadSprint;
                }
            }
            if (!inputState.bRunning) {
                this.bJoypadBDown = false;
                this.bJoypadSprint = false;
            }
        } else {
            long l;
            boolean bl;
            boolean bl2;
            boolean bl3 = inputState.isAiming = (this.isAimKeyDown() || Mouse.isButtonDownUICheck(1) && this.TimeRightPressed >= 0.15f) && this.getPlayerNum() == 0 && StringUtils.isNullOrEmpty(this.getVariableString("BumpFallType"));
            this.TimeRightPressed = Mouse.isButtonDown(1) ? (this.TimeRightPressed += GameTime.getInstance().getRealworldSecondsSinceLastUpdate()) : 0.0f;
            inputState.isCharging = !this.isCharging ? Mouse.isButtonDownUICheck(1) && this.TimeRightPressed >= 0.15f || this.isAimKeyDown() : Mouse.isButtonDown(1) || this.isAimKeyDown();
            int n = Core.getInstance().getKey("Run");
            int n2 = Core.getInstance().getKey("Sprint");
            if (this.isAllowRun()) {
                inputState.bRunning = GameKeyboard.isKeyDown(n);
            }
            if (this.isAllowSprint()) {
                if (!Core.OptiondblTapJogToSprint) {
                    if (GameKeyboard.isKeyDown(n2)) {
                        inputState.bSprinting = true;
                        this.pressedRunTimer = 1.0f;
                    } else {
                        inputState.bSprinting = false;
                    }
                } else {
                    if (!GameKeyboard.wasKeyDown(n) && GameKeyboard.isKeyDown(n) && this.pressedRunTimer < 30.0f && this.pressedRun) {
                        inputState.bSprinting = true;
                    }
                    if (GameKeyboard.wasKeyDown(n) && !GameKeyboard.isKeyDown(n)) {
                        inputState.bSprinting = false;
                        this.pressedRun = true;
                    }
                    if (!inputState.bRunning) {
                        inputState.bSprinting = false;
                    }
                    if (this.pressedRun) {
                        this.pressedRunTimer += 1.0f;
                    }
                    if (this.pressedRunTimer > 30.0f) {
                        this.pressedRunTimer = 0.0f;
                        this.pressedRun = false;
                    }
                }
            }
            this.updateToggleToAim();
            if (inputState.bRunning || inputState.bSprinting) {
                this.setForceAim(false);
            }
            if (this.PlayerIndex == 0 && Core.getInstance().isToggleToRun()) {
                bl2 = GameKeyboard.isKeyDown(n);
                bl = GameKeyboard.wasKeyDown(n);
                l = System.currentTimeMillis();
                if (bl2 && !bl) {
                    this.runKeyDownMS = l;
                } else if (!bl2 && bl && l - this.runKeyDownMS < 500L) {
                    this.toggleForceRun();
                }
            }
            if (this.PlayerIndex == 0 && Core.getInstance().isToggleToSprint()) {
                bl2 = GameKeyboard.isKeyDown(n2);
                bl = GameKeyboard.wasKeyDown(n2);
                l = System.currentTimeMillis();
                if (bl2 && !bl) {
                    this.sprintKeyDownMS = l;
                } else if (!bl2 && bl && l - this.sprintKeyDownMS < 500L) {
                    this.toggleForceSprint();
                }
            }
            if (this.isForceAim()) {
                inputState.isAiming = true;
                inputState.isCharging = true;
            }
            if (this.isForceRun()) {
                inputState.bRunning = true;
            }
            if (this.isForceSprint()) {
                inputState.bSprinting = true;
            }
        }
    }

    public IsoZombie getClosestZombieToOtherZombie(IsoZombie isoZombie) {
        IsoZombie isoZombie2 = null;
        ArrayList<IsoZombie> arrayList = new ArrayList<IsoZombie>();
        ArrayList<IsoMovingObject> arrayList2 = IsoWorld.instance.CurrentCell.getObjectList();
        for (int i = 0; i < arrayList2.size(); ++i) {
            IsoMovingObject isoMovingObject = arrayList2.get(i);
            if (isoMovingObject == isoZombie || !(isoMovingObject instanceof IsoZombie)) continue;
            arrayList.add((IsoZombie)isoMovingObject);
        }
        float f = 0.0f;
        for (int i = 0; i < arrayList.size(); ++i) {
            IsoZombie isoZombie3 = (IsoZombie)arrayList.get(i);
            float f2 = IsoUtils.DistanceTo(isoZombie3.x, isoZombie3.y, isoZombie.x, isoZombie.y);
            if (isoZombie2 != null && !(f2 < f)) continue;
            isoZombie2 = isoZombie3;
            f = f2;
        }
        return isoZombie2;
    }

    @Deprecated
    public IsoGameCharacter getClosestZombieDist() {
        float f = 0.4f;
        boolean bl = false;
        IsoPlayer.testHitPosition.x = this.x + this.getForwardDirection().x * f;
        IsoPlayer.testHitPosition.y = this.y + this.getForwardDirection().y * f;
        HandWeapon handWeapon = this.getWeapon();
        ArrayList<IsoZombie> arrayList = new ArrayList<IsoZombie>();
        for (int i = (int)IsoPlayer.testHitPosition.x - (int)handWeapon.getMaxRange(); i <= (int)IsoPlayer.testHitPosition.x + (int)handWeapon.getMaxRange(); ++i) {
            for (int j = (int)IsoPlayer.testHitPosition.y - (int)handWeapon.getMaxRange(); j <= (int)IsoPlayer.testHitPosition.y + (int)handWeapon.getMaxRange(); ++j) {
                IsoGridSquare isoGridSquare = IsoWorld.instance.CurrentCell.getGridSquare((double)i, (double)j, this.z);
                if (isoGridSquare == null || isoGridSquare.getMovingObjects().size() <= 0) continue;
                for (int k = 0; k < isoGridSquare.getMovingObjects().size(); ++k) {
                    IsoMovingObject isoMovingObject = isoGridSquare.getMovingObjects().get(k);
                    if (!(isoMovingObject instanceof IsoZombie)) continue;
                    Vector2 vector22 = tempVector2_1.set(this.getX(), this.getY());
                    Vector2 vector23 = tempVector2_2.set(isoMovingObject.getX(), isoMovingObject.getY());
                    vector23.x -= vector22.x;
                    vector23.y -= vector22.y;
                    Vector2 vector24 = this.getForwardDirection();
                    vector23.normalize();
                    vector24.normalize();
                    Float f2 = Float.valueOf(vector23.dot(vector24));
                    if (f2.floatValue() >= handWeapon.getMinAngle() || isoMovingObject.isOnFloor()) {
                        bl = true;
                    }
                    if (!bl || !(((IsoZombie)isoMovingObject).Health > 0.0f)) continue;
                    ((IsoZombie)isoMovingObject).setHitFromBehind(this.isBehind((IsoZombie)isoMovingObject));
                    ((IsoZombie)isoMovingObject).setHitAngle(((IsoZombie)isoMovingObject).getForwardDirection());
                    ((IsoZombie)isoMovingObject).setPlayerAttackPosition(((IsoZombie)isoMovingObject).testDotSide(this));
                    float f3 = IsoUtils.DistanceTo(isoMovingObject.x, isoMovingObject.y, this.x, this.y);
                    if (!(f3 < handWeapon.getMaxRange())) continue;
                    arrayList.add((IsoZombie)isoMovingObject);
                }
            }
        }
        if (!arrayList.isEmpty()) {
            Collections.sort(arrayList, new Comparator<IsoGameCharacter>(){

                @Override
                public int compare(IsoGameCharacter isoGameCharacter, IsoGameCharacter isoGameCharacter2) {
                    float f;
                    float f2 = IsoUtils.DistanceTo(isoGameCharacter.x, isoGameCharacter.y, IsoPlayer.testHitPosition.x, IsoPlayer.testHitPosition.y);
                    if (f2 > (f = IsoUtils.DistanceTo(isoGameCharacter2.x, isoGameCharacter2.y, IsoPlayer.testHitPosition.x, IsoPlayer.testHitPosition.y))) {
                        return 1;
                    }
                    if (f > f2) {
                        return -1;
                    }
                    return 0;
                }
            });
            return (IsoGameCharacter)arrayList.get(0);
        }
        return null;
    }

    @Override
    public void hitConsequences(HandWeapon handWeapon, IsoGameCharacter isoGameCharacter, boolean bl, float f, boolean bl2) {
        Object object = isoGameCharacter.getVariableString("ZombieHitReaction");
        if ("Shot".equals(object)) {
            isoGameCharacter.setCriticalHit(Rand.Next(100) < ((IsoPlayer)isoGameCharacter).calculateCritChance(this));
        }
        if (isoGameCharacter instanceof IsoPlayer && (GameServer.bServer || GameClient.bClient)) {
            if (ServerOptions.getInstance().KnockedDownAllowed.getValue()) {
                this.setKnockedDown(isoGameCharacter.isCriticalHit());
            }
        } else {
            this.setKnockedDown(isoGameCharacter.isCriticalHit());
        }
        if (isoGameCharacter instanceof IsoPlayer) {
            if (!StringUtils.isNullOrEmpty(this.getHitReaction())) {
                this.actionContext.reportEvent("washitpvpagain");
            }
            this.actionContext.reportEvent("washitpvp");
            this.setVariable("hitpvp", true);
        } else {
            this.actionContext.reportEvent("washit");
        }
        if (bl) {
            if (GameServer.bServer) {
                return;
            }
            isoGameCharacter.xp.AddXP(PerkFactory.Perks.Strength, 2.0f);
            this.setHitForce(Math.min(0.5f, this.getHitForce()));
            this.setHitReaction("HitReaction");
            String string = this.testDotSide(isoGameCharacter);
            this.setHitFromBehind("BEHIND".equals(string));
            return;
        }
        if (!(GameServer.bServer || GameClient.bClient && !this.isLocalPlayer())) {
            this.BodyDamage.DamageFromWeapon(handWeapon);
        } else if (!GameServer.bServer && !this.isLocalPlayer()) {
            this.BodyDamage.splatBloodFloorBig();
        }
        if ("Bite".equals(object)) {
            String string = this.testDotSide(isoGameCharacter);
            boolean bl3 = string.equals("FRONT");
            boolean bl4 = string.equals("BEHIND");
            if (string.equals("RIGHT")) {
                object = (String)object + "LEFT";
            }
            if (string.equals("LEFT")) {
                object = (String)object + "RIGHT";
            }
            if (object != null && !"".equals(object)) {
                this.setHitReaction((String)object);
            }
        } else if (!this.isKnockedDown()) {
            this.setHitReaction("HitReaction");
        }
    }

    private HandWeapon getWeapon() {
        if (this.getPrimaryHandItem() instanceof HandWeapon) {
            return (HandWeapon)this.getPrimaryHandItem();
        }
        if (this.getSecondaryHandItem() instanceof HandWeapon) {
            return (HandWeapon)this.getSecondaryHandItem();
        }
        return (HandWeapon)InventoryItemFactory.CreateItem("BareHands");
    }

    private void updateMechanicsItems() {
        if (GameServer.bServer || this.mechanicsItem.isEmpty()) {
            return;
        }
        Iterator<Long> iterator = this.mechanicsItem.keySet().iterator();
        ArrayList<Long> arrayList = new ArrayList<Long>();
        while (iterator.hasNext()) {
            Long l = iterator.next();
            Long l2 = this.mechanicsItem.get(l);
            if (GameTime.getInstance().getCalender().getTimeInMillis() <= l2 + 86400000L) continue;
            arrayList.add(l);
        }
        for (int i = 0; i < arrayList.size(); ++i) {
            this.mechanicsItem.remove(arrayList.get(i));
        }
    }

    private void enterExitVehicle() {
        boolean bl;
        boolean bl2 = bl = this.PlayerIndex == 0 && GameKeyboard.isKeyDown(Core.getInstance().getKey("Interact"));
        if (bl) {
            this.bUseVehicle = true;
            this.useVehicleDuration += GameTime.instance.getRealworldSecondsSinceLastUpdate();
        }
        if (!this.bUsedVehicle && this.bUseVehicle && (!bl || this.useVehicleDuration > 0.5f)) {
            this.bUsedVehicle = true;
            if (this.getVehicle() != null) {
                LuaEventManager.triggerEvent("OnUseVehicle", this, this.getVehicle(), this.useVehicleDuration > 0.5f);
            } else {
                for (int i = 0; i < this.getCell().vehicles.size(); ++i) {
                    BaseVehicle baseVehicle = this.getCell().vehicles.get(i);
                    if (baseVehicle.getUseablePart(this) == null) continue;
                    LuaEventManager.triggerEvent("OnUseVehicle", this, baseVehicle, this.useVehicleDuration > 0.5f);
                    break;
                }
            }
        }
        if (!bl) {
            this.bUseVehicle = false;
            this.bUsedVehicle = false;
            this.useVehicleDuration = 0.0f;
        }
    }

    private void checkActionGroup() {
        ActionGroup actionGroup = this.actionContext.getGroup();
        if (this.getVehicle() == null) {
            ActionGroup actionGroup2 = ActionGroup.getActionGroup("player");
            if (actionGroup != actionGroup2) {
                this.advancedAnimator.OnAnimDataChanged(false);
                this.initializeStates();
                this.actionContext.setGroup(actionGroup2);
                this.clearVariable("bEnteringVehicle");
                this.clearVariable("EnterAnimationFinished");
                this.clearVariable("bExitingVehicle");
                this.clearVariable("ExitAnimationFinished");
                this.clearVariable("bSwitchingSeat");
                this.clearVariable("SwitchSeatAnimationFinished");
                this.setHitReaction("");
            }
        } else {
            ActionGroup actionGroup3 = ActionGroup.getActionGroup("player-vehicle");
            if (actionGroup != actionGroup3) {
                this.advancedAnimator.OnAnimDataChanged(false);
                this.initializeStates();
                this.actionContext.setGroup(actionGroup3);
            }
        }
    }

    public BaseVehicle getUseableVehicle() {
        if (this.getVehicle() != null) {
            return null;
        }
        int n = ((int)this.x - 4) / 10 - 1;
        int n2 = ((int)this.y - 4) / 10 - 1;
        int n3 = (int)Math.ceil((this.x + 4.0f) / 10.0f) + 1;
        int n4 = (int)Math.ceil((this.y + 4.0f) / 10.0f) + 1;
        for (int i = n2; i < n4; ++i) {
            for (int j = n; j < n3; ++j) {
                IsoChunk isoChunk;
                IsoChunk isoChunk2 = isoChunk = GameServer.bServer ? ServerMap.instance.getChunk(j, i) : IsoWorld.instance.CurrentCell.getChunkForGridSquare(j * 10, i * 10, 0);
                if (isoChunk == null) continue;
                for (int k = 0; k < isoChunk.vehicles.size(); ++k) {
                    BaseVehicle baseVehicle = isoChunk.vehicles.get(k);
                    if (baseVehicle.getUseablePart(this) == null && baseVehicle.getBestSeat(this) == -1) continue;
                    return baseVehicle;
                }
            }
        }
        return null;
    }

    public Boolean isNearVehicle() {
        if (this.getVehicle() != null) {
            return false;
        }
        int n = ((int)this.x - 4) / 10 - 1;
        int n2 = ((int)this.y - 4) / 10 - 1;
        int n3 = (int)Math.ceil((this.x + 4.0f) / 10.0f) + 1;
        int n4 = (int)Math.ceil((this.y + 4.0f) / 10.0f) + 1;
        for (int i = n2; i < n4; ++i) {
            for (int j = n; j < n3; ++j) {
                IsoChunk isoChunk;
                IsoChunk isoChunk2 = isoChunk = GameServer.bServer ? ServerMap.instance.getChunk(j, i) : IsoWorld.instance.CurrentCell.getChunkForGridSquare(j * 10, i * 10, 0);
                if (isoChunk == null) continue;
                for (int k = 0; k < isoChunk.vehicles.size(); ++k) {
                    BaseVehicle baseVehicle = isoChunk.vehicles.get(k);
                    if (baseVehicle.getScript() == null || !((double)baseVehicle.DistTo(this) < 3.5)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public BaseVehicle getNearVehicle() {
        if (this.getVehicle() != null) {
            return null;
        }
        int n = ((int)this.x - 4) / 10 - 1;
        int n2 = ((int)this.y - 4) / 10 - 1;
        int n3 = (int)Math.ceil((this.x + 4.0f) / 10.0f) + 1;
        int n4 = (int)Math.ceil((this.y + 4.0f) / 10.0f) + 1;
        for (int i = n2; i < n4; ++i) {
            for (int j = n; j < n3; ++j) {
                IsoChunk isoChunk;
                IsoChunk isoChunk2 = isoChunk = GameServer.bServer ? ServerMap.instance.getChunk(j, i) : IsoWorld.instance.CurrentCell.getChunk(j, i);
                if (isoChunk == null) continue;
                for (int k = 0; k < isoChunk.vehicles.size(); ++k) {
                    BaseVehicle baseVehicle = isoChunk.vehicles.get(k);
                    if (baseVehicle.getScript() == null || (int)this.getZ() != (int)baseVehicle.getZ() || this.isLocalPlayer() && baseVehicle.getTargetAlpha(this.PlayerIndex) == 0.0f || this.DistToSquared((int)baseVehicle.x, (int)baseVehicle.y) >= 16.0f || !PolygonalMap2.instance.intersectLineWithVehicle(this.x, this.y, this.x + this.getForwardDirection().x * 4.0f, this.y + this.getForwardDirection().y * 4.0f, baseVehicle, tempVector2) || PolygonalMap2.instance.lineClearCollide(this.x, this.y, IsoPlayer.tempVector2.x, IsoPlayer.tempVector2.y, (int)this.z, baseVehicle, false, true)) continue;
                    return baseVehicle;
                }
            }
        }
        return null;
    }

    private void updateWhileInVehicle() {
        ActionGroup actionGroup;
        this.bLookingWhileInVehicle = false;
        ActionGroup actionGroup2 = this.actionContext.getGroup();
        if (actionGroup2 != (actionGroup = ActionGroup.getActionGroup("player-vehicle"))) {
            this.advancedAnimator.OnAnimDataChanged(false);
            this.initializeStates();
            this.actionContext.setGroup(actionGroup);
        }
        if (GameClient.bClient && this.getVehicle().getSeat(this) == -1) {
            DebugLog.log("forced " + this.getUsername() + " out of vehicle seat -1");
            this.setVehicle(null);
            return;
        }
        this.dirtyRecalcGridStackTime = 10.0f;
        if (this.getVehicle().isDriver(this)) {
            WeaponType weaponType;
            this.getVehicle().updatePhysics();
            boolean bl = true;
            if (this.isAiming() && (weaponType = WeaponType.getWeaponType(this)).equals((Object)WeaponType.firearm)) {
                bl = false;
            }
            if (this.getVariableBoolean("isLoading")) {
                bl = false;
            }
            if (bl) {
                this.getVehicle().updateControls();
            }
        } else {
            BaseVehicle baseVehicle = this.getVehicle();
            if (baseVehicle.getDriver() == null && baseVehicle.engineSpeed > (double)baseVehicle.getScript().getEngineIdleSpeed()) {
                baseVehicle.engineSpeed = Math.max(baseVehicle.engineSpeed - (double)(50.0f * (GameTime.getInstance().getMultiplier() / 0.8f)), (double)baseVehicle.getScript().getEngineIdleSpeed());
            }
            if (GameClient.connection != null) {
                PassengerMap.updatePassenger(this);
            }
        }
        this.fallTime = 0.0f;
        this.bSeenThisFrame = false;
        this.bCouldBeSeenThisFrame = false;
        this.closestZombie = 1000000.0f;
        this.setBeenMovingFor(this.getBeenMovingFor() - 0.625f * GameTime.getInstance().getMultiplier());
        if (!this.Asleep) {
            float f = (float)ZomboidGlobals.SittingEnduranceMultiplier;
            f *= 1.0f - this.stats.fatigue;
            this.stats.endurance = (float)((double)this.stats.endurance + ZomboidGlobals.ImobileEnduranceReduce * SandboxOptions.instance.getEnduranceRegenMultiplier() * (double)this.getRecoveryMod() * (double)(f *= GameTime.instance.getMultiplier()));
            this.stats.endurance = PZMath.clamp(this.stats.endurance, 0.0f, 1.0f);
        }
        this.updateToggleToAim();
        if (this.vehicle != null) {
            VehicleWindow vehicleWindow;
            Vector3f vector3f = this.vehicle.getForwardVector(tempVector3f);
            boolean bl = this.isAimControlActive();
            if (this.PlayerIndex == 0) {
                this.TimeRightPressed = Mouse.isButtonDown(1) ? (this.TimeRightPressed += GameTime.getInstance().getRealworldSecondsSinceLastUpdate()) : 0.0f;
                bl |= Mouse.isButtonDownUICheck(1) && this.TimeRightPressed >= 0.15f;
            }
            if (!bl && this.isCurrentState(IdleState.instance())) {
                this.setForwardDirection(vector3f.x, vector3f.z);
                this.getForwardDirection().normalize();
            }
            if (this.lastAngle.x != this.getForwardDirection().x || this.lastAngle.y != this.getForwardDirection().y) {
                this.dirtyRecalcGridStackTime = 10.0f;
            }
            this.DirectionFromVector(this.getForwardDirection());
            AnimationPlayer animationPlayer = this.getAnimationPlayer();
            if (animationPlayer != null && animationPlayer.isReady()) {
                animationPlayer.SetForceDir(this.getForwardDirection());
                float f = animationPlayer.getAngle() + animationPlayer.getTwistAngle();
                this.dir = IsoDirections.fromAngle(tempVector2.setLengthAndDirection(f, 1.0f));
            }
            boolean bl2 = false;
            int n = this.vehicle.getSeat(this);
            VehiclePart vehiclePart = this.vehicle.getPassengerDoor(n);
            if (vehiclePart != null && (vehicleWindow = vehiclePart.findWindow()) != null && !vehicleWindow.isHittable()) {
                bl2 = true;
            }
            if (bl2) {
                this.attackWhileInVehicle();
            } else if (bl) {
                this.bLookingWhileInVehicle = true;
                this.setAngleFromAim();
            } else {
                this.checkJoypadIgnoreAimUntilCentered();
                this.setIsAiming(false);
            }
        }
        this.updateCursorVisibility();
    }

    private void attackWhileInVehicle() {
        this.setIsAiming(false);
        boolean bl = false;
        boolean bl2 = false;
        if (GameWindow.ActivatedJoyPad != null && this.JoypadBind != -1) {
            if (!this.bJoypadMovementActive) {
                return;
            }
            if (this.isChargingLT && !JoypadManager.instance.isLTPressed(this.JoypadBind)) {
                bl2 = true;
            } else {
                bl = this.isCharging && !JoypadManager.instance.isRTPressed(this.JoypadBind);
            }
            float f = JoypadManager.instance.getAimingAxisX(this.JoypadBind);
            float f2 = JoypadManager.instance.getAimingAxisY(this.JoypadBind);
            if (this.bJoypadIgnoreAimUntilCentered) {
                if (f == 0.0f && f2 == 0.0f) {
                    this.bJoypadIgnoreAimUntilCentered = false;
                } else {
                    f2 = 0.0f;
                    f = 0.0f;
                }
            }
            this.setIsAiming(f * f + f2 * f2 >= 0.09f);
            this.isCharging = this.isAiming() && JoypadManager.instance.isRTPressed(this.JoypadBind);
            this.isChargingLT = this.isAiming() && JoypadManager.instance.isLTPressed(this.JoypadBind);
        } else {
            boolean bl3 = this.isAimKeyDown();
            this.setIsAiming(bl3 || Mouse.isButtonDownUICheck(1) && this.TimeRightPressed >= 0.15f);
            if (this.isCharging) {
                this.isCharging = bl3 || Mouse.isButtonDown(1);
            } else {
                boolean bl4 = this.isCharging = bl3 || Mouse.isButtonDownUICheck(1) && this.TimeRightPressed >= 0.15f;
            }
            if (this.isForceAim()) {
                this.setIsAiming(true);
                this.isCharging = true;
            }
            if (GameKeyboard.isKeyDown(Core.getInstance().getKey("Melee")) && this.authorizeMeleeAction) {
                bl2 = true;
            } else {
                boolean bl5 = bl = this.isCharging && Mouse.isButtonDownUICheck(0);
                if (bl) {
                    this.setIsAiming(true);
                }
            }
        }
        if (!this.isCharging && !this.isChargingLT) {
            this.chargeTime = 0.0f;
        }
        if (!this.isAiming() || this.bBannedAttacking || !this.CanAttack()) {
            return;
        }
        this.chargeTime += GameTime.instance.getMultiplier();
        this.useChargeTime = this.chargeTime;
        this.m_meleePressed = bl2;
        this.setAngleFromAim();
        if (bl2) {
            this.sprite.Animate = true;
            this.setDoShove(true);
            this.AttemptAttack(this.useChargeTime);
            this.useChargeTime = 0.0f;
            this.chargeTime = 0.0f;
        } else if (bl) {
            this.sprite.Animate = true;
            if (this.getRecoilDelay() <= 0.0f) {
                this.AttemptAttack(this.useChargeTime);
            }
            this.useChargeTime = 0.0f;
            this.chargeTime = 0.0f;
        }
    }

    private void setAngleFromAim() {
        Vector2 vector22 = tempVector2;
        if (GameWindow.ActivatedJoyPad != null && this.JoypadBind != -1) {
            this.getControllerAimDir(vector22);
        } else {
            vector22.set(this.getX(), this.getY());
            int n = Mouse.getX();
            int n2 = Mouse.getY();
            vector22.x -= IsoUtils.XToIso(n, (float)n2 + 55.0f * this.def.getScaleY(), this.getZ());
            vector22.y -= IsoUtils.YToIso(n, (float)n2 + 55.0f * this.def.getScaleY(), this.getZ());
            vector22.x = -vector22.x;
            vector22.y = -vector22.y;
        }
        if (vector22.getLengthSquared() > 0.0f) {
            vector22.normalize();
            this.DirectionFromVector(vector22);
            this.setForwardDirection(vector22);
            if (this.lastAngle.x != vector22.x || this.lastAngle.y != vector22.y) {
                this.lastAngle.x = vector22.x;
                this.lastAngle.y = vector22.y;
                this.dirtyRecalcGridStackTime = 10.0f;
            }
        }
    }

    private void updateTorchStrength() {
        if (this.getTorchStrength() > 0.0f || this.flickTorch) {
            DrainableComboItem drainableComboItem = Type.tryCastTo(this.getActiveLightItem(), DrainableComboItem.class);
            if (drainableComboItem == null) {
                return;
            }
            if (Rand.Next(600 - (int)(0.4 / (double)drainableComboItem.getUsedDelta() * 100.0)) == 0) {
                this.flickTorch = true;
            }
            this.flickTorch = false;
            if (this.flickTorch) {
                if (Rand.Next(6) == 0) {
                    drainableComboItem.setActivated(false);
                } else {
                    drainableComboItem.setActivated(true);
                }
                if (Rand.Next(40) == 0) {
                    this.flickTorch = false;
                    drainableComboItem.setActivated(true);
                }
            }
        }
    }

    @Override
    public IsoCell getCell() {
        return IsoWorld.instance.CurrentCell;
    }

    public void calculateContext() {
        float f = this.x;
        float f2 = this.y;
        float f3 = this.x;
        IsoGridSquare[] isoGridSquareArray = new IsoGridSquare[4];
        if (this.dir == IsoDirections.N) {
            isoGridSquareArray[2] = this.getCell().getGridSquare(f - 1.0f, f2 - 1.0f, f3);
            isoGridSquareArray[1] = this.getCell().getGridSquare(f, f2 - 1.0f, f3);
            isoGridSquareArray[3] = this.getCell().getGridSquare(f + 1.0f, f2 - 1.0f, f3);
        } else if (this.dir == IsoDirections.NE) {
            isoGridSquareArray[2] = this.getCell().getGridSquare(f, f2 - 1.0f, f3);
            isoGridSquareArray[1] = this.getCell().getGridSquare(f + 1.0f, f2 - 1.0f, f3);
            isoGridSquareArray[3] = this.getCell().getGridSquare(f + 1.0f, f2, f3);
        } else if (this.dir == IsoDirections.E) {
            isoGridSquareArray[2] = this.getCell().getGridSquare(f + 1.0f, f2 - 1.0f, f3);
            isoGridSquareArray[1] = this.getCell().getGridSquare(f + 1.0f, f2, f3);
            isoGridSquareArray[3] = this.getCell().getGridSquare(f + 1.0f, f2 + 1.0f, f3);
        } else if (this.dir == IsoDirections.SE) {
            isoGridSquareArray[2] = this.getCell().getGridSquare(f + 1.0f, f2, f3);
            isoGridSquareArray[1] = this.getCell().getGridSquare(f + 1.0f, f2 + 1.0f, f3);
            isoGridSquareArray[3] = this.getCell().getGridSquare(f, f2 + 1.0f, f3);
        } else if (this.dir == IsoDirections.S) {
            isoGridSquareArray[2] = this.getCell().getGridSquare(f + 1.0f, f2 + 1.0f, f3);
            isoGridSquareArray[1] = this.getCell().getGridSquare(f, f2 + 1.0f, f3);
            isoGridSquareArray[3] = this.getCell().getGridSquare(f - 1.0f, f2 + 1.0f, f3);
        } else if (this.dir == IsoDirections.SW) {
            isoGridSquareArray[2] = this.getCell().getGridSquare(f, f2 + 1.0f, f3);
            isoGridSquareArray[1] = this.getCell().getGridSquare(f - 1.0f, f2 + 1.0f, f3);
            isoGridSquareArray[3] = this.getCell().getGridSquare(f - 1.0f, f2, f3);
        } else if (this.dir == IsoDirections.W) {
            isoGridSquareArray[2] = this.getCell().getGridSquare(f - 1.0f, f2 + 1.0f, f3);
            isoGridSquareArray[1] = this.getCell().getGridSquare(f - 1.0f, f2, f3);
            isoGridSquareArray[3] = this.getCell().getGridSquare(f - 1.0f, f2 - 1.0f, f3);
        } else if (this.dir == IsoDirections.NW) {
            isoGridSquareArray[2] = this.getCell().getGridSquare(f - 1.0f, f2, f3);
            isoGridSquareArray[1] = this.getCell().getGridSquare(f - 1.0f, f2 - 1.0f, f3);
            isoGridSquareArray[3] = this.getCell().getGridSquare(f, f2 - 1.0f, f3);
        }
        isoGridSquareArray[0] = this.current;
        for (int i = 0; i < 4; ++i) {
            IsoGridSquare isoGridSquare = isoGridSquareArray[i];
            if (isoGridSquare != null) continue;
        }
    }

    public boolean isSafeToClimbOver(IsoDirections isoDirections) {
        IsoGridSquare isoGridSquare = null;
        switch (isoDirections) {
            case N: {
                isoGridSquare = this.getCell().getGridSquare(this.x, this.y - 1.0f, this.z);
                break;
            }
            case S: {
                isoGridSquare = this.getCell().getGridSquare(this.x, this.y + 1.0f, this.z);
                break;
            }
            case W: {
                isoGridSquare = this.getCell().getGridSquare(this.x - 1.0f, this.y, this.z);
                break;
            }
            case E: {
                isoGridSquare = this.getCell().getGridSquare(this.x + 1.0f, this.y, this.z);
                break;
            }
            default: {
                return false;
            }
        }
        if (isoGridSquare == null) {
            return false;
        }
        if (isoGridSquare.Is(IsoFlagType.water)) {
            return false;
        }
        if (!isoGridSquare.TreatAsSolidFloor()) {
            return isoGridSquare.HasStairsBelow();
        }
        return true;
    }

    public boolean doContext(IsoDirections isoDirections) {
        IsoObject isoObject;
        if (this.isIgnoreContextKey()) {
            return false;
        }
        if (this.isBlockMovement()) {
            return false;
        }
        for (int i = 0; i < this.getCell().vehicles.size(); ++i) {
            BaseVehicle baseVehicle = this.getCell().vehicles.get(i);
            if (baseVehicle.getUseablePart(this) == null) continue;
            return false;
        }
        float f = this.x - (float)((int)this.x);
        float f2 = this.y - (float)((int)this.y);
        IsoDirections isoDirections2 = IsoDirections.Max;
        IsoDirections isoDirections3 = IsoDirections.Max;
        if (isoDirections == IsoDirections.NW) {
            if (f2 < f) {
                if (this.doContextNSWE(IsoDirections.N)) {
                    return true;
                }
                if (this.doContextNSWE(IsoDirections.W)) {
                    return true;
                }
                isoDirections2 = IsoDirections.S;
                isoDirections3 = IsoDirections.E;
            } else {
                if (this.doContextNSWE(IsoDirections.W)) {
                    return true;
                }
                if (this.doContextNSWE(IsoDirections.N)) {
                    return true;
                }
                isoDirections2 = IsoDirections.E;
                isoDirections3 = IsoDirections.S;
            }
        } else if (isoDirections == IsoDirections.NE) {
            if (f2 < (f = 1.0f - f)) {
                if (this.doContextNSWE(IsoDirections.N)) {
                    return true;
                }
                if (this.doContextNSWE(IsoDirections.E)) {
                    return true;
                }
                isoDirections2 = IsoDirections.S;
                isoDirections3 = IsoDirections.W;
            } else {
                if (this.doContextNSWE(IsoDirections.E)) {
                    return true;
                }
                if (this.doContextNSWE(IsoDirections.N)) {
                    return true;
                }
                isoDirections2 = IsoDirections.W;
                isoDirections3 = IsoDirections.S;
            }
        } else if (isoDirections == IsoDirections.SE) {
            if ((f2 = 1.0f - f2) < (f = 1.0f - f)) {
                if (this.doContextNSWE(IsoDirections.S)) {
                    return true;
                }
                if (this.doContextNSWE(IsoDirections.E)) {
                    return true;
                }
                isoDirections2 = IsoDirections.N;
                isoDirections3 = IsoDirections.W;
            } else {
                if (this.doContextNSWE(IsoDirections.E)) {
                    return true;
                }
                if (this.doContextNSWE(IsoDirections.S)) {
                    return true;
                }
                isoDirections2 = IsoDirections.W;
                isoDirections3 = IsoDirections.N;
            }
        } else if (isoDirections == IsoDirections.SW) {
            if ((f2 = 1.0f - f2) < f) {
                if (this.doContextNSWE(IsoDirections.S)) {
                    return true;
                }
                if (this.doContextNSWE(IsoDirections.W)) {
                    return true;
                }
                isoDirections2 = IsoDirections.N;
                isoDirections3 = IsoDirections.E;
            } else {
                if (this.doContextNSWE(IsoDirections.W)) {
                    return true;
                }
                if (this.doContextNSWE(IsoDirections.S)) {
                    return true;
                }
                isoDirections2 = IsoDirections.E;
                isoDirections3 = IsoDirections.N;
            }
        } else {
            if (this.doContextNSWE(isoDirections)) {
                return true;
            }
            isoDirections2 = isoDirections.RotLeft(4);
        }
        if (isoDirections2 != IsoDirections.Max && (isoObject = this.getContextDoorOrWindowOrWindowFrame(isoDirections2)) != null) {
            this.doContextDoorOrWindowOrWindowFrame(isoDirections2, isoObject);
            return true;
        }
        if (isoDirections3 != IsoDirections.Max && (isoObject = this.getContextDoorOrWindowOrWindowFrame(isoDirections3)) != null) {
            this.doContextDoorOrWindowOrWindowFrame(isoDirections3, isoObject);
            return true;
        }
        return false;
    }

    private boolean doContextNSWE(IsoDirections isoDirections) {
        assert (isoDirections == IsoDirections.N || isoDirections == IsoDirections.S || isoDirections == IsoDirections.W || isoDirections == IsoDirections.E);
        if (this.current == null) {
            return false;
        }
        if (isoDirections == IsoDirections.N && this.current.Is(IsoFlagType.climbSheetN) && this.canClimbSheetRope(this.current)) {
            this.climbSheetRope();
            return true;
        }
        if (isoDirections == IsoDirections.S && this.current.Is(IsoFlagType.climbSheetS) && this.canClimbSheetRope(this.current)) {
            this.climbSheetRope();
            return true;
        }
        if (isoDirections == IsoDirections.W && this.current.Is(IsoFlagType.climbSheetW) && this.canClimbSheetRope(this.current)) {
            this.climbSheetRope();
            return true;
        }
        if (isoDirections == IsoDirections.E && this.current.Is(IsoFlagType.climbSheetE) && this.canClimbSheetRope(this.current)) {
            this.climbSheetRope();
            return true;
        }
        IsoGridSquare isoGridSquare = this.current.nav[isoDirections.index()];
        boolean bl = IsoWindow.isTopOfSheetRopeHere(isoGridSquare) && this.canClimbDownSheetRope(isoGridSquare);
        IsoObject isoObject = this.getContextDoorOrWindowOrWindowFrame(isoDirections);
        if (isoObject != null) {
            this.doContextDoorOrWindowOrWindowFrame(isoDirections, isoObject);
            return true;
        }
        if (GameKeyboard.isKeyDown(42) && this.current != null && this.ticksSincePressedMovement > 15.0f) {
            IsoObject isoObject2;
            IsoGridSquare isoGridSquare2;
            IsoObject isoObject3 = this.current.getDoor(true);
            if (isoObject3 instanceof IsoDoor && ((IsoDoor)isoObject3).isFacingSheet(this)) {
                ((IsoDoor)isoObject3).toggleCurtain();
                return true;
            }
            IsoObject isoObject4 = this.current.getDoor(false);
            if (isoObject4 instanceof IsoDoor && ((IsoDoor)isoObject4).isFacingSheet(this)) {
                ((IsoDoor)isoObject4).toggleCurtain();
                return true;
            }
            if (isoDirections == IsoDirections.E) {
                isoGridSquare2 = IsoWorld.instance.CurrentCell.getGridSquare(this.x + 1.0f, this.y, this.z);
                IsoObject isoObject5 = isoObject2 = isoGridSquare2 != null ? isoGridSquare2.getDoor(true) : null;
                if (isoObject2 instanceof IsoDoor && ((IsoDoor)isoObject2).isFacingSheet(this)) {
                    ((IsoDoor)isoObject2).toggleCurtain();
                    return true;
                }
            }
            if (isoDirections == IsoDirections.S) {
                isoGridSquare2 = IsoWorld.instance.CurrentCell.getGridSquare(this.x, this.y + 1.0f, this.z);
                IsoObject isoObject6 = isoObject2 = isoGridSquare2 != null ? isoGridSquare2.getDoor(false) : null;
                if (isoObject2 instanceof IsoDoor && ((IsoDoor)isoObject2).isFacingSheet(this)) {
                    ((IsoDoor)isoObject2).toggleCurtain();
                    return true;
                }
            }
        }
        boolean bl2 = this.isSafeToClimbOver(isoDirections);
        if (this.z > 0.0f && bl) {
            bl2 = true;
        }
        if (this.timePressedContext < 0.5f && !bl2) {
            return false;
        }
        if (this.ignoreAutoVault) {
            return false;
        }
        if (isoDirections == IsoDirections.N && this.getCurrentSquare().Is(IsoFlagType.HoppableN)) {
            this.climbOverFence(isoDirections);
            return true;
        }
        if (isoDirections == IsoDirections.W && this.getCurrentSquare().Is(IsoFlagType.HoppableW)) {
            this.climbOverFence(isoDirections);
            return true;
        }
        if (isoDirections == IsoDirections.S && IsoWorld.instance.CurrentCell.getGridSquare(this.x, this.y + 1.0f, this.z) != null && IsoWorld.instance.CurrentCell.getGridSquare(this.x, this.y + 1.0f, this.z).Is(IsoFlagType.HoppableN)) {
            this.climbOverFence(isoDirections);
            return true;
        }
        if (isoDirections == IsoDirections.E && IsoWorld.instance.CurrentCell.getGridSquare(this.x + 1.0f, this.y, this.z) != null && IsoWorld.instance.CurrentCell.getGridSquare(this.x + 1.0f, this.y, this.z).Is(IsoFlagType.HoppableW)) {
            this.climbOverFence(isoDirections);
            return true;
        }
        return this.climbOverWall(isoDirections);
    }

    public IsoObject getContextDoorOrWindowOrWindowFrame(IsoDirections isoDirections) {
        if (this.current == null || isoDirections == null) {
            return null;
        }
        IsoGridSquare isoGridSquare = this.current.nav[isoDirections.index()];
        IsoObject isoObject = null;
        switch (isoDirections) {
            case N: {
                isoObject = this.current.getOpenDoor(isoDirections);
                if (isoObject != null) {
                    return isoObject;
                }
                isoObject = this.current.getDoorOrWindowOrWindowFrame(isoDirections, true);
                if (isoObject != null) {
                    return isoObject;
                }
                isoObject = this.current.getDoor(true);
                if (isoObject != null) {
                    return isoObject;
                }
                if (isoGridSquare == null || this.current.isBlockedTo(isoGridSquare)) break;
                isoObject = isoGridSquare.getOpenDoor(IsoDirections.S);
                break;
            }
            case S: {
                isoObject = this.current.getOpenDoor(isoDirections);
                if (isoObject != null) {
                    return isoObject;
                }
                if (isoGridSquare == null) break;
                boolean bl = this.current.isBlockedTo(isoGridSquare);
                isoObject = isoGridSquare.getDoorOrWindowOrWindowFrame(IsoDirections.N, bl);
                if (isoObject != null) {
                    return isoObject;
                }
                isoObject = isoGridSquare.getDoor(true);
                break;
            }
            case W: {
                isoObject = this.current.getOpenDoor(isoDirections);
                if (isoObject != null) {
                    return isoObject;
                }
                isoObject = this.current.getDoorOrWindowOrWindowFrame(isoDirections, true);
                if (isoObject != null) {
                    return isoObject;
                }
                isoObject = this.current.getDoor(false);
                if (isoObject != null) {
                    return isoObject;
                }
                if (isoGridSquare == null || this.current.isBlockedTo(isoGridSquare)) break;
                isoObject = isoGridSquare.getOpenDoor(IsoDirections.E);
                break;
            }
            case E: {
                isoObject = this.current.getOpenDoor(isoDirections);
                if (isoObject != null) {
                    return isoObject;
                }
                if (isoGridSquare == null) break;
                boolean bl = this.current.isBlockedTo(isoGridSquare);
                isoObject = isoGridSquare.getDoorOrWindowOrWindowFrame(IsoDirections.W, bl);
                if (isoObject != null) {
                    return isoObject;
                }
                isoObject = isoGridSquare.getDoor(false);
            }
        }
        return isoObject;
    }

    private void doContextDoorOrWindowOrWindowFrame(IsoDirections isoDirections, IsoObject isoObject) {
        boolean bl;
        IsoGridSquare isoGridSquare = this.current.nav[isoDirections.index()];
        boolean bl2 = bl = IsoWindow.isTopOfSheetRopeHere(isoGridSquare) && this.canClimbDownSheetRope(isoGridSquare);
        if (isoObject instanceof IsoDoor) {
            IsoDoor isoDoor = (IsoDoor)isoObject;
            if (GameKeyboard.isKeyDown(42) && isoDoor.HasCurtains() != null && isoDoor.isFacingSheet(this) && this.ticksSincePressedMovement > 15.0f) {
                isoDoor.toggleCurtain();
            } else if (this.timePressedContext >= 0.5f) {
                if (isoDoor.isHoppable() && !this.isIgnoreAutoVault()) {
                    this.climbOverFence(isoDirections);
                } else {
                    isoDoor.ToggleDoor(this);
                }
            } else {
                isoDoor.ToggleDoor(this);
            }
        } else if (isoObject instanceof IsoThumpable && ((IsoThumpable)isoObject).isDoor()) {
            IsoThumpable isoThumpable = (IsoThumpable)isoObject;
            if (this.timePressedContext >= 0.5f) {
                if (isoThumpable.isHoppable() && !this.isIgnoreAutoVault()) {
                    this.climbOverFence(isoDirections);
                } else {
                    isoThumpable.ToggleDoor(this);
                }
            } else {
                isoThumpable.ToggleDoor(this);
            }
        } else if (isoObject instanceof IsoWindow && !isoObject.getSquare().getProperties().Is(IsoFlagType.makeWindowInvincible)) {
            IsoWindow isoWindow = (IsoWindow)isoObject;
            if (GameKeyboard.isKeyDown(42)) {
                IsoCurtain isoCurtain = isoWindow.HasCurtains();
                if (isoCurtain != null && this.current != null && !isoCurtain.getSquare().isBlockedTo(this.current)) {
                    isoCurtain.ToggleDoor(this);
                }
            } else if (this.timePressedContext >= 0.5f) {
                if (isoWindow.canClimbThrough(this)) {
                    this.climbThroughWindow(isoWindow);
                } else if (!(isoWindow.PermaLocked || isoWindow.isBarricaded() || isoWindow.IsOpen() || isoWindow.isDestroyed())) {
                    this.openWindow(isoWindow);
                }
            } else if (isoWindow.Health > 0 && !isoWindow.isDestroyed()) {
                IsoBarricade isoBarricade = isoWindow.getBarricadeForCharacter(this);
                if (!isoWindow.open && isoBarricade == null) {
                    this.openWindow(isoWindow);
                } else if (isoBarricade == null) {
                    this.closeWindow(isoWindow);
                }
            } else if (isoWindow.isGlassRemoved()) {
                if (!(this.isSafeToClimbOver(isoDirections) || isoObject.getSquare().haveSheetRope || bl)) {
                    return;
                }
                if (!isoWindow.isBarricaded()) {
                    this.climbThroughWindow(isoWindow);
                }
            }
        } else if (isoObject instanceof IsoThumpable && !isoObject.getSquare().getProperties().Is(IsoFlagType.makeWindowInvincible)) {
            IsoThumpable isoThumpable = (IsoThumpable)isoObject;
            if (GameKeyboard.isKeyDown(42)) {
                IsoCurtain isoCurtain = isoThumpable.HasCurtains();
                if (isoCurtain != null && this.current != null && !isoCurtain.getSquare().isBlockedTo(this.current)) {
                    isoCurtain.ToggleDoor(this);
                }
            } else if (this.timePressedContext >= 0.5f) {
                if (isoThumpable.canClimbThrough(this)) {
                    this.climbThroughWindow(isoThumpable);
                }
            } else {
                if (!(this.isSafeToClimbOver(isoDirections) || isoObject.getSquare().haveSheetRope || bl)) {
                    return;
                }
                if (isoThumpable.canClimbThrough(this)) {
                    this.climbThroughWindow(isoThumpable);
                }
            }
        } else if (IsoWindowFrame.isWindowFrame(isoObject)) {
            if (GameKeyboard.isKeyDown(42)) {
                IsoCurtain isoCurtain = IsoWindowFrame.getCurtain(isoObject);
                if (isoCurtain != null && this.current != null && !isoCurtain.getSquare().isBlockedTo(this.current)) {
                    isoCurtain.ToggleDoor(this);
                }
            } else if ((this.timePressedContext >= 0.5f || this.isSafeToClimbOver(isoDirections) || bl) && IsoWindowFrame.canClimbThrough(isoObject, this)) {
                this.climbThroughWindowFrame(isoObject);
            }
        }
    }

    public boolean hopFence(IsoDirections isoDirections, boolean bl) {
        IsoDirections isoDirections2 = isoDirections;
        float f = this.x - (float)((int)this.x);
        float f2 = this.y - (float)((int)this.y);
        if (isoDirections == IsoDirections.NW) {
            if (f2 < f) {
                if (this.hopFence(IsoDirections.N, bl)) {
                    return true;
                }
                return this.hopFence(IsoDirections.W, bl);
            }
            if (this.hopFence(IsoDirections.W, bl)) {
                return true;
            }
            return this.hopFence(IsoDirections.N, bl);
        }
        if (isoDirections == IsoDirections.NE) {
            if (f2 < (f = 1.0f - f)) {
                if (this.hopFence(IsoDirections.N, bl)) {
                    return true;
                }
                return this.hopFence(IsoDirections.E, bl);
            }
            if (this.hopFence(IsoDirections.E, bl)) {
                return true;
            }
            return this.hopFence(IsoDirections.N, bl);
        }
        if (isoDirections == IsoDirections.SE) {
            if ((f2 = 1.0f - f2) < (f = 1.0f - f)) {
                if (this.hopFence(IsoDirections.S, bl)) {
                    return true;
                }
                return this.hopFence(IsoDirections.E, bl);
            }
            if (this.hopFence(IsoDirections.E, bl)) {
                return true;
            }
            return this.hopFence(IsoDirections.S, bl);
        }
        if (isoDirections == IsoDirections.SW) {
            if ((f2 = 1.0f - f2) < f) {
                if (this.hopFence(IsoDirections.S, bl)) {
                    return true;
                }
                return this.hopFence(IsoDirections.W, bl);
            }
            if (this.hopFence(IsoDirections.W, bl)) {
                return true;
            }
            return this.hopFence(IsoDirections.S, bl);
        }
        if (this.current == null) {
            return false;
        }
        IsoGridSquare isoGridSquare = this.current.nav[isoDirections2.index()];
        if (isoGridSquare == null || isoGridSquare.Is(IsoFlagType.water)) {
            return false;
        }
        if (isoDirections2 == IsoDirections.N && this.getCurrentSquare().Is(IsoFlagType.HoppableN)) {
            if (bl) {
                return true;
            }
            this.climbOverFence(isoDirections2);
            return true;
        }
        if (isoDirections2 == IsoDirections.W && this.getCurrentSquare().Is(IsoFlagType.HoppableW)) {
            if (bl) {
                return true;
            }
            this.climbOverFence(isoDirections2);
            return true;
        }
        if (isoDirections2 == IsoDirections.S && IsoWorld.instance.CurrentCell.getGridSquare(this.x, this.y + 1.0f, this.z) != null && IsoWorld.instance.CurrentCell.getGridSquare(this.x, this.y + 1.0f, this.z).Is(IsoFlagType.HoppableN)) {
            if (bl) {
                return true;
            }
            this.climbOverFence(isoDirections2);
            return true;
        }
        if (isoDirections2 == IsoDirections.E && IsoWorld.instance.CurrentCell.getGridSquare(this.x + 1.0f, this.y, this.z) != null && IsoWorld.instance.CurrentCell.getGridSquare(this.x + 1.0f, this.y, this.z).Is(IsoFlagType.HoppableW)) {
            if (bl) {
                return true;
            }
            this.climbOverFence(isoDirections2);
            return true;
        }
        return false;
    }

    public boolean canClimbOverWall(IsoDirections isoDirections) {
        if (this.isSprinting()) {
            return false;
        }
        if (!this.isSafeToClimbOver(isoDirections) || this.current == null) {
            return false;
        }
        if (this.current.haveRoof) {
            return false;
        }
        if (this.current.getBuilding() != null) {
            return false;
        }
        IsoGridSquare isoGridSquare = IsoWorld.instance.CurrentCell.getGridSquare(this.current.x, this.current.y, this.current.z + 1);
        if (isoGridSquare != null && isoGridSquare.HasSlopedRoof()) {
            return false;
        }
        IsoGridSquare isoGridSquare2 = this.current.nav[isoDirections.index()];
        if (isoGridSquare2.haveRoof) {
            return false;
        }
        if (isoGridSquare2.isSolid() || isoGridSquare2.isSolidTrans()) {
            return false;
        }
        if (isoGridSquare2.getBuilding() != null) {
            return false;
        }
        IsoGridSquare isoGridSquare3 = IsoWorld.instance.CurrentCell.getGridSquare(isoGridSquare2.x, isoGridSquare2.y, isoGridSquare2.z + 1);
        if (isoGridSquare3 != null && isoGridSquare3.HasSlopedRoof()) {
            return false;
        }
        switch (isoDirections) {
            case N: {
                if (this.current.Is(IsoFlagType.CantClimb)) {
                    return false;
                }
                if (!this.current.Has(IsoObjectType.wall)) {
                    return false;
                }
                if (!this.current.Is(IsoFlagType.collideN)) {
                    return false;
                }
                if (this.current.Is(IsoFlagType.HoppableN)) {
                    return false;
                }
                if (isoGridSquare == null || !isoGridSquare.Is(IsoFlagType.collideN)) break;
                return false;
            }
            case S: {
                if (isoGridSquare2.Is(IsoFlagType.CantClimb)) {
                    return false;
                }
                if (!isoGridSquare2.Has(IsoObjectType.wall)) {
                    return false;
                }
                if (!isoGridSquare2.Is(IsoFlagType.collideN)) {
                    return false;
                }
                if (isoGridSquare2.Is(IsoFlagType.HoppableN)) {
                    return false;
                }
                if (isoGridSquare3 == null || !isoGridSquare3.Is(IsoFlagType.collideN)) break;
                return false;
            }
            case W: {
                if (this.current.Is(IsoFlagType.CantClimb)) {
                    return false;
                }
                if (!this.current.Has(IsoObjectType.wall)) {
                    return false;
                }
                if (!this.current.Is(IsoFlagType.collideW)) {
                    return false;
                }
                if (this.current.Is(IsoFlagType.HoppableW)) {
                    return false;
                }
                if (isoGridSquare == null || !isoGridSquare.Is(IsoFlagType.collideW)) break;
                return false;
            }
            case E: {
                if (isoGridSquare2.Is(IsoFlagType.CantClimb)) {
                    return false;
                }
                if (!isoGridSquare2.Has(IsoObjectType.wall)) {
                    return false;
                }
                if (!isoGridSquare2.Is(IsoFlagType.collideW)) {
                    return false;
                }
                if (isoGridSquare2.Is(IsoFlagType.HoppableW)) {
                    return false;
                }
                if (isoGridSquare3 == null || !isoGridSquare3.Is(IsoFlagType.collideW)) break;
                return false;
            }
            default: {
                return false;
            }
        }
        return IsoWindow.canClimbThroughHelper(this, this.current, isoGridSquare2, isoDirections == IsoDirections.N || isoDirections == IsoDirections.S);
    }

    public boolean climbOverWall(IsoDirections isoDirections) {
        if (!this.canClimbOverWall(isoDirections)) {
            return false;
        }
        this.dropHeavyItems();
        ClimbOverWallState.instance().setParams(this, isoDirections);
        this.actionContext.reportEvent("EventClimbWall");
        return true;
    }

    private void updateSleepingPillsTaken() {
        if (this.getSleepingPillsTaken() > 0 && this.lastPillsTaken > 0L && GameTime.instance.Calender.getTimeInMillis() - this.lastPillsTaken > 0x6DDD00L) {
            this.setSleepingPillsTaken(this.getSleepingPillsTaken() - 1);
        }
    }

    public boolean AttemptAttack() {
        return this.DoAttack(this.useChargeTime);
    }

    @Override
    public boolean DoAttack(float f) {
        return this.DoAttack(f, false, null);
    }

    public boolean DoAttack(float f, boolean bl, String string) {
        if (!this.authorizeMeleeAction) {
            return false;
        }
        this.setForceShove(bl);
        this.setClickSound(string);
        this.pressedAttack(true);
        return false;
    }

    public int getPlayerNum() {
        return this.PlayerIndex;
    }

    public void updateLOS() {
        float f;
        this.spottedList.clear();
        this.stats.NumVisibleZombies = 0;
        this.stats.LastNumChasingZombies = this.stats.NumChasingZombies;
        this.stats.NumChasingZombies = 0;
        this.stats.MusicZombiesTargeting = 0;
        this.stats.MusicZombiesVisible = 0;
        this.NumSurvivorsInVicinity = 0;
        if (this.getCurrentSquare() == null) {
            return;
        }
        boolean bl = GameServer.bServer;
        boolean bl2 = GameClient.bClient;
        int n = this.PlayerIndex;
        IsoPlayer isoPlayer = IsoPlayer.getInstance();
        float f2 = this.getX();
        float f3 = this.getY();
        float f4 = this.getZ();
        int n2 = 0;
        int n3 = 0;
        int n4 = this.getCell().getObjectList().size();
        for (int i = 0; i < n4; ++i) {
            IsoGridSquare isoGridSquare;
            IsoMovingObject isoMovingObject = this.getCell().getObjectList().get(i);
            if (isoMovingObject instanceof IsoPhysicsObject || isoMovingObject instanceof BaseVehicle) continue;
            if (isoMovingObject == this) {
                this.spottedList.add(isoMovingObject);
                continue;
            }
            float f5 = isoMovingObject.getX();
            float f6 = isoMovingObject.getY();
            float f7 = isoMovingObject.getZ();
            float f8 = IsoUtils.DistanceTo(f5, f6, f2, f3);
            if (f8 < 20.0f) {
                ++n2;
            }
            if ((isoGridSquare = isoMovingObject.getCurrentSquare()) == null) continue;
            if (this.isSeeEveryone()) {
                isoMovingObject.setAlphaAndTarget(n, 1.0f);
                continue;
            }
            IsoGameCharacter isoGameCharacter = Type.tryCastTo(isoMovingObject, IsoGameCharacter.class);
            IsoPlayer isoPlayer2 = Type.tryCastTo(isoGameCharacter, IsoPlayer.class);
            IsoZombie isoZombie = Type.tryCastTo(isoGameCharacter, IsoZombie.class);
            if (isoPlayer != null && isoMovingObject != isoPlayer && isoGameCharacter != null && isoGameCharacter.isInvisible() && isoPlayer.accessLevel.isEmpty()) {
                isoGameCharacter.setAlphaAndTarget(n, 0.0f);
                continue;
            }
            float f9 = this.getSeeNearbyCharacterDistance();
            boolean bl3 = bl ? ServerLOS.instance.isCouldSee(this, isoGridSquare) : isoGridSquare.isCouldSee(n);
            boolean bl4 = bl2 && isoPlayer2 != null ? true : (!bl ? isoGridSquare.isCanSee(n) : bl3);
            if (!this.isAsleep() && (bl4 || f8 < f9 && bl3)) {
                this.TestZombieSpotPlayer(isoMovingObject);
                if (isoGameCharacter != null && isoGameCharacter.IsVisibleToPlayer[n]) {
                    if (isoGameCharacter instanceof IsoSurvivor) {
                        ++this.NumSurvivorsInVicinity;
                    }
                    if (isoZombie != null) {
                        this.lastSeenZombieTime = 0.0;
                        if (f7 >= f4 - 1.0f && f8 < 7.0f && !isoZombie.Ghost && !isoZombie.isFakeDead() && isoGridSquare.getRoom() == this.getCurrentSquare().getRoom()) {
                            this.TicksSinceSeenZombie = 0;
                            ++this.stats.NumVisibleZombies;
                        }
                        if (f8 < 3.0f) {
                            ++n3;
                        }
                        if (!isoZombie.isSceneCulled()) {
                            ++this.stats.MusicZombiesVisible;
                            if (isoZombie.target == this) {
                                ++this.stats.MusicZombiesTargeting;
                            }
                        }
                    }
                    this.spottedList.add(isoGameCharacter);
                    if (!(isoPlayer2 instanceof IsoPlayer) && !this.bRemote) {
                        if (isoPlayer2 != null && isoPlayer2 != isoPlayer) {
                            isoPlayer2.setTargetAlpha(n, 1.0f);
                        } else {
                            isoGameCharacter.setTargetAlpha(n, 1.0f);
                        }
                    }
                    float f10 = 4.0f;
                    if (this.stats.NumVisibleZombies > 4) {
                        f10 = 7.0f;
                    }
                    if (f8 < f10 && isoGameCharacter instanceof IsoZombie && (int)f7 == (int)f4 && !this.isGhostMode() && !bl2) {
                        GameTime.instance.setMultiplier(1.0f);
                        if (!bl) {
                            UIManager.getSpeedControls().SetCurrentGameSpeed(1);
                        }
                    }
                    if (f8 < f10 && isoGameCharacter instanceof IsoZombie && (int)f7 == (int)f4 && !this.LastSpotted.contains(isoGameCharacter)) {
                        this.stats.NumVisibleZombies += 2;
                    }
                }
            } else {
                if (isoMovingObject != instance) {
                    isoMovingObject.setTargetAlpha(n, 0.0f);
                }
                if (bl3) {
                    this.TestZombieSpotPlayer(isoMovingObject);
                }
            }
            if (!(f8 < 2.0f) || isoMovingObject.getTargetAlpha(n) != 1.0f || this.bRemote) continue;
            isoMovingObject.setAlpha(n, 1.0f);
        }
        if (this.isAlive() && n3 > 0 && this.stats.LastVeryCloseZombies == 0 && this.stats.NumVisibleZombies > 0 && this.stats.LastNumVisibleZombies == 0 && this.timeSinceLastStab >= 600.0f) {
            this.timeSinceLastStab = 0.0f;
            long l = this.getEmitter().playSoundImpl("ZombieSurprisedPlayer", null);
            this.getEmitter().setVolume(l, (float)Core.getInstance().getOptionJumpScareVolume() / 10.0f);
        }
        if (this.stats.NumVisibleZombies > 0) {
            this.timeSinceLastStab = 0.0f;
        }
        if (this.timeSinceLastStab < 600.0f) {
            this.timeSinceLastStab += GameTime.getInstance().getMultiplier() / 1.6f;
        }
        if ((f = (float)n2 / 20.0f) > 1.0f) {
            f = 1.0f;
        }
        SoundManager.instance.BlendVolume(MainScreenState.ambient, f *= 0.6f);
        int n5 = 0;
        for (int i = 0; i < this.spottedList.size(); ++i) {
            if (!this.LastSpotted.contains(this.spottedList.get(i))) {
                this.LastSpotted.add((IsoMovingObject)this.spottedList.get(i));
            }
            if (!(this.spottedList.get(i) instanceof IsoZombie)) continue;
            ++n5;
        }
        if (this.ClearSpottedTimer <= 0 && n5 == 0) {
            this.LastSpotted.clear();
            this.ClearSpottedTimer = 1000;
        } else {
            --this.ClearSpottedTimer;
        }
        this.stats.LastNumVisibleZombies = this.stats.NumVisibleZombies;
        this.stats.LastVeryCloseZombies = n3;
    }

    public float getSeeNearbyCharacterDistance() {
        return 3.5f - this.stats.getFatigue();
    }

    private boolean checkSpottedPLayerTimer(IsoPlayer isoPlayer) {
        if (!isoPlayer.spottedByPlayer) {
            return false;
        }
        if (this.spottedPlayerTimer.containsKey(isoPlayer.getRemoteID())) {
            this.spottedPlayerTimer.put(isoPlayer.getRemoteID(), this.spottedPlayerTimer.get(isoPlayer.getRemoteID()) + 1);
        } else {
            this.spottedPlayerTimer.put(isoPlayer.getRemoteID(), 1);
        }
        if (this.spottedPlayerTimer.get(isoPlayer.getRemoteID()) > 100) {
            isoPlayer.spottedByPlayer = false;
            isoPlayer.doRenderShadow = false;
            return false;
        }
        return true;
    }

    public boolean checkCanSeeClient(UdpConnection udpConnection) {
        if (udpConnection.accessLevel > 1) {
            return true;
        }
        return !this.isInvisible();
    }

    public boolean checkCanSeeClient(IsoPlayer isoPlayer) {
        int n;
        float f;
        float f2;
        isoPlayer.doRenderShadow = true;
        Vector2 vector22 = tempVector2_1.set(this.getX(), this.getY());
        Vector2 vector23 = tempVector2_2.set(isoPlayer.getX(), isoPlayer.getY());
        vector23.x -= vector22.x;
        vector23.y -= vector22.y;
        Vector2 vector24 = this.getForwardDirection();
        vector23.normalize();
        vector24.normalize();
        vector24.normalize();
        float f3 = vector23.dot(vector24);
        if (!GameClient.bClient || isoPlayer == this || !this.isLocalPlayer()) {
            return true;
        }
        if (!this.isAccessLevel("None") && this.canSeeAll) {
            isoPlayer.spottedByPlayer = true;
            return true;
        }
        float f4 = f2 = this.current == null ? 0.0f : isoPlayer.getCurrentSquare().DistTo(this.getCurrentSquare());
        if (f2 <= 2.0f) {
            isoPlayer.spottedByPlayer = true;
            return true;
        }
        if (ServerOptions.getInstance().HidePlayersBehindYou.getValue() && (double)f3 < -0.5) {
            return this.checkSpottedPLayerTimer(isoPlayer);
        }
        if (isoPlayer.isGhostMode() && this.isAccessLevel("None")) {
            isoPlayer.doRenderShadow = false;
            isoPlayer.spottedByPlayer = false;
            return false;
        }
        IsoGridSquare.ILighting iLighting = isoPlayer.getCurrentSquare().lighting[this.getPlayerNum()];
        if (!iLighting.bCouldSee()) {
            return this.checkSpottedPLayerTimer(isoPlayer);
        }
        if (!isoPlayer.isSneaking() || !ServerOptions.getInstance().SneakModeHideFromOtherPlayers.getValue() || isoPlayer.isSprinting()) {
            isoPlayer.spottedByPlayer = true;
            return true;
        }
        if (f2 > 30.0f) {
            isoPlayer.spottedByPlayer = false;
        }
        if (isoPlayer.spottedByPlayer) {
            return true;
        }
        isoPlayer.doRenderShadow = true;
        float f5 = (float)(Math.pow(Math.max(40.0f - f2, 0.0f), 3.0) / 12000.0);
        float f6 = (float)(1.0 - (double)((float)isoPlayer.remoteSneakLvl / 10.0f) * 0.9 + 0.3);
        float f7 = 1.0f;
        if ((double)f3 < 0.8) {
            f7 = 0.3f;
        }
        if ((double)f3 < 0.6) {
            f7 = 0.05f;
        }
        float f8 = (iLighting.lightInfo().getR() + iLighting.lightInfo().getG() + iLighting.lightInfo().getB()) / 3.0f;
        float f9 = (float)((1.0 - (double)((float)this.getMoodles().getMoodleLevel(MoodleType.Tired) / 5.0f)) * 0.7 + 0.3);
        float f10 = 0.1f;
        if (isoPlayer.isPlayerMoving()) {
            f10 = 0.35f;
        }
        if (isoPlayer.isRunning()) {
            f10 = 1.0f;
        }
        ArrayList<PolygonalMap2.Point> arrayList = PolygonalMap2.instance.getPointInLine(isoPlayer.getX(), isoPlayer.getY(), this.getX(), this.getY(), (int)this.getZ());
        IsoGridSquare isoGridSquare = null;
        float f11 = 0.0f;
        float f12 = 0.0f;
        boolean bl = false;
        for (int i = 0; i < arrayList.size(); ++i) {
            PolygonalMap2.Point point = arrayList.get(i);
            isoGridSquare = IsoCell.getInstance().getGridSquare((double)point.x, (double)point.y, this.getZ());
            if (isoGridSquare == null) continue;
            f = isoGridSquare.getGridSneakModifier(false);
            if (f > 1.0f) {
                bl = true;
                break;
            }
            for (n = 0; n < isoGridSquare.getObjects().size(); n += 1) {
                IsoObject isoObject = isoGridSquare.getObjects().get(n);
                if (!isoObject.getSprite().getProperties().Is(IsoFlagType.solidtrans) && !isoObject.getSprite().getProperties().Is(IsoFlagType.solid) && !isoObject.getSprite().getProperties().Is(IsoFlagType.windowW) && !isoObject.getSprite().getProperties().Is(IsoFlagType.windowN)) continue;
                bl = true;
                break;
            }
            if (bl) break;
        }
        if (bl) {
            f11 = isoGridSquare.DistTo(isoPlayer.getCurrentSquare());
            f12 = isoGridSquare.DistTo(this.getCurrentSquare());
        }
        float f13 = f12 < 2.0f ? 5.0f : Math.min(f11, 5.0f);
        f13 = Math.max(0.0f, f13 - 1.0f);
        float f14 = Math.max(0.1f, 1.0f - ClimateManager.getInstance().getFogIntensity());
        f = f7 * f5 * f8 * f6 * f9 * f10 * (f13 = (float)((double)f13 / 5.0 * 0.9 + 0.1)) * f14;
        if (f >= 1.0f) {
            isoPlayer.spottedByPlayer = true;
            return true;
        }
        f = (float)(1.0 - Math.pow(1.0f - f, GameTime.getInstance().getMultiplier()));
        isoPlayer.spottedByPlayer = n = Rand.Next(0.0f, 1.0f) < (f *= 0.5f) ? 1 : 0;
        if (!n) {
            isoPlayer.doRenderShadow = false;
        }
        return n != 0;
    }

    public String getTimeSurvived() {
        int n;
        Object object = "";
        int n2 = n = (int)this.getHoursSurvived();
        int n3 = n / 24;
        n2 = n % 24;
        int n4 = n3 / 30;
        n3 %= 30;
        int n5 = n4 / 12;
        n4 %= 12;
        String string = Translator.getText("IGUI_Gametime_day");
        String string2 = Translator.getText("IGUI_Gametime_year");
        String string3 = Translator.getText("IGUI_Gametime_hour");
        String string4 = Translator.getText("IGUI_Gametime_month");
        if (n5 != 0) {
            if (n5 > 1) {
                string2 = Translator.getText("IGUI_Gametime_years");
            }
            if (((String)object).length() > 0) {
                object = (String)object + ", ";
            }
            object = (String)object + n5 + " " + string2;
        }
        if (n4 != 0) {
            if (n4 > 1) {
                string4 = Translator.getText("IGUI_Gametime_months");
            }
            if (((String)object).length() > 0) {
                object = (String)object + ", ";
            }
            object = (String)object + n4 + " " + string4;
        }
        if (n3 != 0) {
            if (n3 > 1) {
                string = Translator.getText("IGUI_Gametime_days");
            }
            if (((String)object).length() > 0) {
                object = (String)object + ", ";
            }
            object = (String)object + n3 + " " + string;
        }
        if (n2 != 0) {
            if (n2 > 1) {
                string3 = Translator.getText("IGUI_Gametime_hours");
            }
            if (((String)object).length() > 0) {
                object = (String)object + ", ";
            }
            object = (String)object + n2 + " " + string3;
        }
        if (((String)object).isEmpty()) {
            int n6 = (int)(this.HoursSurvived * 60.0);
            object = n6 + " " + Translator.getText("IGUI_Gametime_minutes");
        }
        return object;
    }

    public boolean IsUsingAimWeapon() {
        if (this.leftHandItem == null) {
            return false;
        }
        if (!(this.leftHandItem instanceof HandWeapon)) {
            return false;
        }
        if (!this.isAiming()) {
            return false;
        }
        return ((HandWeapon)this.leftHandItem).bIsAimedFirearm;
    }

    private boolean IsUsingAimHandWeapon() {
        if (this.leftHandItem == null) {
            return false;
        }
        if (!(this.leftHandItem instanceof HandWeapon)) {
            return false;
        }
        if (!this.isAiming()) {
            return false;
        }
        return ((HandWeapon)this.leftHandItem).bIsAimedHandWeapon;
    }

    private boolean DoAimAnimOnAiming() {
        return this.IsUsingAimWeapon();
    }

    public int getSleepingPillsTaken() {
        return this.sleepingPillsTaken;
    }

    public void setSleepingPillsTaken(int n) {
        this.sleepingPillsTaken = n;
        if (this.getStats().Drunkenness > 10.0f) {
            ++this.sleepingPillsTaken;
        }
        this.lastPillsTaken = GameTime.instance.Calender.getTimeInMillis();
    }

    @Override
    public boolean isOutside() {
        return this.getCurrentSquare() != null && this.getCurrentSquare().getRoom() == null && !this.isInARoom();
    }

    public double getLastSeenZomboidTime() {
        return this.lastSeenZombieTime;
    }

    public float getPlayerClothingTemperature() {
        float f = 0.0f;
        if (this.getClothingItem_Feet() != null) {
            f += ((Clothing)this.getClothingItem_Feet()).getTemperature();
        }
        if (this.getClothingItem_Hands() != null) {
            f += ((Clothing)this.getClothingItem_Hands()).getTemperature();
        }
        if (this.getClothingItem_Head() != null) {
            f += ((Clothing)this.getClothingItem_Head()).getTemperature();
        }
        if (this.getClothingItem_Legs() != null) {
            f += ((Clothing)this.getClothingItem_Legs()).getTemperature();
        }
        if (this.getClothingItem_Torso() != null) {
            f += ((Clothing)this.getClothingItem_Torso()).getTemperature();
        }
        return f;
    }

    public float getPlayerClothingInsulation() {
        float f = 0.0f;
        if (this.getClothingItem_Feet() != null) {
            f += ((Clothing)this.getClothingItem_Feet()).getInsulation() * 0.1f;
        }
        if (this.getClothingItem_Hands() != null) {
            f += ((Clothing)this.getClothingItem_Hands()).getInsulation() * 0.0f;
        }
        if (this.getClothingItem_Head() != null) {
            f += ((Clothing)this.getClothingItem_Head()).getInsulation() * 0.0f;
        }
        if (this.getClothingItem_Legs() != null) {
            f += ((Clothing)this.getClothingItem_Legs()).getInsulation() * 0.3f;
        }
        if (this.getClothingItem_Torso() != null) {
            f += ((Clothing)this.getClothingItem_Torso()).getInsulation() * 0.6f;
        }
        return f;
    }

    public InventoryItem getActiveLightItem() {
        if (this.rightHandItem != null && this.rightHandItem.isEmittingLight()) {
            return this.rightHandItem;
        }
        if (this.leftHandItem != null && this.leftHandItem.isEmittingLight()) {
            return this.leftHandItem;
        }
        AttachedItems attachedItems = this.getAttachedItems();
        for (int i = 0; i < attachedItems.size(); ++i) {
            InventoryItem inventoryItem = attachedItems.getItemByIndex(i);
            if (!inventoryItem.isEmittingLight()) continue;
            return inventoryItem;
        }
        return null;
    }

    public boolean isTorchCone() {
        if (this.bRemote) {
            return this.mpTorchCone;
        }
        InventoryItem inventoryItem = this.getActiveLightItem();
        return inventoryItem != null && inventoryItem.isTorchCone();
    }

    public float getTorchDot() {
        InventoryItem inventoryItem;
        if (this.bRemote) {
            // empty if block
        }
        if ((inventoryItem = this.getActiveLightItem()) != null) {
            return inventoryItem.getTorchDot();
        }
        return 0.0f;
    }

    public float getLightDistance() {
        if (this.bRemote) {
            return this.mpTorchDist;
        }
        InventoryItem inventoryItem = this.getActiveLightItem();
        if (inventoryItem != null) {
            return inventoryItem.getLightDistance();
        }
        return 0.0f;
    }

    public boolean pressedMovement(boolean bl) {
        if (this.isNPC) {
            return false;
        }
        if (GameClient.bClient && !this.isLocal()) {
            return this.networkAI.isPressedMovement();
        }
        boolean bl2 = false;
        if (this.PlayerIndex == 0) {
            bl2 = GameKeyboard.isKeyDown(Core.getInstance().getKey("Run"));
        }
        if (this.JoypadBind != -1) {
            bl2 |= JoypadManager.instance.isRTPressed(this.JoypadBind);
        }
        this.setVariable("pressedRunButton", bl2);
        if (!bl && (this.isBlockMovement() || this.isIgnoreInputsForDirection())) {
            if (GameClient.bClient && this.isLocal()) {
                this.networkAI.setPressedMovement(false);
            }
            return false;
        }
        if (this.PlayerIndex == 0 && (GameKeyboard.isKeyDown(Core.getInstance().getKey(leftStr)) || GameKeyboard.isKeyDown(Core.getInstance().getKey(rightStr)) || GameKeyboard.isKeyDown(Core.getInstance().getKey(forwardStr)) || GameKeyboard.isKeyDown(Core.getInstance().getKey(backwardStr)))) {
            if (GameClient.bClient && this.isLocal()) {
                this.networkAI.setPressedMovement(true);
            }
            return true;
        }
        if (this.JoypadBind != -1) {
            float f = JoypadManager.instance.getMovementAxisY(this.JoypadBind);
            float f2 = JoypadManager.instance.getMovementAxisX(this.JoypadBind);
            float f3 = JoypadManager.instance.getDeadZone(this.JoypadBind, 0);
            if (Math.abs(f) > f3 || Math.abs(f2) > f3) {
                if (GameClient.bClient && this.isLocal()) {
                    this.networkAI.setPressedMovement(true);
                }
                return true;
            }
        }
        if (GameClient.bClient && this.isLocal()) {
            this.networkAI.setPressedMovement(false);
        }
        return false;
    }

    public boolean pressedCancelAction() {
        if (this.isNPC) {
            return false;
        }
        if (GameClient.bClient && !this.isLocal()) {
            return this.networkAI.isPressedCancelAction();
        }
        if (this.PlayerIndex == 0 && GameKeyboard.isKeyDown(Core.getInstance().getKey("CancelAction"))) {
            if (GameClient.bClient && this.isLocal()) {
                this.networkAI.setPressedCancelAction(true);
            }
            return true;
        }
        if (this.JoypadBind != -1) {
            boolean bl = JoypadManager.instance.isBButtonStartPress(this.JoypadBind);
            if (GameClient.bClient && this.isLocal()) {
                this.networkAI.setPressedCancelAction(bl);
            }
            return bl;
        }
        if (GameClient.bClient && this.isLocal()) {
            this.networkAI.setPressedCancelAction(false);
        }
        return false;
    }

    public boolean checkWalkTo() {
        if (this.isNPC) {
            return false;
        }
        if (this.PlayerIndex == 0 && GameKeyboard.isKeyDown(Core.getInstance().getKey("WalkTo"))) {
            LuaEventManager.triggerEvent("OnPressWalkTo", 0, 0, 0);
            return true;
        }
        return false;
    }

    public boolean pressedAim() {
        if (this.isNPC) {
            return false;
        }
        if (this.PlayerIndex == 0) {
            if (this.isAimKeyDown()) {
                return true;
            }
            if (Mouse.isButtonDownUICheck(1)) {
                return true;
            }
        }
        if (this.JoypadBind != -1) {
            float f = JoypadManager.instance.getAimingAxisY(this.JoypadBind);
            float f2 = JoypadManager.instance.getAimingAxisX(this.JoypadBind);
            return Math.abs(f) > 0.1f || Math.abs(f2) > 0.1f;
        }
        return false;
    }

    @Override
    public boolean isDoingActionThatCanBeCancelled() {
        if (this.isDead()) {
            return false;
        }
        if (!this.getCharacterActions().isEmpty()) {
            return true;
        }
        State state = this.getCurrentState();
        if (state != null && state.isDoingActionThatCanBeCancelled()) {
            return true;
        }
        for (int i = 0; i < this.stateMachine.getSubStateCount(); ++i) {
            state = this.stateMachine.getSubStateAt(i);
            if (state == null || !state.isDoingActionThatCanBeCancelled()) continue;
            return true;
        }
        return false;
    }

    public long getSteamID() {
        return this.steamID;
    }

    public void setSteamID(long l) {
        this.steamID = l;
    }

    public boolean isTargetedByZombie() {
        return this.targetedByZombie;
    }

    @Override
    public boolean isMaskClicked(int n, int n2, boolean bl) {
        if (this.sprite == null) {
            return false;
        }
        return this.sprite.isMaskClicked(this.dir, n, n2, bl);
    }

    public int getOffSetXUI() {
        return this.offSetXUI;
    }

    public void setOffSetXUI(int n) {
        this.offSetXUI = n;
    }

    public int getOffSetYUI() {
        return this.offSetYUI;
    }

    public void setOffSetYUI(int n) {
        this.offSetYUI = n;
    }

    public String getUsername() {
        return this.getUsername(false);
    }

    public String getUsername(Boolean bl) {
        Object object = this.username;
        if (bl.booleanValue() && GameClient.bClient && ServerOptions.instance.ShowFirstAndLastName.getValue() && this.isAccessLevel("None")) {
            object = this.getDescriptor().getForename() + " " + this.getDescriptor().getSurname();
            if (ServerOptions.instance.DisplayUserName.getValue()) {
                object = (String)object + " (" + this.username + ")";
            }
        }
        return object;
    }

    public void setUsername(String string) {
        this.username = string;
    }

    public void updateUsername() {
        if (GameClient.bClient || GameServer.bServer) {
            return;
        }
        this.username = this.getDescriptor().getForename() + this.getDescriptor().getSurname();
    }

    @Override
    public short getOnlineID() {
        return this.OnlineID;
    }

    public boolean isLocalPlayer() {
        if (GameServer.bServer) {
            return false;
        }
        for (int i = 0; i < numPlayers; ++i) {
            if (players[i] != this) continue;
            return true;
        }
        return false;
    }

    public static void setLocalPlayer(int n, IsoPlayer isoPlayer) {
        IsoPlayer.players[n] = isoPlayer;
    }

    public static IsoPlayer getLocalPlayerByOnlineID(short s) {
        for (int i = 0; i < numPlayers; ++i) {
            IsoPlayer isoPlayer = players[i];
            if (isoPlayer == null || isoPlayer.OnlineID != s) continue;
            return isoPlayer;
        }
        return null;
    }

    public boolean isOnlyPlayerAsleep() {
        if (!this.isAsleep()) {
            return false;
        }
        for (int i = 0; i < numPlayers; ++i) {
            if (players[i] == null || players[i].isDead() || players[i] == this || !players[i].isAsleep()) continue;
            return false;
        }
        return true;
    }

    @Override
    public void OnDeath() {
        super.OnDeath();
        if (GameServer.bServer) {
            return;
        }
        this.StopAllActionQueue();
        if (this.isAsleep()) {
            UIManager.FadeIn(this.getPlayerNum(), 0.5);
            this.setAsleep(false);
        }
        this.dropHandItems();
        if (IsoPlayer.allPlayersDead()) {
            SoundManager.instance.playMusic(DEATH_MUSIC_NAME);
        }
        if (this.isLocalPlayer()) {
            LuaEventManager.triggerEvent("OnPlayerDeath", this);
        }
        if (this.isLocalPlayer() && this.getVehicle() != null) {
            this.getVehicle().exit(this);
        }
        this.removeSaveFile();
        if (this.shouldBecomeZombieAfterDeath()) {
            this.forceAwake();
        }
        this.getMoodles().Update();
        this.getCell().setDrag(null, this.getPlayerNum());
    }

    public boolean isNoClip() {
        return this.noClip;
    }

    public void setNoClip(boolean bl) {
        this.noClip = bl;
    }

    public void setAuthorizeMeleeAction(boolean bl) {
        this.authorizeMeleeAction = bl;
    }

    public boolean isAuthorizeMeleeAction() {
        return this.authorizeMeleeAction;
    }

    public void setAuthorizeShoveStomp(boolean bl) {
        this.authorizeShoveStomp = bl;
    }

    public boolean isAuthorizeShoveStomp() {
        return this.authorizeShoveStomp;
    }

    public boolean isBlockMovement() {
        return this.blockMovement;
    }

    public void setBlockMovement(boolean bl) {
        this.blockMovement = bl;
    }

    public void startReceivingBodyDamageUpdates(IsoPlayer isoPlayer) {
        if (GameClient.bClient && isoPlayer != null && isoPlayer != this && this.isLocalPlayer() && !isoPlayer.isLocalPlayer()) {
            isoPlayer.resetBodyDamageRemote();
            BodyDamageSync.instance.startReceivingUpdates(isoPlayer.getOnlineID());
        }
    }

    public void stopReceivingBodyDamageUpdates(IsoPlayer isoPlayer) {
        if (GameClient.bClient && isoPlayer != null && isoPlayer != this && !isoPlayer.isLocalPlayer()) {
            BodyDamageSync.instance.stopReceivingUpdates(isoPlayer.getOnlineID());
        }
    }

    public Nutrition getNutrition() {
        return this.nutrition;
    }

    public Fitness getFitness() {
        return this.fitness;
    }

    private boolean updateRemotePlayer() {
        if (!this.bRemote) {
            return false;
        }
        if (GameServer.bServer) {
            ServerLOS.instance.doServerZombieLOS(this);
            ServerLOS.instance.updateLOS(this);
            if (this.isDead()) {
                return true;
            }
            this.removeFromSquare();
            this.setX(this.realx);
            this.setY(this.realy);
            this.setZ(this.realz);
            this.setLx(this.realx);
            this.setLy(this.realy);
            this.setLz(this.realz);
            this.ensureOnTile();
            if (this.slowTimer > 0.0f) {
                this.slowTimer -= GameTime.instance.getRealworldSecondsSinceLastUpdate();
                this.slowFactor -= GameTime.instance.getMultiplier() / 100.0f;
                if (this.slowFactor < 0.0f) {
                    this.slowFactor = 0.0f;
                }
            } else {
                this.slowFactor = 0.0f;
            }
        }
        if (GameClient.bClient) {
            Object object;
            float f;
            float f2;
            float f3;
            if (this.isCurrentState(BumpedState.instance())) {
                return true;
            }
            if (this.networkAI.isCollisionEnabled() || this.networkAI.isNoCollisionTimeout()) {
                this.setCollidable(true);
                f3 = this.networkAI.targetX;
                f2 = this.networkAI.targetY;
                f = this.networkAI.targetZ;
            } else {
                this.setCollidable(false);
                f3 = this.realx;
                f2 = this.realy;
                f = this.realz;
            }
            this.updateMovementRates();
            PathFindBehavior2 pathFindBehavior2 = this.getPathFindBehavior2();
            boolean bl = false;
            if (!this.networkAI.events.isEmpty()) {
                object = this.networkAI.events.iterator();
                while (object.hasNext()) {
                    EventPacket eventPacket = (EventPacket)object.next();
                    if (eventPacket.process(this)) {
                        this.networkAI.moving = false;
                        this.m_isPlayerMoving = false;
                        this.setJustMoved(false);
                        if (this.networkAI.usePathFind) {
                            pathFindBehavior2.reset();
                            this.setPath2(null);
                            this.networkAI.usePathFind = false;
                        }
                        object.remove();
                        return true;
                    }
                    if (!eventPacket.isMovableEvent()) {
                        tempo.set(eventPacket.x - this.x, eventPacket.y - this.y);
                        f3 = eventPacket.x;
                        f2 = eventPacket.y;
                        f = eventPacket.z;
                        bl = true;
                    }
                    if (!eventPacket.isTimeout()) continue;
                    this.networkAI.moving = false;
                    this.m_isPlayerMoving = false;
                    this.setJustMoved(false);
                    if (this.networkAI.usePathFind) {
                        pathFindBehavior2.reset();
                        this.setPath2(null);
                        this.networkAI.usePathFind = false;
                    }
                    if (Core.bDebug) {
                        DebugLog.log(DebugType.Multiplayer, String.format("Event timeout (%d) : %s", this.networkAI.events.size(), eventPacket.getDescription()));
                    }
                    object.remove();
                    return true;
                }
            }
            if (!bl && this.networkAI.collidePointX > -1.0f && this.networkAI.collidePointY > -1.0f && ((int)this.x != (int)this.networkAI.collidePointX || (int)this.y != (int)this.networkAI.collidePointY)) {
                f3 = this.networkAI.collidePointX;
                f2 = this.networkAI.collidePointY;
                DebugLog.log(DebugType.ActionSystem, "Player " + this.username + ": collide point (" + f3 + ", " + f2 + ") has not been reached, so move to it");
            }
            if (DebugOptions.instance.MultiplayerShowPlayerPrediction.getValue()) {
                this.networkAI.targetX = f3;
                this.networkAI.targetY = f2;
            }
            if (!this.networkAI.forcePathFinder && this.isCollidedThisFrame() && IsoUtils.DistanceManhatten(f3, f2, this.x, this.y) > 3.0f) {
                this.networkAI.forcePathFinder = true;
            }
            if (this.networkAI.forcePathFinder && !PolygonalMap2.instance.lineClearCollide(this.x, this.y, f3, f2, (int)this.z, this.vehicle, false, true) && IsoUtils.DistanceManhatten(f3, f2, this.x, this.y) < 2.0f || this.getCurrentState() == ClimbOverFenceState.instance() || this.getCurrentState() == ClimbThroughWindowState.instance() || this.getCurrentState() == ClimbOverWallState.instance()) {
                this.networkAI.forcePathFinder = false;
            }
            if (!this.networkAI.needToMovingUsingPathFinder && !this.networkAI.forcePathFinder) {
                if (this.networkAI.usePathFind) {
                    pathFindBehavior2.reset();
                    this.setPath2(null);
                    this.networkAI.usePathFind = false;
                }
                pathFindBehavior2.walkingOnTheSpot.reset(this.x, this.y);
                this.getDeferredMovement(tempVector2_2);
                if (this.getCurrentState() == ClimbOverWallState.instance() || this.getCurrentState() == ClimbOverFenceState.instance()) {
                    this.MoveUnmodded(tempVector2_2);
                } else {
                    float f4 = IsoUtils.DistanceTo(this.x, this.y, this.networkAI.targetX, this.networkAI.targetY) / IsoUtils.DistanceTo(this.realx, this.realy, this.networkAI.targetX, this.networkAI.targetY);
                    float f5 = 0.8f + 0.4f * IsoUtils.smoothstep(0.8f, 1.2f, f4);
                    pathFindBehavior2.moveToPoint(f3, f2, f5);
                }
                boolean bl2 = this.m_isPlayerMoving = !bl && IsoUtils.DistanceManhatten(f3, f2, this.x, this.y) > 0.2f || (int)f3 != (int)this.x || (int)f2 != (int)this.y || (int)this.z != (int)f;
                if (!this.m_isPlayerMoving) {
                    this.DirectionFromVector(this.networkAI.direction);
                    this.setForwardDirection(this.networkAI.direction);
                    this.networkAI.forcePathFinder = false;
                    if (this.networkAI.usePathFind) {
                        pathFindBehavior2.reset();
                        this.setPath2(null);
                        this.networkAI.usePathFind = false;
                    }
                }
                this.setJustMoved(this.m_isPlayerMoving);
                this.m_deltaX = 0.0f;
                this.m_deltaY = 0.0f;
            } else {
                if (!this.networkAI.usePathFind || f3 != pathFindBehavior2.getTargetX() || f2 != pathFindBehavior2.getTargetY()) {
                    pathFindBehavior2.pathToLocationF(f3, f2, f);
                    pathFindBehavior2.walkingOnTheSpot.reset(this.x, this.y);
                    this.networkAI.usePathFind = true;
                }
                if ((object = pathFindBehavior2.update()) == PathFindBehavior2.BehaviorResult.Failed) {
                    this.setPathFindIndex(-1);
                    if (this.networkAI.forcePathFinder) {
                        this.networkAI.forcePathFinder = false;
                    } else if (NetworkTeleport.teleport(this, NetworkTeleport.Type.teleportation, f3, f2, (byte)f, 1.0f) && GameServer.bServer) {
                        DebugLog.Multiplayer.warn(String.format("Player %d teleport from (%.2f, %.2f, %.2f) to (%.2f, %.2f, %.2f)", this.getOnlineID(), Float.valueOf(this.x), Float.valueOf(this.y), Float.valueOf(this.z), Float.valueOf(f3), Float.valueOf(f2), Float.valueOf(f)));
                    }
                } else if (object == PathFindBehavior2.BehaviorResult.Succeeded) {
                    int n = (int)pathFindBehavior2.getTargetX();
                    int n2 = (int)pathFindBehavior2.getTargetY();
                    IsoChunk isoChunk = GameServer.bServer ? ServerMap.instance.getChunk(n / 10, n2 / 10) : IsoWorld.instance.CurrentCell.getChunkForGridSquare(n, n2, 0);
                    this.m_isPlayerMoving = true;
                    this.setJustMoved(true);
                }
                this.m_deltaX = 0.0f;
                this.m_deltaY = 0.0f;
            }
            if (!this.m_isPlayerMoving || this.isAiming()) {
                this.DirectionFromVector(this.networkAI.direction);
                this.setForwardDirection(this.networkAI.direction);
                tempo.set(f3 - this.nx, -(f2 - this.ny));
                tempo.normalize();
                float f6 = this.legsSprite.modelSlot.model.AnimPlayer.getRenderedAngle();
                if ((double)f6 > Math.PI * 2) {
                    f6 = (float)((double)f6 - Math.PI * 2);
                }
                if (f6 < 0.0f) {
                    f6 = (float)((double)f6 + Math.PI * 2);
                }
                tempo.rotate(f6);
                tempo.setLength(Math.min(IsoUtils.DistanceTo(f3, f2, this.x, this.y), 1.0f));
                this.m_deltaX = IsoPlayer.tempo.x;
                this.m_deltaY = IsoPlayer.tempo.y;
            }
        }
        return true;
    }

    private boolean updateWhileDead() {
        if (GameServer.bServer) {
            return false;
        }
        if (!this.isLocalPlayer()) {
            return false;
        }
        if (!this.isDead()) {
            return false;
        }
        this.setVariable("bPathfind", false);
        this.setMoving(false);
        this.m_isPlayerMoving = false;
        if (this.getVehicle() != null) {
            this.getVehicle().exit(this);
        }
        if (this.heartEventInstance != 0L) {
            this.getEmitter().stopSound(this.heartEventInstance);
            this.heartEventInstance = 0L;
        }
        return true;
    }

    private void initFMODParameters() {
        FMODParameterList fMODParameterList = this.getFMODParameters();
        fMODParameterList.add(this.parameterCharacterMovementSpeed);
        fMODParameterList.add(this.parameterEquippedBaggageContainer);
        fMODParameterList.add(this.parameterFootstepMaterial);
        fMODParameterList.add(this.parameterFootstepMaterial2);
        fMODParameterList.add(this.parameterLocalPlayer);
        fMODParameterList.add(this.parameterMeleeHitSurface);
        fMODParameterList.add(this.parameterPlayerHealth);
        fMODParameterList.add(this.parameterShoeType);
        fMODParameterList.add(this.parameterVehicleHitLocation);
    }

    public ParameterCharacterMovementSpeed getParameterCharacterMovementSpeed() {
        return this.parameterCharacterMovementSpeed;
    }

    public void setMeleeHitSurface(ParameterMeleeHitSurface.Material material) {
        this.parameterMeleeHitSurface.setMaterial(material);
    }

    public void setMeleeHitSurface(String string) {
        try {
            this.parameterMeleeHitSurface.setMaterial(ParameterMeleeHitSurface.Material.valueOf(string));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.parameterMeleeHitSurface.setMaterial(ParameterMeleeHitSurface.Material.Default);
        }
    }

    public void setVehicleHitLocation(BaseVehicle baseVehicle) {
        ParameterVehicleHitLocation.HitLocation hitLocation = ParameterVehicleHitLocation.calculateLocation(baseVehicle, this.getX(), this.getY(), this.getZ());
        this.parameterVehicleHitLocation.setLocation(hitLocation);
    }

    private void updateHeartSound() {
        boolean bl;
        if (GameServer.bServer) {
            return;
        }
        if (!this.isLocalPlayer()) {
            return;
        }
        GameSound gameSound = GameSounds.getSound("HeartBeat");
        boolean bl2 = bl = gameSound != null && gameSound.getUserVolume() > 0.0f && this.stats.Panic > 0.0f;
        if (!this.Asleep && bl && GameTime.getInstance().getTrueMultiplier() == 1.0f) {
            this.heartDelay -= GameTime.getInstance().getMultiplier() / 1.6f;
            if (this.heartEventInstance == 0L || !this.getEmitter().isPlaying(this.heartEventInstance)) {
                this.heartEventInstance = this.getEmitter().playSoundImpl("HeartBeat", null);
                this.getEmitter().setVolume(this.heartEventInstance, 0.0f);
            }
            if (this.heartDelay <= 0.0f) {
                this.heartDelay = this.heartDelayMax = (float)((int)((1.0f - this.stats.Panic / 100.0f * 0.7f) * 25.0f) * 2);
                if (this.heartEventInstance != 0L) {
                    this.getEmitter().setVolume(this.heartEventInstance, this.stats.Panic / 100.0f);
                }
            }
        } else if (this.heartEventInstance != 0L) {
            this.getEmitter().setVolume(this.heartEventInstance, 0.0f);
        }
    }

    private void updateWorldAmbiance() {
        if (GameServer.bServer) {
            return;
        }
        if (!this.isLocalPlayer()) {
            return;
        }
        if (!(this.getPlayerNum() != 0 || this.worldAmbianceInstance != 0L && this.getEmitter().isPlaying(this.worldAmbianceInstance))) {
            this.worldAmbianceInstance = this.getEmitter().playSoundImpl("WorldAmbiance", null);
            this.getEmitter().setVolume(this.worldAmbianceInstance, 1.0f);
        }
    }

    private void updateEquippedBaggageContainer() {
        if (GameServer.bServer) {
            return;
        }
        if (!this.isLocalPlayer()) {
            return;
        }
        InventoryItem inventoryItem = this.getClothingItem_Back();
        if (inventoryItem != null && inventoryItem.IsInventoryContainer()) {
            String string = inventoryItem.getSoundParameter("EquippedBaggageContainer");
            this.parameterEquippedBaggageContainer.setContainerType(string);
            return;
        }
        inventoryItem = this.getSecondaryHandItem();
        if (inventoryItem != null && inventoryItem.IsInventoryContainer()) {
            String string = inventoryItem.getSoundParameter("EquippedBaggageContainer");
            this.parameterEquippedBaggageContainer.setContainerType(string);
            return;
        }
        inventoryItem = this.getPrimaryHandItem();
        if (inventoryItem != null && inventoryItem.IsInventoryContainer()) {
            String string = inventoryItem.getSoundParameter("EquippedBaggageContainer");
            this.parameterEquippedBaggageContainer.setContainerType(string);
            return;
        }
        this.parameterEquippedBaggageContainer.setContainerType(ParameterEquippedBaggageContainer.ContainerType.None);
    }

    @Override
    public void DoFootstepSound(String string) {
        ParameterCharacterMovementSpeed.MovementType movementType = ParameterCharacterMovementSpeed.MovementType.Walk;
        float f = 0.5f;
        switch (string) {
            case "sneak_walk": {
                f = 0.25f;
                movementType = ParameterCharacterMovementSpeed.MovementType.SneakWalk;
                break;
            }
            case "sneak_run": {
                f = 0.25f;
                movementType = ParameterCharacterMovementSpeed.MovementType.SneakRun;
                break;
            }
            case "strafe": {
                f = 0.5f;
                movementType = ParameterCharacterMovementSpeed.MovementType.Strafe;
                break;
            }
            case "walk": {
                f = 0.5f;
                movementType = ParameterCharacterMovementSpeed.MovementType.Walk;
                break;
            }
            case "run": {
                f = 0.75f;
                movementType = ParameterCharacterMovementSpeed.MovementType.Run;
                break;
            }
            case "sprint": {
                f = 1.0f;
                movementType = ParameterCharacterMovementSpeed.MovementType.Sprint;
            }
        }
        this.parameterCharacterMovementSpeed.setMovementType(movementType);
        super.DoFootstepSound(f);
    }

    private void updateHeavyBreathing() {
    }

    private void checkVehicleContainers() {
        Object object;
        int n;
        ArrayList<VehicleContainer> arrayList = this.vehicleContainerData.tempContainers;
        arrayList.clear();
        int n2 = (int)this.getX() - 4;
        int n3 = (int)this.getY() - 4;
        int n4 = (int)this.getX() + 4;
        int n5 = (int)this.getY() + 4;
        int n6 = n2 / 10;
        int n7 = n3 / 10;
        int n8 = (int)Math.ceil((float)n4 / 10.0f);
        int n9 = (int)Math.ceil((float)n5 / 10.0f);
        for (n = n7; n < n9; ++n) {
            for (int i = n6; i < n8; ++i) {
                Object object2 = object = GameServer.bServer ? ServerMap.instance.getChunk(i, n) : IsoWorld.instance.CurrentCell.getChunkForGridSquare(i * 10, n * 10, 0);
                if (object == null) continue;
                for (int j = 0; j < ((IsoChunk)object).vehicles.size(); ++j) {
                    BaseVehicle baseVehicle = ((IsoChunk)object).vehicles.get(j);
                    VehicleScript vehicleScript = baseVehicle.getScript();
                    if (vehicleScript == null) continue;
                    for (int k = 0; k < vehicleScript.getPartCount(); ++k) {
                        VehicleScript.Part part = vehicleScript.getPart(k);
                        if (part.container == null || part.area == null || !baseVehicle.isInArea(part.area, this)) continue;
                        VehicleContainer vehicleContainer = this.vehicleContainerData.freeContainers.isEmpty() ? new VehicleContainer() : this.vehicleContainerData.freeContainers.pop();
                        arrayList.add(vehicleContainer.set(baseVehicle, k));
                    }
                }
            }
        }
        if (arrayList.size() != this.vehicleContainerData.containers.size()) {
            this.vehicleContainerData.freeContainers.addAll(this.vehicleContainerData.containers);
            this.vehicleContainerData.containers.clear();
            this.vehicleContainerData.containers.addAll(arrayList);
            LuaEventManager.triggerEvent("OnContainerUpdate");
        } else {
            for (n = 0; n < arrayList.size(); ++n) {
                VehicleContainer vehicleContainer = arrayList.get(n);
                if (vehicleContainer.equals(object = this.vehicleContainerData.containers.get(n))) continue;
                this.vehicleContainerData.freeContainers.addAll(this.vehicleContainerData.containers);
                this.vehicleContainerData.containers.clear();
                this.vehicleContainerData.containers.addAll(arrayList);
                LuaEventManager.triggerEvent("OnContainerUpdate");
                break;
            }
        }
    }

    public void setJoypadIgnoreAimUntilCentered(boolean bl) {
        this.bJoypadIgnoreAimUntilCentered = bl;
    }

    public boolean canSeePlayerStats() {
        return this.accessLevel != "";
    }

    public ByteBufferWriter createPlayerStats(ByteBufferWriter byteBufferWriter, String string) {
        byteBufferWriter.putShort(this.getOnlineID());
        byteBufferWriter.putUTF(string);
        byteBufferWriter.putUTF(this.getDisplayName());
        byteBufferWriter.putUTF(this.getDescriptor().getForename());
        byteBufferWriter.putUTF(this.getDescriptor().getSurname());
        byteBufferWriter.putUTF(this.getDescriptor().getProfession());
        if (!StringUtils.isNullOrEmpty(this.getTagPrefix())) {
            byteBufferWriter.putByte((byte)1);
            byteBufferWriter.putUTF(this.getTagPrefix());
        } else {
            byteBufferWriter.putByte((byte)0);
        }
        byteBufferWriter.putBoolean(this.isAllChatMuted());
        byteBufferWriter.putFloat(this.getTagColor().r);
        byteBufferWriter.putFloat(this.getTagColor().g);
        byteBufferWriter.putFloat(this.getTagColor().b);
        byteBufferWriter.putByte(this.showTag ? (byte)1 : 0);
        byteBufferWriter.putByte(this.factionPvp ? (byte)1 : 0);
        return byteBufferWriter;
    }

    public String setPlayerStats(ByteBuffer byteBuffer, String string) {
        String string2 = GameWindow.ReadString(byteBuffer);
        String string3 = GameWindow.ReadString(byteBuffer);
        String string4 = GameWindow.ReadString(byteBuffer);
        String string5 = GameWindow.ReadString(byteBuffer);
        String string6 = "";
        if (byteBuffer.get() == 1) {
            string6 = GameWindow.ReadString(byteBuffer);
        }
        boolean bl = byteBuffer.get() == 1;
        float f = byteBuffer.getFloat();
        float f2 = byteBuffer.getFloat();
        float f3 = byteBuffer.getFloat();
        Object object = "";
        this.setTagColor(new ColorInfo(f, f2, f3, 1.0f));
        this.setTagPrefix(string6);
        this.showTag = byteBuffer.get() == 1;
        boolean bl2 = this.factionPvp = byteBuffer.get() == 1;
        if (!string3.equals(this.getDescriptor().getForename())) {
            object = GameServer.bServer ? string + " Changed " + string2 + " forname in " + string3 : "Changed your forname in " + string3;
        }
        this.getDescriptor().setForename(string3);
        if (!string4.equals(this.getDescriptor().getSurname())) {
            object = GameServer.bServer ? string + " Changed " + string2 + " surname in " + string4 : "Changed your surname in " + string4;
        }
        this.getDescriptor().setSurname(string4);
        if (!string5.equals(this.getDescriptor().getProfession())) {
            object = GameServer.bServer ? string + " Changed " + string2 + " profession to " + string5 : "Changed your profession in " + string5;
        }
        this.getDescriptor().setProfession(string5);
        if (!this.getDisplayName().equals(string2)) {
            if (GameServer.bServer) {
                object = string + " Changed display name \"" + this.getDisplayName() + "\" to \"" + string2 + "\"";
                ServerWorldDatabase.instance.updateDisplayName(this.username, string2);
            } else {
                object = "Changed your display name to " + string2;
            }
            this.setDisplayName(string2);
        }
        if (bl != this.isAllChatMuted()) {
            object = bl ? (GameServer.bServer ? string + " Banned " + string2 + " from using /all chat" : "Banned you from using /all chat") : (GameServer.bServer ? string + " Allowed " + string2 + " to use /all chat" : "Now allowed you to use /all chat");
        }
        this.setAllChatMuted(bl);
        if (GameServer.bServer && !"".equals(object)) {
            LoggerManager.getLogger("admin").write((String)object);
        }
        if (GameClient.bClient) {
            LuaEventManager.triggerEvent("OnMiniScoreboardUpdate");
        }
        return object;
    }

    public boolean isAllChatMuted() {
        return this.allChatMuted;
    }

    public void setAllChatMuted(boolean bl) {
        this.allChatMuted = bl;
    }

    public String getAccessLevel() {
        switch (this.accessLevel) {
            case "admin": {
                return "Admin";
            }
            case "moderator": {
                return "Moderator";
            }
            case "overseer": {
                return "Overseer";
            }
            case "gm": {
                return "GM";
            }
            case "observer": {
                return "Observer";
            }
        }
        return "None";
    }

    public boolean isAccessLevel(String string) {
        return this.getAccessLevel().equalsIgnoreCase(string);
    }

    public void setAccessLevel(String string) {
        byte by = PlayerType.fromString(string.trim().toLowerCase());
        if (by == 1) {
            GameClient.SendCommandToServer("/setaccesslevel \"" + this.username + "\" \"none\"");
        } else {
            GameClient.SendCommandToServer("/setaccesslevel \"" + this.username + "\" \"" + PlayerType.toString(by) + "\"");
        }
    }

    public void addMechanicsItem(String string, VehiclePart vehiclePart, Long l) {
        int n = 1;
        int n2 = 1;
        if (this.mechanicsItem.get(Long.parseLong(string)) == null) {
            if (vehiclePart.getTable("uninstall") != null && vehiclePart.getTable("uninstall").rawget("skills") != null) {
                String[] stringArray;
                for (String string2 : stringArray = ((String)vehiclePart.getTable("uninstall").rawget("skills")).split(";")) {
                    if (!string2.contains("Mechanics")) continue;
                    int n3 = Integer.parseInt(string2.split(":")[1]);
                    if (n3 >= 6) {
                        n = 3;
                        n2 = 7;
                        continue;
                    }
                    if (n3 >= 4) {
                        n = 3;
                        n2 = 5;
                        continue;
                    }
                    if (n3 >= 2) {
                        n = 2;
                        n2 = 4;
                        continue;
                    }
                    if (Rand.Next(3) != 0) continue;
                    n = 2;
                    n2 = 2;
                }
            }
            this.getXp().AddXP(PerkFactory.Perks.Mechanics, (float)Rand.Next(n, n2));
        }
        this.mechanicsItem.put(Long.parseLong(string), l);
    }

    public void setPosition(float f, float f2, float f3) {
        this.setX(f);
        this.setY(f2);
        this.setZ(f3);
    }

    private void updateTemperatureCheck() {
        int n = this.Moodles.getMoodleLevel(MoodleType.Hypothermia);
        if (this.hypothermiaCache == -1 || this.hypothermiaCache != n) {
            if (n >= 3 && n > this.hypothermiaCache && this.isAsleep() && !this.ForceWakeUp) {
                this.forceAwake();
            }
            this.hypothermiaCache = n;
        }
        int n2 = this.Moodles.getMoodleLevel(MoodleType.Hyperthermia);
        if (this.hyperthermiaCache == -1 || this.hyperthermiaCache != n2) {
            if (n2 >= 3 && n2 > this.hyperthermiaCache && this.isAsleep() && !this.ForceWakeUp) {
                this.forceAwake();
            }
            this.hyperthermiaCache = n2;
        }
    }

    public float getZombieRelevenceScore(IsoZombie isoZombie) {
        if (isoZombie.getCurrentSquare() == null) {
            return -10000.0f;
        }
        float f = 0.0f;
        if (isoZombie.getCurrentSquare().getCanSee(this.PlayerIndex)) {
            f += 100.0f;
        } else if (isoZombie.getCurrentSquare().isCouldSee(this.PlayerIndex)) {
            f += 10.0f;
        }
        if (isoZombie.getCurrentSquare().getRoom() != null && this.current.getRoom() == null) {
            f -= 20.0f;
        }
        if (isoZombie.getCurrentSquare().getRoom() == null && this.current.getRoom() != null) {
            f -= 20.0f;
        }
        if (isoZombie.getCurrentSquare().getRoom() != this.current.getRoom()) {
            f -= 20.0f;
        }
        float f2 = isoZombie.DistTo(this);
        f -= f2;
        if (f2 < 20.0f) {
            f += 300.0f;
        }
        if (f2 < 15.0f) {
            f += 300.0f;
        }
        if (f2 < 10.0f) {
            f += 1000.0f;
        }
        if (isoZombie.getTargetAlpha() < 1.0f && f > 0.0f) {
            f *= isoZombie.getTargetAlpha();
        }
        return f;
    }

    @Override
    public BaseVisual getVisual() {
        return this.humanVisual;
    }

    @Override
    public HumanVisual getHumanVisual() {
        return this.humanVisual;
    }

    @Override
    public ItemVisuals getItemVisuals() {
        return this.itemVisuals;
    }

    @Override
    public void getItemVisuals(ItemVisuals itemVisuals) {
        if (!this.bRemote) {
            this.getWornItems().getItemVisuals(itemVisuals);
        } else {
            itemVisuals.clear();
            itemVisuals.addAll(this.itemVisuals);
        }
    }

    @Override
    public void dressInNamedOutfit(String string) {
        this.getHumanVisual().dressInNamedOutfit(string, this.itemVisuals);
        this.onClothingOutfitPreviewChanged();
    }

    @Override
    public void dressInClothingItem(String string) {
        this.getHumanVisual().dressInClothingItem(string, this.itemVisuals);
        this.onClothingOutfitPreviewChanged();
    }

    private void onClothingOutfitPreviewChanged() {
        if (!this.isLocalPlayer()) {
            return;
        }
        this.getInventory().clear();
        this.wornItems.setFromItemVisuals(this.itemVisuals);
        this.wornItems.addItemsToItemContainer(this.getInventory());
        this.itemVisuals.clear();
        this.resetModel();
        this.onWornItemsChanged();
    }

    @Override
    public void onWornItemsChanged() {
        this.parameterShoeType.setShoeType(null);
    }

    @Override
    public void actionStateChanged(ActionContext actionContext) {
        super.actionStateChanged(actionContext);
    }

    public Vector2 getLastAngle() {
        return this.lastAngle;
    }

    public void setLastAngle(Vector2 vector22) {
        this.lastAngle.set(vector22);
    }

    public int getDialogMood() {
        return this.DialogMood;
    }

    public void setDialogMood(int n) {
        this.DialogMood = n;
    }

    public int getPing() {
        return this.ping;
    }

    public void setPing(int n) {
        this.ping = n;
    }

    public IsoMovingObject getDragObject() {
        return this.DragObject;
    }

    public void setDragObject(IsoMovingObject isoMovingObject) {
        this.DragObject = isoMovingObject;
    }

    public float getAsleepTime() {
        return this.AsleepTime;
    }

    public void setAsleepTime(float f) {
        this.AsleepTime = f;
    }

    public Stack<IsoMovingObject> getSpottedList() {
        return this.spottedList;
    }

    public int getTicksSinceSeenZombie() {
        return this.TicksSinceSeenZombie;
    }

    public void setTicksSinceSeenZombie(int n) {
        this.TicksSinceSeenZombie = n;
    }

    public boolean isWaiting() {
        return this.Waiting;
    }

    public void setWaiting(boolean bl) {
        this.Waiting = bl;
    }

    public IsoSurvivor getDragCharacter() {
        return this.DragCharacter;
    }

    public void setDragCharacter(IsoSurvivor isoSurvivor) {
        this.DragCharacter = isoSurvivor;
    }

    public float getHeartDelay() {
        return this.heartDelay;
    }

    public void setHeartDelay(float f) {
        this.heartDelay = f;
    }

    public float getHeartDelayMax() {
        return this.heartDelayMax;
    }

    public void setHeartDelayMax(int n) {
        this.heartDelayMax = n;
    }

    @Override
    public double getHoursSurvived() {
        return this.HoursSurvived;
    }

    public void setHoursSurvived(double d) {
        this.HoursSurvived = d;
    }

    public float getMaxWeightDelta() {
        return this.maxWeightDelta;
    }

    public void setMaxWeightDelta(float f) {
        this.maxWeightDelta = f;
    }

    public String getForname() {
        return this.Forname;
    }

    public void setForname(String string) {
        this.Forname = string;
    }

    public String getSurname() {
        return this.Surname;
    }

    public void setSurname(String string) {
        this.Surname = string;
    }

    public boolean isbChangeCharacterDebounce() {
        return this.bChangeCharacterDebounce;
    }

    public void setbChangeCharacterDebounce(boolean bl) {
        this.bChangeCharacterDebounce = bl;
    }

    public int getFollowID() {
        return this.followID;
    }

    public void setFollowID(int n) {
        this.followID = n;
    }

    public boolean isbSeenThisFrame() {
        return this.bSeenThisFrame;
    }

    public void setbSeenThisFrame(boolean bl) {
        this.bSeenThisFrame = bl;
    }

    public boolean isbCouldBeSeenThisFrame() {
        return this.bCouldBeSeenThisFrame;
    }

    public void setbCouldBeSeenThisFrame(boolean bl) {
        this.bCouldBeSeenThisFrame = bl;
    }

    public float getTimeSinceLastStab() {
        return this.timeSinceLastStab;
    }

    public void setTimeSinceLastStab(float f) {
        this.timeSinceLastStab = f;
    }

    public Stack<IsoMovingObject> getLastSpotted() {
        return this.LastSpotted;
    }

    public void setLastSpotted(Stack<IsoMovingObject> stack) {
        this.LastSpotted = stack;
    }

    public int getClearSpottedTimer() {
        return this.ClearSpottedTimer;
    }

    public void setClearSpottedTimer(int n) {
        this.ClearSpottedTimer = n;
    }

    public boolean IsRunning() {
        return this.isRunning();
    }

    public void InitSpriteParts() {
    }

    public boolean IsAiming() {
        return this.isAiming();
    }

    public String getTagPrefix() {
        return this.tagPrefix;
    }

    public void setTagPrefix(String string) {
        this.tagPrefix = string;
    }

    public ColorInfo getTagColor() {
        return this.tagColor;
    }

    public void setTagColor(ColorInfo colorInfo) {
        this.tagColor.set(colorInfo);
    }

    @Deprecated
    public Integer getTransactionID() {
        return this.transactionID;
    }

    @Deprecated
    public void setTransactionID(Integer n) {
        this.transactionID = n;
    }

    public String getDisplayName() {
        if (GameClient.bClient) {
            if (this.displayName == null || this.displayName.equals("")) {
                this.displayName = this.getUsername();
            }
        } else if (!GameServer.bServer) {
            this.displayName = this.getUsername();
        }
        return this.displayName;
    }

    public void setDisplayName(String string) {
        this.displayName = string;
    }

    public boolean isSeeNonPvpZone() {
        return this.seeNonPvpZone || DebugOptions.instance.MultiplayerSeeNonPvpZones.getValue();
    }

    public void setSeeNonPvpZone(boolean bl) {
        this.seeNonPvpZone = bl;
    }

    public boolean isShowTag() {
        return this.showTag;
    }

    public void setShowTag(boolean bl) {
        this.showTag = bl;
    }

    public boolean isFactionPvp() {
        return this.factionPvp;
    }

    public void setFactionPvp(boolean bl) {
        this.factionPvp = bl;
    }

    public boolean isForceAim() {
        return this.forceAim;
    }

    public void setForceAim(boolean bl) {
        this.forceAim = bl;
    }

    public boolean toggleForceAim() {
        this.forceAim = !this.forceAim;
        return this.forceAim;
    }

    public boolean isForceSprint() {
        return this.forceSprint;
    }

    public void setForceSprint(boolean bl) {
        this.forceSprint = bl;
    }

    public boolean toggleForceSprint() {
        this.forceSprint = !this.forceSprint;
        return this.forceSprint;
    }

    public boolean isForceRun() {
        return this.forceRun;
    }

    public void setForceRun(boolean bl) {
        this.forceRun = bl;
    }

    public boolean toggleForceRun() {
        this.forceRun = !this.forceRun;
        return this.forceRun;
    }

    public boolean isDeaf() {
        return this.Traits.Deaf.isSet();
    }

    public boolean isForceOverrideAnim() {
        return this.forceOverrideAnim;
    }

    public void setForceOverrideAnim(boolean bl) {
        this.forceOverrideAnim = bl;
    }

    public Long getMechanicsItem(String string) {
        return this.mechanicsItem.get(Long.parseLong(string));
    }

    public boolean isWearingNightVisionGoggles() {
        return this.isWearingNightVisionGoggles;
    }

    public void setWearingNightVisionGoggles(boolean bl) {
        this.isWearingNightVisionGoggles = bl;
    }

    @Override
    public void OnAnimEvent(AnimLayer animLayer, AnimEvent animEvent) {
        super.OnAnimEvent(animLayer, animEvent);
        if (this.CharacterActions.isEmpty()) {
            return;
        }
        BaseAction baseAction = (BaseAction)this.CharacterActions.get(0);
        baseAction.OnAnimEvent(animEvent);
    }

    @Override
    public void onCullStateChanged(ModelManager modelManager, boolean bl) {
        super.onCullStateChanged(modelManager, bl);
        if (!bl) {
            DebugFileWatcher.instance.add(this.m_setClothingTriggerWatcher);
        } else {
            DebugFileWatcher.instance.remove(this.m_setClothingTriggerWatcher);
        }
    }

    @Override
    public boolean isTimedActionInstant() {
        if ((GameClient.bClient || GameServer.bServer) && this.isAccessLevel("None")) {
            return false;
        }
        return super.isTimedActionInstant();
    }

    @Override
    public boolean isSkeleton() {
        return false;
    }

    @Override
    public void addWorldSoundUnlessInvisible(int n, int n2, boolean bl) {
        if (this.isGhostMode()) {
            return;
        }
        super.addWorldSoundUnlessInvisible(n, n2, bl);
    }

    private void updateFootInjuries() {
        Object object;
        IsoObject isoObject;
        InventoryItem inventoryItem = this.getWornItems().getItem("Shoes");
        if (inventoryItem != null && inventoryItem.getCondition() > 0) {
            return;
        }
        if (this.getCurrentSquare() == null) {
            return;
        }
        if (this.getCurrentSquare().getBrokenGlass() != null) {
            BodyPartType bodyPartType = BodyPartType.FromIndex(Rand.Next(BodyPartType.ToIndex(BodyPartType.Foot_L), BodyPartType.ToIndex(BodyPartType.Foot_R) + 1));
            BodyPart bodyPart = this.getBodyDamage().getBodyPart(bodyPartType);
            bodyPart.generateDeepShardWound();
        }
        int n = 0;
        boolean bl = false;
        if (this.getCurrentSquare().getZone() != null && (this.getCurrentSquare().getZone().getType().equals("Forest") || this.getCurrentSquare().getZone().getType().equals("DeepForest"))) {
            bl = true;
        }
        if ((isoObject = this.getCurrentSquare().getFloor()) != null && isoObject.getSprite() != null && isoObject.getSprite().getName() != null) {
            object = isoObject.getSprite().getName();
            if (object.contains("blends_natural_01") && bl) {
                n = 2;
            } else if (!object.contains("blends_natural_01") && this.getCurrentSquare().getBuilding() == null) {
                n = 1;
            }
        }
        if (n == 0) {
            return;
        }
        if (this.isWalking && !this.isRunning() && !this.isSprinting()) {
            this.footInjuryTimer += n;
        } else if (this.isRunning() && !this.isSprinting()) {
            this.footInjuryTimer += n + 2;
        } else if (this.isSprinting()) {
            this.footInjuryTimer += n + 5;
        } else {
            if (this.footInjuryTimer > 0 && Rand.Next(3) == 0) {
                --this.footInjuryTimer;
            }
            return;
        }
        if (Rand.Next(Rand.AdjustForFramerate(8500 - this.footInjuryTimer)) <= 0) {
            this.footInjuryTimer = 0;
            object = BodyPartType.FromIndex(Rand.Next(BodyPartType.ToIndex(BodyPartType.Foot_L), BodyPartType.ToIndex(BodyPartType.Foot_R) + 1));
            BodyPart bodyPart = this.getBodyDamage().getBodyPart((BodyPartType)((Object)object));
            if (bodyPart.getScratchTime() > 30.0f) {
                if (!bodyPart.isCut()) {
                    bodyPart.setCut(true);
                    bodyPart.setCutTime(Rand.Next(1.0f, 3.0f));
                } else {
                    bodyPart.setCutTime(bodyPart.getCutTime() + Rand.Next(1.0f, 3.0f));
                }
            } else {
                if (!bodyPart.scratched()) {
                    bodyPart.setScratched(true, true);
                    bodyPart.setScratchTime(Rand.Next(1.0f, 3.0f));
                } else {
                    bodyPart.setScratchTime(bodyPart.getScratchTime() + Rand.Next(1.0f, 3.0f));
                }
                if (bodyPart.getScratchTime() > 20.0f && bodyPart.getBleedingTime() == 0.0f) {
                    bodyPart.setBleedingTime(Rand.Next(3.0f, 10.0f));
                }
            }
        }
    }

    public int getMoodleLevel(MoodleType moodleType) {
        return this.getMoodles().getMoodleLevel(moodleType);
    }

    public boolean isAttackStarted() {
        return this.attackStarted;
    }

    @Override
    public boolean isBehaviourMoving() {
        return this.hasPath() || super.isBehaviourMoving();
    }

    public boolean isJustMoved() {
        return this.JustMoved;
    }

    public void setJustMoved(boolean bl) {
        this.JustMoved = bl;
    }

    @Override
    public boolean isPlayerMoving() {
        return this.m_isPlayerMoving;
    }

    @Override
    public float getTimedActionTimeModifier() {
        if (this.getBodyDamage().getThermoregulator() != null) {
            return this.getBodyDamage().getThermoregulator().getTimedActionTimeModifier();
        }
        return 1.0f;
    }

    public boolean isLookingWhileInVehicle() {
        return this.getVehicle() != null && this.bLookingWhileInVehicle;
    }

    public void setInitiateAttack(boolean bl) {
        this.initiateAttack = bl;
    }

    public boolean isIgnoreInputsForDirection() {
        return this.ignoreInputsForDirection;
    }

    public void setIgnoreInputsForDirection(boolean bl) {
        this.ignoreInputsForDirection = bl;
    }

    public boolean isIgnoreContextKey() {
        return this.ignoreContextKey;
    }

    public void setIgnoreContextKey(boolean bl) {
        this.ignoreContextKey = bl;
    }

    public boolean isIgnoreAutoVault() {
        return this.ignoreAutoVault;
    }

    public void setIgnoreAutoVault(boolean bl) {
        this.ignoreAutoVault = bl;
    }

    public boolean isAllowSprint() {
        return this.allowSprint;
    }

    public void setAllowSprint(boolean bl) {
        this.allowSprint = bl;
    }

    public boolean isAllowRun() {
        return this.allowRun;
    }

    public void setAllowRun(boolean bl) {
        this.allowRun = bl;
    }

    public String getAttackType() {
        return this.attackType;
    }

    public void setAttackType(String string) {
        this.attackType = string;
    }

    public void clearNetworkEvents() {
        this.networkAI.events.clear();
        this.clearVariable("PerformingAction");
        this.clearVariable("IsPerformingAnAction");
        this.overridePrimaryHandModel = null;
        this.overrideSecondaryHandModel = null;
        this.resetModelNextFrame();
    }

    public boolean isCanSeeAll() {
        return this.canSeeAll;
    }

    public void setCanSeeAll(boolean bl) {
        this.canSeeAll = bl;
    }

    public boolean isNetworkTeleportEnabled() {
        return NetworkTeleport.enable;
    }

    public void setNetworkTeleportEnabled(boolean bl) {
        NetworkTeleport.enable = bl;
    }

    public boolean isCheatPlayerSeeEveryone() {
        return DebugOptions.instance.CheatPlayerSeeEveryone.getValue();
    }

    public float getRelevantAndDistance(float f, float f2, float f3) {
        if (Math.abs(this.x - f) <= f3 * 10.0f && Math.abs(this.y - f2) <= f3 * 10.0f) {
            return IsoUtils.DistanceTo(this.x, this.y, f, f2);
        }
        return Float.POSITIVE_INFINITY;
    }

    public boolean isCanHearAll() {
        return this.canHearAll;
    }

    public void setCanHearAll(boolean bl) {
        this.canHearAll = bl;
    }

    public ArrayList<String> getAlreadyReadBook() {
        return this.alreadyReadBook;
    }

    public void setMoodleCantSprint(boolean bl) {
        this.MoodleCantSprint = bl;
    }

    public void setAttackFromBehind(boolean bl) {
        this.attackFromBehind = bl;
    }

    public boolean isAttackFromBehind() {
        return this.attackFromBehind;
    }

    public float getDamageFromHitByACar(float f) {
        float f2 = 1.0f;
        switch (SandboxOptions.instance.DamageToPlayerFromHitByACar.getValue()) {
            case 1: {
                f2 = 0.0f;
                break;
            }
            case 2: {
                f2 = 0.5f;
                break;
            }
            case 4: {
                f2 = 2.0f;
                break;
            }
            case 5: {
                f2 = 5.0f;
            }
        }
        float f3 = f * f2;
        if (DebugOptions.instance.MultiplayerCriticalHit.getValue()) {
            f3 += 10.0f;
        }
        if (f3 > 0.0f) {
            int n = (int)(2.0f + f3 * 0.07f);
            for (int i = 0; i < n; ++i) {
                int n2 = Rand.Next(BodyPartType.ToIndex(BodyPartType.Hand_L), BodyPartType.ToIndex(BodyPartType.MAX));
                BodyPart bodyPart = this.getBodyDamage().getBodyPart(BodyPartType.FromIndex(n2));
                float f4 = Math.max(Rand.Next(f3 - 15.0f, f3), 5.0f);
                if (this.Traits.FastHealer.isSet()) {
                    f4 = (float)((double)f4 * 0.8);
                } else if (this.Traits.SlowHealer.isSet()) {
                    f4 = (float)((double)f4 * 1.2);
                }
                switch (SandboxOptions.instance.InjurySeverity.getValue()) {
                    case 1: {
                        f4 *= 0.5f;
                        break;
                    }
                    case 3: {
                        f4 *= 1.5f;
                    }
                }
                f4 = (float)((double)f4 * 0.9);
                bodyPart.AddDamage(f4);
                if (f4 > 40.0f && Rand.Next(12) == 0) {
                    bodyPart.generateDeepWound();
                }
                if (f4 > 10.0f && Rand.Next(100) <= 10 && SandboxOptions.instance.BoneFracture.getValue()) {
                    bodyPart.setFractureTime(Rand.Next(Rand.Next(10.0f, f4 + 10.0f), Rand.Next(f4 + 20.0f, f4 + 30.0f)));
                }
                if (f4 > 30.0f && Rand.Next(100) <= 80 && SandboxOptions.instance.BoneFracture.getValue() && n2 == BodyPartType.ToIndex(BodyPartType.Head)) {
                    bodyPart.setFractureTime(Rand.Next(Rand.Next(10.0f, f4 + 10.0f), Rand.Next(f4 + 20.0f, f4 + 30.0f)));
                }
                if (!(f4 > 10.0f) || Rand.Next(100) > 60 || !SandboxOptions.instance.BoneFracture.getValue() || n2 <= BodyPartType.ToIndex(BodyPartType.Groin)) continue;
                bodyPart.setFractureTime(Rand.Next(Rand.Next(10.0f, f4 + 20.0f), Rand.Next(f4 + 30.0f, f4 + 40.0f)));
            }
            this.getBodyDamage().Update();
        }
        this.addBlood(f);
        if (GameClient.bClient && this.isLocal()) {
            this.updateMovementRates();
            GameClient.sendPlayerInjuries(this);
            GameClient.sendPlayerDamage(this);
        }
        return f3;
    }

    @Override
    public float Hit(BaseVehicle baseVehicle, float f, boolean bl, float f2, float f3) {
        float f4 = this.doBeatenVehicle(f);
        super.Hit(baseVehicle, f, bl, f2, f3);
        return f4;
    }

    @Override
    public void Kill(IsoGameCharacter isoGameCharacter) {
        if (this.isOnKillDone()) {
            return;
        }
        super.Kill(isoGameCharacter);
        this.getBodyDamage().setOverallBodyHealth(0.0f);
        if (DebugOptions.instance.MultiplayerPlayerZombie.getValue()) {
            this.getBodyDamage().setInfectionLevel(100.0f);
        }
        if (isoGameCharacter == null) {
            this.DoDeath(null, null);
        } else {
            this.DoDeath(isoGameCharacter.getUseHandWeapon(), isoGameCharacter);
        }
        if (GameClient.bClient) {
            ClientPlayerDB.getInstance().clientSendNetworkPlayerInt(this);
        }
    }

    @Override
    public boolean shouldDoInventory() {
        return this.isLocalPlayer();
    }

    @Override
    public void becomeCorpse() {
        if (this.isOnDeathDone()) {
            return;
        }
        if (!this.shouldBecomeCorpse() && !this.isLocalPlayer()) {
            return;
        }
        super.becomeCorpse();
        if (GameClient.bClient && this.shouldDoInventory()) {
            GameClient.sendPlayerDeath(this);
        }
        if (!GameClient.bClient) {
            IsoDeadBody isoDeadBody = new IsoDeadBody(this);
            if (this.shouldBecomeZombieAfterDeath()) {
                isoDeadBody.reanimateLater();
            }
            if (GameServer.bServer) {
                GameServer.sendBecomeCorpse(isoDeadBody);
            }
        }
    }

    @Override
    public void preupdate() {
        if (GameClient.bClient) {
            HitReactionNetworkAI hitReactionNetworkAI;
            this.networkAI.updateHitVehicle();
            if (!this.isLocal() && this.isKnockedDown() && !this.isOnFloor() && (hitReactionNetworkAI = this.getHitReactionNetworkAI()).isSetup() && !hitReactionNetworkAI.isStarted()) {
                hitReactionNetworkAI.start();
            }
        }
        super.preupdate();
    }

    @Override
    public HitReactionNetworkAI getHitReactionNetworkAI() {
        return this.networkAI.hitReaction;
    }

    @Override
    public NetworkCharacterAI getNetworkCharacterAI() {
        return this.networkAI;
    }

    public void setFitnessSpeed() {
        this.clearVariable("FitnessStruggle");
        float f = (float)this.getPerkLevel(PerkFactory.Perks.Fitness) / 5.0f / 1.1f - (float)this.getMoodleLevel(MoodleType.Endurance) / 20.0f;
        if (f > 1.5f) {
            f = 1.5f;
        }
        if (f < 0.85f) {
            f = 1.0f;
            this.setVariable("FitnessStruggle", true);
        }
        this.setVariable("FitnessSpeed", f);
    }

    @Override
    public boolean isLocal() {
        return super.isLocal() || this.isLocalPlayer();
    }

    public boolean isClimbOverWallSuccess() {
        return this.climbOverWallSuccess;
    }

    public void setClimbOverWallSuccess(boolean bl) {
        this.climbOverWallSuccess = bl;
    }

    public boolean isClimbOverWallStruggle() {
        return this.climbOverWallStruggle;
    }

    public void setClimbOverWallStruggle(boolean bl) {
        this.climbOverWallStruggle = bl;
    }

    @Override
    public boolean isVehicleCollisionActive(BaseVehicle baseVehicle) {
        if (!super.isVehicleCollisionActive(baseVehicle)) {
            return false;
        }
        if (this.isGodMod()) {
            return false;
        }
        IsoPlayer isoPlayer = GameClient.IDToPlayerMap.get(this.vehicle4testCollision.getNetPlayerId());
        if (!SwipeStatePlayer.checkPVP(isoPlayer, this)) {
            return false;
        }
        if (SandboxOptions.instance.DamageToPlayerFromHitByACar.getValue() < 1) {
            return false;
        }
        if (this.getVehicle() == baseVehicle) {
            return false;
        }
        return !this.isCurrentState(PlayerFallDownState.instance()) && !this.isCurrentState(PlayerFallingState.instance()) && !this.isCurrentState(PlayerKnockedDown.instance());
    }

    public boolean isShowMPInfos() {
        return this.showMPInfos;
    }

    public void setShowMPInfos(boolean bl) {
        this.showMPInfos = bl;
    }

    static {
        instanceLock = "IsoPlayer.instance Lock";
        testHitPosition = new Vector2();
        FollowDeadCount = 240;
        StaticTraits = new Stack();
        tempo = new Vector2();
        tempVector2 = new Vector2();
        CoopPVP = false;
        m_isoPlayerTriggerWatcher = new PredicatedFileWatcher(ZomboidFileSystem.instance.getMessagingDirSub("Trigger_ResetIsoPlayerModel.xml"), IsoPlayer::onTrigger_ResetIsoPlayerModel);
        tempVector2_1 = new Vector2();
        tempVector2_2 = new Vector2();
        tempVector3f = new Vector3f();
        RecentlyRemoved = new ArrayList();
        s_moveVars = new MoveVars();
        s_targetsProne = new ArrayList();
        s_targetsStanding = new ArrayList();
    }

    static class InputState {
        public boolean bMelee;
        public boolean isAttacking;
        public boolean bRunning;
        public boolean bSprinting;
        boolean isAiming;
        boolean isCharging;
        boolean isChargingLT;

        InputState() {
        }
    }

    private static class VehicleContainerData {
        ArrayList<VehicleContainer> tempContainers = new ArrayList();
        ArrayList<VehicleContainer> containers = new ArrayList();
        Stack<VehicleContainer> freeContainers = new Stack();

        private VehicleContainerData() {
        }
    }

    private static class s_performance {
        static final PerformanceProfileProbe postUpdate = new PerformanceProfileProbe("IsoPlayer.postUpdate");
        static final PerformanceProfileProbe highlightRangedTargets = new PerformanceProfileProbe("IsoPlayer.highlightRangedTargets");
        static final PerformanceProfileProbe update = new PerformanceProfileProbe("IsoPlayer.update");

        private s_performance() {
        }
    }

    static final class MoveVars {
        float moveX;
        float moveY;
        float strafeX;
        float strafeY;
        IsoDirections NewFacing;

        MoveVars() {
        }
    }

    private static class VehicleContainer {
        BaseVehicle vehicle;
        int containerIndex;

        private VehicleContainer() {
        }

        public VehicleContainer set(BaseVehicle baseVehicle, int n) {
            this.vehicle = baseVehicle;
            this.containerIndex = n;
            return this;
        }

        public boolean equals(Object object) {
            return object instanceof VehicleContainer && this.vehicle == ((VehicleContainer)object).vehicle && this.containerIndex == ((VehicleContainer)object).containerIndex;
        }
    }
}

