/*
 * Decompiled with CFR 0.152.
 */
package zombie.characters;

import java.io.Serializable;
import zombie.Lua.LuaHookManager;
import zombie.WorldSoundManager;
import zombie.ai.states.SwipeStatePlayer;
import zombie.characters.IsoGameCharacter;
import zombie.characters.IsoPlayer;
import zombie.characters.IsoSurvivor;
import zombie.characters.Moodles.MoodleType;
import zombie.characters.skills.PerkFactory;
import zombie.inventory.InventoryItem;
import zombie.inventory.InventoryItemFactory;
import zombie.inventory.types.HandWeapon;
import zombie.iso.IsoCell;
import zombie.iso.IsoMovingObject;
import zombie.iso.Vector2;
import zombie.network.packets.hit.AttackVars;
import zombie.ui.UIManager;

public class IsoLivingCharacter
extends IsoGameCharacter {
    public float useChargeDelta = 0.0f;
    public final HandWeapon bareHands = (HandWeapon)InventoryItemFactory.CreateItem("Base.BareHands");
    public boolean bDoShove = false;
    public boolean bCollidedWithPushable = false;
    public IsoGameCharacter targetOnGround;

    public IsoLivingCharacter(IsoCell isoCell, float f, float f2, float f3) {
        super(isoCell, f, f2, f3);
    }

    public boolean isCollidedWithPushableThisFrame() {
        return this.bCollidedWithPushable;
    }

    public boolean AttemptAttack(float f) {
        HandWeapon handWeapon = null;
        handWeapon = this.leftHandItem instanceof HandWeapon ? (HandWeapon)this.leftHandItem : this.bareHands;
        if (handWeapon != this.bareHands && this instanceof IsoPlayer) {
            AttackVars attackVars = new AttackVars();
            SwipeStatePlayer.instance().CalcAttackVars(this, attackVars);
            this.setDoShove(attackVars.bDoShove);
            if (LuaHookManager.TriggerHook("Attack", this, Float.valueOf(f), handWeapon)) {
                return false;
            }
        }
        return this.DoAttack(f);
    }

    public boolean DoAttack(float f) {
        InventoryItem inventoryItem;
        if (this.isDead()) {
            return false;
        }
        if (this.leftHandItem != null && (inventoryItem = this.leftHandItem) instanceof HandWeapon) {
            Serializable serializable;
            int n;
            this.useHandWeapon = (HandWeapon)inventoryItem;
            if (this.useHandWeapon.getCondition() <= 0) {
                return false;
            }
            int n2 = this.Moodles.getMoodleLevel(MoodleType.Endurance);
            if (this.useHandWeapon.isCantAttackWithLowestEndurance() && n2 == 4) {
                return false;
            }
            int n3 = 0;
            if (this.useHandWeapon.isRanged()) {
                n = this.useHandWeapon.getRecoilDelay();
                serializable = Float.valueOf((float)n * (1.0f - (float)this.getPerkLevel(PerkFactory.Perks.Aiming) / 30.0f));
                this.setRecoilDelay(((Float)serializable).intValue());
            }
            if (this instanceof IsoSurvivor && this.useHandWeapon.isRanged() && n3 < this.useHandWeapon.getMaxHitCount()) {
                for (n = 0; n < this.getCell().getObjectList().size(); ++n) {
                    float f2;
                    serializable = this.getCell().getObjectList().get(n);
                    if (serializable == this || !((IsoMovingObject)serializable).isShootable() || !this.IsAttackRange(((IsoMovingObject)serializable).getX(), ((IsoMovingObject)serializable).getY(), ((IsoMovingObject)serializable).getZ()) || !((f2 = 1.0f) > 0.0f)) continue;
                    Vector2 vector22 = new Vector2(this.getX(), this.getY());
                    Vector2 vector23 = new Vector2(((IsoMovingObject)serializable).getX(), ((IsoMovingObject)serializable).getY());
                    vector23.x -= vector22.x;
                    vector23.y -= vector22.y;
                    boolean bl = false;
                    if (vector23.x == 0.0f && vector23.y == 0.0f) {
                        bl = true;
                    }
                    Vector2 vector24 = this.getForwardDirection();
                    this.DirectionFromVector(vector24);
                    vector23.normalize();
                    float f3 = vector23.dot(vector24);
                    if (bl) {
                        f3 = 1.0f;
                    }
                    if (f3 > 1.0f) {
                        f3 = 1.0f;
                    }
                    if (f3 < -1.0f) {
                        f3 = -1.0f;
                    }
                    if (f3 >= this.useHandWeapon.getMinAngle() && f3 <= this.useHandWeapon.getMaxAngle()) {
                        ++n3;
                    }
                    if (n3 >= this.useHandWeapon.getMaxHitCount()) break;
                }
            }
            if (UIManager.getPicked() != null) {
                this.attackTargetSquare = UIManager.getPicked().square;
                if (UIManager.getPicked().tile instanceof IsoMovingObject) {
                    this.attackTargetSquare = ((IsoMovingObject)UIManager.getPicked().tile).getCurrentSquare();
                }
            }
            if (this.useHandWeapon.getAmmoType() != null && !this.inventory.contains(this.useHandWeapon.getAmmoType())) {
                return false;
            }
            if (!(this.useHandWeapon.getOtherHandRequire() == null || this.rightHandItem != null && this.rightHandItem.getType().equals(this.useHandWeapon.getOtherHandRequire()))) {
                return false;
            }
            if (!this.useHandWeapon.isRanged()) {
                this.getEmitter().playSound(this.useHandWeapon.getSwingSound(), this);
                WorldSoundManager.instance.addSound(this, (int)this.getX(), (int)this.getY(), (int)this.getZ(), this.useHandWeapon.getSoundRadius(), this.useHandWeapon.getSoundVolume());
            }
            this.AttackWasSuperAttack = this.superAttack;
            this.changeState(SwipeStatePlayer.instance());
            if (this.useHandWeapon.getAmmoType() != null) {
                if (this instanceof IsoPlayer) {
                    IsoPlayer.getInstance().inventory.RemoveOneOf(this.useHandWeapon.getAmmoType());
                } else {
                    this.inventory.RemoveOneOf(this.useHandWeapon.getAmmoType());
                }
            }
            if (this.useHandWeapon.isUseSelf() && this.leftHandItem != null) {
                this.leftHandItem.Use();
            }
            if (this.useHandWeapon.isOtherHandUse() && this.rightHandItem != null) {
                this.rightHandItem.Use();
            }
            return true;
        }
        return false;
    }

    public boolean isDoShove() {
        return this.bDoShove;
    }

    public void setDoShove(boolean bl) {
        this.bDoShove = bl;
    }
}

