/*
 * Decompiled with CFR 0.152.
 */
package zombie.characters;

import zombie.GameTime;
import zombie.ai.states.PlayerFallDownState;
import zombie.ai.states.PlayerKnockedDown;
import zombie.ai.states.PlayerOnGroundState;
import zombie.ai.states.ZombieFallDownState;
import zombie.ai.states.ZombieOnGroundState;
import zombie.characters.IsoGameCharacter;
import zombie.characters.IsoPlayer;
import zombie.characters.IsoZombie;
import zombie.core.math.PZMath;
import zombie.debug.DebugLog;
import zombie.inventory.types.HandWeapon;
import zombie.iso.IsoDirections;
import zombie.iso.IsoMovingObject;
import zombie.iso.IsoUtils;
import zombie.iso.IsoWorld;
import zombie.iso.Vector2;
import zombie.network.GameServer;
import zombie.vehicles.BaseVehicle;
import zombie.vehicles.PolygonalMap2;

public class HitReactionNetworkAI {
    private static final float G = 2.0f;
    private static final float DURATION = 600.0f;
    public final Vector2 startPosition = new Vector2();
    public final Vector2 finalPosition = new Vector2();
    public byte finalPositionZ = 0;
    public final Vector2 startDirection = new Vector2();
    public final Vector2 finalDirection = new Vector2();
    private float startAngle;
    private float finalAngle;
    private final IsoGameCharacter character;
    private long startTime;

    public HitReactionNetworkAI(IsoGameCharacter isoGameCharacter) {
        this.character = isoGameCharacter;
        this.startTime = 0L;
    }

    public boolean isSetup() {
        return this.finalPosition.x != 0.0f && this.finalPosition.y != 0.0f;
    }

    public boolean isStarted() {
        return this.startTime > 0L;
    }

    public void start() {
        if (this.isSetup() && !this.isStarted()) {
            this.startTime = GameTime.getServerTimeMills();
            if (this.startPosition.x != this.character.x || this.startPosition.y != this.character.y) {
                DebugLog.Multiplayer.warn("HitReaction start shifted");
            }
            DebugLog.Damage.trace("id=%d: %s / %s => %s", this.character.getOnlineID(), this.getActualDescription(), this.getStartDescription(), this.getFinalDescription());
        }
    }

    public void finish() {
        if (this.startTime != 0L) {
            DebugLog.Damage.trace("id=%d: %s / %s => %s", this.character.getOnlineID(), this.getActualDescription(), this.getStartDescription(), this.getFinalDescription());
        }
        this.startTime = 0L;
        this.setup(0.0f, 0.0f, (byte)0, Float.valueOf(0.0f));
    }

    public void setup(float f, float f2, byte by, Float f3) {
        this.startPosition.set(this.character.x, this.character.y);
        this.finalPosition.set(f, f2);
        this.finalPositionZ = by;
        this.startDirection.set(this.character.getForwardDirection());
        this.startAngle = this.character.getAnimAngleRadians();
        Vector2 vector22 = new Vector2().set(this.finalPosition.x - this.startPosition.x, this.finalPosition.y - this.startPosition.y);
        if (f3 == null) {
            vector22.normalize();
            f3 = Float.valueOf(vector22.dot(this.character.getForwardDirection()));
            PZMath.lerp(this.finalDirection, vector22, this.character.getForwardDirection(), Math.abs(f3.floatValue()));
            IsoMovingObject.getVectorFromDirection(this.finalDirection, IsoDirections.fromAngle(this.finalDirection));
        } else {
            this.finalDirection.setLengthAndDirection(f3.floatValue(), 1.0f);
        }
        this.finalAngle = f3.floatValue();
        if (this.isSetup()) {
            DebugLog.Damage.trace("id=%d: %s / %s => %s", this.character.getOnlineID(), this.getActualDescription(), this.getStartDescription(), this.getFinalDescription());
        }
    }

    private void moveInternal(float f, float f2, float f3, float f4) {
        this.character.nx = f;
        this.character.ny = f2;
        this.character.setDir(IsoDirections.fromAngle(f3, f4));
        this.character.setForwardDirection(f3, f4);
        this.character.getAnimationPlayer().SetForceDir(this.character.getForwardDirection());
    }

    public void moveFinal() {
        this.moveInternal(this.finalPosition.x, this.finalPosition.y, this.finalDirection.x, this.finalDirection.y);
        this.character.nx = this.character.x = this.finalPosition.x;
        this.character.lx = this.character.x;
        this.character.ny = this.character.y = this.finalPosition.y;
        this.character.ly = this.character.y;
        this.character.setCurrent(IsoWorld.instance.CurrentCell.getGridSquare((double)((int)this.finalPosition.x), (double)((int)this.finalPosition.y), this.character.z));
        DebugLog.Damage.trace("id=%d: %s / %s => %s", this.character.getOnlineID(), this.getActualDescription(), this.getStartDescription(), this.getFinalDescription());
    }

    public void move() {
        if (this.finalPositionZ != (byte)this.character.z) {
            DebugLog.Damage.trace("HitReaction interrupt id=%d: z-final:%d z-current=%d", this.character.getOnlineID(), this.finalPositionZ, (byte)this.character.z);
            this.finish();
            return;
        }
        float f = Math.min(1.0f, Math.max(0.0f, (float)(GameTime.getServerTimeMills() - this.startTime) / 600.0f));
        if (this.startPosition.x == this.finalPosition.x && this.startPosition.y == this.finalPosition.y) {
            f = 1.0f;
        }
        if (f < 1.0f) {
            f = (PZMath.gain(f * 0.5f + 0.5f, 2.0f) - 0.5f) * 2.0f;
            this.moveInternal(PZMath.lerp(this.startPosition.x, this.finalPosition.x, f), PZMath.lerp(this.startPosition.y, this.finalPosition.y, f), PZMath.lerp(this.startDirection.x, this.finalDirection.x, f), PZMath.lerp(this.startDirection.y, this.finalDirection.y, f));
        } else {
            this.moveFinal();
            this.finish();
        }
    }

    public boolean isDoSkipMovement() {
        if (this.character instanceof IsoZombie) {
            return this.character.isCurrentState(ZombieFallDownState.instance()) || this.character.isCurrentState(ZombieOnGroundState.instance());
        }
        if (this.character instanceof IsoPlayer) {
            return this.character.isCurrentState(PlayerFallDownState.instance()) || this.character.isCurrentState(PlayerKnockedDown.instance()) || this.character.isCurrentState(PlayerOnGroundState.instance());
        }
        return false;
    }

    private String getStartDescription() {
        return String.format("start=[ pos=( %f ; %f ) dir=( %f ; %f ) angle=%f ]", Float.valueOf(this.startPosition.x), Float.valueOf(this.startPosition.y), Float.valueOf(this.startDirection.x), Float.valueOf(this.startDirection.y), Float.valueOf(this.startAngle));
    }

    private String getFinalDescription() {
        return String.format("final=[ pos=( %f ; %f ) dir=( %f ; %f ) angle=%f ]", Float.valueOf(this.finalPosition.x), Float.valueOf(this.finalPosition.y), Float.valueOf(this.finalDirection.x), Float.valueOf(this.finalDirection.y), Float.valueOf(this.finalAngle));
    }

    private String getActualDescription() {
        return String.format("actual=[ pos=( %f ; %f ) dir=( %f ; %f ) angle=%f ]", Float.valueOf(this.character.x), Float.valueOf(this.character.y), Float.valueOf(this.character.getForwardDirection().getX()), Float.valueOf(this.character.getForwardDirection().getY()), Float.valueOf(this.character.getAnimAngleRadians()));
    }

    public String getDescription() {
        return String.format("start=%d | (x=%f,y=%f;a=%f;l=%f)", this.startTime, Float.valueOf(this.finalPosition.x), Float.valueOf(this.finalPosition.y), Float.valueOf(this.finalAngle), Float.valueOf(IsoUtils.DistanceTo(this.startPosition.x, this.startPosition.y, this.finalPosition.x, this.finalPosition.y)));
    }

    public static void CalcHitReactionWeapon(IsoGameCharacter isoGameCharacter, IsoGameCharacter isoGameCharacter2, HandWeapon handWeapon) {
        HitReactionNetworkAI hitReactionNetworkAI = isoGameCharacter2.getHitReactionNetworkAI();
        if (isoGameCharacter2.isOnFloor()) {
            hitReactionNetworkAI.setup(isoGameCharacter2.x, isoGameCharacter2.y, (byte)isoGameCharacter2.z, Float.valueOf(isoGameCharacter2.getAnimAngleRadians()));
        } else {
            Vector2 vector22 = new Vector2();
            Float f = isoGameCharacter2.calcHitDir(isoGameCharacter, handWeapon, vector22);
            if (isoGameCharacter2 instanceof IsoPlayer) {
                vector22.x = (vector22.x + isoGameCharacter2.x + ((IsoPlayer)isoGameCharacter2).networkAI.targetX) * 0.5f;
                vector22.y = (vector22.y + isoGameCharacter2.y + ((IsoPlayer)isoGameCharacter2).networkAI.targetY) * 0.5f;
            } else {
                vector22.x += isoGameCharacter2.x;
                vector22.y += isoGameCharacter2.y;
            }
            vector22.x = PZMath.roundFromEdges(vector22.x);
            vector22.y = PZMath.roundFromEdges(vector22.y);
            if (PolygonalMap2.instance.lineClearCollide(isoGameCharacter2.x, isoGameCharacter2.y, vector22.x, vector22.y, (int)isoGameCharacter2.z, null, false, true)) {
                vector22.x = isoGameCharacter2.x;
                vector22.y = isoGameCharacter2.y;
            }
            hitReactionNetworkAI.setup(vector22.x, vector22.y, (byte)isoGameCharacter2.z, f);
        }
        if (hitReactionNetworkAI.isSetup()) {
            hitReactionNetworkAI.start();
        }
    }

    public static void CalcHitReactionVehicle(IsoGameCharacter isoGameCharacter, BaseVehicle baseVehicle) {
        HitReactionNetworkAI hitReactionNetworkAI = isoGameCharacter.getHitReactionNetworkAI();
        if (!hitReactionNetworkAI.isStarted()) {
            if (isoGameCharacter.isOnFloor()) {
                hitReactionNetworkAI.setup(isoGameCharacter.x, isoGameCharacter.y, (byte)isoGameCharacter.z, Float.valueOf(isoGameCharacter.getAnimAngleRadians()));
            } else {
                Vector2 vector22 = new Vector2();
                isoGameCharacter.calcHitDir(vector22);
                if (isoGameCharacter instanceof IsoPlayer) {
                    vector22.x = (vector22.x + isoGameCharacter.x + ((IsoPlayer)isoGameCharacter).networkAI.targetX) * 0.5f;
                    vector22.y = (vector22.y + isoGameCharacter.y + ((IsoPlayer)isoGameCharacter).networkAI.targetY) * 0.5f;
                } else {
                    vector22.x += isoGameCharacter.x;
                    vector22.y += isoGameCharacter.y;
                }
                vector22.x = PZMath.roundFromEdges(vector22.x);
                vector22.y = PZMath.roundFromEdges(vector22.y);
                if (PolygonalMap2.instance.lineClearCollide(isoGameCharacter.x, isoGameCharacter.y, vector22.x, vector22.y, (int)isoGameCharacter.z, baseVehicle, false, true)) {
                    vector22.x = isoGameCharacter.x;
                    vector22.y = isoGameCharacter.y;
                }
                hitReactionNetworkAI.setup(vector22.x, vector22.y, (byte)isoGameCharacter.z, null);
            }
        }
        if (hitReactionNetworkAI.isSetup()) {
            hitReactionNetworkAI.start();
        }
    }

    public void process(float f, float f2, float f3, float f4) {
        this.setup(f, f2, (byte)f3, Float.valueOf(f4));
        this.start();
        if (GameServer.bServer) {
            this.moveFinal();
            this.finish();
        }
    }
}

