/*
 * Decompiled with CFR 0.152.
 */
package zombie.characters;

import java.util.ArrayList;
import java.util.Arrays;
import se.krka.kahlua.j2se.KahluaTableImpl;
import se.krka.kahlua.vm.KahluaTableIterator;
import zombie.Lua.LuaManager;
import zombie.characters.SurvivorDesc;
import zombie.core.ImmutableColor;
import zombie.core.skinnedmodel.population.BeardStyle;
import zombie.core.skinnedmodel.population.HairStyle;
import zombie.core.skinnedmodel.population.OutfitRNG;
import zombie.iso.IsoWorld;
import zombie.util.StringUtils;
import zombie.util.Type;

public final class HairOutfitDefinitions {
    public static final HairOutfitDefinitions instance = new HairOutfitDefinitions();
    public boolean m_dirty = true;
    public String hairStyle;
    public int minWorldAge;
    public final ArrayList<HaircutDefinition> m_haircutDefinition = new ArrayList();
    public final ArrayList<HaircutOutfitDefinition> m_outfitDefinition = new ArrayList();
    private final ThreadLocal<ArrayList<HairStyle>> m_tempHairStyles = ThreadLocal.withInitial(ArrayList::new);

    public void checkDirty() {
        if (this.m_dirty) {
            this.m_dirty = false;
            this.init();
        }
    }

    private void init() {
        Object object;
        KahluaTableImpl kahluaTableImpl;
        this.m_haircutDefinition.clear();
        this.m_outfitDefinition.clear();
        KahluaTableImpl kahluaTableImpl2 = (KahluaTableImpl)LuaManager.env.rawget("HairOutfitDefinitions");
        if (kahluaTableImpl2 == null) {
            return;
        }
        KahluaTableImpl kahluaTableImpl3 = Type.tryCastTo(kahluaTableImpl2.rawget("haircutDefinition"), KahluaTableImpl.class);
        if (kahluaTableImpl3 == null) {
            return;
        }
        KahluaTableIterator kahluaTableIterator = kahluaTableImpl3.iterator();
        while (kahluaTableIterator.advance()) {
            kahluaTableImpl = Type.tryCastTo(kahluaTableIterator.getValue(), KahluaTableImpl.class);
            if (kahluaTableImpl == null) continue;
            object = new HaircutDefinition(kahluaTableImpl.rawgetStr("name"), kahluaTableImpl.rawgetInt("minWorldAge"), new ArrayList<String>(Arrays.asList(kahluaTableImpl.rawgetStr("onlyFor").split(","))));
            this.m_haircutDefinition.add((HaircutDefinition)object);
        }
        kahluaTableImpl = Type.tryCastTo(kahluaTableImpl2.rawget("haircutOutfitDefinition"), KahluaTableImpl.class);
        if (kahluaTableImpl == null) {
            return;
        }
        kahluaTableIterator = kahluaTableImpl.iterator();
        while (kahluaTableIterator.advance()) {
            object = Type.tryCastTo(kahluaTableIterator.getValue(), KahluaTableImpl.class);
            if (object == null) continue;
            HaircutOutfitDefinition haircutOutfitDefinition = new HaircutOutfitDefinition(((KahluaTableImpl)object).rawgetStr("outfit"), HairOutfitDefinitions.initStringChance(((KahluaTableImpl)object).rawgetStr("haircut")), HairOutfitDefinitions.initStringChance(((KahluaTableImpl)object).rawgetStr("beard")), HairOutfitDefinitions.initStringChance(((KahluaTableImpl)object).rawgetStr("haircutColor")));
            this.m_outfitDefinition.add(haircutOutfitDefinition);
        }
    }

    public boolean isHaircutValid(String string, String string2) {
        instance.checkDirty();
        if (StringUtils.isNullOrEmpty(string)) {
            return true;
        }
        for (int i = 0; i < HairOutfitDefinitions.instance.m_haircutDefinition.size(); ++i) {
            HaircutDefinition haircutDefinition = HairOutfitDefinitions.instance.m_haircutDefinition.get(i);
            if (!haircutDefinition.hairStyle.equals(string2)) continue;
            if (!haircutDefinition.onlyFor.contains(string)) {
                return false;
            }
            if (!(IsoWorld.instance.getWorldAgeDays() < (float)haircutDefinition.minWorldAge)) continue;
            return false;
        }
        return true;
    }

    public void getValidHairStylesForOutfit(String string, ArrayList<HairStyle> arrayList, ArrayList<HairStyle> arrayList2) {
        arrayList2.clear();
        for (int i = 0; i < arrayList.size(); ++i) {
            HairStyle hairStyle = arrayList.get(i);
            if (hairStyle.isNoChoose() || !this.isHaircutValid(string, hairStyle.name)) continue;
            arrayList2.add(hairStyle);
        }
    }

    public String getRandomHaircut(String string, ArrayList<HairStyle> arrayList) {
        ArrayList<HairStyle> arrayList2 = this.m_tempHairStyles.get();
        this.getValidHairStylesForOutfit(string, arrayList, arrayList2);
        if (arrayList2.isEmpty()) {
            return "";
        }
        String string2 = OutfitRNG.pickRandom(arrayList2).name;
        boolean bl = false;
        block0: for (int i = 0; i < HairOutfitDefinitions.instance.m_outfitDefinition.size() && !bl; ++i) {
            HaircutOutfitDefinition haircutOutfitDefinition = HairOutfitDefinitions.instance.m_outfitDefinition.get(i);
            if (!haircutOutfitDefinition.outfit.equals(string) || haircutOutfitDefinition.haircutChance == null) continue;
            float f = OutfitRNG.Next(0.0f, 100.0f);
            float f2 = 0.0f;
            for (int j = 0; j < haircutOutfitDefinition.haircutChance.size(); ++j) {
                StringChance stringChance = haircutOutfitDefinition.haircutChance.get(j);
                if (!(f < (f2 += stringChance.chance))) continue;
                string2 = stringChance.str;
                if ("null".equalsIgnoreCase(stringChance.str)) {
                    string2 = "";
                }
                if ("random".equalsIgnoreCase(stringChance.str)) {
                    string2 = OutfitRNG.pickRandom(arrayList2).name;
                }
                bl = true;
                continue block0;
            }
        }
        return string2;
    }

    public ImmutableColor getRandomHaircutColor(String string) {
        ImmutableColor immutableColor = SurvivorDesc.HairCommonColors.get(OutfitRNG.Next(SurvivorDesc.HairCommonColors.size()));
        String string2 = null;
        boolean bl = false;
        block0: for (int i = 0; i < HairOutfitDefinitions.instance.m_outfitDefinition.size() && !bl; ++i) {
            HaircutOutfitDefinition haircutOutfitDefinition = HairOutfitDefinitions.instance.m_outfitDefinition.get(i);
            if (!haircutOutfitDefinition.outfit.equals(string) || haircutOutfitDefinition.haircutColor == null) continue;
            float f = OutfitRNG.Next(0.0f, 100.0f);
            float f2 = 0.0f;
            for (int j = 0; j < haircutOutfitDefinition.haircutColor.size(); ++j) {
                StringChance stringChance = haircutOutfitDefinition.haircutColor.get(j);
                if (!(f < (f2 += stringChance.chance))) continue;
                string2 = stringChance.str;
                if ("random".equalsIgnoreCase(stringChance.str)) {
                    immutableColor = SurvivorDesc.HairCommonColors.get(OutfitRNG.Next(SurvivorDesc.HairCommonColors.size()));
                    string2 = null;
                }
                bl = true;
                continue block0;
            }
        }
        if (!StringUtils.isNullOrEmpty(string2)) {
            String[] stringArray = string2.split(",");
            immutableColor = new ImmutableColor(Float.parseFloat(stringArray[0]), Float.parseFloat(stringArray[1]), Float.parseFloat(stringArray[2]));
        }
        return immutableColor;
    }

    public String getRandomBeard(String string, ArrayList<BeardStyle> arrayList) {
        String string2 = OutfitRNG.pickRandom(arrayList).name;
        boolean bl = false;
        block0: for (int i = 0; i < HairOutfitDefinitions.instance.m_outfitDefinition.size() && !bl; ++i) {
            HaircutOutfitDefinition haircutOutfitDefinition = HairOutfitDefinitions.instance.m_outfitDefinition.get(i);
            if (!haircutOutfitDefinition.outfit.equals(string) || haircutOutfitDefinition.beardChance == null) continue;
            float f = OutfitRNG.Next(0.0f, 100.0f);
            float f2 = 0.0f;
            for (int j = 0; j < haircutOutfitDefinition.beardChance.size(); ++j) {
                StringChance stringChance = haircutOutfitDefinition.beardChance.get(j);
                if (!(f < (f2 += stringChance.chance))) continue;
                string2 = stringChance.str;
                if ("null".equalsIgnoreCase(stringChance.str)) {
                    string2 = "";
                }
                if ("random".equalsIgnoreCase(stringChance.str)) {
                    string2 = OutfitRNG.pickRandom(arrayList).name;
                }
                bl = true;
                continue block0;
            }
        }
        return string2;
    }

    private static ArrayList<StringChance> initStringChance(String string) {
        if (StringUtils.isNullOrWhitespace(string)) {
            return null;
        }
        ArrayList<StringChance> arrayList = new ArrayList<StringChance>();
        String[] stringArray = string.split(";");
        int n = 0;
        for (String string2 : stringArray) {
            String[] stringArray2 = string2.split(":");
            StringChance stringChance = new StringChance();
            stringChance.str = stringArray2[0];
            stringChance.chance = Float.parseFloat(stringArray2[1]);
            n = (int)((float)n + stringChance.chance);
            arrayList.add(stringChance);
        }
        if (n < 100) {
            StringChance stringChance = new StringChance();
            stringChance.str = "random";
            stringChance.chance = 100 - n;
            arrayList.add(stringChance);
        }
        return arrayList;
    }

    public static final class HaircutDefinition {
        public String hairStyle;
        public int minWorldAge;
        public ArrayList<String> onlyFor;

        public HaircutDefinition(String string, int n, ArrayList<String> arrayList) {
            this.hairStyle = string;
            this.minWorldAge = n;
            this.onlyFor = arrayList;
        }
    }

    public static final class HaircutOutfitDefinition {
        public String outfit;
        public ArrayList<StringChance> haircutChance;
        public ArrayList<StringChance> beardChance;
        public ArrayList<StringChance> haircutColor;

        public HaircutOutfitDefinition(String string, ArrayList<StringChance> arrayList, ArrayList<StringChance> arrayList2, ArrayList<StringChance> arrayList3) {
            this.outfit = string;
            this.haircutChance = arrayList;
            this.beardChance = arrayList2;
            this.haircutColor = arrayList3;
        }
    }

    private static final class StringChance {
        String str;
        float chance;

        private StringChance() {
        }
    }
}

