/*
 * Decompiled with CFR 0.152.
 */
package zombie.characters;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import zombie.GameWindow;
import zombie.characters.IsoPlayer;
import zombie.chat.ChatSettings;
import zombie.chat.defaultChats.FactionChat;
import zombie.core.Rand;
import zombie.core.network.ByteBufferWriter;
import zombie.core.textures.ColorInfo;
import zombie.network.GameClient;
import zombie.network.ServerOptions;
import zombie.network.chat.ChatServer;

public final class Faction {
    private String name;
    private String owner;
    private String tag;
    private ColorInfo tagColor;
    private final ArrayList<String> players = new ArrayList();
    public static ArrayList<Faction> factions = new ArrayList();

    public Faction() {
    }

    public Faction(String string, String string2) {
        this.setName(string);
        this.setOwner(string2);
        this.tagColor = new ColorInfo(Rand.Next(0.3f, 1.0f), Rand.Next(0.3f, 1.0f), Rand.Next(0.3f, 1.0f), 1.0f);
    }

    public static Faction createFaction(String string, String string2) {
        if (!Faction.factionExist(string)) {
            Faction faction = new Faction(string, string2);
            factions.add(faction);
            if (GameClient.bClient) {
                GameClient.sendFaction(faction, false);
            }
            return faction;
        }
        return null;
    }

    public static ArrayList<Faction> getFactions() {
        return factions;
    }

    public static boolean canCreateFaction(IsoPlayer isoPlayer) {
        boolean bl = ServerOptions.instance.Faction.getValue();
        if (bl && ServerOptions.instance.FactionDaySurvivedToCreate.getValue() > 0 && isoPlayer.getHoursSurvived() / 24.0 < (double)ServerOptions.instance.FactionDaySurvivedToCreate.getValue()) {
            bl = false;
        }
        return bl;
    }

    public boolean canCreateTag() {
        return this.players.size() + 1 >= ServerOptions.instance.FactionPlayersRequiredForTag.getValue();
    }

    public static boolean isAlreadyInFaction(String string) {
        for (int i = 0; i < factions.size(); ++i) {
            Faction faction = factions.get(i);
            if (faction.getOwner().equals(string)) {
                return true;
            }
            for (int j = 0; j < faction.getPlayers().size(); ++j) {
                if (!faction.getPlayers().get(j).equals(string)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isAlreadyInFaction(IsoPlayer isoPlayer) {
        return Faction.isAlreadyInFaction(isoPlayer.getUsername());
    }

    public void removePlayer(String string) {
        this.getPlayers().remove(string);
        if (GameClient.bClient) {
            GameClient.sendFaction(this, false);
        }
    }

    public static boolean factionExist(String string) {
        for (int i = 0; i < factions.size(); ++i) {
            if (!factions.get(i).getName().equals(string)) continue;
            return true;
        }
        return false;
    }

    public static boolean tagExist(String string) {
        for (int i = 0; i < factions.size(); ++i) {
            if (factions.get(i).getTag() == null || !factions.get(i).getTag().equals(string)) continue;
            return true;
        }
        return false;
    }

    public static Faction getPlayerFaction(IsoPlayer isoPlayer) {
        for (int i = 0; i < factions.size(); ++i) {
            Faction faction = factions.get(i);
            if (faction.getOwner().equals(isoPlayer.getUsername())) {
                return faction;
            }
            for (int j = 0; j < faction.getPlayers().size(); ++j) {
                if (!faction.getPlayers().get(j).equals(isoPlayer.getUsername())) continue;
                return faction;
            }
        }
        return null;
    }

    public static Faction getPlayerFaction(String string) {
        for (int i = 0; i < factions.size(); ++i) {
            Faction faction = factions.get(i);
            if (faction.getOwner().equals(string)) {
                return faction;
            }
            for (int j = 0; j < faction.getPlayers().size(); ++j) {
                if (!faction.getPlayers().get(j).equals(string)) continue;
                return faction;
            }
        }
        return null;
    }

    public static Faction getFaction(String string) {
        for (int i = 0; i < factions.size(); ++i) {
            if (!factions.get(i).getName().equals(string)) continue;
            return factions.get(i);
        }
        return null;
    }

    public void removeFaction() {
        Faction.getFactions().remove(this);
        if (GameClient.bClient) {
            GameClient.sendFaction(this, true);
        }
    }

    public void syncFaction() {
        if (GameClient.bClient) {
            GameClient.sendFaction(this, false);
        }
    }

    public boolean isOwner(String string) {
        return this.getOwner().equals(string);
    }

    public boolean isPlayerMember(IsoPlayer isoPlayer) {
        return this.isMember(isoPlayer.getUsername());
    }

    public boolean isMember(String string) {
        for (int i = 0; i < this.getPlayers().size(); ++i) {
            if (!this.getPlayers().get(i).equals(string)) continue;
            return true;
        }
        return false;
    }

    public void writeToBuffer(ByteBufferWriter byteBufferWriter, boolean bl) {
        byteBufferWriter.putUTF(this.getName());
        byteBufferWriter.putUTF(this.getOwner());
        byteBufferWriter.putInt(this.getPlayers().size());
        if (this.getTag() != null) {
            byteBufferWriter.putByte((byte)1);
            byteBufferWriter.putUTF(this.getTag());
            byteBufferWriter.putFloat(this.getTagColor().r);
            byteBufferWriter.putFloat(this.getTagColor().g);
            byteBufferWriter.putFloat(this.getTagColor().b);
        } else {
            byteBufferWriter.putByte((byte)0);
        }
        for (String string : this.getPlayers()) {
            byteBufferWriter.putUTF(string);
        }
        byteBufferWriter.putBoolean(bl);
    }

    public void save(ByteBuffer byteBuffer) {
        GameWindow.WriteString(byteBuffer, this.getName());
        GameWindow.WriteString(byteBuffer, this.getOwner());
        byteBuffer.putInt(this.getPlayers().size());
        if (this.getTag() != null) {
            byteBuffer.put((byte)1);
            GameWindow.WriteString(byteBuffer, this.getTag());
            byteBuffer.putFloat(this.getTagColor().r);
            byteBuffer.putFloat(this.getTagColor().g);
            byteBuffer.putFloat(this.getTagColor().b);
        } else {
            byteBuffer.put((byte)0);
        }
        for (String string : this.getPlayers()) {
            GameWindow.WriteString(byteBuffer, string);
        }
    }

    public void load(ByteBuffer byteBuffer, int n) {
        this.setName(GameWindow.ReadString(byteBuffer));
        this.setOwner(GameWindow.ReadString(byteBuffer));
        int n2 = byteBuffer.getInt();
        if (byteBuffer.get() == 1) {
            this.setTag(GameWindow.ReadString(byteBuffer));
            this.setTagColor(new ColorInfo(byteBuffer.getFloat(), byteBuffer.getFloat(), byteBuffer.getFloat(), 1.0f));
        } else {
            this.setTagColor(new ColorInfo(Rand.Next(0.3f, 1.0f), Rand.Next(0.3f, 1.0f), Rand.Next(0.3f, 1.0f), 1.0f));
        }
        for (int i = 0; i < n2; ++i) {
            this.getPlayers().add(GameWindow.ReadString(byteBuffer));
        }
        if (ChatServer.isInited()) {
            FactionChat factionChat = ChatServer.getInstance().createFactionChat(this.getName());
            ChatSettings chatSettings = FactionChat.getDefaultSettings();
            chatSettings.setFontColor(this.tagColor.r, this.tagColor.g, this.tagColor.b, this.tagColor.a);
            factionChat.setSettings(chatSettings);
        }
    }

    public void addPlayer(String string) {
        for (int i = 0; i < factions.size(); ++i) {
            Faction faction = factions.get(i);
            if (faction.getOwner().equals(string)) {
                return;
            }
            for (int j = 0; j < faction.getPlayers().size(); ++j) {
                if (!faction.getPlayers().get(j).equals(string)) continue;
                return;
            }
        }
        this.players.add(string);
        if (GameClient.bClient) {
            GameClient.sendFaction(this, false);
        }
    }

    public ArrayList<String> getPlayers() {
        return this.players;
    }

    public ColorInfo getTagColor() {
        return this.tagColor;
    }

    public void setTagColor(ColorInfo colorInfo) {
        if (colorInfo.r < 0.19f) {
            colorInfo.r = 0.19f;
        }
        if (colorInfo.g < 0.19f) {
            colorInfo.g = 0.19f;
        }
        if (colorInfo.b < 0.19f) {
            colorInfo.b = 0.19f;
        }
        this.tagColor = colorInfo;
    }

    public String getTag() {
        return this.tag;
    }

    public void setTag(String string) {
        this.tag = string;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public String getOwner() {
        return this.owner;
    }

    public void setOwner(String string) {
        if (this.owner == null) {
            this.owner = string;
            return;
        }
        if (!this.isMember(this.owner)) {
            this.getPlayers().add(this.owner);
            this.getPlayers().remove(string);
        }
        this.owner = string;
    }
}

