/*
 * Decompiled with CFR 0.152.
 */
package zombie.characters;

import java.util.ArrayList;
import org.lwjgl.opengl.GL11;
import zombie.characterTextures.ItemSmartTexture;
import zombie.core.skinnedmodel.ModelManager;
import zombie.core.skinnedmodel.model.ModelInstance;
import zombie.core.textures.SmartTexture;
import zombie.core.textures.Texture;
import zombie.core.textures.TextureDraw;
import zombie.inventory.InventoryItem;
import zombie.inventory.types.HandWeapon;
import zombie.popman.ObjectPool;

public final class EquippedTextureCreator
extends TextureDraw.GenericDrawer {
    private boolean bRendered;
    private ModelInstance modelInstance;
    private float bloodLevel;
    private final ArrayList<Texture> texturesNotReady = new ArrayList();
    private static final ObjectPool<EquippedTextureCreator> pool = new ObjectPool<EquippedTextureCreator>(EquippedTextureCreator::new);

    public void init(ModelInstance modelInstance, InventoryItem inventoryItem) {
        float f = 0.0f;
        if (inventoryItem instanceof HandWeapon) {
            f = ((HandWeapon)inventoryItem).getBloodLevel();
        }
        this.init(modelInstance, f);
    }

    public void init(ModelInstance modelInstance, float f) {
        this.bRendered = false;
        this.texturesNotReady.clear();
        this.modelInstance = modelInstance;
        this.bloodLevel = f;
        if (this.modelInstance != null) {
            ++this.modelInstance.renderRefCount;
            Texture texture = this.modelInstance.tex;
            if (texture instanceof SmartTexture) {
                texture = null;
            }
            if (texture != null && !texture.isReady()) {
                this.texturesNotReady.add(texture);
            }
            if ((texture = Texture.getSharedTexture("media/textures/BloodTextures/BloodOverlayWeapon.png")) != null && !texture.isReady()) {
                this.texturesNotReady.add(texture);
            }
            if ((texture = Texture.getSharedTexture("media/textures/BloodTextures/BloodOverlayWeaponMask.png")) != null && !texture.isReady()) {
                this.texturesNotReady.add(texture);
            }
        }
    }

    @Override
    public void render() {
        for (int i = 0; i < this.texturesNotReady.size(); ++i) {
            Texture texture = this.texturesNotReady.get(i);
            if (texture.isReady()) continue;
            return;
        }
        GL11.glPushAttrib((int)2048);
        try {
            this.updateTexture(this.modelInstance, this.bloodLevel);
        }
        finally {
            GL11.glPopAttrib();
        }
        this.bRendered = true;
    }

    private void updateTexture(ModelInstance modelInstance, float f) {
        if (modelInstance == null) {
            return;
        }
        ItemSmartTexture itemSmartTexture = null;
        if (f > 0.0f) {
            if (modelInstance.tex instanceof ItemSmartTexture) {
                itemSmartTexture = (ItemSmartTexture)modelInstance.tex;
            } else if (modelInstance.tex != null) {
                itemSmartTexture = new ItemSmartTexture(modelInstance.tex.getName());
            }
        } else if (modelInstance.tex instanceof ItemSmartTexture) {
            itemSmartTexture = (ItemSmartTexture)modelInstance.tex;
        }
        if (itemSmartTexture == null) {
            return;
        }
        itemSmartTexture.setBlood("media/textures/BloodTextures/BloodOverlayWeapon.png", "media/textures/BloodTextures/BloodOverlayWeaponMask.png", f, 300);
        itemSmartTexture.calculate();
        modelInstance.tex = itemSmartTexture;
    }

    @Override
    public void postRender() {
        ModelManager.instance.derefModelInstance(this.modelInstance);
        this.texturesNotReady.clear();
        if (!this.bRendered) {
            // empty if block
        }
        pool.release(this);
    }

    public boolean isRendered() {
        return this.bRendered;
    }

    public static EquippedTextureCreator alloc() {
        return pool.alloc();
    }
}

