/*
 * Decompiled with CFR 0.152.
 */
package zombie.characters;

import fmod.fmod.FMOD_STUDIO_PARAMETER_DESCRIPTION;
import java.util.HashMap;
import zombie.characters.BaseCharacterSoundEmitter;
import zombie.characters.IsoGameCharacter;
import zombie.core.Rand;
import zombie.iso.IsoObject;
import zombie.network.GameClient;

public final class DummyCharacterSoundEmitter
extends BaseCharacterSoundEmitter {
    public float x;
    public float y;
    public float z;
    private final HashMap<Long, String> sounds = new HashMap();

    public DummyCharacterSoundEmitter(IsoGameCharacter isoGameCharacter) {
        super(isoGameCharacter);
    }

    @Override
    public void register() {
    }

    @Override
    public void unregister() {
    }

    @Override
    public long playVocals(String string) {
        return 0L;
    }

    @Override
    public void playFootsteps(String string, float f) {
    }

    @Override
    public long playSound(String string) {
        long l = Rand.Next(Integer.MAX_VALUE);
        this.sounds.put(l, string);
        if (GameClient.bClient) {
            GameClient.instance.PlaySound(string, false, this.character);
        }
        return l;
    }

    @Override
    public long playSound(String string, IsoObject isoObject) {
        return this.playSound(string);
    }

    @Override
    public long playSoundImpl(String string, IsoObject isoObject) {
        long l = Rand.Next(Long.MAX_VALUE);
        this.sounds.put(l, string);
        return l;
    }

    @Override
    public void tick() {
    }

    @Override
    public void set(float f, float f2, float f3) {
        this.x = f;
        this.y = f2;
        this.z = f3;
    }

    @Override
    public boolean isClear() {
        return this.sounds.isEmpty();
    }

    @Override
    public void setPitch(long l, float f) {
    }

    @Override
    public void setVolume(long l, float f) {
    }

    @Override
    public int stopSound(long l) {
        if (GameClient.bClient) {
            GameClient.instance.StopSound(this.character, this.sounds.get(l), false);
        }
        this.sounds.remove(l);
        return 0;
    }

    @Override
    public void stopSoundLocal(long l) {
        this.sounds.remove(l);
    }

    @Override
    public void stopOrTriggerSound(long l) {
        if (GameClient.bClient) {
            GameClient.instance.StopSound(this.character, this.sounds.get(l), true);
        }
        this.sounds.remove(l);
    }

    @Override
    public void stopOrTriggerSoundByName(String string) {
        this.sounds.values().remove(string);
    }

    @Override
    public void stopAll() {
        if (GameClient.bClient) {
            for (String string : this.sounds.values()) {
                GameClient.instance.StopSound(this.character, string, false);
            }
        }
        this.sounds.clear();
    }

    @Override
    public int stopSoundByName(String string) {
        this.sounds.values().remove(string);
        return 0;
    }

    @Override
    public boolean hasSoundsToStart() {
        return false;
    }

    @Override
    public boolean isPlaying(long l) {
        return this.sounds.containsKey(l);
    }

    @Override
    public boolean isPlaying(String string) {
        return this.sounds.containsValue(string);
    }

    @Override
    public void setParameterValue(long l, FMOD_STUDIO_PARAMETER_DESCRIPTION fMOD_STUDIO_PARAMETER_DESCRIPTION, float f) {
    }

    public boolean hasSustainPoints(long l) {
        return false;
    }
}

