/*
 * Decompiled with CFR 0.152.
 */
package zombie.characters;

import java.util.ArrayList;
import zombie.GameTime;
import zombie.ZomboidGlobals;
import zombie.characterTextures.BloodBodyPartType;
import zombie.characterTextures.BloodClothingType;
import zombie.characters.BodyDamage.BodyPart;
import zombie.characters.BodyDamage.BodyPartType;
import zombie.characters.BodyDamage.Thermoregulator;
import zombie.characters.IsoGameCharacter;
import zombie.core.math.PZMath;
import zombie.core.skinnedmodel.visual.ItemVisual;
import zombie.core.skinnedmodel.visual.ItemVisuals;
import zombie.inventory.InventoryItem;
import zombie.inventory.types.Clothing;

public final class ClothingWetness {
    private static final ItemVisuals itemVisuals = new ItemVisuals();
    private static final ArrayList<BloodBodyPartType> coveredParts = new ArrayList();
    public final IsoGameCharacter character;
    public final ItemList[] clothing = new ItemList[BloodBodyPartType.MAX.index()];
    public final int[] perspiringParts = new int[BloodBodyPartType.MAX.index()];
    public boolean changed = true;

    public ClothingWetness(IsoGameCharacter isoGameCharacter) {
        this.character = isoGameCharacter;
        for (int i = 0; i < this.clothing.length; ++i) {
            this.clothing[i] = new ItemList();
        }
    }

    public void calculateExposedItems() {
        int n;
        for (n = 0; n < this.clothing.length; ++n) {
            this.clothing[n].clear();
        }
        this.character.getItemVisuals(itemVisuals);
        for (n = itemVisuals.size() - 1; n >= 0; --n) {
            ItemVisual itemVisual = (ItemVisual)itemVisuals.get(n);
            InventoryItem inventoryItem = itemVisual.getInventoryItem();
            ArrayList<BloodClothingType> arrayList = inventoryItem.getBloodClothingType();
            if (arrayList == null) continue;
            coveredParts.clear();
            BloodClothingType.getCoveredParts(arrayList, coveredParts);
            for (int i = 0; i < coveredParts.size(); ++i) {
                BloodBodyPartType bloodBodyPartType = coveredParts.get(i);
                this.clothing[bloodBodyPartType.index()].add(inventoryItem);
            }
        }
    }

    public void updateWetness(float f, float f2) {
        Object object;
        float f3;
        boolean bl;
        boolean bl2;
        float f4;
        float f5;
        Thermoregulator.ThermalNode thermalNode;
        BodyPart bodyPart;
        BodyPartType bodyPartType;
        BloodBodyPartType bloodBodyPartType;
        int n;
        boolean bl3 = false;
        InventoryItem inventoryItem = this.character.getPrimaryHandItem();
        if (inventoryItem != null && inventoryItem.isProtectFromRainWhileEquipped()) {
            bl3 = true;
        }
        if ((inventoryItem = this.character.getSecondaryHandItem()) != null && inventoryItem.isProtectFromRainWhileEquipped()) {
            bl3 = true;
        }
        if (this.changed) {
            this.changed = false;
            this.calculateExposedItems();
        }
        this.character.getItemVisuals(itemVisuals);
        for (int i = 0; i < itemVisuals.size(); ++i) {
            InventoryItem inventoryItem2 = ((ItemVisual)itemVisuals.get(i)).getInventoryItem();
            if (!(inventoryItem2 instanceof Clothing)) continue;
            if (inventoryItem2.getBloodClothingType() == null) {
                ((Clothing)inventoryItem2).updateWetness(true);
                continue;
            }
            ((Clothing)inventoryItem2).flushWetness();
        }
        float f6 = (float)ZomboidGlobals.WetnessIncrease * GameTime.instance.getMultiplier();
        float f7 = (float)ZomboidGlobals.WetnessDecrease * GameTime.instance.getMultiplier();
        block1: for (n = 0; n < this.clothing.length; ++n) {
            float f8;
            bloodBodyPartType = BloodBodyPartType.FromIndex(n);
            bodyPartType = BodyPartType.FromIndex(n);
            if (bodyPartType == BodyPartType.MAX) continue;
            bodyPart = this.character.getBodyDamage().getBodyPart(bodyPartType);
            thermalNode = this.character.getBodyDamage().getThermoregulator().getNodeForBloodType(bloodBodyPartType);
            if (bodyPart == null || thermalNode == null) continue;
            f5 = 0.0f;
            f4 = PZMath.clamp(thermalNode.getSecondaryDelta(), 0.0f, 1.0f);
            f4 *= f4;
            if ((f4 *= 0.2f + 0.8f * (1.0f - thermalNode.getDistToCore())) > 0.1f) {
                f5 += f4;
            } else {
                f8 = (thermalNode.getSkinCelcius() - 20.0f) / 22.0f;
                f8 *= f8;
                f8 -= f;
                f8 = Math.max(0.0f, f8);
                f5 -= f8;
                if (f > 0.0f) {
                    f5 = 0.0f;
                }
            }
            int n2 = this.perspiringParts[n] = f5 > 0.0f ? 1 : 0;
            if (f5 == 0.0f) continue;
            f5 = f5 > 0.0f ? (f5 *= f6) : (f5 *= f7);
            bodyPart.setWetness(bodyPart.getWetness() + f5);
            if (f5 > 0.0f && bodyPart.getWetness() < 25.0f || f5 < 0.0f && bodyPart.getWetness() > 50.0f) continue;
            if (f5 > 0.0f) {
                f8 = this.character.getBodyDamage().getThermoregulator().getExternalAirTemperature();
                f8 += 10.0f;
                f8 = PZMath.clamp(f8, 0.0f, 20.0f) / 20.0f;
                f5 *= 0.4f + 0.6f * f8;
            }
            boolean bl4 = false;
            bl2 = false;
            bl = false;
            f3 = 1.0f;
            for (int i = this.clothing[n].size() - 1; i >= 0; --i) {
                InventoryItem inventoryItem3;
                if (f5 > 0.0f) {
                    int n3 = n;
                    this.perspiringParts[n3] = this.perspiringParts[n3] + 1;
                }
                if (!((inventoryItem3 = (InventoryItem)this.clothing[n].get(i)) instanceof Clothing)) continue;
                f3 = 1.0f;
                Clothing clothing = (Clothing)inventoryItem3;
                object = clothing.getVisual();
                if (object != null) {
                    if (((ItemVisual)object).getHole(bloodBodyPartType) > 0.0f) {
                        bl4 = true;
                        continue;
                    }
                    if (f5 > 0.0f && clothing.getWetness() >= 100.0f) {
                        bl2 = true;
                        continue;
                    }
                    if (f5 < 0.0f && clothing.getWetness() <= 0.0f) {
                        bl = true;
                        continue;
                    }
                    if (f5 > 0.0f && clothing.getWaterResistance() > 0.0f && (f3 = PZMath.max(0.0f, 1.0f - clothing.getWaterResistance())) <= 0.0f) {
                        int n4 = n;
                        this.perspiringParts[n4] = this.perspiringParts[n4] - 1;
                        continue block1;
                    }
                }
                coveredParts.clear();
                BloodClothingType.getCoveredParts(inventoryItem3.getBloodClothingType(), coveredParts);
                int n5 = coveredParts.size();
                float f9 = f5;
                if (f9 > 0.0f) {
                    f9 *= f3;
                }
                if (bl4 || bl2 || bl) {
                    f9 /= 2.0f;
                }
                clothing.setWetness(clothing.getWetness() + f9);
                continue block1;
            }
        }
        for (n = 0; n < this.clothing.length; ++n) {
            bloodBodyPartType = BloodBodyPartType.FromIndex(n);
            bodyPartType = BodyPartType.FromIndex(n);
            if (bodyPartType == BodyPartType.MAX) continue;
            bodyPart = this.character.getBodyDamage().getBodyPart(bodyPartType);
            thermalNode = this.character.getBodyDamage().getThermoregulator().getNodeForBloodType(bloodBodyPartType);
            if (bodyPart == null || thermalNode == null) continue;
            f5 = 100.0f;
            if (bl3) {
                f5 = 100.0f * BodyPartType.GetUmbrellaMod(bodyPartType);
            }
            f4 = 0.0f;
            f4 = f > 0.0f ? f * f6 : (f4 -= f2 * f7);
            boolean bl5 = false;
            bl2 = false;
            bl = false;
            f3 = 1.0f;
            float f10 = 2.0f;
            for (int i = 0; i < this.clothing[n].size(); ++i) {
                int n6 = 1 + (this.clothing[n].size() - i);
                f3 = 1.0f;
                object = (InventoryItem)this.clothing[n].get(i);
                if (!(object instanceof Clothing)) continue;
                Clothing clothing = (Clothing)object;
                ItemVisual itemVisual = clothing.getVisual();
                if (itemVisual != null) {
                    if (itemVisual.getHole(bloodBodyPartType) > 0.0f) {
                        bl5 = true;
                        continue;
                    }
                    if (f4 > 0.0f && clothing.getWetness() >= 100.0f) {
                        bl2 = true;
                        continue;
                    }
                    if (f4 < 0.0f && clothing.getWetness() <= 0.0f) {
                        bl = true;
                        continue;
                    }
                    if (f4 > 0.0f && clothing.getWaterResistance() > 0.0f && (f3 = PZMath.max(0.0f, 1.0f - clothing.getWaterResistance())) <= 0.0f) break;
                }
                coveredParts.clear();
                BloodClothingType.getCoveredParts(((InventoryItem)object).getBloodClothingType(), coveredParts);
                int n7 = coveredParts.size();
                float f11 = f4;
                if (f11 > 0.0f) {
                    f11 *= f3;
                }
                f11 /= (float)n7;
                if (bl5 || bl2 || bl) {
                    f11 /= f10;
                }
                if (f4 < 0.0f && n6 > this.perspiringParts[n] || f4 > 0.0f && clothing.getWetness() <= f5) {
                    clothing.setWetness(clothing.getWetness() + f11);
                }
                if (f4 > 0.0f) break;
                if (!bl) continue;
                f10 *= 2.0f;
            }
            if (this.clothing[n].isEmpty()) {
                if (!(f4 < 0.0f && this.perspiringParts[n] == 0) && !(bodyPart.getWetness() <= f5)) continue;
                bodyPart.setWetness(bodyPart.getWetness() + f4);
                continue;
            }
            InventoryItem inventoryItem4 = (InventoryItem)this.clothing[n].get(this.clothing[n].size() - 1);
            if (!(inventoryItem4 instanceof Clothing)) continue;
            object = (Clothing)inventoryItem4;
            if (f4 > 0.0f && this.perspiringParts[n] == 0 && ((Clothing)object).getWetness() >= 50.0f && bodyPart.getWetness() <= f5) {
                bodyPart.setWetness(bodyPart.getWetness() + f4 / 2.0f);
            }
            if (!(f4 < 0.0f) || this.perspiringParts[n] != 0 || !(((Clothing)object).getWetness() <= 50.0f)) continue;
            bodyPart.setWetness(bodyPart.getWetness() + f4 / 2.0f);
        }
    }

    @Deprecated
    public void increaseWetness(float f) {
        int n;
        if (f <= 0.0f) {
            return;
        }
        if (this.changed) {
            this.changed = false;
            this.calculateExposedItems();
        }
        this.character.getItemVisuals(itemVisuals);
        for (n = 0; n < itemVisuals.size(); ++n) {
            InventoryItem inventoryItem = ((ItemVisual)itemVisuals.get(n)).getInventoryItem();
            if (!(inventoryItem instanceof Clothing)) continue;
            ((Clothing)inventoryItem).flushWetness();
        }
        n = 0;
        for (int i = 0; i < this.clothing.length; ++i) {
            InventoryItem inventoryItem;
            BloodBodyPartType bloodBodyPartType = BloodBodyPartType.FromIndex(i);
            boolean bl = false;
            boolean bl2 = false;
            for (int j = 0; j < this.clothing[i].size(); ++j) {
                inventoryItem = (InventoryItem)this.clothing[i].get(j);
                if (!(inventoryItem instanceof Clothing)) continue;
                Clothing clothing = (Clothing)inventoryItem;
                ItemVisual itemVisual = clothing.getVisual();
                if (itemVisual != null) {
                    if (itemVisual.getHole(bloodBodyPartType) > 0.0f) {
                        bl = true;
                        continue;
                    }
                    if (clothing.getWetness() >= 100.0f) {
                        bl2 = true;
                        continue;
                    }
                }
                coveredParts.clear();
                BloodClothingType.getCoveredParts(inventoryItem.getBloodClothingType(), coveredParts);
                int n2 = coveredParts.size();
                float f2 = f / (float)n2;
                if (bl || bl2) {
                    f2 /= 2.0f;
                }
                clothing.setWetness(clothing.getWetness() + f2);
                break;
            }
            if (this.clothing[i].isEmpty()) {
                ++n;
                continue;
            }
            InventoryItem inventoryItem2 = (InventoryItem)this.clothing[i].get(this.clothing[i].size() - 1);
            if (!(inventoryItem2 instanceof Clothing) || !(((Clothing)(inventoryItem = (Clothing)inventoryItem2)).getWetness() >= 100.0f)) continue;
            ++n;
        }
        if (n > 0) {
            float f3 = this.character.getBodyDamage().getWetness();
            float f4 = f * ((float)n / (float)this.clothing.length);
            this.character.getBodyDamage().setWetness(f3 + f4);
        }
    }

    @Deprecated
    public void decreaseWetness(float f) {
        if (f <= 0.0f) {
            return;
        }
        if (this.changed) {
            this.changed = false;
            this.calculateExposedItems();
        }
        this.character.getItemVisuals(itemVisuals);
        for (int i = itemVisuals.size() - 1; i >= 0; --i) {
            Clothing clothing;
            ItemVisual itemVisual = (ItemVisual)itemVisuals.get(i);
            InventoryItem inventoryItem = itemVisual.getInventoryItem();
            if (!(inventoryItem instanceof Clothing) || !((clothing = (Clothing)inventoryItem).getWetness() > 0.0f)) continue;
            clothing.setWetness(clothing.getWetness() - f);
        }
    }

    private static final class ItemList
    extends ArrayList<InventoryItem> {
        private ItemList() {
        }
    }
}

