/*
 * Decompiled with CFR 0.152.
 */
package zombie.characters.CharacterTimedActions;

import java.util.ArrayList;
import java.util.Arrays;
import zombie.GameTime;
import zombie.ai.states.PlayerActionsState;
import zombie.characters.CharacterActionAnims;
import zombie.characters.IsoGameCharacter;
import zombie.characters.IsoPlayer;
import zombie.core.Core;
import zombie.core.skinnedmodel.advancedanimation.AnimEvent;
import zombie.inventory.InventoryItem;
import zombie.inventory.types.HandWeapon;
import zombie.network.packets.EventPacket;
import zombie.ui.UIManager;
import zombie.util.StringUtils;
import zombie.util.Type;

public class BaseAction {
    public long SoundEffect = -1L;
    public float CurrentTime = -2.0f;
    public float LastTime = -1.0f;
    public int MaxTime = 60;
    public float PrevLastTime = 0.0f;
    public boolean UseProgressBar = true;
    public boolean ForceProgressBar = false;
    public IsoGameCharacter chr;
    public boolean StopOnWalk = true;
    public boolean StopOnRun = true;
    public boolean StopOnAim = false;
    public float caloriesModifier = 1.0f;
    public float delta = 0.0f;
    public boolean blockMovementEtc;
    public boolean overrideAnimation;
    public final ArrayList<String> animVariables = new ArrayList();
    public boolean loopAction = false;
    public boolean bStarted = false;
    public boolean forceStop = false;
    public boolean forceComplete = false;
    private static final ArrayList<String> specificNetworkAnim = new ArrayList<String>(Arrays.asList("Reload", "Bandage", "Loot", "AttachItem", "Drink", "Eat", "Pour", "Read", "fill_container_tap", "drink_tap", "WearClothing"));
    private InventoryItem primaryHandItem = null;
    private InventoryItem secondaryHandItem = null;
    private String primaryHandMdl;
    private String secondaryHandMdl;
    public boolean overrideHandModels = false;

    public BaseAction(IsoGameCharacter isoGameCharacter) {
        this.chr = isoGameCharacter;
    }

    public void forceStop() {
        this.forceStop = true;
    }

    public void forceComplete() {
        this.forceComplete = true;
    }

    public void PlayLoopedSoundTillComplete(String string, int n, float f) {
        this.SoundEffect = this.chr.getEmitter().playSound(string);
    }

    public boolean hasStalled() {
        if (!this.bStarted) {
            return false;
        }
        return this.LastTime == this.CurrentTime && this.LastTime == this.PrevLastTime && this.LastTime < 0.0f || this.CurrentTime < 0.0f;
    }

    public float getJobDelta() {
        return this.delta;
    }

    public void resetJobDelta() {
        this.delta = 0.0f;
        this.CurrentTime = 0.0f;
    }

    public void waitToStart() {
        if (this.chr.shouldWaitToStartTimedAction()) {
            return;
        }
        this.bStarted = true;
        this.start();
    }

    public void update() {
        boolean bl;
        this.PrevLastTime = this.LastTime;
        this.LastTime = this.CurrentTime;
        this.CurrentTime += GameTime.instance.getMultiplier();
        if (this.CurrentTime < 0.0f) {
            this.CurrentTime = 0.0f;
        }
        boolean bl2 = bl = (Core.getInstance().isOptionProgressBar() || this.ForceProgressBar) && this.UseProgressBar && this.chr instanceof IsoPlayer && ((IsoPlayer)this.chr).isLocalPlayer();
        if (this.MaxTime == -1) {
            if (bl) {
                UIManager.getProgressBar(((IsoPlayer)this.chr).getPlayerNum()).setValue(Float.POSITIVE_INFINITY);
            }
            return;
        }
        this.delta = this.MaxTime == 0 ? 0.0f : Math.min(this.CurrentTime / (float)this.MaxTime, 1.0f);
        if (bl) {
            UIManager.getProgressBar(((IsoPlayer)this.chr).getPlayerNum()).setValue(this.delta);
        }
    }

    public void start() {
        this.forceComplete = false;
        this.forceStop = false;
        if (this.chr.isCurrentState(PlayerActionsState.instance())) {
            InventoryItem inventoryItem = this.chr.getPrimaryHandItem();
            InventoryItem inventoryItem2 = this.chr.getSecondaryHandItem();
            this.chr.setHideWeaponModel(!(inventoryItem instanceof HandWeapon) && !(inventoryItem2 instanceof HandWeapon));
        }
    }

    public void reset() {
        this.CurrentTime = 0.0f;
        this.forceComplete = false;
        this.forceStop = false;
    }

    public float getCurrentTime() {
        return this.CurrentTime;
    }

    public void stop() {
        UIManager.getProgressBar(((IsoPlayer)this.chr).getPlayerNum()).setValue(0.0f);
        if (this.SoundEffect > -1L) {
            this.chr.getEmitter().stopSound(this.SoundEffect);
            this.SoundEffect = -1L;
        }
        this.stopTimedActionAnim();
    }

    public boolean valid() {
        return true;
    }

    public boolean finished() {
        return this.CurrentTime >= (float)this.MaxTime && this.MaxTime != -1;
    }

    public void perform() {
        UIManager.getProgressBar(((IsoPlayer)this.chr).getPlayerNum()).setValue(1.0f);
        if (!this.loopAction) {
            this.stopTimedActionAnim();
        }
    }

    public void setUseProgressBar(boolean bl) {
        this.UseProgressBar = bl;
    }

    public void setBlockMovementEtc(boolean bl) {
        this.blockMovementEtc = bl;
    }

    public void setOverrideAnimation(boolean bl) {
        this.overrideAnimation = bl;
    }

    public void stopTimedActionAnim() {
        for (int i = 0; i < this.animVariables.size(); ++i) {
            String string = this.animVariables.get(i);
            this.chr.clearVariable(string);
        }
        this.chr.setVariable("IsPerformingAnAction", false);
        if (this.overrideHandModels) {
            this.overrideHandModels = false;
            this.chr.resetEquippedHandsModels();
        }
    }

    public void setAnimVariable(String string, String string2) {
        if (!this.animVariables.contains(string)) {
            this.animVariables.add(string);
        }
        this.chr.setVariable(string, string2);
    }

    public void setAnimVariable(String string, boolean bl) {
        if (!this.animVariables.contains(string)) {
            this.animVariables.add(string);
        }
        this.chr.setVariable(string, String.valueOf(bl));
    }

    public String getPrimaryHandMdl() {
        return this.primaryHandMdl;
    }

    public String getSecondaryHandMdl() {
        return this.secondaryHandMdl;
    }

    public InventoryItem getPrimaryHandItem() {
        return this.primaryHandItem;
    }

    public InventoryItem getSecondaryHandItem() {
        return this.secondaryHandItem;
    }

    public void setActionAnim(CharacterActionAnims characterActionAnims) {
        this.setActionAnim(characterActionAnims.toString());
    }

    public void setActionAnim(String string) {
        this.setAnimVariable("PerformingAction", string);
        this.chr.setVariable("IsPerformingAnAction", true);
        if (Core.bDebug) {
            this.chr.advancedAnimator.printDebugCharacterActions(string);
        }
    }

    public void setOverrideHandModels(InventoryItem inventoryItem, InventoryItem inventoryItem2) {
        this.setOverrideHandModels(inventoryItem, inventoryItem2, true);
    }

    public void setOverrideHandModels(InventoryItem inventoryItem, InventoryItem inventoryItem2, boolean bl) {
        this.setOverrideHandModelsObject(inventoryItem, inventoryItem2, bl);
    }

    public void setOverrideHandModelsString(String string, String string2) {
        this.setOverrideHandModelsString(string, string2, true);
    }

    public void setOverrideHandModelsString(String string, String string2, boolean bl) {
        this.setOverrideHandModelsObject(string, string2, bl);
    }

    public void setOverrideHandModelsObject(Object object, Object object2, boolean bl) {
        this.overrideHandModels = true;
        this.primaryHandItem = Type.tryCastTo(object, InventoryItem.class);
        this.secondaryHandItem = Type.tryCastTo(object2, InventoryItem.class);
        this.primaryHandMdl = StringUtils.discardNullOrWhitespace(Type.tryCastTo(object, String.class));
        this.secondaryHandMdl = StringUtils.discardNullOrWhitespace(Type.tryCastTo(object2, String.class));
        if (bl) {
            this.chr.resetEquippedHandsModels();
        }
        if (this.primaryHandItem != null || this.secondaryHandItem != null) {
            this.chr.reportEvent(EventPacket.EventType.EventOverrideItem.name());
        }
    }

    public void OnAnimEvent(AnimEvent animEvent) {
    }

    public void setLoopedAction(boolean bl) {
        this.loopAction = bl;
    }
}

