/*
 * Decompiled with CFR 0.152.
 */
package zombie.characters;

import fmod.fmod.EmitterType;
import fmod.fmod.FMODManager;
import fmod.fmod.FMODSoundBank;
import fmod.fmod.FMODSoundEmitter;
import fmod.fmod.FMODVoice;
import fmod.fmod.FMOD_STUDIO_PARAMETER_DESCRIPTION;
import zombie.SoundManager;
import zombie.characters.BaseCharacterSoundEmitter;
import zombie.characters.IsoGameCharacter;
import zombie.characters.IsoPlayer;
import zombie.debug.DebugLog;
import zombie.debug.DebugOptions;
import zombie.debug.DebugType;
import zombie.interfaces.ICommonSoundEmitter;
import zombie.iso.IsoMovingObject;
import zombie.iso.IsoObject;
import zombie.network.GameServer;

public final class CharacterSoundEmitter
extends BaseCharacterSoundEmitter
implements ICommonSoundEmitter {
    float currentPriority;
    final FMODSoundEmitter vocals = new FMODSoundEmitter();
    final FMODSoundEmitter footsteps = new FMODSoundEmitter();
    final FMODSoundEmitter extra = new FMODSoundEmitter();
    private long footstep1 = 0L;
    private long footstep2 = 0L;

    public CharacterSoundEmitter(IsoGameCharacter isoGameCharacter) {
        super(isoGameCharacter);
        this.vocals.emitterType = EmitterType.Voice;
        this.vocals.parent = this.character;
        this.vocals.parameterUpdater = isoGameCharacter;
        this.footsteps.emitterType = EmitterType.Footstep;
        this.footsteps.parent = this.character;
        this.footsteps.parameterUpdater = isoGameCharacter;
        this.extra.emitterType = EmitterType.Extra;
        this.extra.parent = this.character;
        this.extra.parameterUpdater = isoGameCharacter;
    }

    @Override
    public void register() {
        SoundManager.instance.registerEmitter(this.vocals);
        SoundManager.instance.registerEmitter(this.footsteps);
        SoundManager.instance.registerEmitter(this.extra);
    }

    @Override
    public void unregister() {
        SoundManager.instance.unregisterEmitter(this.vocals);
        SoundManager.instance.unregisterEmitter(this.footsteps);
        SoundManager.instance.unregisterEmitter(this.extra);
    }

    @Override
    public long playVocals(String string) {
        if (GameServer.bServer) {
            return 0L;
        }
        FMODVoice fMODVoice = FMODSoundBank.instance.getVoice(string);
        if (fMODVoice == null) {
            long l = this.vocals.playSoundImpl(string, false, null);
            return l;
        }
        float f = fMODVoice.priority;
        long l = this.vocals.playSound(fMODVoice.sound, this.character);
        this.currentPriority = f;
        return l;
    }

    footstep getFootstepToPlay() {
        IsoObject isoObject;
        Object object;
        if (FMODManager.instance.getNumListeners() == 1) {
            for (int i = 0; i < IsoPlayer.numPlayers; ++i) {
                object = IsoPlayer.players[i];
                if (object == null || object == this.character || ((IsoPlayer)object).Traits.Deaf.isSet()) continue;
                if ((int)((IsoMovingObject)object).getZ() >= (int)this.character.getZ()) break;
                return footstep.upstairs;
            }
        }
        if ((isoObject = this.character.getCurrentSquare().getFloor()) != null && isoObject.getSprite() != null && isoObject.getSprite().getName() != null) {
            object = isoObject.getSprite().getName();
            if (((String)object).endsWith("blends_natural_01_5") || ((String)object).endsWith("blends_natural_01_6") || ((String)object).endsWith("blends_natural_01_7") || ((String)object).endsWith("blends_natural_01_0")) {
                return footstep.gravel;
            }
            if (((String)object).endsWith("blends_street_01_48") || ((String)object).endsWith("blends_street_01_53") || ((String)object).endsWith("blends_street_01_54") || ((String)object).endsWith("blends_street_01_55")) {
                return footstep.gravel;
            }
            if (((String)object).startsWith("blends_natural_01")) {
                return footstep.grass;
            }
            if (((String)object).startsWith("floors_interior_tilesandwood_01_")) {
                int n = Integer.parseInt(((String)object).replaceFirst("floors_interior_tilesandwood_01_", ""));
                if (n > 40 && n < 48) {
                    return footstep.wood;
                }
                return footstep.concrete;
            }
            if (((String)object).startsWith("carpentry_02_")) {
                return footstep.wood;
            }
            if (((String)object).startsWith("floors_interior_carpet_")) {
                return footstep.wood;
            }
            return footstep.concrete;
        }
        return footstep.concrete;
    }

    @Override
    public void playFootsteps(String string, float f) {
        long l;
        if (GameServer.bServer) {
            return;
        }
        boolean bl = this.footsteps.isPlaying(this.footstep1);
        boolean bl2 = this.footsteps.isPlaying(this.footstep2);
        if (bl && bl2) {
            l = this.footstep1;
            this.footstep1 = this.footstep2;
            this.footstep2 = l;
            if (this.footsteps.restart(this.footstep2)) {
                return;
            }
            this.footsteps.stopSoundLocal(this.footstep2);
            this.footstep2 = 0L;
        } else if (bl2) {
            this.footstep1 = this.footstep2;
            this.footstep2 = 0L;
            bl = true;
            bl2 = false;
        }
        l = this.footsteps.playSoundImpl(string, false, null);
        if (!bl) {
            this.footstep1 = l;
        } else {
            this.footstep2 = l;
        }
    }

    @Override
    public long playSound(String string) {
        if (this.character.isInvisible() && !DebugOptions.instance.Character.Debug.PlaySoundWhenInvisible.getValue()) {
            return 0L;
        }
        if (DebugLog.isEnabled(DebugType.Sound)) {
            DebugLog.Sound.debugln("Playing sound: " + string + (this.character.isZombie() ? " for zombie" : " for player"));
        }
        return this.extra.playSound(string);
    }

    @Override
    public long playSound(String string, boolean bl) {
        if (this.character.isInvisible() && !DebugOptions.instance.Character.Debug.PlaySoundWhenInvisible.getValue()) {
            return 0L;
        }
        if (DebugLog.isEnabled(DebugType.Sound)) {
            DebugLog.Sound.debugln("Playing sound: " + string + (this.character.isZombie() ? " for zombie" : " for player"));
        }
        return this.extra.playSound(string, bl);
    }

    @Override
    public long playSound(String string, IsoObject isoObject) {
        if (this.character.isInvisible() && !DebugOptions.instance.Character.Debug.PlaySoundWhenInvisible.getValue()) {
            return 0L;
        }
        if (DebugLog.isEnabled(DebugType.Sound)) {
            DebugLog.Sound.debugln("Playing sound: " + string + (this.character.isZombie() ? " for zombie" : " for player"));
        }
        if (GameServer.bServer) {
            return 0L;
        }
        return this.extra.playSound(string, isoObject);
    }

    @Override
    public long playSoundImpl(String string, IsoObject isoObject) {
        if (this.character instanceof IsoPlayer && ((IsoPlayer)this.character).bRemote && this.character.isInvisible()) {
            return 0L;
        }
        if (DebugLog.isEnabled(DebugType.Sound)) {
            DebugLog.Sound.debugln("Playing sound: " + string + (this.character.isZombie() ? " for zombie" : " for player"));
        }
        return this.extra.playSoundImpl(string, false, isoObject);
    }

    @Override
    public void tick() {
        this.vocals.tick();
        this.footsteps.tick();
        this.extra.tick();
    }

    @Override
    public void setPos(float f, float f2, float f3) {
        this.set(f, f2, f3);
    }

    @Override
    public void set(float f, float f2, float f3) {
        this.footsteps.x = this.extra.x = f;
        this.vocals.x = this.extra.x;
        this.footsteps.y = this.extra.y = f2;
        this.vocals.y = this.extra.y;
        this.footsteps.z = this.extra.z = f3;
        this.vocals.z = this.extra.z;
    }

    @Override
    public boolean isEmpty() {
        return this.isClear();
    }

    @Override
    public boolean isClear() {
        return this.vocals.isEmpty() && this.footsteps.isEmpty() && this.extra.isEmpty();
    }

    @Override
    public void setPitch(long l, float f) {
        this.extra.setPitch(l, f);
        this.footsteps.setPitch(l, f);
        this.vocals.setPitch(l, f);
    }

    @Override
    public void setVolume(long l, float f) {
        this.extra.setVolume(l, f);
        this.footsteps.setVolume(l, f);
        this.vocals.setVolume(l, f);
    }

    @Override
    public boolean hasSustainPoints(long l) {
        if (this.extra.isPlaying(l)) {
            return this.extra.hasSustainPoints(l);
        }
        if (this.footsteps.isPlaying(l)) {
            return this.footsteps.hasSustainPoints(l);
        }
        if (this.vocals.isPlaying(l)) {
            return this.vocals.hasSustainPoints(l);
        }
        return false;
    }

    @Override
    public void triggerCue(long l) {
        if (this.extra.isPlaying(l)) {
            this.extra.triggerCue(l);
        } else if (this.footsteps.isPlaying(l)) {
            this.footsteps.triggerCue(l);
        } else if (this.vocals.isPlaying(l)) {
            this.vocals.triggerCue(l);
        }
    }

    @Override
    public int stopSound(long l) {
        this.extra.stopSound(l);
        this.footsteps.stopSound(l);
        this.vocals.stopSound(l);
        return 0;
    }

    @Override
    public void stopSoundLocal(long l) {
        this.extra.stopSoundLocal(l);
        this.footsteps.stopSoundLocal(l);
        this.vocals.stopSoundLocal(l);
    }

    @Override
    public void stopOrTriggerSound(long l) {
        this.extra.stopOrTriggerSound(l);
        this.footsteps.stopOrTriggerSound(l);
        this.vocals.stopOrTriggerSound(l);
    }

    @Override
    public void stopOrTriggerSoundByName(String string) {
        this.extra.stopOrTriggerSoundByName(string);
        this.footsteps.stopOrTriggerSoundByName(string);
        this.vocals.stopOrTriggerSoundByName(string);
    }

    @Override
    public void stopAll() {
        this.extra.stopAll();
        this.footsteps.stopAll();
        this.vocals.stopAll();
    }

    @Override
    public int stopSoundByName(String string) {
        this.extra.stopSoundByName(string);
        this.footsteps.stopSoundByName(string);
        this.vocals.stopSoundByName(string);
        return 0;
    }

    @Override
    public boolean hasSoundsToStart() {
        return this.extra.hasSoundsToStart() || this.footsteps.hasSoundsToStart() || this.vocals.hasSoundsToStart();
    }

    @Override
    public boolean isPlaying(long l) {
        return this.extra.isPlaying(l) || this.footsteps.isPlaying(l) || this.vocals.isPlaying(l);
    }

    @Override
    public boolean isPlaying(String string) {
        return this.extra.isPlaying(string) || this.footsteps.isPlaying(string) || this.vocals.isPlaying(string);
    }

    @Override
    public void setParameterValue(long l, FMOD_STUDIO_PARAMETER_DESCRIPTION fMOD_STUDIO_PARAMETER_DESCRIPTION, float f) {
        this.extra.setParameterValue(l, fMOD_STUDIO_PARAMETER_DESCRIPTION, f);
    }

    static enum footstep {
        upstairs,
        grass,
        wood,
        concrete,
        gravel,
        snow;

    }
}

