/*
 * Decompiled with CFR 0.152.
 */
package zombie.characters.BodyDamage;

import java.nio.ByteBuffer;
import zombie.GameTime;
import zombie.Lua.LuaEventManager;
import zombie.SandboxOptions;
import zombie.ai.states.ClimbOverFenceState;
import zombie.ai.states.ClimbThroughWindowState;
import zombie.ai.states.SwipeStatePlayer;
import zombie.characters.CharacterTimedActions.BaseAction;
import zombie.characters.IsoPlayer;
import zombie.characters.skills.PerkFactory;
import zombie.network.GameClient;
import zombie.network.GameServer;

public final class Nutrition {
    private IsoPlayer parent;
    private float carbohydrates = 0.0f;
    private float lipids = 0.0f;
    private float proteins = 0.0f;
    private float calories = 0.0f;
    private float carbohydratesDecreraseFemale = 0.0032f;
    private float carbohydratesDecreraseMale = 0.0035f;
    private float lipidsDecreraseFemale = 7.0E-4f;
    private float lipidsDecreraseMale = 0.00113f;
    private float proteinsDecreraseFemale = 7.0E-4f;
    private float proteinsDecreraseMale = 8.6E-4f;
    private float caloriesDecreraseFemaleNormal = 0.016f;
    private float caloriesDecreaseMaleNormal = 0.016f;
    private float caloriesDecreraseFemaleExercise = 0.13f;
    private float caloriesDecreaseMaleExercise = 0.13f;
    private float caloriesDecreraseFemaleSleeping = 0.003f;
    private float caloriesDecreaseMaleSleeping = 0.003f;
    private int caloriesToGainWeightMale = 1100;
    private int caloriesToGainWeightMaxMale = 4000;
    private int caloriesToGainWeightFemale = 1000;
    private int caloriesToGainWeightMaxFemale = 3000;
    private int caloriesDecreaseMax = 2500;
    private float weightGain = 1.3E-5f;
    private float weightLoss = 8.5E-6f;
    private double weight = 60.0;
    private int updatedWeight = 0;
    private boolean isFemale = false;
    private int syncWeightTimer = 0;
    private float caloriesMax = 0.0f;
    private float caloriesMin = 0.0f;
    private boolean incWeight = false;
    private boolean incWeightLot = false;
    private boolean decWeight = false;

    public Nutrition(IsoPlayer isoPlayer) {
        this.parent = isoPlayer;
        if (this.isFemale) {
            this.setWeight(60.0);
        } else {
            this.setWeight(80.0);
        }
        this.setCalories(800.0f);
    }

    public void update() {
        if (GameServer.bServer) {
            return;
        }
        if (!SandboxOptions.instance.Nutrition.getValue()) {
            return;
        }
        if (this.parent == null || this.parent.isDead()) {
            return;
        }
        if (GameClient.bClient && !this.parent.isLocalPlayer()) {
            return;
        }
        this.setCarbohydrates(this.getCarbohydrates() - (this.isFemale ? this.carbohydratesDecreraseFemale : this.carbohydratesDecreraseMale) * GameTime.getInstance().getGameWorldSecondsSinceLastUpdate());
        this.setLipids(this.getLipids() - (this.isFemale ? this.lipidsDecreraseFemale : this.lipidsDecreraseMale) * GameTime.getInstance().getGameWorldSecondsSinceLastUpdate());
        this.setProteins(this.getProteins() - (this.isFemale ? this.proteinsDecreraseFemale : this.proteinsDecreraseMale) * GameTime.getInstance().getGameWorldSecondsSinceLastUpdate());
        this.updateCalories();
        this.updateWeight();
    }

    private void updateCalories() {
        float f = 1.0f;
        if (!this.parent.getCharacterActions().isEmpty()) {
            f = ((BaseAction)this.parent.getCharacterActions().get((int)0)).caloriesModifier;
        }
        if (this.parent.isCurrentState(SwipeStatePlayer.instance()) || this.parent.isCurrentState(ClimbOverFenceState.instance()) || this.parent.isCurrentState(ClimbThroughWindowState.instance())) {
            f = 8.0f;
        }
        float f2 = 1.0f;
        if (this.parent.getBodyDamage() != null && this.parent.getBodyDamage().getThermoregulator() != null) {
            f2 = (float)this.parent.getBodyDamage().getThermoregulator().getEnergyMultiplier();
        }
        float f3 = (float)(this.getWeight() / 80.0);
        if (this.parent.IsRunning() && this.parent.isPlayerMoving()) {
            f = 1.0f;
            this.setCalories(this.getCalories() - (this.isFemale ? this.caloriesDecreraseFemaleExercise : this.caloriesDecreaseMaleExercise) * f * f3 * GameTime.getInstance().getGameWorldSecondsSinceLastUpdate());
        } else if (this.parent.isSprinting() && this.parent.isPlayerMoving()) {
            f = 1.3f;
            this.setCalories(this.getCalories() - (this.isFemale ? this.caloriesDecreraseFemaleExercise : this.caloriesDecreaseMaleExercise) * f * f3 * GameTime.getInstance().getGameWorldSecondsSinceLastUpdate());
        } else if (this.parent.isPlayerMoving()) {
            f = 0.6f;
            this.setCalories(this.getCalories() - (this.isFemale ? this.caloriesDecreraseFemaleExercise : this.caloriesDecreaseMaleExercise) * f * f3 * GameTime.getInstance().getGameWorldSecondsSinceLastUpdate());
        } else if (this.parent.isAsleep()) {
            this.setCalories(this.getCalories() - (this.isFemale ? this.caloriesDecreraseFemaleSleeping : this.caloriesDecreaseMaleSleeping) * f * f2 * f3 * GameTime.getInstance().getGameWorldSecondsSinceLastUpdate());
        } else {
            this.setCalories(this.getCalories() - (this.isFemale ? this.caloriesDecreraseFemaleNormal : this.caloriesDecreaseMaleNormal) * f * f2 * f3 * GameTime.getInstance().getGameWorldSecondsSinceLastUpdate());
        }
        if (this.getCalories() > this.caloriesMax) {
            this.caloriesMax = this.getCalories();
        }
        if (this.getCalories() < this.caloriesMin) {
            this.caloriesMin = this.getCalories();
        }
    }

    private void updateWeight() {
        this.setIncWeight(false);
        this.setIncWeightLot(false);
        this.setDecWeight(false);
        float f = this.caloriesToGainWeightMale;
        float f2 = this.caloriesToGainWeightMaxMale;
        float f3 = 0.0f;
        if (this.isFemale) {
            f = this.caloriesToGainWeightFemale;
            f2 = this.caloriesToGainWeightMaxFemale;
        }
        float f4 = (float)((this.getWeight() - 80.0) * 40.0);
        f = 1600.0f + f4;
        f3 = (float)((this.getWeight() - 70.0) * 30.0);
        if (f3 > 0.0f) {
            f3 = 0.0f;
        }
        if (this.getCalories() > f) {
            this.setIncWeight(true);
            float f5 = this.getCalories() / f2;
            if (f5 > 1.0f) {
                f5 = 1.0f;
            }
            float f6 = this.weightGain;
            if (this.getCarbohydrates() > 700.0f || this.getLipids() > 700.0f) {
                f6 *= 3.0f;
                this.setIncWeightLot(true);
            } else if (this.getCarbohydrates() > 400.0f || this.getLipids() > 400.0f) {
                f6 *= 2.0f;
                this.setIncWeightLot(true);
            }
            this.setWeight(this.getWeight() + (double)(f6 * f5 * GameTime.getInstance().getGameWorldSecondsSinceLastUpdate()));
        } else if (this.getCalories() < f3) {
            this.setDecWeight(true);
            float f7 = Math.abs(this.getCalories()) / (float)this.caloriesDecreaseMax;
            if (f7 > 1.0f) {
                f7 = 1.0f;
            }
            this.setWeight(this.getWeight() - (double)(this.weightLoss * f7 * GameTime.getInstance().getGameWorldSecondsSinceLastUpdate()));
        }
        ++this.updatedWeight;
        if (this.updatedWeight >= 2000) {
            this.applyTraitFromWeight();
            this.updatedWeight = 0;
        }
        if (GameClient.bClient) {
            ++this.syncWeightTimer;
            if (this.syncWeightTimer >= 5000) {
                GameClient.sendWeight(this.parent);
                this.syncWeightTimer = 0;
            }
        }
    }

    public void syncWeight() {
        GameClient.sendWeight(this.parent);
    }

    public void save(ByteBuffer byteBuffer) {
        byteBuffer.putFloat(this.getCalories());
        byteBuffer.putFloat(this.getProteins());
        byteBuffer.putFloat(this.getLipids());
        byteBuffer.putFloat(this.getCarbohydrates());
        byteBuffer.putFloat((float)this.getWeight());
    }

    public void load(ByteBuffer byteBuffer) {
        this.setCalories(byteBuffer.getFloat());
        this.setProteins(byteBuffer.getFloat());
        this.setLipids(byteBuffer.getFloat());
        this.setCarbohydrates(byteBuffer.getFloat());
        this.setWeight(byteBuffer.getFloat());
    }

    public void applyWeightFromTraits() {
        if (this.parent.getTraits() != null && !this.parent.getTraits().isEmpty()) {
            if (this.parent.Traits.Emaciated.isSet()) {
                this.setWeight(50.0);
            }
            if (this.parent.Traits.VeryUnderweight.isSet()) {
                this.setWeight(60.0);
            }
            if (this.parent.Traits.Underweight.isSet()) {
                this.setWeight(70.0);
            }
            if (this.parent.Traits.Overweight.isSet()) {
                this.setWeight(95.0);
            }
            if (this.parent.Traits.Obese.isSet()) {
                this.setWeight(105.0);
            }
        }
    }

    public void applyTraitFromWeight() {
        this.parent.getTraits().remove("Underweight");
        this.parent.getTraits().remove("Very Underweight");
        this.parent.getTraits().remove("Emaciated");
        this.parent.getTraits().remove("Overweight");
        this.parent.getTraits().remove("Obese");
        if (this.getWeight() >= 100.0) {
            this.parent.getTraits().add("Obese");
        }
        if (this.getWeight() >= 85.0 && this.getWeight() < 100.0) {
            this.parent.getTraits().add("Overweight");
        }
        if (this.getWeight() > 65.0 && this.getWeight() <= 75.0) {
            this.parent.getTraits().add("Underweight");
        }
        if (this.getWeight() > 50.0 && this.getWeight() <= 65.0) {
            this.parent.getTraits().add("Very Underweight");
        }
        if (this.getWeight() <= 50.0) {
            this.parent.getTraits().add("Emaciated");
        }
    }

    public boolean characterHaveWeightTrouble() {
        return this.parent.Traits.Emaciated.isSet() || this.parent.Traits.Obese.isSet() || this.parent.Traits.VeryUnderweight.isSet() || this.parent.Traits.Underweight.isSet() || this.parent.Traits.Overweight.isSet();
    }

    public boolean canAddFitnessXp() {
        if (this.parent.getPerkLevel(PerkFactory.Perks.Fitness) >= 9 && this.characterHaveWeightTrouble()) {
            return false;
        }
        if (this.parent.getPerkLevel(PerkFactory.Perks.Fitness) >= 6) {
            return !this.parent.Traits.Emaciated.isSet() && !this.parent.Traits.Obese.isSet() && !this.parent.Traits.VeryUnderweight.isSet();
        }
        return true;
    }

    public float getCarbohydrates() {
        return this.carbohydrates;
    }

    public void setCarbohydrates(float f) {
        if (f < -500.0f) {
            f = -500.0f;
        }
        if (f > 1000.0f) {
            f = 1000.0f;
        }
        this.carbohydrates = f;
    }

    public float getProteins() {
        return this.proteins;
    }

    public void setProteins(float f) {
        if (f < -500.0f) {
            f = -500.0f;
        }
        if (f > 1000.0f) {
            f = 1000.0f;
        }
        this.proteins = f;
    }

    public float getCalories() {
        return this.calories;
    }

    public void setCalories(float f) {
        if (f < -2200.0f) {
            f = -2200.0f;
        }
        if (f > 3700.0f) {
            f = 3700.0f;
        }
        this.calories = f;
    }

    public float getLipids() {
        return this.lipids;
    }

    public void setLipids(float f) {
        if (f < -500.0f) {
            f = -500.0f;
        }
        if (f > 1000.0f) {
            f = 1000.0f;
        }
        this.lipids = f;
    }

    public double getWeight() {
        return this.weight;
    }

    public void setWeight(double d) {
        if (d < 35.0) {
            d = 35.0;
            float f = this.parent.getBodyDamage().getHealthReductionFromSevereBadMoodles() * GameTime.instance.getMultiplier();
            this.parent.getBodyDamage().ReduceGeneralHealth(f);
            LuaEventManager.triggerEvent("OnPlayerGetDamage", this.parent, "LOWWEIGHT", Float.valueOf(f));
        }
        this.weight = d;
    }

    public boolean isIncWeight() {
        return this.incWeight;
    }

    public void setIncWeight(boolean bl) {
        this.incWeight = bl;
    }

    public boolean isIncWeightLot() {
        return this.incWeightLot;
    }

    public void setIncWeightLot(boolean bl) {
        this.incWeightLot = bl;
    }

    public boolean isDecWeight() {
        return this.decWeight;
    }

    public void setDecWeight(boolean bl) {
        this.decWeight = bl;
    }
}

