/*
 * Decompiled with CFR 0.152.
 */
package zombie.characters.BodyDamage;

public enum Metabolics {
    Sleeping(0.8f),
    SeatedResting(1.0f),
    StandingAtRest(1.2f),
    SedentaryActivity(1.2f),
    Default(1.6f),
    DrivingCar(1.4f),
    LightDomestic(1.9f),
    HeavyDomestic(2.9f),
    DefaultExercise(3.0f),
    UsingTools(3.4f),
    LightWork(4.3f),
    MediumWork(5.4f),
    DiggingSpade(6.5f),
    HeavyWork(7.0f),
    ForestryAxe(8.5f),
    Walking2kmh(1.9f),
    Walking5kmh(3.1f),
    Running10kmh(6.5f),
    Running15kmh(9.5f),
    JumpFence(4.0f),
    ClimbRope(8.0f),
    Fitness(6.0f),
    FitnessHeavy(9.0f),
    MAX(10.3f);

    private final float met;

    private Metabolics(float f) {
        this.met = f;
    }

    public float getMet() {
        return this.met;
    }

    public float getWm2() {
        return Metabolics.MetToWm2(this.met);
    }

    public float getW() {
        return Metabolics.MetToW(this.met);
    }

    public float getBtuHr() {
        return Metabolics.MetToBtuHr(this.met);
    }

    public static float MetToWm2(float f) {
        return 58.0f * f;
    }

    public static float MetToW(float f) {
        return Metabolics.MetToWm2(f) * 1.8f;
    }

    public static float MetToBtuHr(float f) {
        return 356.0f * f;
    }
}

